/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.metadata.impl;

import com.ibm.ws.sm.workspace.metadata.impl.MetaDataParserConstant;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryContextTypeImpl;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryDocumentTypeImpl;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryMetaDataImpl;
import com.ibm.ws.sm.workspace.metadata.impl.RepositoryValidatorDefImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParserHandler
extends DefaultHandler
implements MetaDataParserConstant {
    private RepositoryMetaDataImpl metaData = new RepositoryMetaDataImpl();
    private boolean display = false;
    private static Writer out;
    private String indentString = "    ";
    private int indentLevel = 0;
    private RepositoryContextTypeImpl context = null;
    private String contextName = null;
    private RepositoryDocumentTypeImpl document = null;
    private String documentName = null;
    private RepositoryValidatorDefImpl validator = null;
    private String validatorName = null;
    private String elementName = null;
    private String elementValue = null;

    RepositoryMetaDataImpl getMetaData() {
        return this.metaData;
    }

    private void handleStartElement(String name) {
        this.elementName = name;
        this.elementValue = "";
        if (name.equals("context")) {
            this.context = null;
            this.contextName = "";
        } else if (name.equals("document")) {
            this.document = null;
            this.documentName = "";
        } else if (name.equals("validator")) {
            this.validator = null;
            this.validatorName = "";
        }
    }

    private RepositoryContextTypeImpl getContext() {
        if (this.context == null) {
            this.context = (RepositoryContextTypeImpl)this.getMetaData().getContextType(this.contextName);
            if (this.context == null) {
                this.context = new RepositoryContextTypeImpl(this.getMetaData());
                this.context.setName(this.contextName);
                this.getMetaData().addContextType(this.context);
            }
        }
        return this.context;
    }

    private RepositoryDocumentTypeImpl getDocument() {
        if (this.document == null) {
            this.document = (RepositoryDocumentTypeImpl)this.getMetaData().getDocumentType(this.documentName);
            if (this.document == null) {
                this.document = new RepositoryDocumentTypeImpl(this.getMetaData());
                this.document.setDisplayName(this.documentName);
                this.getMetaData().addDocumentType(this.document);
            }
        }
        return this.document;
    }

    private RepositoryValidatorDefImpl getValidator() {
        if (this.validator == null) {
            this.validator = (RepositoryValidatorDefImpl)this.getMetaData().getValidatorDef(this.validatorName);
            if (this.validator == null) {
                this.validator = new RepositoryValidatorDefImpl();
                this.validator.setDisplayName(this.validatorName);
                this.getMetaData().addValidatorType(this.validator);
            }
        }
        return this.validator;
    }

    private void handleEndElement(String name) {
        this.elementName = null;
        this.elementValue = this.elementValue.trim();
        if (name.equals("metadata-name")) {
            this.getMetaData().setName(this.elementValue);
        } else if (name.equals("root-context-type")) {
            this.getMetaData().setRootContextTypeName(this.elementValue);
        } else if (name.equals("context-name")) {
            this.contextName = this.elementValue;
            this.getContext();
        } else if (name.equals("document-name")) {
            this.documentName = this.elementValue;
            this.getDocument();
        } else if (name.equals("validator-name")) {
            this.validatorName = this.elementValue;
            this.getValidator();
        } else if (name.equals("child-document-name")) {
            this.getContext().addDocumentTypeName(this.elementValue);
        } else if (name.equals("child-context-name")) {
            this.getContext().addChildContextTypeName(this.elementValue);
        } else if (name.equals("root-document-type")) {
            this.getContext().setRootDocumentTypeName(this.elementValue);
        } else if (name.equals("root-refobject-type")) {
            this.getDocument().addRootRefObjectTypeName(this.elementValue);
        } else if (name.equals("child-validator-name")) {
            this.getDocument().addValidatorName(this.elementValue);
        } else if (name.equals("file-pattern")) {
            this.getDocument().setFilePattern(this.elementValue);
        } else if (name.equals("file-type")) {
            this.getDocument().setFileType(Integer.getInteger(this.elementValue));
        } else if (name.equals("validator-class-name")) {
            this.getValidator().setClassName(this.elementValue);
        } else if (name.equals("validator-description")) {
            this.getValidator().setDescription(this.elementValue);
        } else if (name.equals("validator-type")) {
            this.getValidator().setValidatorType(this.elementValue);
        } else if (name.equals("cross-document")) {
            this.getValidator().setCrossDocumentValidator(new Boolean(this.elementValue));
        }
    }

    private void handleChar(String name) {
        if (this.elementName == null) {
            return;
        }
        this.elementValue = this.elementValue + name;
    }

    public void startDocument() throws SAXException {
        try {
            out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
            this.nl();
            this.nl();
            this.emit("START DOCUMENT");
            this.nl();
            this.emit("<?xml version='1.0' encoding='UTF-8'?>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.emit("END DOCUMENT");
        try {
            this.nl();
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        ++this.indentLevel;
        this.nl();
        this.emit("ELEMENT: ");
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.emit("<" + eName);
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                this.nl();
                this.emit("   ATTR: ");
                this.emit(aName);
                this.emit("\t\"");
                this.emit(attrs.getValue(i));
                this.emit("\"");
            }
        }
        if (attrs.getLength() > 0) {
            this.nl();
        }
        this.emit(">");
        this.handleStartElement(eName);
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.nl();
        this.emit("END_ELM: ");
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.emit("</" + eName + ">");
        --this.indentLevel;
        this.handleEndElement(eName);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.nl();
        this.emit("CHARS:   ");
        String s = new String(buf, offset, len);
        this.emit(s);
        this.handleChar(s);
    }

    private void emit(String s) throws SAXException {
        if (!this.display) {
            return;
        }
        try {
            out.write(s);
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void nl() throws SAXException {
        if (!this.display) {
            return;
        }
        String lineEnd = System.getProperty("line.separator");
        try {
            out.write(lineEnd);
            for (int i = 0; i < this.indentLevel; ++i) {
                out.write(this.indentString);
            }
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }
}

