/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.merger.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.merger.MergeUtil;
import com.ibm.ws.sm.workspace.util.ServerIndexUtil;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerIndexMerger
implements MergeUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ServerIndexMerger.class);
    private static String ERROR_LOAD_RESOURCE = "WKSP1001E: Error loading resource {0} for context {1} --{2}";
    private static String ERROR_SAVE_RESOURCE = "WKSP1002E: Error saving resource {0} --{1}";
    private static String ERROR_MERGE_RESOURCE = "WKSP1003E: Error merging resource {0} for context {1} ";
    private static String ERROR_SERVERENTRY = "WKSP1004E: Error - ServerEntry {0} does not have a corresponding server in the configuration.";
    private static String ERROR_APPDEPLOYMENT = "WKSP1005E: Error - DeployedApplication {0} does not have a corresponding deployment.xml in the configuration.";
    private ServerIndexUtil util = new ServerIndexUtil();

    public boolean merge(RepositoryContext context, String uri, String origURI, String currentURI) throws WorkSpaceException {
        ServerIndex serverIndexLocal = this.getObject(context, uri);
        ServerIndex serverIndexOrig = this.getObject(context, origURI);
        ServerIndex serverIndexCurrent = this.getObject(context, currentURI);
        boolean ok = this.util.mergeDocuments(serverIndexOrig, serverIndexLocal, serverIndexCurrent);
        Tr.debug(tc, "merge status: " + ok);
        if (ok) {
            this.saveObject(serverIndexCurrent);
        }
        return ok;
    }

    private ServerIndex getObject(RepositoryContext context, String uri) throws WorkSpaceException {
        try {
            Resource resource = context.getResourceSet().getResource(URI.createURI(uri), true);
            if (resource == null) {
                return null;
            }
            return (ServerIndex)resource.getContents().iterator().next();
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, ERROR_LOAD_RESOURCE, new Object[]{uri, context.getURI(), e}, e);
        }
    }

    private void saveObject(ServerIndex serverIndex) throws WorkSpaceException {
        try {
            serverIndex.eResource().save(new HashMap());
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, ERROR_SAVE_RESOURCE, new Object[]{serverIndex, e}, e);
        }
    }

    public void selfCorrect(WorkSpaceFile file) throws WorkSpaceException {
        boolean changed = false;
        RepositoryContext context = file.getContext();
        ServerIndex si = this.getObject(context, file.getFileName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "selfCorrect: getObject(context: " + context + ", file: " + file + ") return si: " + si);
        }
        if (si == null) {
            return;
        }
        EList servers = si.getServerEntries();
        EList epr = si.getEndPointRefs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EndPointRefs #1 = " + epr);
        }
        for (int i = 0; i < servers.size(); ++i) {
            ServerEntry server = (ServerEntry)servers.get(i);
            String servername = server.getServerName();
            EList sep = server.getSpecialEndpoints();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, servername + " SpecialEndpoints #1 = " + sep);
            }
            try {
                Server s = (Server)this.getContentObject(context, "servers/" + servername + "/server.xml");
            }
            catch (Exception e) {
                String resURI = context.getURI() + "/servers/" + servername + "/server.xml";
                if (((RepositoryContextImpl)context).getRepositoryAdapter().exist(context.getWorkSpace(), resURI)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "selfCorrect: Found " + resURI + " in the master config repository, leave it as is.");
                    }
                }
                changed = true;
                WorkSpaceException exc = WorkSpaceLogger.createException(tc, ERROR_SERVERENTRY, new Object[]{servername}, e);
                FFDCFilter.processException(exc, "com.ibm.ws.sm.workspace.merger.impl.ServerIndexMerger.selfCorrect", "100");
                Tr.warning(tc, "ServerEntry without corresponding server in the configuration: " + servername);
                servers.remove(i);
                --i;
                epr.removeAll(sep);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "EndPointRefs #2 = " + epr);
                Tr.debug(tc, servername + " SpecialEndpoints #2 = " + sep);
                continue;
            }
            RepositoryContext cellContext = context.getParent();
            String appUri = null;
            EList apps = server.getDeployedApplications();
            for (int a = 0; a < apps.size(); ++a) {
                appUri = "applications/" + (String)apps.get(a);
                appUri = appUri + "/deployment.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selfCorrect: Checking deployment.xml for Server: " + servername + ", App: " + appUri);
                }
                try {
                    Deployment appObj = (Deployment)this.getContentObject(cellContext, appUri);
                    continue;
                }
                catch (Exception e) {
                    String resURI = cellContext.getURI() + "/" + appUri;
                    if (((RepositoryContextImpl)cellContext).getRepositoryAdapter().exist(cellContext.getWorkSpace(), resURI)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "selfCorrect: Found " + resURI + " in the master config repository, leave it as it.");
                        continue;
                    }
                    changed = true;
                    WorkSpaceException exc = WorkSpaceLogger.createException(tc, ERROR_APPDEPLOYMENT, new Object[]{(String)apps.get(a)}, e);
                    FFDCFilter.processException(exc, "com.ibm.ws.sm.workspace.merger.impl.ServerIndexMerger.selfCorrect", "121");
                    Tr.warning(tc, "DeployedApplication without corresponding deployment.xml in the configuration: " + (String)apps.get(a));
                    apps.remove(a);
                    --a;
                }
            }
        }
        if (changed) {
            this.saveObject(si);
        }
    }

    private synchronized Object getContentObject(RepositoryContext context, String uri) throws WorkSpaceException {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContentObject (context: " + context + ", uri: " + uri + ")");
        }
        try {
            Resource resource = context.getResourceSet().getResource(URI.createURI(uri), true);
            obj = resource.getContents().iterator().next();
        }
        catch (NullPointerException npe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can not find corresponding " + uri + " in the configuration.");
            }
            throw npe;
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, ERROR_LOAD_RESOURCE, new Object[]{uri, context.getURI(), e}, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContentObject (context: " + context + ", uri: " + uri + ") return object: " + obj);
        }
        return obj;
    }
}

