/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.WorkSpacePersistentObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;

public class WorkspaceMetadataAccessor
implements ManagedObjectMetadataAccessor,
WorkSpaceListener {
    private static TraceComponent _tc = Tr.register(WorkspaceMetadataAccessor.class, "Admin", null);
    private static String METADATA_FILE_URI_SUFFIX = "/node-metadata.properties";
    private static HashMap _accessorCache = new HashMap();
    private WorkSpace _ws;
    private String _userName;
    private HashMap _metadataCache = new HashMap();

    public static ManagedObjectMetadataAccessor createAccessor(String userName) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "creating metadata accessor", "userName=" + userName);
        }
        ManagedObjectMetadataAccessor accessor = WorkspaceMetadataAccessor.getCachedOrCreateNewAccessor(userName);
        return accessor;
    }

    public WorkspaceMetadataAccessor(WorkSpace workspace, Properties props) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WorkspaceMetadataAccessor", new Object[]{workspace, props});
        }
        this._ws = workspace;
        this._userName = this._ws.getUserName();
        this._ws.addWorkSpaceListener(this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WorkspaceMetadataAccessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMetadataProperties(String nodeName) throws AdminException {
        Properties nodeData;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperties", new String[]{"userName=" + this._userName, "nodeName=" + nodeName});
        }
        HashMap hashMap = this._metadataCache;
        synchronized (hashMap) {
            nodeData = (Properties)this._metadataCache.get(nodeName);
        }
        if (nodeData == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getMetadataProperties", "Properties not cached.");
            }
            nodeData = this.extractMetadata(nodeName);
            this.addMetadataToCache(nodeName, nodeData);
        }
        nodeData = (Properties)nodeData.clone();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperties", "props=" + nodeData);
        }
        return nodeData;
    }

    public String getMetadataProperty(String nodeName, String propName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMetadataProperty", new String[]{"userName=" + this._userName, "nodeName=" + nodeName, "propName=" + propName});
        }
        Properties nodeData = this.getMetadataProperties(nodeName);
        String propValue = nodeData.getProperty(propName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMetadataProperty", propName + "=" + propValue);
        }
        return propValue;
    }

    public void handle(WorkSpaceEvent event2) {
        int eventType = event2.getType();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "handle", new String[]{"userName=" + this._userName, "eventType=" + eventType});
        }
        if (eventType == 22 || eventType == 21 || eventType == 11) {
            WorkSpacePersistentObject wspo = (WorkSpacePersistentObject)event2.getSource();
            String uri = wspo.getURI();
            if (!(eventType != 22 && eventType != 21 || uri.endsWith(METADATA_FILE_URI_SUFFIX))) {
                return;
            }
            String nodeName = ConfigStructureHelper.nodeNameForDoc((String)uri);
            if (nodeName != null && uri.startsWith("cells/") && uri.indexOf("/servers/") == -1 && !uri.endsWith("/servers")) {
                this.removeMetadataFromCache(nodeName);
            }
        } else if (eventType == 0) {
            WorkspaceMetadataAccessor.removeAccessorFromCache(this._userName);
        }
    }

    private Properties extractMetadata(String nodeName) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractMetadata");
        }
        Properties metadata2 = new Properties();
        InputStream is = null;
        try {
            AdminService admin = AdminServiceFactory.getAdminService();
            RepositoryContext nodeContext = null;
            if (admin != null) {
                String cellName = admin.getCellName();
                nodeContext = this._ws.getRootContext().findContext("cells/" + cellName + "/nodes/" + nodeName);
            } else {
                Collection match = this._ws.getRootContext().findContext("nodes", nodeName);
                if (match.size() != 0) {
                    nodeContext = (RepositoryContext)match.iterator().next();
                }
            }
            if (nodeContext == null) {
                MetadataNotAvailableException me = new MetadataNotAvailableException("specified node name is not valid: " + nodeName);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "extractMetadata", me);
                }
                throw me;
            }
            is = nodeContext.getInputStream("node-metadata.properties");
            metadata2.load(is);
        }
        catch (MetadataNotAvailableException me) {
            throw me;
        }
        catch (Throwable t) {
            MetadataNotAvailableException me = new MetadataNotAvailableException(t, "Unexpected exception received while extracting metadata from the workspace" + this._ws.getUserName());
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "extractMetadata: Unexpected exception: ", me);
            }
            throw me;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.sm.workspace.impl.WorkspaceMetadataAccessor", "149");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractMetadata");
        }
        return metadata2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMetadataToCache(String nodeName, Properties nodeData) {
        HashMap hashMap = this._metadataCache;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding metadata to cache: nodeName=" + nodeName);
            }
            this._metadataCache.put(nodeName, nodeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMetadataFromCache(String nodeName) {
        HashMap hashMap = this._metadataCache;
        synchronized (hashMap) {
            Object metadata2 = this._metadataCache.remove(nodeName);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed metadata from cache:", new String[]{"nodeName=" + nodeName, "metadata=" + metadata2});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ManagedObjectMetadataAccessor getCachedOrCreateNewAccessor(String userName) throws Exception {
        ManagedObjectMetadataAccessor accessor = null;
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getCachedOrCreateNewAccessor", "userName=" + userName);
            }
            WorkSpace wkspc = WorkSpaceManagerFactory.getManager().getWorkSpace(userName);
            HashMap hashMap = _accessorCache;
            synchronized (hashMap) {
                accessor = (ManagedObjectMetadataAccessor)_accessorCache.get(userName);
                if (accessor == null) {
                    accessor = wkspc.getManagedObjectMetadataAccessor();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding to accessor cache: userName=" + userName);
                    }
                    _accessorCache.put(userName, accessor);
                }
            }
        }
        catch (Exception e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCachedOrCreateNewAccessor: Exception:", e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCachedOrCreateNewAccessor", "accessor=" + accessor);
        }
        return accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAccessorFromCache(String userName) {
        HashMap hashMap = _accessorCache;
        synchronized (hashMap) {
            Object accessor = _accessorCache.remove(userName);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed from accessor cache:", new String[]{"userName=" + userName, "accessor=" + accessor});
            }
        }
    }
}

