/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentLockedException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.ConfigLimits;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.merger.MergeUtilManager;
import com.ibm.ws.sm.workspace.merger.impl.ServerIndexMerger;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceMasterRepositoryAdapter
implements WorkSpaceRepositoryAdapter,
WorkSpaceMessage,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceMasterRepositoryAdapter.class);
    private boolean debugEnabled = tc.isDebugEnabled();
    private static final String SESSION_ID_FILE_PREFIX = ".workspace_";
    private static final String DIGEST_SUFFIX = ".workspace_save";
    private static final String ORIG_SUFFIX = ".copy";
    private static final String BACKUP_SUFFIX = ".backup";
    private static final String CURRENT_SUFFIX = ".current";
    private static final String WORKSPACE_REPOSITORY = ".repositoryContext";
    private static final String SERVER_INDEX_NAME = "serverindex.xml";
    private static final String CLUSTER_XML_NAME = "cluster.xml";
    private static final String WORKSPACE_MONITOR = "workspace_monitor";
    private static final String CONFIG_CONSISTENCY_CHECK = "config_consistency_check";
    private static boolean init = false;
    private static RepositoryMetaData defaultMetaData = null;
    private ConfigRepository configRepository = null;
    private Properties repositoryProp;

    private ConfigRepository getConfigRepository() throws WorkSpaceException {
        if (this.configRepository == null) {
            this.configRepository = this.repositoryProp != null && this.repositoryProp.getProperty("location") != null ? WorkSpaceMasterRepositoryAdapter.getRepository(this.repositoryProp) : WorkSpaceMasterRepositoryAdapter.getDefaultRepository();
            if (this.configRepository == null) {
                throw WorkSpaceLogger.createException(tc, "WKSP0007E Error getting ConfigRepository -{0}", new Object[]{null});
            }
        }
        return this.configRepository;
    }

    private RepositoryMetaData getDefaultMetaData() {
        if (defaultMetaData == null) {
            try {
                String configRoot = (String)WorkSpaceMasterRepositoryAdapter.getDefaultRepository().getConfig().get("was.repository.root");
                if (configRoot != null) {
                    configRoot = configRoot + File.separator + ".repository";
                }
                if (configRoot == null || !new File(configRoot).isDirectory()) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0020E Error getting meta data root {0}", new Object[]{configRoot});
                }
                defaultMetaData = RepositoryMetaDataFactory.getFactory().getMetaData(configRoot);
            }
            catch (WorkSpaceException e) {
                new RuntimeException(e.getMessage());
            }
        }
        return defaultMetaData;
    }

    private static ConfigRepository getDefaultRepository() throws WorkSpaceException {
        Properties prop = new Properties();
        prop.setProperty("location", "local");
        ConfigRepository defaultRepository = WorkSpaceMasterRepositoryAdapter.getRepository(prop);
        return defaultRepository;
    }

    private static ConfigRepository getRepository(Properties prop) throws WorkSpaceException {
        try {
            return ConfigRepositoryClientFactory.getConfigRepositoryClient(prop);
        }
        catch (AdminException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0007E Error getting ConfigRepository -{0}", new Object[]{e}, e);
        }
    }

    public String[] getCatalog(WorkSpace workspace, String uri, int type, int depth) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCatalog ()", new Object[]{workspace, uri, new Integer(type), new Integer(depth)});
        }
        int configType = 1;
        int configDepth = depth;
        switch (type) {
            case 1: {
                configType = 1;
                break;
            }
            case 0: {
                configType = 2;
                break;
            }
            case 2: {
                configType = 255;
            }
        }
        switch (depth) {
            case -1: {
                configDepth = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                configDepth = 1;
                break;
            }
            case 0: {
                configDepth = 0;
            }
        }
        String[] result = this.getConfigRepository().listResourceNames(uri, configType, configDepth);
        if (tc.isEntryEnabled()) {
            String catalog = "";
            if (uri.length() > 0) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = result[i].substring(uri.length() + 1);
                    if (i != 0) {
                        catalog = catalog + ", ";
                    }
                    catalog = catalog + result[i];
                }
            }
            Tr.exit(tc, "getCatalog () return: [" + catalog + "]");
        } else if (uri.length() > 0) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].substring(uri.length() + 1);
            }
        }
        return result;
    }

    public boolean exist(WorkSpace workspace, String uri) throws WorkSpaceException {
        String[] result = this.getConfigRepository().listResourceNames(uri, 255, 0);
        return result.length > 0;
    }

    /*
     * Unable to fully structure code
     */
    public Integer checkSynchState(WorkSpaceFile file) throws WorkSpaceException {
        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.entry(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchState (" + file + ")");
        }
        conflictState = ConflictState.UN_MODIFIED;
        if (file.getState() == WorkSpaceFileState.UPDATED || file.getState() == WorkSpaceFileState.DELETED || file.getState() == WorkSpaceFileState.EXTRACTED) {
            if (!this.exist(file.getContext().getWorkSpace(), file.getURI())) {
                if (this.debugEnabled) {
                    Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, file.getURI() + " has been removed in Master Repository");
                }
                conflictState = ConflictState.REMOVED;
            } else {
                try {
                    digest = this.getConfigRepository().getDigest(file.getURI());
                    if (digest == null || digest.equals(this.getDigest(file))) ** GOTO lbl24
                    if (this.debugEnabled) {
                        Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, file.getURI() + " has been modified in Master Repository");
                    }
                    conflictState = ConflictState.MODIFIED;
                    conflictState = this.checkMerge(file, conflictState);
                }
                catch (Exception e) {
                    throw WorkSpaceLogger.createException(WorkSpaceMasterRepositoryAdapter.tc, "WKSP0008E RepositoryException while checking the state of {0} in the master repository --{1}", new Object[]{file.getURI(), e}, e);
                }
            }
        } else if (file.getState() == WorkSpaceFileState.ADDED && this.exist(file.getContext().getWorkSpace(), file.getURI())) {
            if (this.debugEnabled) {
                Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, file.getURI() + " has been added in Master Repository");
            }
            conflictState = ConflictState.ADDED;
        }
lbl24:
        // 6 sources

        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.exit(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchState (" + file + ") return: " + conflictState);
        }
        return conflictState;
    }

    /*
     * Unable to fully structure code
     */
    Integer checkSynchStateForRefresh(WorkSpaceFile file) throws WorkSpaceException {
        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.entry(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchStateForRefresh (" + file + ")");
        }
        conflictState = ConflictState.UN_MODIFIED;
        if (file.getState() == WorkSpaceFileState.UPDATED || file.getState() == WorkSpaceFileState.DELETED || file.getState() == WorkSpaceFileState.EXTRACTED) {
            if (!this.exist(file.getContext().getWorkSpace(), file.getURI())) {
                if (this.debugEnabled) {
                    Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, file.getURI() + " has been removed in Master Repository");
                }
                conflictState = ConflictState.REMOVED;
            } else {
                try {
                    digest = this.getConfigRepository().getDigest(file.getURI());
                    if (digest == null || digest.equals(this.getDigest(file))) ** GOTO lbl24
                    if (this.debugEnabled) {
                        Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, file.getURI() + " has been modified in Master Repository");
                    }
                    conflictState = ConflictState.MODIFIED;
                    conflictState = this.checkMergeForRefresh(file, conflictState);
                }
                catch (Exception e) {
                    throw WorkSpaceLogger.createException(WorkSpaceMasterRepositoryAdapter.tc, "WKSP0008E RepositoryException while checking the state of {0} in the master repository --{1}", new Object[]{file.getURI(), e}, e);
                }
            }
        } else if (file.getState() == WorkSpaceFileState.ADDED && this.exist(file.getContext().getWorkSpace(), file.getURI())) {
            if (this.debugEnabled) {
                Tr.debug(WorkSpaceMasterRepositoryAdapter.tc, file.getURI() + " has been added in Master Repository");
            }
            conflictState = ConflictState.ADDED;
        }
lbl24:
        // 6 sources

        if (WorkSpaceMasterRepositoryAdapter.tc.isEntryEnabled()) {
            Tr.exit(WorkSpaceMasterRepositoryAdapter.tc, "checkSynchStateForRefresh (" + file + ") return: " + conflictState);
        }
        return conflictState;
    }

    boolean isSelfCorrection() {
        boolean result = true;
        String propValue = null;
        String processType = "DMGR";
        if (AdminServiceFactory.getAdminService() == null || !AdminServiceFactory.getAdminService().getProcessType().equals("DeploymentManager")) {
            processType = "LocalMode or Non-DMGR";
            result = false;
        } else {
            try {
                propValue = System.getProperty(CONFIG_CONSISTENCY_CHECK);
                if (propValue != null && propValue.equals("false")) {
                    result = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSelfCorrection return " + result + ", processType = " + processType + ", " + CONFIG_CONSISTENCY_CHECK + " = " + propValue);
        }
        return result;
    }

    private void selfCorrect(WorkSpaceFile file) throws WorkSpaceException {
        if (file.getName().equalsIgnoreCase(SERVER_INDEX_NAME)) {
            ServerIndexMerger util2 = (ServerIndexMerger)MergeUtilManager.getUtil(file);
            util2.selfCorrect(file);
        }
    }

    private DocumentDigest getDigest(WorkSpaceFile file) throws WorkSpaceException {
        DocumentDigest digest = null;
        String path = null;
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        if (this.needMerge(file) && !FileAccessorUtil.exist(fa, path = file.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX)) {
            path = null;
        }
        if (path == null) {
            path = file.getURI() + DIGEST_SUFFIX;
        }
        if (this.debugEnabled) {
            Tr.debug(tc, "Digest version: " + path);
        }
        try {
            ObjectInputStream in = new ObjectInputStream(fa.load(path));
            digest = (DocumentDigest)in.readObject();
            in.close();
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0016E Error get digest for {0} --{1}", new Object[]{path, e}, e);
        }
        return digest;
    }

    private void validateFileLength(Map files) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFileLength", files);
        }
        Iterator itr = files.keySet().iterator();
        while (itr.hasNext()) {
            WorkSpaceFile file = (WorkSpaceFile)itr.next();
            String path = file.getURI();
            String fileName = path.replace('/', File.separatorChar);
            try {
                FileAccessor fa = ((WorkSpaceImpl)file.getContext().getWorkSpace()).getFileAccessor();
                String fullPath = FileAccessorUtil.getFullPath(fa, fileName);
                WorkSpaceMasterRepositoryAdapter.checkURILength(fullPath);
                if (!FileAccessorUtil.exist(fa, path)) {
                    String msg = "validateFileLength: File \"" + fullPath + "\" does not exist in wstemp, and will not be updated to master repository.";
                    Tr.warning(tc, msg);
                    itr.remove();
                    continue;
                }
                if (FileAccessorUtil.getLength(fa, path) != 0L) continue;
                String appsPath = File.separator + "applications" + File.separator;
                String msg = "validateFileLength: File \"" + fullPath + "\" is zero length.";
                if (fileName.indexOf(appsPath) < 0) {
                    Tr.error(tc, msg);
                    throw new WorkSpaceException(msg);
                }
                Tr.warning(tc, msg);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter.validateFileLength", "370", this);
                throw WorkSpaceLogger.createException(tc, "WKSP0022E File validation failed --{0}.", new Object[]{e}, e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFileLength");
        }
    }

    private void backupServerindex(WorkSpaceFile file) throws WorkSpaceException {
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        String fileURI = file.getURI();
        if (this.needMerge(file)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "backupServerindex: " + file);
            }
            try {
                FileAccessorUtil.copyFile(fa, fileURI, fileURI + BACKUP_SUFFIX);
            }
            catch (IOException ioe) {
                throw WorkSpaceLogger.createException(tc, "WKSP0023E Unable to copy file {0} due to exception --{1}", new Object[]{fileURI, ioe});
            }
        }
    }

    private void restoreServerindex(WorkSpaceFile file) throws WorkSpaceException {
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        String fileURI = file.getURI();
        if (this.needMerge(file)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "restoreServerindex: " + file);
            }
            try {
                FileAccessorUtil.copyFile(fa, fileURI + BACKUP_SUFFIX, fileURI);
            }
            catch (IOException ioe) {
                throw WorkSpaceLogger.createException(tc, "WKSP0023E Unable to copy file {0} due to exception --{1}", new Object[]{fileURI + BACKUP_SUFFIX, ioe});
            }
        }
    }

    public void update(Map[] files) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", files);
        }
        this.validateFileLength(files[0]);
        this.validateFileLength(files[1]);
        DocumentContentSource[] addedDocuments = new DocumentContentSource[files[0].size()];
        int i = 0;
        for (WorkSpaceFile file : files[0].keySet()) {
            addedDocuments[i] = (DocumentContentSource)this.collectFile(file, (Integer)files[0].get(file));
            if (this.isClusterFile(file)) {
                this.checkClusterConfigLimit(file);
            }
            if (this.debugEnabled) {
                Tr.debug(tc, addedDocuments[i].getDocument().getURI() + " will be added to the Master Repository");
            }
            ++i;
        }
        DocumentContentSource[] updatedDocuments = new DocumentContentSource[files[1].size()];
        i = 0;
        for (WorkSpaceFile file : files[1].keySet()) {
            this.backupServerindex(file);
            if (this.isSelfCorrection()) {
                this.selfCorrect(file);
            }
            updatedDocuments[i] = (DocumentContentSource)this.collectFile(file, (Integer)files[1].get(file));
            if (this.debugEnabled) {
                Tr.debug(tc, updatedDocuments[i].getDocument().getURI() + " will be updated to the Master Repository");
            }
            ++i;
        }
        Document[] deletedDocuments = new Document[files[2].size()];
        i = 0;
        for (WorkSpaceFile file : files[2].keySet()) {
            deletedDocuments[i] = (Document)this.collectFile(file, (Integer)files[2].get(file));
            if (this.debugEnabled) {
                Tr.debug(tc, deletedDocuments[i].getURI() + " will be deleted to the Master Repository");
            }
            ++i;
        }
        boolean retry = true;
        int maxRetry = 10;
        for (i = 1; i <= maxRetry; ++i) {
            Integer conflictState;
            int j;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "update, addedDocs: " + addedDocuments.length + ", updatedDocs: " + updatedDocuments.length + ", deletedDocs: " + deletedDocuments.length);
                }
                this.getConfigRepository().update(addedDocuments, updatedDocuments, deletedDocuments);
            }
            catch (DocumentChangedException e) {
                Tr.warning(tc, "Got DocumentChangedException, #" + i + " on file \"" + e.getMessage() + "\"", e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                j = 0;
                for (WorkSpaceFile file : files[1].keySet()) {
                    conflictState = ConflictState.MODIFIED;
                    this.restoreServerindex(file);
                    conflictState = this.checkMerge(file, conflictState);
                    if (this.isSelfCorrection()) {
                        this.selfCorrect(file);
                    }
                    updatedDocuments[j] = (DocumentContentSource)this.collectFile(file, (Integer)files[1].get(file));
                    ++j;
                }
                continue;
            }
            catch (DocumentLockedException e) {
                Tr.warning(tc, "Got DocumentLockedException, #" + i + " on file \"" + e.getMessage() + "\"", e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                j = 0;
                for (WorkSpaceFile file : files[1].keySet()) {
                    conflictState = ConflictState.MODIFIED;
                    this.restoreServerindex(file);
                    conflictState = this.checkMerge(file, conflictState);
                    if (this.isSelfCorrection()) {
                        this.selfCorrect(file);
                    }
                    updatedDocuments[j] = (DocumentContentSource)this.collectFile(file, (Integer)files[1].get(file));
                    ++j;
                }
                continue;
            }
            catch (RepositoryException e) {
                throw new WorkSpaceException("RepositoryException while updating documents in master repository", e);
            }
            retry = false;
            break;
        }
        if (retry) {
            throw new WorkSpaceException("RepositoryException while retry updating documents in master repository");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private boolean isClusterFile(WorkSpaceFile file) throws WorkSpaceException {
        boolean isCluster = false;
        String uri = file.getURI();
        if (uri != null) {
            isCluster = uri.endsWith(CLUSTER_XML_NAME) && uri.indexOf("/clusters/") != -1;
        } else if (this.debugEnabled) {
            Tr.debug(tc, "isClusterFile: null URI");
        }
        return isCluster;
    }

    private void checkClusterConfigLimit(WorkSpaceFile clusterFile) throws WorkSpaceException {
        ConfigRepository masterRepo;
        String[] existingClusters;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterConfigLimit");
        }
        RepositoryContext cellContext = clusterFile.getContext().getParentContext();
        String clustersURI = cellContext.getURI() + "/clusters";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusters URI: " + clustersURI);
        }
        if ((existingClusters = (masterRepo = WorkSpaceMasterRepositoryAdapter.getDefaultRepository()).listResourceNames(clustersURI, 2, 0)).length > 0) {
            existingClusters = masterRepo.listResourceNames(clustersURI, 2, 1);
        }
        short existingClusterCount = (short)existingClusters.length;
        Collection clusterCtxs = cellContext.findContext(cellContext.getWorkSpace().getMetaData().getContextType("clusters"));
        short newClusterCount = (short)clusterCtxs.size();
        short totalClusterCount = (short)(existingClusterCount + newClusterCount);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster Info:", new String[]{"existing=" + existingClusterCount, "newClusterCount=" + newClusterCount});
        }
        try {
            ConfigLimits limits = ConfigLimits.createConfigLimits();
            if (!limits.isNumberOfClustersWithinLimit(totalClusterCount)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkClusterConfigLimit: Exceeding number of clusters permitted by license.", new String[]{"totalClusterCount=" + totalClusterCount});
                }
                throw WorkSpaceLogger.createException(tc, "WKSP0550E Application Server license restrictions in effect do not allow this configuration change.");
            }
        }
        catch (AdminException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkClusterConfigLimit", "Exception: Config limits read error.");
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0551E An error occurred while checking licensing restrictions.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterConfigLimit", "Within limits");
        }
    }

    public void extract(WorkSpaceFile file) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (file: " + file + ")");
        }
        this.extract(file, file.getURI(), this.needMerge(file));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (file: " + file + ")");
        }
    }

    private void extract(WorkSpaceFile file, String target, boolean needCopy) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (file: " + file + ", target: " + target + ", needCopy: " + needCopy + ")");
        }
        FileOutputStream out = null;
        FileOutputStream siOut = null;
        String fileURI = file.getURI();
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        try {
            File filePath = new File(target);
            FileAccessorUtil.makeDir(fa, filePath.getParent());
            if (this.debugEnabled) {
                Tr.debug(tc, "Extracting from " + fileURI);
            }
            DocumentContentSource dc = this.getConfigRepository().extract(fileURI);
            if (this.debugEnabled) {
                Tr.debug(tc, "Extracting to   " + filePath + ", under: " + filePath.getParentFile() + ", size = " + dc.getSource().available());
            }
            out = (FileOutputStream)fa.getOutputStream(target);
            if (needCopy) {
                if (this.debugEnabled) {
                    Tr.debug(tc, "\tKeep original ");
                }
                siOut = (FileOutputStream)fa.getOutputStream(target + ORIG_SUFFIX);
            }
            InputStream in = dc.getSource();
            byte[] buf = new byte[4096];
            int bytesRead = in.read(buf);
            while (bytesRead != -1) {
                out.write(buf, 0, bytesRead);
                if (siOut != null) {
                    siOut.write(buf, 0, bytesRead);
                }
                bytesRead = in.read(buf);
            }
            in.close();
            out.flush();
            out.close();
            if (siOut != null) {
                siOut.flush();
                siOut.close();
            }
            this.setDigest(fa, target + DIGEST_SUFFIX, dc.getDocument().getDigest());
        }
        catch (IOException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0012E Exception when while extracting {0} from Config Repository--{1}", new Object[]{fileURI, e}, e);
        }
        catch (RepositoryException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0012E Exception when while extracting {0} from Config Repository--{1}", new Object[]{fileURI, e}, e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (siOut != null) {
                    siOut.close();
                }
            }
            catch (IOException e) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (file: " + file + ", target: " + target + ", needCopy: " + needCopy + ")");
        }
    }

    private boolean needMerge(WorkSpaceFile file) {
        return file.getName().equalsIgnoreCase(SERVER_INDEX_NAME);
    }

    private void setDigest(FileAccessor fa, String path, DocumentDigest digest) throws WorkSpaceException {
        try {
            ObjectOutputStream out = new ObjectOutputStream(fa.getOutputStream(path));
            out.writeObject(digest);
            out.close();
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0017E Error keep digest for {0}:{1} --{2}", new Object[]{path, digest, e}, e);
        }
    }

    public void release(WorkSpaceFile file) throws WorkSpaceException {
        if (this.debugEnabled) {
            Tr.debug(tc, "release: " + file.getPath());
        }
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        FileAccessorUtil.delete(fa, file.getURI());
        FileAccessorUtil.delete(fa, file.getURI() + DIGEST_SUFFIX);
        if (FileAccessorUtil.exist(fa, file.getURI() + ORIG_SUFFIX)) {
            ((WorkSpaceResourceSet)((Object)file.getContext().getResourceSet())).release(file.getName() + ORIG_SUFFIX);
            FileAccessorUtil.delete(fa, file.getURI() + ORIG_SUFFIX);
        }
        if (FileAccessorUtil.exist(fa, file.getURI() + CURRENT_SUFFIX)) {
            ((WorkSpaceResourceSet)((Object)file.getContext().getResourceSet())).release(file.getName() + CURRENT_SUFFIX);
            FileAccessorUtil.delete(fa, file.getURI() + CURRENT_SUFFIX);
        }
        FileAccessorUtil.delete(fa, file.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX);
    }

    public void release(RepositoryContext context) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release (context: " + context + ")");
        }
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        FileAccessorUtil.deleteTree(fa, context.getURI());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release (context: " + context + ")");
        }
    }

    public void delete(RepositoryContext context) throws WorkSpaceException {
    }

    public void delete(WorkSpaceFile file) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (file: " + file + ")");
        }
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        FileAccessorUtil.delete(fa, file.getURI());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete (file: " + file + ")");
        }
    }

    public void setSessionId(WorkSpace ws) throws WorkSpaceException {
        this.createSessionIdFile(ws);
    }

    public void unsetSessionId(WorkSpace ws) throws WorkSpaceException {
        this.deleteSessionIdFile(ws);
    }

    public boolean isValid(WorkSpace ws) throws WorkSpaceException {
        try {
            FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
            String sessionIdFilePath = this.getSessionIdFilePath(ws);
            return FileAccessorUtil.exist(fa, sessionIdFilePath);
        }
        catch (Exception e) {
            throw new WorkSpaceException("Exception in isValid workspace ", e);
        }
    }

    private String getSessionIdFilePath(WorkSpace ws) {
        return SESSION_ID_FILE_PREFIX + ws.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessionIdFile(WorkSpace ws) throws WorkSpaceException {
        FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
        String sessionIdFilePath = this.getSessionIdFilePath(ws);
        try {
            if (!FileAccessorUtil.exist(fa, "")) {
                FileAccessorUtil.makeDir(fa, "");
            } else {
                List existingSessionIdFiles = FileAccessorUtil.listFiles(fa, "", 1, 1);
                for (int i = 0; i < existingSessionIdFiles.size(); ++i) {
                    String path = (String)existingSessionIdFiles.get(i);
                    if (!path.startsWith(SESSION_ID_FILE_PREFIX)) continue;
                    FileAccessorUtil.delete(fa, path);
                }
            }
            FileAccessorUtil.createNewFile(fa, sessionIdFilePath);
            FileOutputStream out = null;
            try {
                out = (FileOutputStream)fa.getOutputStream(sessionIdFilePath);
                byte[] buf = ((WorkSpaceImpl)ws).getCallerInfo().getBytes();
                out.write(buf);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                    ((WorkSpaceImpl)ws).setCallerInfo("");
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            if (fa instanceof DefaultFileAccessor) {
                String filePath = ((DefaultFileAccessor)fa).getFullPath(sessionIdFilePath);
                throw WorkSpaceLogger.createException(tc, "WKSP0011E Unable to create existing session id file {0} --{1}", new Object[]{filePath, e}, e);
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0011E Unable to create existing session id file {0} --{1}", new Object[]{sessionIdFilePath, e}, e);
        }
    }

    private void deleteSessionIdFile(WorkSpace ws) {
        try {
            FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
            String sessionIdFilePath = this.getSessionIdFilePath(ws);
            fa.delete(sessionIdFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize(Properties prop) throws WorkSpaceException {
        this.setRepositoryProp(prop);
    }

    private static void initialize() throws WorkSpaceException {
        if (!init) {
            try {
                Properties prop1 = new Properties();
                ConfigRepositoryFactory.getConfigRepository().initialize(prop1);
            }
            catch (Exception e) {
                WorkSpaceLogger.createException(tc, "WKSP0000E Error initialize  -- {0}", new Object[]{e}, e);
            }
            init = true;
        }
    }

    private void setRepositoryProp(Properties prop) {
        this.repositoryProp = prop;
        this.configRepository = null;
    }

    public void remove(WorkSpace ws) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove (wsUserPath: " + ws.getUserPath() + ")");
        }
        try {
            FileAccessor fa = ((WorkSpaceImpl)ws).getFileAccessor();
            FileAccessorUtil.deleteTree(fa, "");
            FileAccessorUtil.deleteUserPath(fa, ws.getUserPath());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove workspace repository failed ");
            }
            throw new WorkSpaceException("remove failed", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove (wsUserPath: " + ws.getUserPath() + ")");
        }
    }

    public void removeWithProfileKeyPath(WorkSpace ws) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove (removeWithProfileKeyPath: " + ws.getUserPath() + ")");
        }
        this.remove(ws);
        File userPath = new File(ws.getUserPath());
        File parentDir = userPath.getParentFile();
        File[] dirList = parentDir.listFiles();
        if (dirList != null && dirList.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting parent directory: (" + parentDir + ")");
            }
            parentDir.delete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove (removeWithProfileKeyPath: " + ws.getUserPath() + ")");
        }
    }

    public void save(RepositoryContext context) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save (context: \"" + context + "\")");
        }
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        String path = context.getURI();
        OutputStream os2 = null;
        String fileName = path.length() == 0 ? WORKSPACE_REPOSITORY : path + File.separator + WORKSPACE_REPOSITORY;
        String fullPath = FileAccessorUtil.getFullPath(fa, fileName.replace('/', File.separatorChar));
        try {
            FileAccessorUtil.makeDir(fa, path);
            if (!FileAccessorUtil.exist(fa, fileName)) {
                FileAccessorUtil.createNewFile(fa, fileName);
            }
            os2 = (FileOutputStream)fa.getOutputStream(fileName);
            byte[] b = context.getPersistData().getBytes();
            ((FileOutputStream)os2).write(b);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Context Saved: (" + context.getState() + ") " + fullPath);
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                try {
                    WorkSpaceMasterRepositoryAdapter.checkURILength(fullPath);
                }
                catch (IOException ioe) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0006E Error while saving context {0}-{1}", new Object[]{context.getName(), ioe}, e);
                }
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0006E Error while saving context {0}-{1}", new Object[]{context.getName(), e}, e);
        }
        finally {
            try {
                if (os2 != null) {
                    os2.flush();
                    ((FileOutputStream)os2).close();
                }
            }
            catch (IOException e) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save (context: \"" + context + "\")");
        }
    }

    public static void checkURILength(String uri) throws IOException {
        int windowsMaxPath = 259;
    }

    public String restore(RepositoryContext context) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restore (context: \"" + context + "\")");
        }
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        String value = null;
        String filePath = context.getURI().length() == 0 ? WORKSPACE_REPOSITORY : context.getURI() + File.separator + WORKSPACE_REPOSITORY;
        BufferedReader br = null;
        InputStream is = null;
        try {
            if (FileAccessorUtil.exist(fa, filePath)) {
                is = fa.load(filePath);
                br = new BufferedReader(new InputStreamReader(is));
                value = br.readLine();
            }
        }
        catch (IOException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0001E Error reading serialized context from {0} -- {1}", new Object[]{filePath, e}, e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restore (context: \"" + context + "\"), value: " + value);
        }
        return value;
    }

    private Object collectFile(WorkSpaceFile file, Integer conflictResolution) throws WorkSpaceException {
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        Document doc = this.getDocument(file);
        Serializable result = null;
        if (conflictResolution != null && conflictResolution == ConflictResolution.OVER_WRITE) {
            doc.setOverwrite(true);
        }
        if (file.getState() == WorkSpaceFileState.ADDED) {
            result = this.getDocumentContentSource(fa, doc, file.getURI());
        } else if (file.getState() == WorkSpaceFileState.UPDATED) {
            String path = null;
            if (this.needMerge(file) && !FileAccessorUtil.exist(fa, path = file.getURI() + CURRENT_SUFFIX)) {
                path = null;
            }
            if (path == null) {
                path = file.getURI();
            }
            if (this.debugEnabled) {
                Tr.debug(tc, "Source version: " + path);
            }
            result = this.getDocumentContentSource(fa, doc, path);
        } else {
            result = doc;
        }
        return result;
    }

    private Integer checkMerge(WorkSpaceFile file, Integer conflictState) throws WorkSpaceException {
        Integer result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkMerge (file: \"" + file.getURI() + "\", conflictState: " + conflictState + ")");
        }
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        if (!this.needMerge(file)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkMerge return conflictState = " + conflictState);
            }
            return conflictState;
        }
        RepositoryContextImpl rc = (RepositoryContextImpl)file.getContext();
        rc.resetAdapterNotifier(false);
        this.extract(file, file.getURI() + CURRENT_SUFFIX, false);
        String fileName = file.getName();
        if (MergeUtilManager.getUtil(file).merge(file.getContext(), fileName, fileName + ORIG_SUFFIX, fileName + CURRENT_SUFFIX)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can be merged:" + fileName);
            }
            result = ConflictState.UN_MODIFIED;
        } else {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can not be merged:" + fileName);
            }
            FileAccessorUtil.delete(fa, file.getURI() + CURRENT_SUFFIX);
            FileAccessorUtil.delete(fa, file.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX);
            result = ConflictState.MODIFIED;
        }
        rc.resetAdapterNotifier(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkMerge return conflictState = " + result);
        }
        return result;
    }

    private Integer checkMergeForRefresh(WorkSpaceFile file, Integer conflictState) throws WorkSpaceException {
        Integer result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkMergeForRefresh (file: \"" + file.getURI() + "\", conflictState: " + conflictState + ")");
        }
        RepositoryContext context = file.getContext();
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        FileAccessor fa = ws.getFileAccessor();
        if (!this.needMerge(file)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkMergeForRefresh return conflictState = " + conflictState);
            }
            return conflictState;
        }
        RepositoryContextImpl rc = (RepositoryContextImpl)file.getContext();
        rc.resetAdapterNotifier(false);
        this.extract(file, file.getURI() + CURRENT_SUFFIX, false);
        String fileName = file.getName();
        if (MergeUtilManager.getUtil(file).merge(file.getContext(), fileName, fileName + ORIG_SUFFIX, fileName + CURRENT_SUFFIX)) {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can be merged:" + fileName);
            }
            result = ConflictState.MODIFIED;
        } else {
            if (this.debugEnabled) {
                Tr.debug(tc, "Can not be merged:" + fileName);
            }
            FileAccessorUtil.delete(fa, file.getURI() + CURRENT_SUFFIX);
            FileAccessorUtil.delete(fa, file.getURI() + CURRENT_SUFFIX + DIGEST_SUFFIX);
            result = ConflictState.MODIFIED;
        }
        rc.resetAdapterNotifier(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkMergeForRefresh return conflictState = " + result);
        }
        return result;
    }

    private InputStream readFile(FileAccessor fa, String fileName) throws IOException {
        RepositoryInputStream rs = null;
        if (fa instanceof DefaultFileAccessor) {
            File rootDir = ((DefaultFileAccessor)fa).getRootDir();
            File f = new File(rootDir.getPath() + File.separator + fileName);
            rs = new RepositoryInputStream(f);
        } else {
            rs = new RepositoryInputStream();
        }
        InputStream in = fa.load(fileName);
        rs.setStream(in);
        return rs;
    }

    private DocumentContentSource getDocumentContentSource(FileAccessor fa, Document doc, String filePath) throws WorkSpaceException {
        try {
            if (fa instanceof DefaultFileAccessor) {
                return new DocumentContentSource(doc, this.getFile((DefaultFileAccessor)fa, filePath));
            }
            return new DocumentContentSource(doc, this.readFile(fa, filePath));
        }
        catch (IOException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0018E Error read file for {0} --{1}", new Object[]{filePath, e}, e);
        }
    }

    private File getFile(DefaultFileAccessor dfa, String fileURI) throws IOException {
        File rootDir = dfa.getRootDir();
        File file = new File(rootDir.getPath() + File.separator + fileURI);
        return file;
    }

    private Document getDocument(WorkSpaceFile file) throws WorkSpaceException {
        Document doc = file.getState() == WorkSpaceFileState.ADDED ? new Document(file.getURI()) : new Document(file.getURI(), this.getDigest(file));
        return doc;
    }

    public RepositoryMetaData getMetaData() {
        return this.getDefaultMetaData();
    }

    private class SessionIdFileFilter
    implements FilenameFilter {
        private SessionIdFileFilter() {
        }

        public boolean accept(File dir, String fileName) {
            return fileName.startsWith(WorkSpaceMasterRepositoryAdapter.SESSION_ID_FILE_PREFIX);
        }
    }
}

