/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceCatalogManager;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceEventImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceFileImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkspaceMetadataAccessor;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.migration.MOFWorkSpaceImpl;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceImpl
extends MOFWorkSpaceImpl
implements WorkSpace,
WorkSpaceConstant,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceImpl.class);
    protected boolean enableSave = true;
    protected String userName = "";
    protected String sessionId = null;
    protected String path = null;
    protected String userPath = null;
    protected FileAccessor fa = null;
    protected RepositoryContextImpl rootContext = null;
    protected List listeners = new ArrayList();
    private WorkSpaceCatalogManager catalogManager;
    private RepositoryMetaData metaData;
    private WorkSpaceRepositoryAdapter repositoryAdapter;
    private ManagedObjectMetadataHelper metadataHelper;
    private ManagedObjectMetadataAccessor accessor;
    private String callerInfo = "";
    private String pKey = null;
    private boolean cleanupNeeded = true;

    public WorkSpaceImpl(String userName) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkSpaceImpl (userName: " + userName + ")");
        }
        this.userName = userName;
        Properties metadataProps = new Properties();
        try {
            this.accessor = new WorkspaceMetadataAccessor(this, metadataProps);
            this.metadataHelper = new ManagedObjectMetadataHelper(this.accessor);
        }
        catch (AdminException ex) {
            throw new WorkSpaceException("unexpected expection", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkSpaceImpl (userName: " + userName + ")");
        }
    }

    WorkSpaceCatalogManager getCatalogManager() {
        if (this.catalogManager == null) {
            this.catalogManager = new WorkSpaceCatalogManager(this);
        }
        return this.catalogManager;
    }

    public RepositoryMetaData getMetaData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetaData");
        }
        if (this.metaData == null) {
            this.metaData = this.getRepositoryAdapter().getMetaData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetaData", this.metaData);
        }
        return this.metaData;
    }

    WorkSpaceRepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    void setRepositoryAdapter(WorkSpaceRepositoryAdapter repositoryAdapter) {
        this.repositoryAdapter = repositoryAdapter;
    }

    void setMetaData(RepositoryMetaData metaData) {
        this.metaData = metaData;
    }

    public void addWorkSpaceListener(WorkSpaceListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWorkSpaceListener", listener);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWorkSpaceListener");
        }
    }

    public Map checkSynchState() throws WorkSpaceException {
        return this.getRootContext().checkSynchState();
    }

    public Map checkSynchStateForRefresh() throws WorkSpaceException {
        return this.getRootContext().checkSynchStateForRefresh();
    }

    public Map checkSynchState(RepositoryContext context) throws WorkSpaceException {
        return context.checkSynchState();
    }

    public Map checkSynchStateForRefresh(RepositoryContext context) throws WorkSpaceException {
        return context.checkSynchStateForRefresh();
    }

    public void checkValid() throws WorkSpaceException {
        if (!this.isValid()) {
            this.notify(new WorkSpaceEventImpl(this, 0));
            throw WorkSpaceLogger.createException(tc, "WKSP0009E Workspace is not valid");
        }
    }

    public synchronized RepositoryContext create(RepositoryContext parent, RepositoryContextType type, String name) throws WorkSpaceException {
        return parent.create(type, name);
    }

    private RepositoryContextImpl createRootContext() {
        RepositoryContextImpl context = new RepositoryContextImpl(this, this.getRootContextType(), "", null);
        context.setRelativeURI("");
        return context;
    }

    public void delete(RepositoryContext context) throws WorkSpaceException {
        context.delete(true);
    }

    public void extract(RepositoryContext context, String fileName, boolean overwrite) throws WorkSpaceException {
        context.extract(fileName, overwrite);
    }

    public void extract(RepositoryContext context, boolean overwrite) throws WorkSpaceException {
        context.extract(overwrite);
    }

    public Collection findContext(RepositoryContextType type) throws WorkSpaceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findContext,  type: " + type.getName() + ", from ROOT.");
        }
        return this.getRootContext().findContext(type);
    }

    public RepositoryContext findContext(String uri) throws WorkSpaceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findContext,   uri: " + uri + ", from ROOT.");
        }
        return this.getRootContext().findContext(uri);
    }

    public List getModifiedList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModifiedList");
        }
        List modifiedList = this.getRootContext().getModifiedList(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModifiedList", modifiedList);
        }
        return modifiedList;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.getUserPath() + FILE_SEPERATOR + "workspace";
        }
        return this.path;
    }

    public String getUserPath() {
        if (this.userPath == null) {
            this.userPath = WORKSPACE_PATH_NAME;
            String uuid = AdminContext.peek();
            if (uuid != null) {
                this.userPath = this.userPath + FILE_SEPERATOR + uuid;
                this.pKey = uuid;
            }
            this.userPath = this.userPath + FILE_SEPERATOR + this.getUserName();
        }
        return this.userPath;
    }

    public FileAccessor getFileAccessor() {
        return this.fa;
    }

    void setFileAccessor(FileAccessor fa) {
        this.fa = fa;
    }

    void setUserRoot(String userRoot) {
        this.userPath = userRoot + FILE_SEPERATOR + this.getUserName();
        this.path = null;
    }

    void setPath(String path) {
        this.path = path;
        this.userPath = path;
    }

    public RepositoryContext getRootContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootContext ()");
        }
        if (this.rootContext == null) {
            this.rootContext = this.createRootContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootContext () \"" + this.rootContext + "\"");
        }
        return this.rootContext;
    }

    private RepositoryContextType getRootContextType() {
        return this.getMetaData().getRootContextType();
    }

    public boolean isExtracted(RepositoryContext context, String fileName) {
        return context.isExtracted(fileName);
    }

    void enableSave() {
        this.enableSave = true;
    }

    void disableSave() {
        this.enableSave = false;
    }

    boolean isEnableSave() {
        return this.enableSave;
    }

    boolean isValid() throws WorkSpaceException {
        boolean valid = true;
        valid = this.sessionId == null ? false : this.getRepositoryAdapter().isValid(this);
        return valid;
    }

    public void notify(WorkSpaceEvent event2) throws WorkSpaceException {
        String msg = "notify [" + event2.getType() + "] ";
        if (tc.isEntryEnabled()) {
            Object obj = event2.getSource();
            if (obj instanceof WorkSpaceImpl) {
                msg = msg + "path: " + this.userPath;
            } else if (obj instanceof RepositoryContextImpl) {
                msg = msg + (RepositoryContextImpl)obj;
            } else if (obj instanceof WorkSpaceFileImpl) {
                msg = msg + (WorkSpaceFileImpl)obj;
            }
            Tr.entry(tc, msg);
        }
        for (WorkSpaceListener listener : this.listeners) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  listener: " + listener);
            }
            listener.handle(event2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, msg);
        }
    }

    void remove() throws WorkSpaceException {
        this.release();
        WorkSpaceRepositoryAdapter wsRepAdapter = this.getRepositoryAdapter();
        if (wsRepAdapter instanceof WorkSpaceMasterRepositoryAdapter && this.isProfileKeyMatched()) {
            WorkSpaceMasterRepositoryAdapter wsMasterRepAdapter = (WorkSpaceMasterRepositoryAdapter)wsRepAdapter;
            wsMasterRepAdapter.removeWithProfileKeyPath(this);
        } else {
            wsRepAdapter.remove(this);
        }
    }

    public void release() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start releasing workspace. Discard all the changes in the local workspace of UserID: " + this.userName + ", SessionID: " + this.sessionId);
        }
        this.getRootContext().release(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Done releasing workspace.");
        }
    }

    public void releaseUnchanged(boolean keep) throws WorkSpaceException {
        this.getRootContext().releaseUnchanged(true, keep);
    }

    public void release(RepositoryContext context) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start releasing context. Discard all the changes under context " + context.getName());
        }
        context.release(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Done releasing context.");
        }
    }

    public void removePersistent() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePersistent");
        }
        if (WorkSpaceMasterRepositoryAdapter.class.isInstance(this.repositoryAdapter)) {
            FileAccessorUtil.deleteTree(this.getFileAccessor(), "");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePersistent");
        }
    }

    public void removeWorkSpaceListener(WorkSpaceListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWorkSpaceListener", listener);
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWorkSpaceListener");
        }
    }

    void restore() throws WorkSpaceException {
        String wsPath = this.getPath();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Restoring repository context tree from wstemp, " + wsPath);
        }
        long startRestore = System.currentTimeMillis();
        ((RepositoryContextImpl)this.getRootContext()).restore();
        long endRestore = System.currentTimeMillis();
        long sec2 = (endRestore - startRestore) / 1000L;
        long nanos = (endRestore - startRestore) % 1000L;
        ((RepositoryContextImpl)this.getRootContext()).getAdapter().releaseCachedCatalog(this.getUserName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Restoring repository context tree from wstemp, " + wsPath + " took " + sec2 + "." + nanos + " sec.");
        }
    }

    public void synch(RepositoryContext context, Map conflictResolutions) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synch", new Object[]{context, conflictResolutions});
        }
        context.synch(conflictResolutions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synch");
        }
    }

    public void synch(Map conflictResolutions) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synch from root", conflictResolutions);
        }
        this.getRootContext().synch(conflictResolutions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synch from root");
        }
    }

    boolean ofSession(String sessionId) throws WorkSpaceException {
        boolean ok = true;
        if (this.isValid()) {
            if (sessionId == null) {
                sessionId = "";
            }
            ok = this.sessionId.equals(sessionId);
        }
        return ok;
    }

    void setSessionId(String sessionId) throws WorkSpaceException {
        if (sessionId == null) {
            sessionId = "";
        }
        this.sessionId = sessionId;
        this.getRepositoryAdapter().setSessionId(this);
        this.notify(new WorkSpaceEventImpl(this, 1));
    }

    void unsetSessionId() throws WorkSpaceException {
        if (this.sessionId != null) {
            this.getRepositoryAdapter().unsetSessionId(this);
            this.sessionId = null;
        }
        this.notify(new WorkSpaceEventImpl(this, 0));
        this.listeners.clear();
    }

    void setCallerInfo(String callerInfo) {
        this.callerInfo = callerInfo;
    }

    String getCallerInfo() {
        return this.callerInfo;
    }

    public boolean cleanupNeeded() {
        return this.cleanupNeeded;
    }

    private boolean isProfileKeyMatched() {
        boolean result = false;
        String currentKey = AdminContext.peek();
        if (this.pKey != null && currentKey != null && currentKey.equals(this.pKey)) {
            result = true;
        }
        return result;
    }

    public void setDisableCleanup() {
        this.cleanupNeeded = false;
    }

    public ManagedObjectMetadataHelper getMetadataHelper() {
        return this.metadataHelper;
    }

    public ManagedObjectMetadataAccessor getManagedObjectMetadataAccessor() {
        return this.accessor;
    }
}

