/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class WorkSpaceCatalogManager
implements WorkSpaceConstant {
    private WorkSpaceImpl workspace;

    WorkSpaceCatalogManager(WorkSpaceImpl workspace) {
        this.workspace = workspace;
    }

    private WorkSpaceRepositoryAdapter getRepositoryAdapter() throws WorkSpaceException {
        return this.workspace.getRepositoryAdapter();
    }

    Map getDeltaChangesInRepository(RepositoryContextImpl context) throws WorkSpaceException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WorkSpaceRepositoryAdapter repository2 = context.getRepositoryAdapter();
        if (context.getState() == WorkSpaceFileState.UPDATED || context.getState() == WorkSpaceFileState.DELETED) {
            if (!repository2.exist(this.workspace, context.getURI())) {
                result.put(context.getURI(), WorkSpaceFileState.DELETED);
                return result;
            }
        } else if (context.getState() == WorkSpaceFileState.ADDED) {
            if (repository2.exist(this.workspace, context.getURI())) {
                result.put(context.getURI(), WorkSpaceFileState.ADDED);
            }
            return result;
        }
        for (RepositoryContextType type : context.getType().getChildContextTypes()) {
            for (String name : context.getAdapter().getChildContextsInRepository(type).keySet()) {
                RepositoryContext newContext = context.getChildForRebuild(type, name);
                if (newContext != null) continue;
                StringBuffer uri = new StringBuffer(context.getURI());
                name = context.getAdapter().getChildContextURI(type, name);
                if (uri.length() > 0 && name.length() > 0) {
                    uri.append('/');
                }
                uri.append(name);
                result.put(uri.toString(), WorkSpaceFileState.ADDED);
            }
        }
        Iterator itr = context.getChildren().iterator();
        while (itr.hasNext()) {
            result.putAll(this.getDeltaChangesInRepository((RepositoryContextImpl)itr.next()));
        }
        return result;
    }
}

