/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SystemModifiedFiles {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(SystemModifiedFiles.class);
    private static HashMap systemModifiedFilesMap = new HashMap();
    private static ThreadLocal filesSystemModifiedInSession = null;

    public static synchronized void addFile(String sessionId, String file) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFile(session: " + sessionId + " file: " + file + " )");
        }
        if (sessionId == null || sessionId.equals("") || file == null || file.equals("")) {
            return;
        }
        HashSet<String> fileSet = (HashSet<String>)systemModifiedFilesMap.get(sessionId);
        if (fileSet == null) {
            fileSet = new HashSet<String>();
            systemModifiedFilesMap.put(sessionId, fileSet);
        }
        fileSet.add(file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFile -- systemModifiedFilesMap: " + systemModifiedFilesMap);
        }
    }

    public static synchronized Set getFileSet(String sessionId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileList for session: " + sessionId);
        }
        if (sessionId == null || sessionId.equals("")) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "systemModifiedFilesMap: " + systemModifiedFilesMap);
        }
        HashSet result = (HashSet)systemModifiedFilesMap.get(sessionId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileList for session (" + sessionId + ") :" + result);
        }
        return result;
    }

    public static synchronized ThreadLocal createThreadLocalFileSet(String sessionId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createThreadLocalFileSet for session: " + sessionId);
        }
        if (sessionId == null || sessionId.equals("")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadLocalFileSet returns null for empty or null sessionId");
            }
            return null;
        }
        final HashSet result = (HashSet)systemModifiedFilesMap.get(sessionId);
        if (result == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createThreadLocalFileSet returns null as none is found in systemModifiedFilesMap: " + systemModifiedFilesMap);
            }
            return null;
        }
        filesSystemModifiedInSession = new ThreadLocal(){

            protected synchronized Object initialValue() {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ThreadLocal.initialValue(): " + result);
                }
                return result;
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createThreadLocalFileSet for session (" + sessionId + ") :" + filesSystemModifiedInSession);
        }
        return filesSystemModifiedInSession;
    }

    public static synchronized ThreadLocal getThreadLocalFileSet() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getThreadLocalFileSet: " + filesSystemModifiedInSession);
        }
        return filesSystemModifiedInSession;
    }

    public static synchronized void RemoveFileSet(String sessionId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RemoveFileSet: " + sessionId);
        }
        HashSet removedSet = (HashSet)systemModifiedFilesMap.remove(sessionId);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed " + removedSet);
            Tr.debug(tc, "Setting filesSystemModifiedInSession to null from " + filesSystemModifiedInSession);
        }
        filesSystemModifiedInSession = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RemoveFileSet");
        }
    }
}

