/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.RepositoryContextPluggable;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import java.util.HashMap;
import java.util.Map;

public class RepositoryContextAdapter {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextAdapter.class);
    private static final char URI_SEPERATOR = '/';
    private RepositoryContextPluggable context;
    private HashMap _catalogs = new HashMap();

    public void setContext(RepositoryContextPluggable context) {
        this.context = context;
    }

    public RepositoryContextPluggable getContext() {
        return this.context;
    }

    public Map getChildContextsInRepository(RepositoryContextType type) throws WorkSpaceException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer uri = new StringBuffer(this.context.getURI());
        String typeName = type.getName();
        if (uri.length() > 0 && typeName.length() > 0) {
            uri.append('/');
        }
        uri.append(typeName);
        String uriString = uri.toString();
        String[] catalog = this.context.getRepositoryAdapter().getCatalog(this.context.getWorkSpace(), uriString, 0, 1);
        boolean needHidden = false;
        for (int i = 0; i < catalog.length; ++i) {
            if (type.getChildContextType(catalog[i]) == null) {
                result.put(catalog[i], this.getChildContextURI(type, catalog[i]));
                continue;
            }
            needHidden = true;
        }
        if (result.size() == 0 && this.context.getRepositoryAdapter().exist(this.context.getWorkSpace(), uriString)) {
            needHidden = true;
        }
        if (needHidden) {
            result.put("", this.getChildContextURI(type, ""));
        }
        return result;
    }

    Map getChildContextsForRestore(RepositoryContextType type) throws WorkSpaceException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer uri = new StringBuffer(this.context.getURI());
        String typeName = type.getName();
        if (uri.length() > 0 && typeName.length() > 0) {
            uri.append('/');
        }
        uri.append(typeName);
        String uriString = uri.toString();
        String[] catalog = this.getCachedCatalog(this.context.getWorkSpace(), uriString);
        boolean needHidden = false;
        for (int i = 0; i < catalog.length; ++i) {
            if (type.getChildContextType(catalog[i]) == null) {
                result.put(catalog[i], this.getChildContextURI(type, catalog[i]));
                continue;
            }
            needHidden = true;
        }
        if (result.size() == 0 && this.context.getRepositoryAdapter().exist(this.context.getWorkSpace(), uriString)) {
            needHidden = true;
        }
        if (needHidden) {
            result.put("", this.getChildContextURI(type, ""));
        }
        return result;
    }

    private String[] getCachedCatalog(WorkSpace workspace, String uriString) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedCatalog ()", new Object[]{workspace, uriString});
        }
        int fromCache = 1;
        String wsID = workspace.getUserName();
        String[] result = null;
        HashMap<String, String[]> catalog = (HashMap<String, String[]>)this._catalogs.get(wsID);
        if (catalog == null) {
            catalog = new HashMap<String, String[]>();
            this._catalogs.put(wsID, catalog);
        } else {
            result = (String[])catalog.get(uriString);
        }
        if (result == null) {
            result = this.context.getRepositoryAdapter().getCatalog(workspace, uriString, 0, 1);
            catalog.put(uriString, result);
            fromCache = 0;
        }
        if (tc.isEntryEnabled()) {
            String catalogStr = "";
            if (uriString.length() > 0) {
                for (int i = 0; i < result.length; ++i) {
                    if (i != 0) {
                        catalogStr = catalogStr + ", ";
                    }
                    catalogStr = catalogStr + result[i];
                }
            }
            Tr.exit(tc, "getCachedCatalog ...: [" + catalogStr + "] " + fromCache);
        }
        return result;
    }

    void releaseCachedCatalog(String wsID) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseCachedCatalog, catalog size = " + this._catalogs.size() + ", workspace ID = " + wsID);
        }
        this._catalogs.remove(wsID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseCachedCatalog, catalog size = " + this._catalogs.size());
        }
    }

    public String getChildContextURI(RepositoryContextType type, String name) {
        StringBuffer uri = new StringBuffer(type.getName());
        if (type.getName().length() > 0 && name.length() > 0) {
            uri.append('/');
        }
        uri.append(name);
        return uri.toString();
    }

    public RepositoryContext findContext(String uri) throws WorkSpaceException {
        RepositoryContext newContext;
        RepositoryContextType childType;
        String appName;
        String[] app;
        String earFile;
        if (uri.length() == 0) {
            return this.context;
        }
        int index = uri.indexOf(47);
        String token = index == -1 ? uri : uri.substring(0, index);
        if (token.equals("applications") && uri.endsWith(".ear") && (earFile = uri.substring(index + 1)).length() != 0 && earFile.indexOf(47) == -1 && !(app = EditionHelper.getAppAndEdition(appName = earFile.substring(0, earFile.indexOf(".ear"))))[0].equals(appName)) {
            uri = "applications/" + app[0] + ".ear";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RepositoryContextAdapter.findContext - modifiying uri for editioned application (" + appName + ") to: " + uri);
            }
        }
        if ((childType = this.context.getType().getChildContextType(token)) == null) {
            return this.context;
        }
        token = "";
        int newIndex = -1;
        if (index >= 0 && childType.getChildContextType(token = (newIndex = uri.indexOf(47, index + 1)) == -1 ? uri.substring(index + 1) : uri.substring(index + 1, newIndex)) != null) {
            token = "";
            newIndex = index;
        }
        if ((newContext = this.context.getChild(childType, token)) != null && newIndex >= 0 && newIndex < uri.length()) {
            return newContext.findContext(uri.substring(newIndex + 1));
        }
        return newContext;
    }
}

