/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.zOS.SAFAuthorizationInterface;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.AuthorizationDeniedException;
import com.ibm.ws.security.zOS.authz.InactiveClassException;
import com.ibm.ws.security.zOS.authz.InvalidCredentialException;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationOptions;
import javax.security.auth.Subject;

public final class SAFAuthorizationManager
implements SAFAuthorizationInterface {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationManager.class, "Security", "com.ibm.ejs.resources.security");
    private static final SAFAuthorizationManager _instance = new SAFAuthorizationManager();
    private PlatformCredentialManager platformCredManager = null;

    public static SAFAuthorizationManager instance() {
        return _instance;
    }

    private SAFAuthorizationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public boolean isCallerAuthorized(String className, String resource, String accessLevel, boolean msgSuppress, String logOption) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        Subject subject;
        PlatformCredential pc;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized5", new Object[]{className, resource, accessLevel, msgSuppress, logOption});
        }
        if ((pc = this.getPlatformCredentialFromSubject(subject = this.getEffectiveSubject())) == null) {
            throw new InvalidCredentialException("Subject does not contain a PlatformCredential");
        }
        boolean authorized = this.checkAccess(pc, className, resource, null, this.getAccessLevel(accessLevel), this.getLogOption(logOption), msgSuppress);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized5", new Boolean(authorized));
        }
        return authorized;
    }

    public boolean isCallerAuthorized(String className, String resource, String accessLevel) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized3", new Object[]{className, resource, accessLevel});
        }
        boolean authorized = this.isCallerAuthorized(className, resource, this.getAccessLevel(accessLevel));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized3", new Boolean(authorized));
        }
        return authorized;
    }

    public boolean isCallerAuthorized(String className, String resource) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized2", new Object[]{className, resource});
        }
        boolean authorized = this.isCallerAuthorized(className, resource, AccessLevel.READ);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized2", new Boolean(authorized));
        }
        return authorized;
    }

    public boolean isCallerAuthorized(String className, String resource, AccessLevel accessLevel) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        Subject subject;
        PlatformCredential pc;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized3-1", new Object[]{className, resource, accessLevel});
        }
        if ((pc = this.getPlatformCredentialFromSubject(subject = this.getEffectiveSubject())) == null) {
            throw new InvalidCredentialException("Subject does not contain a PlatformCredential");
        }
        boolean authorized = this.isAuthorized(pc, className, resource, accessLevel);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized3-1", new Boolean(authorized));
        }
        return authorized;
    }

    public boolean isAuthorized(PlatformCredential pc, String className, String resource) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthorized", new Object[]{pc, className, resource});
        }
        boolean authorized = this.isAuthorized(pc, className, resource, AccessLevel.READ);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAuthorized", new Boolean(authorized));
        }
        return authorized;
    }

    public boolean isAuthorized(PlatformCredential pc, String className, String resource, AccessLevel accessLevel) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthorized", new Object[]{pc, className, resource, accessLevel});
        }
        boolean authorized = this.checkAccess(pc, className, resource, null, accessLevel, SAFAuthorizationOptions.NOFAIL, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAuthorized", new Boolean(authorized));
        }
        return authorized;
    }

    public boolean checkAccess(PlatformCredential pc, String className, String resource, String applid, AccessLevel accessLevel, SAFAuthorizationOptions.LogOption logOption, boolean msgSuppress) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        return this.checkAccess(pc, className, resource, applid, accessLevel, logOption, msgSuppress, false);
    }

    public boolean checkAccess(PlatformCredential pc, String className, String resource, String applid, AccessLevel accessLevel, SAFAuthorizationOptions.LogOption logOption, boolean msgSuppress, boolean fastAuth) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{pc, className, resource, applid, accessLevel, logOption, new Boolean(msgSuppress), new Boolean(fastAuth)});
        }
        boolean accessGranted = true;
        SAFServiceResult result = SAFServiceResult.getSafServiceResult();
        int rc = SAFAuthorizationManager.ntv_checkAccess(pc, className, resource, applid, accessLevel.getValue(), logOption.getValue(), msgSuppress, fastAuth, result);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Result", result);
        }
        if (rc != 0) {
            accessGranted = false;
        } else if (result.getSafReturnCode() == 4 && result.getReturnCode() == 4) {
            accessGranted = false;
            if (!this.isResourceClassActive(className)) {
                String msg = className + " class is inactive";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new InactiveClassException(msg);
            }
        } else {
            if (result.getSafReturnCode() == 8 && result.getReturnCode() == 8) {
                String msg = "Authorization denied";
                throw new AuthorizationDeniedException("Authorization denied");
            }
            accessGranted = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(accessGranted));
        }
        return accessGranted;
    }

    public boolean isResourceClassActive(String className) {
        SAFServiceResult result;
        int rc;
        boolean active;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResourceClassActive", className);
        }
        boolean bl = active = (rc = SAFAuthorizationManager.ntv_getClassStatus(className, result = SAFServiceResult.getSafServiceResult())) == 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResourceClassActive", new Boolean(active));
        }
        return active;
    }

    private Subject getEffectiveSubject() throws InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveSubject");
        }
        Subject subject = null;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            subject = contextManager.getInvocationSubject();
            if (subject == null) {
                subject = contextManager.getCallerSubject();
            }
            if (subject == null) {
                subject = contextManager.createUnauthenticatedSubject();
            }
        }
        catch (WSSecurityException wse) {
            String msg = "Unable to acquire subject for authorization";
            InvalidCredentialException ice = new InvalidCredentialException("Unable to acquire subject for authorization", wse);
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "Unable to acquire subject for authorization", ice);
            }
            throw ice;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveSubject", subject);
        }
        return subject;
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
        }
        PlatformCredentialManager pcm = PlatformCredentialManager.instance();
        PlatformCredential pc = pcm.getPlatformCredentialFromSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformCredentialFromSubject", pc);
        }
        return pc;
    }

    private AccessLevel getAccessLevel(String accessLevel) {
        if (accessLevel.equalsIgnoreCase("NO_ACCESS")) {
            return AccessLevel.NO_ACCESS;
        }
        if (accessLevel.equalsIgnoreCase("READ")) {
            return AccessLevel.READ;
        }
        if (accessLevel.equalsIgnoreCase("UPDATE")) {
            return AccessLevel.UPDATE;
        }
        if (accessLevel.equalsIgnoreCase("CONTROL")) {
            return AccessLevel.CONTROL;
        }
        if (accessLevel.equalsIgnoreCase("ALTER")) {
            return AccessLevel.ALTER;
        }
        return AccessLevel.NO_ACCESS;
    }

    private SAFAuthorizationOptions.LogOption getLogOption(String logOption) {
        if (logOption.equalsIgnoreCase("NONE")) {
            return SAFAuthorizationOptions.NONE;
        }
        if (logOption.equalsIgnoreCase("ASIS")) {
            return SAFAuthorizationOptions.ASIS;
        }
        return SAFAuthorizationOptions.NOFAIL;
    }

    private static native int ntv_checkAccess(PlatformCredential var0, String var1, String var2, String var3, int var4, int var5, boolean var6, boolean var7, SAFServiceResult var8);

    private static native int ntv_getClassStatus(String var0, SAFServiceResult var1);
}

