/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.NativeConfiguration;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationManager;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.Subject;

public class TrustedIDEvaluatorImpl
implements TrustedIDEvaluator {
    private SAFAuthorizationManager authzMgr;
    private PlatformCredentialManager platformCredManager;
    private static final String className = "CBIND";
    private String realm = "";
    private static final TraceComponent tc = Tr.register(TrustedIDEvaluatorImpl.class, "Security", "com.ibm.ejs.resources.security");

    public TrustedIDEvaluatorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.platformCredManager = PlatformCredentialManager.instance();
        this.authzMgr = SAFAuthorizationManager.instance();
        this.realm = this.getContextManager().getProperty("security.activeUserRegistry.realm");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isTrusted(String user) {
        boolean isTrusted;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTrusted", user);
            }
            isTrusted = false;
            PlatformCredential pc = null;
            Subject subject = null;
            if (user.equals("*")) {
                isTrusted = false;
            } else if (this.getContextManager().isInternalServerId(user)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using internally generated server ID", user);
                }
                pc = this.platformCredManager.createServerCredential();
                isTrusted = this.checkProfileAccess(pc);
            } else {
                try {
                    subject = this.getContextManager().login(this.realm, user);
                    if (subject != null) {
                        pc = this.getPlatformCredentialFromSubject(subject);
                        isTrusted = this.checkProfileAccess(pc);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not get subject");
                    }
                }
                catch (WSLoginFailedException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.isTrusted", "153", this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Login failed", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrusted", new Boolean(isTrusted));
        }
        return isTrusted;
    }

    public boolean isTrusted(String user, String password) {
        boolean isTrusted;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTrusted", new Object[]{user, password != null ? "****" : null});
            }
            isTrusted = false;
            PlatformCredential pc = null;
            Subject subject = null;
            if (user.equals("*")) {
                isTrusted = false;
            } else if (password == null || password.equals("")) {
                isTrusted = this.isTrusted(user);
            } else {
                try {
                    subject = this.getContextManager().login(this.realm, user, password);
                    if (subject != null) {
                        pc = this.getPlatformCredentialFromSubject(subject);
                        isTrusted = this.checkProfileAccess(pc);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not get subject");
                    }
                }
                catch (WSLoginFailedException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.isTrusted", "214", this);
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "Login failed", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrusted", new Boolean(isTrusted));
        }
        return isTrusted;
    }

    public boolean isTrusted(X509Certificate[] cert) {
        boolean isTrusted;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTrusted", cert);
            }
            isTrusted = false;
            PlatformCredential pc = null;
            Subject subject = null;
            try {
                subject = this.getContextManager().login(this.realm, cert);
                if (subject != null) {
                    pc = this.getPlatformCredentialFromSubject(subject);
                    isTrusted = this.checkProfileAccess(pc);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not get subject");
                }
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.isTrusted", "264", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Login failed", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrusted", new Boolean(isTrusted));
        }
        return isTrusted;
    }

    public Boolean mutualAuthCBINDCheck(X509Certificate[] cert) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mutualAuthCBINDCheck", cert);
        }
        boolean check = false;
        check = NativeConfiguration.getConfig().isMutualAuthCBINDCheckEnabled() ? this.isTrusted(cert) : true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mutualAuthCBINDCheck", new Boolean(check));
        }
        return new Boolean(check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkProfileAccess(PlatformCredential pc) {
        boolean trusted;
        block12: {
            String prefixName;
            String clusterShortName;
            String resource;
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "checkProfileAccess", pc);
                }
                trusted = false;
                resource = "";
                clusterShortName = SecurityObjectLocator.getAdminData().getString("generic.server.short.name");
                boolean pushed = false;
                prefixName = null;
                pushed = SecurityObjectLocator.pushAdminContext();
                try {
                    prefixName = SecurityObjectLocator.getSecurityConfig().getSAFProfilePrefix();
                    Object var8_7 = null;
                    if (!pushed) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (pushed) {
                        SecurityObjectLocator.popContext();
                    }
                    throw throwable;
                }
                SecurityObjectLocator.popContext();
            }
            resource = prefixName != null && prefixName.length() > 0 ? "CB.BIND." + prefixName + "." + clusterShortName : "CB.BIND." + clusterShortName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource being checked is", resource);
            }
            if (pc != null) {
                try {
                    trusted = this.authzMgr.isAuthorized(pc, className, resource, AccessLevel.CONTROL);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.zOS.TrustedIDEvaluatorImpl.checkProfileAccess", "355", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to perform authorization check", e);
                    }
                    break block12;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Platform Credential for user is null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProfileAccess", new Boolean(trusted));
        }
        return trusted;
    }

    private ContextManager getContextManager() {
        return ContextManagerFactory.getInstance();
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCred;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCred = null;
            Iterator<PlatformCredential> privateCreds = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (privateCreds.hasNext()) {
                platformCred = privateCreds.next();
            }
            if (platformCred == null) {
                WSCredential wsCred = null;
                Iterator<WSCredential> publicCreds = subject.getPublicCredentials(WSCredential.class).iterator();
                if (publicCreds.hasNext()) {
                    wsCred = publicCreds.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential", wsCred);
                }
                if (wsCred != null) {
                    try {
                        final WSCredential wsc = wsCred;
                        platformCred = (PlatformCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return wsc.get("com.ibm.ws.security.zos.PlatformCredential");
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Unable to get PlatformCredential", e);
                    }
                }
            }
        }
        if (platformCred == null) {
            platformCred = this.platformCredManager.createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCred);
        }
        return platformCred;
    }
}

