/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.zOS.SAFServiceResult;

public final class SAFServiceMessages {
    private static final TraceComponent tc = Tr.register(SAFServiceResult.class, "Security", "com.ibm.ejs.resources.security");

    private SAFServiceMessages() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public static String getSafServiceMessage(int wasRetCode, String wasServiceName, int safRetCode, int returnCode, int reasonCode, String serviceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSafServiceMessage");
        }
        if (wasServiceName.equals("BBOSSAUP") && wasRetCode == 31) {
            return "The caller is not authorized for the function. This usually indicates that the BBO.TRUSTEDAPPS profile has not been set up correctly";
        }
        if (serviceName.equals("RACROUTE REQUEST=FASTAUTH")) {
            if (safRetCode == 4) {
                if (returnCode == 4) {
                    return "The resource or class name is not defined to RACF or the class has not been RACLISTed";
                }
                if (returnCode == 12) {
                    return "RACF is not active";
                }
                if (returnCode == 28) {
                    return "The class was RACLISTed by RACROUTE REQUEST=LIST, GLOBAL=YES, or SETROPTS RACLIST, but the data space has been deleted";
                }
                if (returnCode == 32) {
                    return "The class was RACLISTed by RACROUTE REQUEST=LIST, GLOBAL=YES, or SETROPTS RACLIST, but the data space cannot be accessed due to an ALESERV failure";
                }
            } else if (safRetCode == 8) {
                if (returnCode == 8) {
                    return "The user or group is not authorized to use the resource";
                }
                if (returnCode == 16) {
                    return "A RACROUTE REQUEST=FASTAUTH installation exit error occurred";
                }
                if (returnCode == 24) {
                    return "Indicates the profile has a conditional access list, the port-of-entry field in the security token is blank-filled and the port-of-entry class is active";
                }
                if (returnCode == 36) {
                    return "Parameter list error";
                }
            }
        }
        if (safRetCode == 0) {
            return "SAF call Successful";
        }
        if (safRetCode == 4) {
            return "RACF is not Installed";
        }
        if (safRetCode != 8) {
            return null;
        }
        if (returnCode != 8) {
            return null;
        }
        if (reasonCode == 4) {
            return "Parameter List error occurred in WAS";
        }
        if (reasonCode == 8) {
            return "An internal error occured during RACF Processing";
        }
        if (reasonCode == 12) {
            return "Recovery environment could not be established";
        }
        if (serviceName.indexOf("IRRSIA00") != -1) {
            if (reasonCode == 16) {
                return "User ID is not defined to SAF";
            }
            if (reasonCode == 20) {
                return "Password or Pass Ticket is not valid";
            }
            if (reasonCode == 24) {
                return "Password is expired";
            }
            if (reasonCode == 28) {
                return "User ID is revoked or user access to group is revoked";
            }
            if (reasonCode == 32) {
                return "User is not authorized. Typically the UserID does not have access to the APPL SAF Class";
            }
            if (reasonCode == 36) {
                return "Certificate is not Valid";
            }
        }
        if (serviceName.indexOf("IRRSIM00") != -1) {
            if (reasonCode == 16) {
                return "There is no mapping to a RACF user ID for the kerberos principal provided";
            }
            if (reasonCode == 20) {
                return "Not authorized to use this service";
            }
            if (reasonCode == 24) {
                return "The specified RACF user ID does not exist";
            }
            if (reasonCode == 28) {
                return "Certificate is not valid";
            }
            if (reasonCode == 32) {
                return "Either no RACF user ID is defined for this certificate, or the certificate status is NOTRUST";
            }
        }
        return null;
    }
}

