/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.om.security.SecurityRoleRef;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.security.audit.Attributes;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.Identity;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.authorize.WSPolicyContextHandlerImpl;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.stat.impl.SecurityAuthorizationModuleImpl;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.ChallengeReply;
import com.ibm.ws.security.web.DenyReply;
import com.ibm.ws.security.web.PermitReply;
import com.ibm.ws.security.web.RedirectReply;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.TAIChallengeReply;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAccessManager;
import com.ibm.ws.security.web.WebAccessPermission;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebReply;
import com.ibm.ws.security.web.WebResourceCollectionConstraints;
import com.ibm.ws.security.web.WebSecurityConfigException;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public abstract class WebCollaborator {
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    public static final String pnWebServer = "$webServer";
    public static final String pnVirtualHost = "$virtualHost";
    public static final String pnRemoteHost = "$remoteHost";
    public static final String pnUri = "$uri";
    public static final String pnMethod = "$method";
    public static final String pnIsSSL = "$isSSL";
    public static final String pnCertificate = "$certificate";
    public static final String pnCipher = "$cipher";
    public static final String pnAuthorization = "Authorization";
    public static final String pnCookie = "Cookie";
    protected static WebReply PERMIT_REPLY = new PermitReply();
    protected static WebReply DENY_AUTHZ_FAILED = new DenyReply("AuthorizationFailed");
    protected static WebReply DENY_AUTHN_FAILED = new DenyReply("AuthenticationFailed");
    protected static WebReply DENY_CONFIG_ERROR = new DenyReply("Configuration error");
    private static final TraceComponent tc = Tr.register(WebCollaborator.class, null, "com.ibm.ejs.resources.security");
    protected boolean securityEnabled;
    protected static WebAuthenticator authenticator = null;
    protected AccessManager authorizer = null;
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int GROUPID = 2;
    protected boolean authDone = false;
    private static Object _lockObject = new Object();
    private WebAppCache webCache = null;
    private static boolean custom_auth_mech = false;
    private static String custom_jaas_config = null;
    private static TrustAssociationManager taManager = null;
    private static WSCallbackHandlerFactory cbkFactory = null;
    private ArrayList adminAppList = null;
    private WebAttributes webSecAttrs;
    private static final String providerName = "WebSphere";
    private static final String componentName = "WAS.security";
    private static String activeUserRegistry = null;
    private static AuditService auditService = null;
    private Date startTime = null;
    private Date endTime = null;
    private static String className = null;
    private ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private static String[] jaccHandlerKeyArray;
    private static WSPolicyContextHandlerImpl wpch;
    private static boolean initialized;
    private static boolean persistCred;
    private static boolean alwaysLogin;
    private static final String PERSIST_CRED = "persisting";
    private static final String ALWAYS_LOGIN = "always";
    private HashMap authorizationMap = new HashMap();
    boolean performTAIForUnprotectedURI = true;
    private SecurityAuthorizationModuleImpl authModule;

    protected abstract WebAppCache getWebCache();

    public WebCollaborator() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void createAuthorizationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthorizationManager");
        }
        this.authorizer = new WebAccessManager();
        this.authorizationMap.put("default", this.authorizer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAuthorizationManager");
        }
    }

    public AccessManager getAuthorizer() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizer");
        }
        if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent() && (uuid = AdminContext.peek()) != null) {
            AccessManager am = (AccessManager)this.authorizationMap.get(uuid);
            if (am == null) {
                am = new WebAccessManager();
                this.authorizationMap.put(uuid, am);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAuthorizer (uuid = " + uuid + ")");
            }
            return am;
        }
        AccessManager am = (AccessManager)this.authorizationMap.get("default");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizer (default)");
        }
        return am;
    }

    public void releaseAuthorizer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseAuthorizer");
        }
        if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
            String uuid = AdminContext.peek();
            if (this.authorizationMap != null) {
                this.authorizationMap.remove(uuid);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "releaseAuthorizer (uuid = " + uuid + ")");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.exit(tc, "releaseAuthorizer authorizationMap is null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseAuthorizer (default)");
        }
    }

    public void initialize() throws Exception {
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            className = this.getClass().getName();
            if (StatsFactory.isPMIEnabled()) {
                this.authModule = SecurityAuthorizationModuleImpl.getInstance("Security Authorization");
            }
            this.securityEnabled = false;
            try {
                this.securityEnabled = SecurityContext.isSecurityEnabled();
                if (this.securityEnabled && !initialized) {
                    String webAuth;
                    SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                    AuthMechanismConfig authMechanism = security2.getActiveAuthMechanism();
                    if (!authMechanism.getType().equals("SWAM")) {
                        taManager = TrustAssociationManager.getInstance();
                        custom_jaas_config = security2.getProperty("com.ibm.ws.security.webInboundLoginConfig");
                        if (security2.getPropertyBool("security.enablePluggableAuthentication")) {
                            custom_auth_mech = true;
                        }
                    } else {
                        custom_jaas_config = security2.getProperty("com.ibm.ws.security.webInboundLoginConfig");
                    }
                    if (auditService == null) {
                        auditService = ContextManagerFactory.getInstance().getAuditService();
                    }
                    activeUserRegistry = security2.getActiveUserRegistry().getType();
                    authenticator = WebAuthenticator.create(custom_jaas_config);
                    String componentName = componentName;
                    SecurityConfig globalConfig = SecurityObjectLocator.getSecurityConfig("security");
                    SecurityConfig appConfig = SecurityObjectLocator.getSecurityConfig("AppSecurity");
                    if (globalConfig.getAuthorizationConfig().getBoolean("useJACCProvider") || appConfig != null && appConfig.getAuthorizationConfig().getBoolean("useJACCProvider")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting the PolicyContextHandlers for JACC for web.");
                        }
                        jaccHandlerKeyArray = new String[]{"javax.security.auth.Subject.container", "javax.servlet.http.HttpServletRequest"};
                        wpch = WSPolicyContextHandlerImpl.getInstance();
                    }
                    if ((webAuth = security2.getString("com.ibm.wsspi.security.web.webAuthReq")) != null) {
                        if (webAuth.equalsIgnoreCase(PERSIST_CRED)) {
                            persistCred = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Persist authenticated credential even URI is not protected.");
                            }
                        }
                        if (webAuth.equalsIgnoreCase(ALWAYS_LOGIN)) {
                            alwaysLogin = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "always set credential on executed thread regardless authorization.");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.initialize", "449", this);
                if (this.securityEnabled) {
                    Tr.error(tc, "security.web.initerror");
                }
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "initialize", new Object[]{e});
            }
        }
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void addWebApp(String appName, String contextRoot, WebApp wConfig, DeployedModule webModuleConfig) throws WebSecurityConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWebApp", new Object[]{appName, contextRoot, wConfig});
        }
        if (this.webCache == null) {
            this.webCache = this.getWebCache();
        }
        try {
            this.webCache.addWebApp(appName, contextRoot, wConfig, webModuleConfig);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.web.WebCollaborator.addWebApp", "485", this);
            WebSecurityConfigException wsce = new WebSecurityConfigException(t.getMessage(), null);
            wsce.initCause(t);
            if (tc.isEventEnabled()) {
                Tr.debug(tc, "addWebApp excption", wsce);
            }
            throw wsce;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWebApp");
        }
    }

    private boolean isAdminApp(String appName) {
        return WSAccessManager.checkIfAdminApp(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WebReply authorize(HttpServletRequest req, HttpServletResponse res, String contextRoot, boolean doAuth, String appName) throws WebSecurityException {
        block117: {
            block113: {
                block112: {
                    block110: {
                        block109: {
                            block108: {
                                block107: {
                                    block106: {
                                        block105: {
                                            block104: {
                                                startTime = 0L;
                                                endTime = 0L;
                                                authTime = 0L;
                                                contextHandler = null;
                                                lastTrailId = null;
                                                eventTrailIds = null;
                                                try {
                                                    block115: {
                                                        block111: {
                                                            if (StatsFactory.isPMIEnabled()) {
                                                                startTime = System.currentTimeMillis();
                                                            }
                                                            if (WebCollaborator.tc.isEntryEnabled()) {
                                                                Tr.entry(WebCollaborator.tc, "authorize", new Object[]{req, res, contextRoot, new Boolean(doAuth), appName});
                                                            }
                                                            reply = null;
                                                            authResult = null;
                                                            authSubject = null;
                                                            authCookies = null;
                                                            authRealm = null;
                                                            authUserName = "???";
                                                            doneWithAuthenticated = false;
                                                            contextManager = ContextManagerFactory.getInstance();
                                                            uriName = WebCollaborator.getURI(req);
                                                            if (uriName == null || uriName.length() == 0) {
                                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                                    Tr.exit(WebCollaborator.tc, "authorize: throw WebSecurityException");
                                                                }
                                                                if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                                    Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                                    msg = "security.audit.service.context.error";
                                                                    WebCollaborator.auditService.processAuditFailure(msg, null);
                                                                }
                                                                if (WebCollaborator.auditService != null) {
                                                                    lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                                    eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                                }
                                                                if (WebCollaborator.auditService != null && WebCollaborator.auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED")) {
                                                                    data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                                    contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                                                    contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                                    contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), contextManager.getDefaultRealm());
                                                                    contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                                    contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data);
                                                                    reqLength = 0;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        ++reqLength;
                                                                        if (!WebCollaborator.tc.isDebugEnabled()) continue;
                                                                        Tr.debug(WebCollaborator.tc, "reqLength: " + reqLength);
                                                                    }
                                                                    reqHdrs = new Attributes[reqLength];
                                                                    attrEnum = -1;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        if (reqHdrs[++attrEnum] == null) {
                                                                            if (WebCollaborator.tc.isDebugEnabled()) {
                                                                                Tr.debug(WebCollaborator.tc, "reqHdrs null, creating new");
                                                                            }
                                                                            reqHdrs[attrEnum] = new Attributes();
                                                                        }
                                                                        reqHdrs[attrEnum].setName("headerName");
                                                                        reqHdrs[attrEnum].setValue(req.getHeader(headerName));
                                                                        reqHdrs[attrEnum].setSource("application");
                                                                    }
                                                                    data = DataHelper.buildResponseData(uriName, reqHdrs, null);
                                                                    contextHandler.buildContextObject("RESPONSE_CONTEXT", (HashMap)data);
                                                                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 14L);
                                                                    try {
                                                                        WebCollaborator.auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                                                                    }
                                                                    catch (ProviderFailureException e) {
                                                                        Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                                        msg = "security.audit.service.sendevent.error";
                                                                        WebCollaborator.auditService.processAuditFailure(msg, e);
                                                                    }
                                                                }
                                                                data = new DenyReply("Invalid URI passed to Security Collaborator.");
                                                                var43_36 = null;
                                                                break block104;
                                                            }
                                                            methodName = req.getMethod();
                                                            webContext = this.webCache.getWebAccessContext(appName, contextRoot);
                                                            webSecAttr = null;
                                                            if (webContext != null) {
                                                                webSecAttr = webContext.getWebAttributes();
                                                            }
                                                            if (!req.isSecure() && (reply = this.checkDataConstraints(webContext, uriName, methodName, req)) != null) {
                                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                                    Tr.exit(WebCollaborator.tc, "authorize: ", reply);
                                                                }
                                                                attrEnum = reply;
                                                                break block105;
                                                            }
                                                            requiredRoles = this.getRequiredRoles(webContext, uriName, methodName);
                                                            everyoneAllowed = false;
                                                            everyoneAllowed = this.authorizer.isEveryoneGranted(webContext, requiredRoles);
                                                            performTAIForUnprotectedURI = SecurityObjectLocator.getSecurityConfig().getPropertyBool("com.ibm.websphere.security.performTAIForUnprotectedURI", true);
                                                            performTAI = true;
                                                            if ((everyoneAllowed || requiredRoles == PermissionRoleMap.NO_REQUIRED_ROLES) && WebCollaborator.persistCred && !performTAIForUnprotectedURI) {
                                                                performTAI = false;
                                                                Tr.debug(WebCollaborator.tc, "TAI authentication will be skipped because performTAIForUnprotectedURI property is set.   everyoneAllowed: " + everyoneAllowed + " requiredRoles: " + requiredRoles + " persistCred: " + WebCollaborator.persistCred + " performTAIForUnprotectedURI: " + performTAIForUnprotectedURI);
                                                            } else {
                                                                Tr.debug(WebCollaborator.tc, "TAI authentication will be performed. everyoneAllowed:" + everyoneAllowed + " persistCred:" + WebCollaborator.persistCred + " performTAIForUnprotectedURI:" + performTAIForUnprotectedURI);
                                                            }
                                                            if (webSecAttr != null && (WebCollaborator.persistCred || WebCollaborator.alwaysLogin)) {
                                                                enableRedirect = true;
                                                                if ((everyoneAllowed || requiredRoles == PermissionRoleMap.NO_REQUIRED_ROLES) && WebCollaborator.persistCred) {
                                                                    if (WebCollaborator.tc.isDebugEnabled()) {
                                                                        Tr.debug(WebCollaborator.tc, "Redirect will not occur:  everyoneAllowed: " + everyoneAllowed + " requiredRoles: " + requiredRoles + " persistCred: " + WebCollaborator.persistCred);
                                                                    }
                                                                    enableRedirect = false;
                                                                }
                                                                doneWithAuthenticated = true;
                                                                authResult = this.SetAuthenticatedSubjectIfNeeded(webSecAttr, req, res, performTAI, enableRedirect);
                                                                if (WebCollaborator.alwaysLogin) {
                                                                    reply = this.handleAlwaysLogin(authResult, webSecAttr, uriName, methodName);
                                                                }
                                                                if (reply != null) {
                                                                    if (WebCollaborator.tc.isEntryEnabled()) {
                                                                        Tr.exit(WebCollaborator.tc, "authorize", reply);
                                                                    }
                                                                    var32_54 = reply;
                                                                    break block106;
                                                                }
                                                            }
                                                            if ((reply = this.validSecAttrs(contextRoot, uriName, methodName, false, appName)) != null) {
                                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                                    Tr.exit(WebCollaborator.tc, "authorize: ", reply);
                                                                }
                                                                enableRedirect = reply;
                                                                break block107;
                                                            }
                                                            if (this.unsupportedAuthMech(webSecAttr)) {
                                                                if (WebCollaborator.tc.isDebugEnabled()) {
                                                                    Tr.debug(WebCollaborator.tc, "Digest Authentication Mechanism is used and is not supported : sending DenyReply response");
                                                                }
                                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                                    Tr.exit(WebCollaborator.tc, "authorize: ");
                                                                }
                                                                if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                                    Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                                    msg = "security.audit.service.context.error";
                                                                    WebCollaborator.auditService.processAuditFailure(msg, null);
                                                                }
                                                                if (WebCollaborator.auditService != null) {
                                                                    lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                                    eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                                }
                                                                if (WebCollaborator.auditService != null && WebCollaborator.auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED")) {
                                                                    data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                                                                    data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                                                                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                                                                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                                                                    data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                                                                    data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), contextManager.getDefaultRealm());
                                                                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                                                                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                                                                    reqLength = 0;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        ++reqLength;
                                                                        if (!WebCollaborator.tc.isDebugEnabled()) continue;
                                                                        Tr.debug(WebCollaborator.tc, "reqLength: " + reqLength);
                                                                    }
                                                                    reqHdrs = new Attributes[reqLength];
                                                                    attrEnum = -1;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        if (reqHdrs[++attrEnum] == null) {
                                                                            if (WebCollaborator.tc.isDebugEnabled()) {
                                                                                Tr.debug(WebCollaborator.tc, "reqHdrs null, creating new");
                                                                            }
                                                                            reqHdrs[attrEnum] = new Attributes();
                                                                        }
                                                                        reqHdrs[attrEnum].setName("headerName");
                                                                        reqHdrs[attrEnum].setValue(req.getHeader(headerName));
                                                                        reqHdrs[attrEnum].setSource("application");
                                                                    }
                                                                    data = DataHelper.buildResponseData(uriName, reqHdrs, null);
                                                                    contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                                                                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 20L);
                                                                    try {
                                                                        WebCollaborator.auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                                                                    }
                                                                    catch (ProviderFailureException e) {
                                                                        Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                                        msg = "security.audit.service.sendevent.error";
                                                                        WebCollaborator.auditService.processAuditFailure(msg, e);
                                                                    }
                                                                }
                                                                data = new DenyReply("Authentication Failed : DIGEST not supported");
                                                                break block108;
                                                            }
                                                            reqdRoles = new String[requiredRoles.length];
                                                            for (i = 0; i < requiredRoles.length; ++i) {
                                                                reqdRoles[i] = requiredRoles[i].getRoleName();
                                                            }
                                                            if (requiredRoles == PermissionRoleMap.NO_REQUIRED_ROLES) {
                                                                reply = WebCollaborator.PERMIT_REPLY;
                                                                if (WebCollaborator.tc.isDebugEnabled()) {
                                                                    b = new StringBuffer("No required roles for ");
                                                                    b.append(uriName).append(".").append(methodName);
                                                                    Tr.debug(WebCollaborator.tc, b.toString());
                                                                }
                                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                                    Tr.exit(WebCollaborator.tc, "authorize", reply);
                                                                }
                                                                if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                                    Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                                    msg = "security.audit.service.context.error";
                                                                    WebCollaborator.auditService.processAuditFailure(msg, null);
                                                                }
                                                                if (WebCollaborator.auditService != null) {
                                                                    lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                                    eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                                }
                                                                if (WebCollaborator.auditService != null && WebCollaborator.auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                                                                    data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                                                                    data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", req.getMethod(), "web", new Long(0L), null, null, reqdRoles, reqdRoles);
                                                                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                                                                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                                                                    data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                                                                    data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), contextManager.getDefaultRealm());
                                                                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                                                                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                                                                    reqLength = 0;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        ++reqLength;
                                                                        if (!WebCollaborator.tc.isDebugEnabled()) continue;
                                                                        Tr.debug(WebCollaborator.tc, "reqLength: " + reqLength);
                                                                    }
                                                                    reqHdrs = new Attributes[reqLength];
                                                                    attrEnum = -1;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        if (reqHdrs[++attrEnum] == null) {
                                                                            if (WebCollaborator.tc.isDebugEnabled()) {
                                                                                Tr.debug(WebCollaborator.tc, "reqHdrs null, creating new");
                                                                            }
                                                                            reqHdrs[attrEnum] = new Attributes();
                                                                        }
                                                                        reqHdrs[attrEnum].setName("headerName");
                                                                        reqHdrs[attrEnum].setValue(req.getHeader(headerName));
                                                                        reqHdrs[attrEnum].setSource("application");
                                                                    }
                                                                    data = DataHelper.buildResponseData(uriName, reqHdrs, null);
                                                                    contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                                                                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                                                                    try {
                                                                        WebCollaborator.auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                                                                    }
                                                                    catch (ProviderFailureException e) {
                                                                        Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                                        msg = "security.audit.service.sendevent.error";
                                                                        WebCollaborator.auditService.processAuditFailure(msg, e);
                                                                    }
                                                                }
                                                                data = reply;
                                                                break block109;
                                                            }
                                                            if (everyoneAllowed) {
                                                                reply = WebCollaborator.PERMIT_REPLY;
                                                                if (WebCollaborator.tc.isDebugEnabled()) {
                                                                    b = new StringBuffer("Unprotected URI is ");
                                                                    b.append(uriName).append(".").append(methodName);
                                                                    if (WebCollaborator.tc.isDebugEnabled()) {
                                                                        Tr.debug(WebCollaborator.tc, b.toString());
                                                                    }
                                                                }
                                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                                    Tr.exit(WebCollaborator.tc, "authorize", reply);
                                                                }
                                                                rolesChecked = new String[]{"everyoneAccess"};
                                                                rolesGranted = new String[]{"everyoneAccess"};
                                                                if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                                    Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                                    msg = "security.audit.service.context.error";
                                                                    WebCollaborator.auditService.processAuditFailure(msg, null);
                                                                }
                                                                if (WebCollaborator.auditService != null) {
                                                                    lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                                    eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                                }
                                                                if (WebCollaborator.auditService != null && WebCollaborator.auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                                                                    data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                                    contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", req.getMethod(), "web", new Long(0L), null, null, rolesChecked, rolesGranted);
                                                                    contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                                    contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), contextManager.getDefaultRealm());
                                                                    contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data);
                                                                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                                    contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data);
                                                                    reqLength = 0;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        ++reqLength;
                                                                        if (!WebCollaborator.tc.isDebugEnabled()) continue;
                                                                        Tr.debug(WebCollaborator.tc, "reqLength: " + reqLength);
                                                                    }
                                                                    reqHdrs = new Attributes[reqLength];
                                                                    attrEnum = -1;
                                                                    e = req.getHeaderNames();
                                                                    while (e.hasMoreElements()) {
                                                                        headerName = (String)e.nextElement();
                                                                        if (reqHdrs[++attrEnum] == null) {
                                                                            if (WebCollaborator.tc.isDebugEnabled()) {
                                                                                Tr.debug(WebCollaborator.tc, "reqHdrs null, creating new");
                                                                            }
                                                                            reqHdrs[attrEnum] = new Attributes();
                                                                        }
                                                                        reqHdrs[attrEnum].setName("headerName");
                                                                        reqHdrs[attrEnum].setValue(req.getHeader(headerName));
                                                                        reqHdrs[attrEnum].setSource("application");
                                                                    }
                                                                    data = DataHelper.buildResponseData(uriName, reqHdrs, null);
                                                                    contextHandler.buildContextObject("RESPONSE_CONTEXT", (HashMap)data);
                                                                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                                                                    try {
                                                                        WebCollaborator.auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                                                                    }
                                                                    catch (ProviderFailureException e) {
                                                                        Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                                        msg = "security.audit.service.sendevent.error";
                                                                        WebCollaborator.auditService.processAuditFailure(msg, e);
                                                                    }
                                                                }
                                                                data = reply;
                                                                break block110;
                                                            }
                                                            if (WebCollaborator.tc.isDebugEnabled()) {
                                                                b = new StringBuffer("URI -  ");
                                                                b.append(uriName).append(".").append(methodName).append(" is protected");
                                                                Tr.debug(WebCollaborator.tc, b.toString());
                                                            }
                                                            prevCaller = null;
                                                            try {
                                                                prevCaller = contextManager.getCallerSubject();
                                                                if (WebCollaborator.tc.isDebugEnabled()) {
                                                                    Tr.debug(WebCollaborator.tc, "Saving previous subject " + prevCaller);
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1135", this);
                                                                if (!WebCollaborator.tc.isDebugEnabled()) break block111;
                                                                Tr.debug(WebCollaborator.tc, "Exception occurred when trying to get initial Caller Subject ");
                                                            }
                                                        }
                                                        try {
                                                            if (StatsFactory.isPMIEnabled()) {
                                                                authTime = System.currentTimeMillis();
                                                            }
                                                            if (!doAuth) ** GOTO lbl382
                                                            if (!doneWithAuthenticated) {
                                                                authResult = WebCollaborator.authenticator.authenticate(webSecAttr, req, res, performTAI);
                                                            }
                                                            if (authResult == null) {
                                                                Tr.error(WebCollaborator.tc, "authResult is null");
                                                                e = WebCollaborator.DENY_AUTHN_FAILED;
                                                                var41_102 = null;
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (Throwable var40_106) {
                                                            var41_105 = null;
                                                            if (StatsFactory.isPMIEnabled() == false) throw var40_106;
                                                            authTime = System.currentTimeMillis() - authTime;
                                                            throw var40_106;
                                                        }
                                                        if (!StatsFactory.isPMIEnabled()) break block112;
                                                        authTime = System.currentTimeMillis() - authTime;
                                                        break block112;
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            reply = this.checkAuthStatus(authResult, webSecAttr);
                                                            if (reply == null) ** GOTO lbl-1000
                                                            if (WebCollaborator.tc.isEntryEnabled()) {
                                                                Tr.exit(WebCollaborator.tc, "authorize", reply);
                                                            }
                                                            e = reply;
                                                            var41_103 = null;
                                                        }
                                                        if (!StatsFactory.isPMIEnabled()) break block113;
                                                        authTime = System.currentTimeMillis() - authTime;
                                                        break block113;
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            block114: {
                                                                authSubject = authResult.getSubject();
                                                                authCookies = authResult.getCookies();
                                                                authUserName = authResult.getUserName();
                                                                authRealm = authResult.getRealm();
                                                                if (!doneWithAuthenticated) {
                                                                    try {
                                                                        contextManager.setCallerSubject(authSubject);
                                                                    }
                                                                    catch (Exception e) {
                                                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1185", this);
                                                                        if (WebCollaborator.tc.isDebugEnabled()) {
                                                                            Tr.debug(WebCollaborator.tc, "Exception occurred when setting credentials for 'current'. ");
                                                                        }
                                                                        break block114;
                                                                    }
                                                                }
                                                                break block114;
lbl382:
                                                                // 1 sources

                                                                try {
                                                                    receivedSubject = contextManager.getCallerSubject();
                                                                    if (receivedSubject != null) {
                                                                        authSubject = receivedSubject;
                                                                    }
                                                                }
                                                                catch (Exception e) {
                                                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1198", this);
                                                                    if (!WebCollaborator.tc.isDebugEnabled()) break block114;
                                                                    Tr.debug(WebCollaborator.tc, "Invalid credentials retrieved from security  'current'.");
                                                                }
                                                            }
                                                            var41_104 = null;
                                                            if (!StatsFactory.isPMIEnabled()) break block115;
                                                            authTime = System.currentTimeMillis() - authTime;
                                                        }
                                                    }
                                                    ok = false;
                                                    try {
                                                        this.checkAuthorization(webContext, requiredRoles, authSubject);
                                                        ok = true;
                                                    }
                                                    catch (AccessException e) {
                                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1227", this);
                                                        if (WebCollaborator.tc.isDebugEnabled()) {
                                                            Tr.debug(WebCollaborator.tc, "checkAuthorization() failed, here is the message in the exception: " + e.getMessage());
                                                        }
                                                        if (authRealm != null) {
                                                            if (authUserName != null) {
                                                                Tr.audit(WebCollaborator.tc, "security.web.authz.failed.foruser", new Object[]{authUserName.concat(":").concat(authRealm), methodName, contextRoot + uriName, e.getMessage()});
                                                            } else {
                                                                Tr.audit(WebCollaborator.tc, "security.web.authz.failed.foruser", new Object[]{authUserName, methodName, contextRoot + uriName, e.getMessage()});
                                                            }
                                                        } else {
                                                            Tr.audit(WebCollaborator.tc, "security.web.authz.failed.foruser", new Object[]{authUserName, methodName, contextRoot + uriName, e.getMessage()});
                                                        }
                                                        try {
                                                            contextManager.setCallerSubject(prevCaller);
                                                        }
                                                        catch (Exception f) {
                                                            FFDCFilter.processException((Throwable)f, "com.ibm.ws.security.web.WebCollaborator.authorize", "1246", this);
                                                        }
                                                    }
                                                    if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                        Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                        msg = "security.audit.service.context.error";
                                                        WebCollaborator.auditService.processAuditFailure(msg, null);
                                                    }
                                                    if (WebCollaborator.auditService != null) {
                                                        lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                        eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                    }
                                                    if (WebCollaborator.auditService != null && (WebCollaborator.auditService.isEventRequired("SECURITY_AUTHZ", "DENIED") || WebCollaborator.auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS"))) {
                                                        rSubj = null;
                                                        if (authSubject != null) {
                                                            rSubj = ((Principal)authSubject.getPrincipals().toArray()[0]).getName();
                                                        }
                                                        data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                                                        reqRoles = new String[requiredRoles.length];
                                                        for (k = 0; k < requiredRoles.length; ++k) {
                                                            reqRoles[k] = requiredRoles[k].getRoleName();
                                                        }
                                                        data = ok != false ? DataHelper.buildAccessData(uriName, "authz", rSubj, rSubj, "accessSuccess", methodName, "web", new Long(0L), null, null, reqRoles, reqRoles) : DataHelper.buildAccessData(uriName, "authz", rSubj, rSubj, "authzDenied", methodName, "web", new Long(0L), null, null, reqRoles, reqRoles);
                                                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                                                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                                                        data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                                                        data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), contextManager.getDefaultRealm());
                                                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                                                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                                                        data = DataHelper.buildProviderData("WebSphere", "providerSuccess");
                                                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                                                        data = DataHelper.buildPolicyData(null, null);
                                                        contextHandler.buildContextObject("POLICY_CONTEXT", data);
                                                        this.auditOutcome = ok != false ? DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L) : DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                                                        try {
                                                            WebCollaborator.auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                                                        }
                                                        catch (ProviderFailureException e) {
                                                            Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                            msg = "security.audit.service.sendevent.error";
                                                            WebCollaborator.auditService.processAuditFailure(msg, e);
                                                        }
                                                    }
                                                    reply = this.createReply(ok, uriName, authCookies);
                                                    if (WebCollaborator.tc.isEntryEnabled()) {
                                                        Tr.exit(WebCollaborator.tc, "authorize", reply);
                                                    }
                                                    var34_80 = reply;
                                                    break block117;
                                                }
                                                catch (Throwable var42_107) {
                                                    var43_46 = null;
                                                    if (StatsFactory.isPMIEnabled() == false) throw var42_107;
                                                    endTime = System.currentTimeMillis();
                                                    this.authModule.onWebAuthTime(endTime - startTime - authTime);
                                                    throw var42_107;
                                                }
                                            }
                                            if (StatsFactory.isPMIEnabled() == false) return data;
                                            endTime = System.currentTimeMillis();
                                            this.authModule.onWebAuthTime(endTime - startTime - authTime);
                                            return data;
                                        }
                                        var43_37 = null;
                                        if (StatsFactory.isPMIEnabled() == false) return attrEnum;
                                        endTime = System.currentTimeMillis();
                                        this.authModule.onWebAuthTime(endTime - startTime - authTime);
                                        return attrEnum;
                                    }
                                    var43_38 = null;
                                    if (StatsFactory.isPMIEnabled() == false) return var32_54;
                                    endTime = System.currentTimeMillis();
                                    this.authModule.onWebAuthTime(endTime - startTime - authTime);
                                    return var32_54;
                                }
                                var43_39 = null;
                                if (StatsFactory.isPMIEnabled() == false) return enableRedirect;
                                endTime = System.currentTimeMillis();
                                this.authModule.onWebAuthTime(endTime - startTime - authTime);
                                return enableRedirect;
                            }
                            var43_40 = null;
                            if (StatsFactory.isPMIEnabled() == false) return data;
                            endTime = System.currentTimeMillis();
                            this.authModule.onWebAuthTime(endTime - startTime - authTime);
                            return data;
                        }
                        var43_41 = null;
                        if (StatsFactory.isPMIEnabled() == false) return data;
                        endTime = System.currentTimeMillis();
                        this.authModule.onWebAuthTime(endTime - startTime - authTime);
                        return data;
                    }
                    var43_42 = null;
                    if (StatsFactory.isPMIEnabled() == false) return data;
                    endTime = System.currentTimeMillis();
                    this.authModule.onWebAuthTime(endTime - startTime - authTime);
                    return data;
                }
                var43_43 = null;
                if (StatsFactory.isPMIEnabled() == false) return e;
                endTime = System.currentTimeMillis();
                this.authModule.onWebAuthTime(endTime - startTime - authTime);
                return e;
            }
            var43_44 = null;
            if (StatsFactory.isPMIEnabled() == false) return e;
            endTime = System.currentTimeMillis();
            this.authModule.onWebAuthTime(endTime - startTime - authTime);
            return e;
        }
        var43_45 = null;
        if (StatsFactory.isPMIEnabled() == false) return var34_80;
        endTime = System.currentTimeMillis();
        this.authModule.onWebAuthTime(endTime - startTime - authTime);
        return var34_80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WebReply authorizeForJACC(HttpServletRequest req, HttpServletResponse res, String contextRoot, boolean doAuth, String moduleName, String appName) throws WebSecurityException {
        block72: {
            block69: {
                block68: {
                    block67: {
                        block66: {
                            block65: {
                                block64: {
                                    block63: {
                                        block62: {
                                            startTime = 0L;
                                            endTime = 0L;
                                            authTime = 0L;
                                            contextHandler = null;
                                            lastTrailId = null;
                                            eventTrailIds = null;
                                            try {
                                                block71: {
                                                    if (StatsFactory.isPMIEnabled()) {
                                                        startTime = System.currentTimeMillis();
                                                    }
                                                    if (WebCollaborator.tc.isEntryEnabled()) {
                                                        Tr.entry(WebCollaborator.tc, "authorizeForJACC");
                                                    }
                                                    if (this.isAdminApp(appName)) {
                                                        if (WebCollaborator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebCollaborator.tc, "authorizeForJACC: app is an adminApp: " + appName);
                                                        }
                                                        var16_13 = this.authorize(req, res, contextRoot, doAuth, appName);
                                                        var43_15 = null;
                                                        break block62;
                                                    }
                                                    reply = null;
                                                    uriName = WebCollaborator.getURI(req);
                                                    preAuthorize = false;
                                                    donePreAuthorize = false;
                                                    webPerm = null;
                                                    if (WebCollaborator.tc.isDebugEnabled()) {
                                                        Tr.debug(WebCollaborator.tc, "URI resolved is: " + uriName);
                                                    }
                                                    methodName = req.getMethod();
                                                    methodNameArray = new String[]{methodName};
                                                    doneWithAuthenticated = false;
                                                    authSubject = null;
                                                    authCookies = null;
                                                    authUserName = "???";
                                                    webContext = this.webCache.getWebAccessContext(appName, contextRoot);
                                                    webSecAttr = null;
                                                    if (webContext != null) {
                                                        webSecAttr = webContext.getWebAttributes();
                                                    }
                                                    authResult = null;
                                                    sb = new StringBuffer(WSAccessManager.getContextID(appName));
                                                    if (sb == null) {
                                                        throw new WebSecurityException("Cannot get the contextID for application: " + appName, new DenyReply("Cannot get the contextID for application: " + appName));
                                                    }
                                                    sb.append("/").append(moduleName);
                                                    contextID = sb.toString();
                                                    if (WebCollaborator.tc.isDebugEnabled()) {
                                                        Tr.debug(WebCollaborator.tc, "contextID = " + contextID);
                                                    }
                                                    if (!req.isSecure() && !this.checkDataConstraints(contextID, req, webUDPerm = new WebUserDataPermission(uriName, methodNameArray, null)) && (reply = this.getRedirectURL(req, uriName, methodName)) != null) {
                                                        if (WebCollaborator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebCollaborator.tc, "authorizeForJACC: ", reply);
                                                        }
                                                        var33_43 = reply;
                                                        break block63;
                                                    }
                                                    if (webSecAttr != null && (WebCollaborator.persistCred || WebCollaborator.alwaysLogin)) {
                                                        enableRedirect = true;
                                                        if (WebCollaborator.persistCred) {
                                                            webPerm = new WebResourcePermission(uriName, methodNameArray);
                                                            if (WebCollaborator.tc.isDebugEnabled()) {
                                                                Tr.debug(WebCollaborator.tc, "preAuthorize(1): WebResourcePermission = " + webPerm);
                                                            }
                                                            preAuthorize = this.checkJaccAccess(webPerm, contextID, req, null, null, methodName);
                                                            donePreAuthorize = true;
                                                            if (preAuthorize) {
                                                                if (WebCollaborator.tc.isDebugEnabled()) {
                                                                    Tr.debug(WebCollaborator.tc, "Redirect will not occur");
                                                                }
                                                                enableRedirect = false;
                                                            }
                                                        }
                                                        doneWithAuthenticated = true;
                                                        authResult = this.SetAuthenticatedSubjectIfNeeded(webSecAttr, req, res, true, enableRedirect);
                                                        if (WebCollaborator.alwaysLogin) {
                                                            reply = this.handleAlwaysLogin(authResult, webSecAttr, uriName, methodName);
                                                        }
                                                        if (reply != null) {
                                                            if (WebCollaborator.tc.isEntryEnabled()) {
                                                                Tr.exit(WebCollaborator.tc, "authorize", reply);
                                                            }
                                                            var33_44 = reply;
                                                            break block64;
                                                        }
                                                    }
                                                    if ((reply = this.validSecAttrs(contextRoot, uriName, methodName, true, appName)) != null) {
                                                        if (WebCollaborator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebCollaborator.tc, "authorizeForJACC: ", reply);
                                                        }
                                                        enableRedirect = reply;
                                                        break block65;
                                                    }
                                                    if (req.isSecure() && !this.checkDataConstraints(contextID, req, webUDPerm = new WebUserDataPermission(uriName, methodNameArray, "CONFIDENTIAL"))) {
                                                        reply = WebCollaborator.DENY_AUTHZ_FAILED;
                                                        if (WebCollaborator.tc.isDebugEnabled()) {
                                                            Tr.debug(WebCollaborator.tc, "WebUserDataPermission: " + webUDPerm + " is Excluded.");
                                                        }
                                                        if (WebCollaborator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebCollaborator.tc, "authorizeForJACC: ", reply);
                                                        }
                                                        var33_45 = reply;
                                                        break block66;
                                                    }
                                                    if (!donePreAuthorize) {
                                                        webPerm = new WebResourcePermission(uriName, methodNameArray);
                                                        if (WebCollaborator.tc.isDebugEnabled()) {
                                                            Tr.debug(WebCollaborator.tc, "preAuthorize(2): WebResourcePermission = " + webPerm);
                                                        }
                                                        preAuthorize = this.checkJaccAccess(webPerm, contextID, req, null, null, methodName);
                                                    }
                                                    if (preAuthorize) {
                                                        if (WebCollaborator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebCollaborator.tc, "preAuthorize is true for web: " + uriName + ". exit value true");
                                                        }
                                                        rolesChecked = new String[]{"everyoneAccess"};
                                                        rolesGranted = new String[]{"everyoneAccess"};
                                                        if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                            Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                            msg = "security.audit.service.context.error";
                                                            WebCollaborator.auditService.processAuditFailure(msg, null);
                                                        }
                                                        if (WebCollaborator.auditService != null) {
                                                            lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                            eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                        }
                                                        if (WebCollaborator.auditService != null && WebCollaborator.auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                                                            data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                            contextHandler.buildContextObject("SESSION_CONTEXT", (HashMap)data);
                                                            data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", req.getMethod(), "web", new Long(0L), null, null, rolesChecked, rolesGranted);
                                                            contextHandler.buildContextObject("ACCESS_CONTEXT", (HashMap)data);
                                                            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                            contextHandler.buildContextObject("EVENT_CONTEXT", (HashMap)data);
                                                            data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                            contextHandler.buildContextObject("PROPAGATION_CONTEXT", (HashMap)data);
                                                            data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                                                            contextHandler.buildContextObject("PROCESS_CONTEXT", (HashMap)data);
                                                            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                            contextHandler.buildContextObject("REGISTRY_CONTEXT", (HashMap)data);
                                                            reqLength = 0;
                                                            e = req.getHeaderNames();
                                                            while (e.hasMoreElements()) {
                                                                headerName = (String)e.nextElement();
                                                                ++reqLength;
                                                                if (!WebCollaborator.tc.isDebugEnabled()) continue;
                                                                Tr.debug(WebCollaborator.tc, "reqLength: " + reqLength);
                                                            }
                                                            reqHdrs = new Attributes[reqLength];
                                                            attrEnum = -1;
                                                            e = req.getHeaderNames();
                                                            while (e.hasMoreElements()) {
                                                                headerName = (String)e.nextElement();
                                                                if (reqHdrs[++attrEnum] == null) {
                                                                    if (WebCollaborator.tc.isDebugEnabled()) {
                                                                        Tr.debug(WebCollaborator.tc, "reqHdrs null, creating new");
                                                                    }
                                                                    reqHdrs[attrEnum] = new Attributes();
                                                                }
                                                                reqHdrs[attrEnum].setName("headerName");
                                                                reqHdrs[attrEnum].setValue(req.getHeader(headerName));
                                                                reqHdrs[attrEnum].setSource("application");
                                                            }
                                                            data = DataHelper.buildResponseData(uriName, reqHdrs, null);
                                                            contextHandler.buildContextObject("RESPONSE_CONTEXT", (HashMap)data);
                                                            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                                                            try {
                                                                WebCollaborator.auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                                                            }
                                                            catch (ProviderFailureException e) {
                                                                Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                                msg = "security.audit.service.sendevent.error";
                                                                WebCollaborator.auditService.processAuditFailure(msg, e);
                                                            }
                                                        }
                                                        data = WebCollaborator.PERMIT_REPLY;
                                                        break block67;
                                                    }
                                                    try {
                                                        contextManager = ContextManagerFactory.getInstance();
                                                        if (StatsFactory.isPMIEnabled()) {
                                                            authTime = System.currentTimeMillis();
                                                        }
                                                        if (!doAuth) ** GOTO lbl201
                                                        if (!doneWithAuthenticated) {
                                                            authResult = WebCollaborator.authenticator.authenticate(webSecAttr, req, res);
                                                        }
                                                        if (authResult == null) {
                                                            Tr.error(WebCollaborator.tc, "authResult is null");
                                                            rolesGranted = WebCollaborator.DENY_AUTHN_FAILED;
                                                            var41_63 = null;
                                                        }
                                                        ** GOTO lbl-1000
                                                    }
                                                    catch (Throwable var40_67) {
                                                        var41_66 = null;
                                                        if (StatsFactory.isPMIEnabled() == false) throw var40_67;
                                                        authTime = System.currentTimeMillis() - authTime;
                                                        throw var40_67;
                                                    }
                                                    if (!StatsFactory.isPMIEnabled()) break block68;
                                                    authTime = System.currentTimeMillis() - authTime;
                                                    break block68;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        reply = this.checkAuthStatus(authResult, webSecAttr);
                                                        if (reply == null) ** GOTO lbl-1000
                                                        if (WebCollaborator.tc.isEntryEnabled()) {
                                                            Tr.exit(WebCollaborator.tc, "authorizeForJACC", reply);
                                                        }
                                                        rolesGranted = reply;
                                                        var41_64 = null;
                                                    }
                                                    if (!StatsFactory.isPMIEnabled()) break block69;
                                                    authTime = System.currentTimeMillis() - authTime;
                                                    break block69;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        block70: {
                                                            authSubject = authResult.getSubject();
                                                            authCookies = authResult.getCookies();
                                                            authUserName = authResult.getUserName();
                                                            if (!doneWithAuthenticated) {
                                                                try {
                                                                    contextManager.setCallerSubject(authSubject);
                                                                }
                                                                catch (Exception e) {
                                                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1689", this);
                                                                    if (WebCollaborator.tc.isDebugEnabled()) {
                                                                        Tr.debug(WebCollaborator.tc, "Exception occurred when setting credentials for 'current'. ");
                                                                    }
                                                                    break block70;
                                                                }
                                                            }
                                                            break block70;
lbl201:
                                                            // 1 sources

                                                            try {
                                                                receivedSubject = contextManager.getCallerSubject();
                                                                if (receivedSubject != null) {
                                                                    authSubject = receivedSubject;
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1702", this);
                                                                if (!WebCollaborator.tc.isDebugEnabled()) break block70;
                                                                Tr.debug(WebCollaborator.tc, "Invalid credentials retrieved from security  'current'.");
                                                            }
                                                        }
                                                        var41_65 = null;
                                                        if (!StatsFactory.isPMIEnabled()) break block71;
                                                        authTime = System.currentTimeMillis() - authTime;
                                                    }
                                                }
                                                finalAuthorize = false;
                                                finalAuthorize = this.checkJaccAccess(webPerm, contextID, req, authSubject, authUserName, methodName);
                                                if (WebCollaborator.auditService != null && (contextHandler = ((AuditServiceImpl)WebCollaborator.auditService).getContextHandler()) == null) {
                                                    Tr.error(WebCollaborator.tc, "security.audit.service.context.error");
                                                    msg = "security.audit.service.context.error";
                                                    WebCollaborator.auditService.processAuditFailure(msg, null);
                                                }
                                                if (WebCollaborator.auditService != null) {
                                                    lastTrailId = WebCollaborator.auditService.getLastTrailId();
                                                    eventTrailIds = WebCollaborator.auditService.getEventTrailIds();
                                                }
                                                if (WebCollaborator.auditService != null && (WebCollaborator.auditService.isEventRequired("SECURITY_AUTHZ", "DENIED") || WebCollaborator.auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS"))) {
                                                    rSubj = null;
                                                    if (authSubject != null) {
                                                        rSubj = ((Principal)authSubject.getPrincipals().toArray()[0]).getName();
                                                    }
                                                    data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                                                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                                                    data = finalAuthorize != false ? DataHelper.buildAccessData(uriName, "resourceAccess", rSubj, rSubj, "accessSuccess", methodName, "web", new Long(0L), null, null, null, null) : DataHelper.buildAccessData(uriName, "resourceAccess", rSubj, rSubj, "denied", methodName, "web", new Long(0L), null, null, null, null);
                                                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                                                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                                                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                                                    data = DataHelper.buildPropagationData(WebCollaborator.auditService.getFirstCaller(), WebCollaborator.auditService.getCallerList());
                                                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                                                    data = DataHelper.buildProcessData(WebCollaborator.auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                                                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                                                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(WebCollaborator.activeUserRegistry));
                                                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                                                    data = DataHelper.buildProviderData("WebSphere", "providerSuccess");
                                                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                                                    data = DataHelper.buildPolicyData(null, null);
                                                    contextHandler.buildContextObject("POLICY_CONTEXT", data);
                                                    this.auditOutcome = finalAuthorize != false ? DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L) : DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                                                    try {
                                                        WebCollaborator.auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                                                    }
                                                    catch (ProviderFailureException e) {
                                                        Tr.error(WebCollaborator.tc, "security.audit.service.sendevent.error", new Object[]{e});
                                                        msg = "security.audit.service.sendevent.error";
                                                        WebCollaborator.auditService.processAuditFailure(msg, e);
                                                    }
                                                }
                                                reply = this.createReply(finalAuthorize, uriName, authCookies);
                                                if (WebCollaborator.tc.isEntryEnabled()) {
                                                    Tr.exit(WebCollaborator.tc, "authorizeForJACC", reply);
                                                }
                                                var33_50 = reply;
                                                break block72;
                                            }
                                            catch (Throwable var42_68) {
                                                var43_24 = null;
                                                if (StatsFactory.isPMIEnabled() == false) throw var42_68;
                                                endTime = System.currentTimeMillis();
                                                this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                                                throw var42_68;
                                            }
                                        }
                                        if (StatsFactory.isPMIEnabled() == false) return var16_13;
                                        endTime = System.currentTimeMillis();
                                        this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                                        return var16_13;
                                    }
                                    var43_16 = null;
                                    if (StatsFactory.isPMIEnabled() == false) return var33_43;
                                    endTime = System.currentTimeMillis();
                                    this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                                    return var33_43;
                                }
                                var43_17 = null;
                                if (StatsFactory.isPMIEnabled() == false) return var33_44;
                                endTime = System.currentTimeMillis();
                                this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                                return var33_44;
                            }
                            var43_18 = null;
                            if (StatsFactory.isPMIEnabled() == false) return enableRedirect;
                            endTime = System.currentTimeMillis();
                            this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                            return enableRedirect;
                        }
                        var43_19 = null;
                        if (StatsFactory.isPMIEnabled() == false) return var33_45;
                        endTime = System.currentTimeMillis();
                        this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                        return var33_45;
                    }
                    var43_20 = null;
                    if (StatsFactory.isPMIEnabled() == false) return data;
                    endTime = System.currentTimeMillis();
                    this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                    return data;
                }
                var43_21 = null;
                if (StatsFactory.isPMIEnabled() == false) return rolesGranted;
                endTime = System.currentTimeMillis();
                this.authModule.onJACCAuthTime(endTime - startTime - authTime);
                return rolesGranted;
            }
            var43_22 = null;
            if (StatsFactory.isPMIEnabled() == false) return rolesGranted;
            endTime = System.currentTimeMillis();
            this.authModule.onJACCAuthTime(endTime - startTime - authTime);
            return rolesGranted;
        }
        var43_23 = null;
        if (StatsFactory.isPMIEnabled() == false) return var33_50;
        endTime = System.currentTimeMillis();
        this.authModule.onJACCAuthTime(endTime - startTime - authTime);
        return var33_50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkJaccAccess(WebResourcePermission webPerm1, String contextid, HttpServletRequest req1, Subject subject, String authUserName, String methodName) {
        boolean hasAccess;
        block22: {
            block21: {
                hasAccess = false;
                final HashMap handlerObjects = new HashMap();
                final Subject jaccSubject = subject;
                final String contextID = contextid;
                final WebResourcePermission webPerm = webPerm1;
                final HttpServletRequest req = req1;
                Boolean jaccAccess = new Boolean(false);
                jaccAccess = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws PolicyContextException {
                        PolicyContext.setContextID(contextID);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Registering JACC context handlers");
                        }
                        for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                            PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                        }
                        handlerObjects.put(jaccHandlerKeyArray[0], jaccSubject);
                        handlerObjects.put(jaccHandlerKeyArray[1], req);
                        ProtectionDomain pd = null;
                        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                        if (jaccSubject != null && jaccSubject.getPrincipals().size() > 0) {
                            Principal[] principalArray = jaccSubject.getPrincipals().toArray(new Principal[jaccSubject.getPrincipals().size()]);
                            pd = new ProtectionDomain((CodeSource)security2.getObject("nullSourceCode"), null, null, principalArray);
                        } else {
                            pd = (ProtectionDomain)security2.getObject("nullProtectionDomain");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting JACC handler data");
                        }
                        PolicyContext.setHandlerData(handlerObjects);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling JACC implies");
                        }
                        Boolean result = new Boolean(Policy.getPolicy().implies(pd, webPerm));
                        return result;
                    }
                });
                hasAccess = jaccAccess;
                if (!tc.isDebugEnabled()) break block21;
                if (hasAccess) {
                    if (jaccSubject == null) {
                        Tr.debug(tc, "hasAccess is true for web during preauthorize");
                    } else {
                        Tr.debug(tc, "hasAccess is true for web during authorize");
                    }
                    break block21;
                }
                if (jaccSubject == null) {
                    Tr.debug(tc, "hasAccess is false for web during preauthorize");
                    break block21;
                }
                Tr.debug(tc, "hasAccess is false for web during authorize");
            }
            Object var15_15 = null;
            try {
                com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                }
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "1943", this);
            }
            break block22;
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.authorize", "1920", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkAuthorization() failed with the exception: " + e);
                    }
                    if (tc.isDebugEnabled()) {
                        if (authUserName == null) {
                            Tr.debug(tc, "authUserName is null");
                        }
                        if (authUserName != null) {
                            Tr.debug(tc, "authUserName is not null: " + authUserName);
                        }
                        if (methodName == null) {
                            Tr.debug(tc, "methodName is null");
                        }
                        if (methodName != null) {
                            Tr.debug(tc, "methodName is not null: " + methodName);
                        }
                    }
                    Tr.audit(tc, "security.web.authz.failed.foruser", new Object[]{authUserName, methodName, contextid, e.getMessage()});
                    Object var15_16 = null;
                    try {
                        com.ibm.ws.security.util.AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                        }
                        FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "1943", this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    com.ibm.ws.security.util.AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception e2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                    }
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "1943", this);
                }
                throw throwable;
            }
        }
        return hasAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean checkDataConstraints(String contextid, HttpServletRequest req, WebUserDataPermission webUDPermission) throws WebSecurityException {
        boolean hasJaccAccess;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkConstraints");
            }
            Object reply = null;
            hasJaccAccess = false;
            final WebUserDataPermission webUDPerm = webUDPermission;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebUserDataPermission = " + webUDPerm);
            }
            final String contextID = contextid;
            final HashMap handlerObjects = new HashMap();
            final HttpServletRequest httpRequest = req;
            Boolean jaccAccess = new Boolean(false);
            jaccAccess = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    PolicyContext.setContextID(contextID);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                    }
                    handlerObjects.put(jaccHandlerKeyArray[1], httpRequest);
                    SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                    ProtectionDomain nullPD = (ProtectionDomain)security2.getObject("nullProtectionDomain");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData(handlerObjects);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling JACC implies");
                    }
                    Boolean result = new Boolean(Policy.getPolicy().implies(nullPD, webUDPerm));
                    return result;
                }
            });
            hasJaccAccess = jaccAccess;
            Object var12_12 = null;
            try {
                com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                }
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "2032", this);
            }
            break block18;
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.checkDataConstraints", "2015", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during checkDataConstraints call: " + e);
                    }
                    Tr.audit(tc, "security.web.authz.checkdataconstraint.failed", new Object[]{contextid, e});
                    hasJaccAccess = false;
                    Object var12_13 = null;
                    try {
                        com.ibm.ws.security.util.AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                        }
                        FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "2032", this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    com.ibm.ws.security.util.AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception e2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                    }
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "2032", this);
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            if (hasJaccAccess) {
                Tr.debug(tc, "hasUserDataJaccAccess is true for web");
            } else {
                Tr.debug(tc, "hasUserDataJaccAccess is false for web");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkConstraints", String.valueOf(hasJaccAccess));
        }
        return hasJaccAccess;
    }

    private boolean isSSLRequired(WebAccessContext webContext, String uriName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSSLRequired");
        }
        WebAccessPermission wa = new WebAccessPermission(uriName, methodName);
        return webContext.getConstraints().isSSLRequired(webContext, wa);
    }

    protected SecurityRole[] getRequiredRoles(WebAccessContext webContext, String uriName, String methodName) {
        WebAccessPermission wa = new WebAccessPermission(uriName, methodName);
        return webContext.getConstraints().getRequiredRoles(webContext, wa);
    }

    protected void checkAuthorization(WebAccessContext context, String uriname, String methodName, Subject receivedSubject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAuthorization");
        }
        ContextHandler contextHandler = null;
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization");
            }
            if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS")) {
                String rSubj = null;
                if (receivedSubject != null) {
                    rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(uriname, "authz", rSubj, rSubj, "accessSuccess", methodName, "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data.clear();
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            return;
        }
        Object grantedRoles = null;
        try {
            this.getAuthorizer().checkAccess(context, uriname, methodName, receivedSubject);
            if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS")) {
                String rSubj = null;
                if (receivedSubject != null) {
                    rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(uriname, "authz", rSubj, rSubj, "accessSuccess", methodName, "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
        }
        catch (AccessException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.checkAuthorization", "2306", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization: throw AccessException");
            }
            if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHZ", "DENIED")) {
                String rSubj = null;
                if (receivedSubject != null) {
                    rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(uriname, "authz", rSubj, rSubj, "denied", methodName, "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException pfe) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, pfe);
                }
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAuthorization");
        }
    }

    protected void checkAuthorization(WebAccessContext context, SecurityRole[] reqRoles, Subject receivedSubject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization");
            }
            return;
        }
        boolean allowed = this.getAuthorizer().isGrantedAnyRole(context, reqRoles, receivedSubject);
        if (!allowed) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAuthorization: throw AccessException");
            }
            int ROLES_SIZE = reqRoles.length;
            StringBuffer sb = new StringBuffer(128);
            sb.append("Authorization failed, Not granted any of the required roles: ");
            for (int i = 0; i < ROLES_SIZE; ++i) {
                sb.append(reqRoles[i].getRoleName()).append(" ");
            }
            throw new AccessException(sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAuthorization");
        }
    }

    protected String getCookieValue(String cookie, String hdrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", hdrName);
        }
        if (cookie == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCookieValue", "no cookie");
            }
            return null;
        }
        int version = 0;
        String domain = null;
        String path = null;
        StringTokenizer tokens = new StringTokenizer(cookie, ",;");
        while (tokens.hasMoreElements()) {
            String pair = tokens.nextToken();
            String name = null;
            String value = null;
            int nameIdx = pair.indexOf("=");
            if (nameIdx == 0 || nameIdx == pair.length()) break;
            name = pair.substring(0, nameIdx).trim();
            if (!name.equals(hdrName) && name.charAt(0) == '$') continue;
            value = pair.substring(nameIdx + 1);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (name.charAt(0) == '$') {
                if (name.equalsIgnoreCase("$Version")) {
                    version = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("$Domain")) {
                    domain = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("$Path")) continue;
                path = value;
                continue;
            }
            if (!name.equalsIgnoreCase(hdrName)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCookieValue", value);
            }
            return value;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue: null");
        }
        return null;
    }

    private String getCookieValue(Cookie[] cookies, String hdrName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookieValue", hdrName);
        }
        String retVal = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!hdrName.equals(cookies[i].getName())) continue;
                retVal = cookies[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookieValue", retVal);
        }
        return retVal;
    }

    public boolean isUserInRole(String rolename, String contextRoot, String vHost, HttpServletRequest req) {
        boolean hasJaccAccess;
        block16: {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            if (!security2.getAuthorizationConfig().getBoolean("useJACCProvider")) {
                return this.isUserInRole(rolename, contextRoot, vHost);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isUserInRoleForJACC");
            }
            Subject authSubject = null;
            Object webContext = null;
            hasJaccAccess = false;
            if (this.securityEnabled) {
                try {
                    WebComponentMetaData wcmd = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    Subject receivedSubject = contextManager.getCallerSubject();
                    if (receivedSubject != null) {
                        authSubject = receivedSubject;
                    }
                    String contextRoot_vhost = vHost + ":" + contextRoot;
                    if (wcmd == null) break block16;
                    String moduleName = ((WebModuleMetaData)wcmd.getModuleMetaData()).getConfiguration().getModuleName();
                    String appName = ((WebModuleMetaData)wcmd.getModuleMetaData()).getApplicationMetaData().getName();
                    if (this.isAdminApp(appName)) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "isUserInRoleForJACC: The app is an adminApp: " + appName);
                        }
                        return this.isUserInRole(rolename, contextRoot, vHost);
                    }
                    SecurityMetaData securityMetaData = (SecurityMetaData)wcmd.getSecurityMetaData();
                    String servletName = null;
                    if (securityMetaData != null) {
                        servletName = securityMetaData.getServletName();
                    }
                    try {
                        hasJaccAccess = servletName != null ? this.checkJaccUserInRolePerm(servletName, rolename, appName, moduleName, authSubject, req) : this.checkJaccUserInRolePerm(nullString, rolename, appName, moduleName, authSubject, req);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.isUserInRole", "2621", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception: ", e);
                        }
                        hasJaccAccess = false;
                    }
                    if (tc.isDebugEnabled()) {
                        if (hasJaccAccess) {
                            Tr.debug(tc, "hasJaccAccess is true for web role ref");
                        } else {
                            Tr.debug(tc, "hasJaccAccess is false for web role ref");
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.isUserInRole", "2636", this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Exception: ", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserInRoleForJACC", String.valueOf(hasJaccAccess));
        }
        return hasJaccAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkJaccUserInRolePerm(String servletName, String roleref, String jaccAppName, String moduleName, Subject authSubject, HttpServletRequest req) {
        boolean hasJaccRoleRefAccess;
        block17: {
            hasJaccRoleRefAccess = false;
            StringBuffer sb = new StringBuffer(WSAccessManager.getContextID(jaccAppName));
            if (sb == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the contextID for application: " + jaccAppName + ". Returning false.");
                }
                return false;
            }
            sb.append("/").append(moduleName);
            String contextid = sb.toString();
            final WebRoleRefPermission webRolePerm = new WebRoleRefPermission(servletName, roleref);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebRoleRefPermission = " + webRolePerm);
            }
            final String contextID = contextid;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "contextID: " + contextID);
            }
            final HashMap handlerObjects = new HashMap();
            final Subject jaccSubject = authSubject;
            final HttpServletRequest httpRequest = req;
            Boolean jaccAccess = new Boolean(false);
            jaccAccess = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    PolicyContext.setContextID(contextID);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                    }
                    handlerObjects.put(jaccHandlerKeyArray[0], jaccSubject);
                    handlerObjects.put(jaccHandlerKeyArray[1], httpRequest);
                    ProtectionDomain pd = null;
                    SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                    if (jaccSubject != null && jaccSubject.getPrincipals().size() > 0) {
                        Principal[] principalArray = jaccSubject.getPrincipals().toArray(new Principal[jaccSubject.getPrincipals().size()]);
                        pd = new ProtectionDomain((CodeSource)security2.getObject("nullSourceCode"), null, null, principalArray);
                    } else {
                        pd = (ProtectionDomain)security2.getObject("nullProtectionDomain");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData(handlerObjects);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling JACC implies");
                    }
                    Boolean result = new Boolean(Policy.getPolicy().implies(pd, webRolePerm));
                    return result;
                }
            });
            hasJaccRoleRefAccess = jaccAccess;
            Object var17_17 = null;
            try {
                com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                }
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "2735", this);
            }
            break block17;
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security. web.WebCollaborator.checkUserInRole", "2717", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during isUserInRolecall: " + e);
                    }
                    Tr.audit(tc, "security.web.authz.isuserinrole.failed", new Object[]{contextid, e});
                    hasJaccRoleRefAccess = false;
                    Object var17_18 = null;
                    try {
                        com.ibm.ws.security.util.AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                        }
                        FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "2735", this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    com.ibm.ws.security.util.AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception e2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                    }
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.web.WebCollaborator.authorize", "2735", this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserInRole", String.valueOf(hasJaccRoleRefAccess));
        }
        return hasJaccRoleRefAccess;
    }

    protected static IPrivateRequestAttributes getPrivateAttributes(HttpServletRequest req) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivateAttributes");
        }
        IPrivateRequestAttributes reqAttrs = null;
        HttpServletRequest sr = req;
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr != null && sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        if (sr != null && sr instanceof SRTServletRequest) {
            reqAttrs = (IPrivateRequestAttributes)sr;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrivateAttributes", new Object[]{reqAttrs});
        }
        return reqAttrs;
    }

    protected static void setPrivateAttributes(HttpServletRequest req, String key, Object object) {
        HttpServletRequest sr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPrivateAttributes", new Object[]{key, object});
        }
        if ((sr = req) instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr != null && sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        if (sr != null && sr instanceof SRTServletRequest) {
            ((IPrivateRequestAttributes)sr).setPrivateAttribute(key, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPrivateAttributes");
        }
    }

    public Principal getUserPrincipal() {
        String principalName;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUserPrincipal");
            }
            principalName = null;
            if (this.securityEnabled) {
                try {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    Subject subject = contextManager.getCallerSubject();
                    final WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "Caller credential: ", cred);
                    }
                    if (subject == null || cred.isUnauthenticated()) break block15;
                    if (contextManager.getPlatformHelper().isZOS()) {
                        try {
                            principalName = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    PlatformCredential pc = null;
                                    String principalClass = (String)cred.get("com.ibm.wsspi.security.token.caller_principal_class");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Requested principal class is: " + principalClass);
                                    }
                                    if ("com.ibm.ws.security.zos.Principal".equals(principalClass)) {
                                        pc = (PlatformCredential)cred.get("com.ibm.ws.security.zos.PlatformCredential");
                                    }
                                    if (pc != null) {
                                        return pc.getUserId();
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.WebCollaborator", "2865", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception getting CallerPrincipalClass: ", new Object[]{e.getException()});
                            }
                            principalName = null;
                        }
                    }
                    SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                    boolean useQualifiedUserName = security2.getBoolean("useDomainQualifiedUserNames");
                    if (principalName == null) {
                        principalName = cred.getSecurityName();
                    }
                    if (useQualifiedUserName) {
                        String realm = cred.getRealmName();
                        if (realm == null || realm.length() == 0) {
                            realm = security2.getActiveUserRegistry().getString("realm");
                        }
                        principalName = realm + "/" + principalName;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.web.WebCollaborator", "2895");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception", e);
                    }
                    principalName = null;
                }
            }
        }
        Identity principal = null;
        if (principalName != null) {
            principal = new Identity(new String(principalName));
        }
        if (tc.isEntryEnabled()) {
            final Identity principal_final = principal;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Tr.exit(tc, "getUserPrincipal", principal_final);
                    return null;
                }
            });
        }
        return principal;
    }

    protected boolean SetUnauthenticatedSubjectIfNeeded(Subject invokedSubject, Subject receivedSubject) {
        boolean result;
        block6: {
            result = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SetUnauthenticatedSubjectIfNeeded");
            }
            if (invokedSubject == null && receivedSubject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoked and received Subject are null, setting it anonymous/unauthenticated.");
                }
                try {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    contextManager.setInvocationSubject(SubjectHelper.createUnauthenticatedSubject());
                    result = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.SetUnauthenticatedSubjectIfNeeded", "2941", this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "setUnauthenticated Subject threw an unexpected exception" + e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SetUnauthenticatedSubjectIfNeeded:" + result);
        }
        return result;
    }

    private int getHTTPSPort(int httpPort) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHTTPSPort: " + httpPort);
        }
        ArrayList vHostPortList = null;
        String vHostName2 = null;
        int port = -1;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig("security");
        Map vHostMap = (Map)security2.getObject("host.virtualhosts");
        List trans = (List)security2.getObject("webcontainer.transports");
        for (String vHostName2 : vHostMap.keySet()) {
            vHostPortList = (ArrayList)vHostMap.get(vHostName2);
            for (int i = 0; i < vHostPortList.size(); ++i) {
                String vHostPort = (String)vHostPortList.get(i);
                if (tc.isDebugEnabled() && vHostPort != null) {
                    Tr.debug(tc, "Port " + vHostPort + " in virtual host " + vHostName2);
                }
                port = -1;
                try {
                    port = Integer.parseInt(vHostPort);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (vHostPort == null || port != httpPort) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found HTTP port " + vHostPort + " in virtual host " + vHostName2);
                }
                for (int j = 0; j < trans.size(); ++j) {
                    Integer portInt = (Integer)trans.get(j);
                    if (portInt == null) continue;
                    int httpsPort = portInt;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking if port " + httpsPort + " is in the same virtual host.");
                    }
                    for (int m = 0; m < vHostPortList.size(); ++m) {
                        String sPort = (String)vHostPortList.get(m);
                        port = -1;
                        try {
                            port = Integer.parseInt(sPort);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        if (sPort != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Port " + port + " in virtual host " + vHostName2);
                        }
                        if (sPort == null || port != httpsPort) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "Found HTTPS port " + httpsPort + " in virtual host " + vHostName2);
                        }
                        return httpsPort;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHTTPSPort: SSL port not found");
        }
        Tr.error(tc, "security.web.httpsPort.notFound");
        return -1;
    }

    protected boolean unsupportedAuthMech(WebAttributes webAttrs) {
        String challengeType = webAttrs.getChallengeType();
        return challengeType.equalsIgnoreCase("DIGEST");
    }

    public boolean isUserInRole(String rolename, String contextRoot, String vHost) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserInRole", new Object[]{rolename, contextRoot, vHost});
        }
        Subject authSubject = null;
        WebAccessContext webContext = null;
        if (this.securityEnabled) {
            block20: {
                try {
                    WebComponentMetaData wcmd = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    Subject receivedSubject = contextManager.getCallerSubject();
                    if (receivedSubject != null) {
                        authSubject = receivedSubject;
                    }
                    String contextRoot_vhost = vHost + ":" + contextRoot;
                    String appName = null;
                    if (wcmd != null) {
                        appName = ((WebModuleMetaData)wcmd.getModuleMetaData()).getApplicationMetaData().getName();
                    }
                    if ((webContext = this.webCache.getWebAccessContext(appName, contextRoot_vhost)) == null) {
                        return false;
                    }
                    if (wcmd != null) {
                        String module_name = ((WebModuleMetaData)wcmd.getModuleMetaData()).getConfiguration().getModuleName();
                        SecurityMetaData securityMetaData = (SecurityMetaData)wcmd.getSecurityMetaData();
                        if (securityMetaData != null) {
                            String servlet_name = securityMetaData.getServletName();
                            List rolerefs = securityMetaData.getSecurityRoleRefs();
                            for (Object securityRoleRef : rolerefs) {
                                String rname;
                                org.eclipse.jst.j2ee.common.SecurityRoleRef srr;
                                if (securityRoleRef instanceof org.eclipse.jst.j2ee.common.SecurityRoleRef) {
                                    srr = (org.eclipse.jst.j2ee.common.SecurityRoleRef)securityRoleRef;
                                    rname = srr.getName();
                                    if (!rname.equals(rolename)) continue;
                                    String rolelink = srr.getLink();
                                    SecurityRole role = WCCMHelper.createSecurityRole(rolelink, rolelink);
                                    return this.getAuthorizer().isGrantedRole(webContext, role, new WSPrincipal(authSubject));
                                }
                                if (!(securityRoleRef instanceof SecurityRoleRef) || !(rname = (srr = (SecurityRoleRef)securityRoleRef).getRoleName()).equals(rolename)) continue;
                                String rolelink = srr.getRoleLink();
                                SecurityRole role = WCCMHelper.createSecurityRole(rolelink, rolelink);
                                return this.getAuthorizer().isGrantedRole(webContext, role, new WSPrincipal(authSubject));
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "In isUserInRole, security metadata is null");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In isUserInRole, WebComponentMetaData is null");
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.isUserInRole", "3178", this);
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Exception: ", e);
                }
            }
            SecurityRole secRole = WCCMHelper.createSecurityRole(rolename, rolename);
            if (secRole != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found security role named " + rolename);
                }
                if (webContext != null && authSubject != null) {
                    return this.getAuthorizer().isGrantedRole(webContext, secRole, new WSPrincipal(authSubject));
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find security role named " + rolename);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserInRole");
        }
        return false;
    }

    protected WebReply checkDataConstraints(WebAccessContext webContext, String uriName, String methodName, HttpServletRequest req) throws WebSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkConstraints");
        }
        WebReply reply = null;
        if (this.isSSLRequired(webContext, uriName, methodName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request should be over SSL to access the resource. Redirecting to HTTPS...");
            }
            reply = this.getRedirectURL(req, uriName, methodName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkConstraints", reply);
        }
        return reply;
    }

    static String getURI(HttpServletRequest req) {
        int sindex;
        String uriName = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            uriName = uriName.concat(pathInfo);
        }
        if (uriName == null || uriName.length() == 0) {
            uriName = "/";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "URI requested: " + uriName);
        }
        if (uriName != null && (sindex = (uriName = WSUtil.resolveURI(uriName)).indexOf(";")) != -1) {
            uriName = uriName.substring(0, sindex);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "URI returned: " + uriName);
        }
        return uriName;
    }

    private boolean checkValidURI(String uriName) {
        return uriName != null && uriName.length() != 0;
    }

    private WebReply unprotectedSpecialURI(WebAttributes webSecAttr, String uriName, String methodName) {
        ContextHandler contextHandler = null;
        if (webSecAttr != null) {
            String lastTrailId = null;
            String[] eventTrailIds = null;
            this.startTime = new Date();
            String loginPage = null;
            String errorPage = null;
            if (webSecAttr.getChallengeType().equals("FORM") && (loginPage = webSecAttr.getLoginURL()) != null && (errorPage = webSecAttr.getReloginURL()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " We have a custom login or error page request, web app login URL:[" + loginPage + "], errorPage URL:[" + errorPage + "], and the requested URI:[" + uriName + "]");
                }
                if (loginPage.equals(uriName) || errorPage.equals(uriName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize, login or error page[" + uriName + "]  requested, permit: ", PERMIT_REPLY);
                    }
                    String[] rolesChecked = new String[]{"unprotectedSpecial"};
                    String[] rolesGranted = new String[]{"unprotectedSpecial"};
                    if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msg = "security.audit.service.context.error";
                        auditService.processAuditFailure(msg, null);
                    }
                    if (auditService != null) {
                        lastTrailId = auditService.getLastTrailId();
                        eventTrailIds = auditService.getEventTrailIds();
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                        HashMap data = DataHelper.buildSessionData(null, null, null, null);
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", methodName, "web", new Long(0L), null, null, rolesChecked, rolesGranted);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildResponseData(uriName, null, null);
                        contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                        try {
                            auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                        }
                        catch (ProviderFailureException e) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, e);
                        }
                    }
                    return PERMIT_REPLY;
                }
                if (uriName != null && uriName.equals("/j_security_check") && methodName != null && methodName.equals("POST")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "authorize, login or error page[" + uriName + "]  requested, permit: ", PERMIT_REPLY);
                    }
                    String[] rolesChecked = new String[]{"unprotectedSpecial"};
                    String[] rolesGranted = new String[]{"unprotectedSpecial"};
                    if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msg = "security.audit.service.context.error";
                        auditService.processAuditFailure(msg, null);
                    }
                    if (auditService != null) {
                        lastTrailId = auditService.getLastTrailId();
                        eventTrailIds = auditService.getEventTrailIds();
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                        HashMap data = DataHelper.buildSessionData(null, null, null, null);
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", methodName, "web", new Long(0L), null, null, rolesChecked, rolesGranted);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildResponseData(uriName, null, null);
                        contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                        try {
                            auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                        }
                        catch (ProviderFailureException e) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, e);
                        }
                    }
                    return PERMIT_REPLY;
                }
            }
        }
        return null;
    }

    private WebReply handleAlwaysLogin(AuthenticationResult authResult, WebAttributes webSecAttr, String uriName, String methodName) {
        WebReply reply = this.unprotectedSpecialURI(webSecAttr, uriName, methodName);
        if (reply != null) {
            return reply;
        }
        if (authResult == null) {
            Tr.error(tc, "authResult is null");
            return DENY_AUTHN_FAILED;
        }
        reply = this.checkAuthStatus(authResult, webSecAttr);
        return reply;
    }

    private AuthenticationResult SetAuthenticatedSubjectIfNeeded(WebAttributes webSecAttr, HttpServletRequest req, HttpServletResponse res, boolean performTAI, boolean enableRedirect) {
        AuthenticationResult authResult;
        block3: {
            authResult = authenticator.authenticate(webSecAttr, req, res, performTAI, enableRedirect);
            if (authResult != null && authResult.getStatus() == 1) {
                try {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    contextManager.setCallerSubject(authResult.getSubject());
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebCollaborator.SetAuthenticatedSubjectIfNeeded", "3493", this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "Exception occurred when setting credentials for 'current'. ");
                }
            }
        }
        return authResult;
    }

    private WebReply validSecAttrs(String contextRoot, String uriName, String methodName, boolean isJacc, String appName) {
        ContextHandler contextHandler = null;
        WebReply reply = null;
        WebAccessContext webContext = this.webCache.getWebAccessContext(appName, contextRoot);
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (webContext == null) {
            this.startTime = new Date();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Web App config found.");
            }
            StringBuffer sb = new StringBuffer("Cannot create a web security context for this request.");
            reply = new DenyReply(sb.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authorize", reply);
            }
            if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "DENIED")) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "denied", methodName, "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildResponseData(uriName, null, null);
                contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 22L);
                try {
                    auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            return reply;
        }
        WebAttributes webSecAttr = webContext.getWebAttributes();
        if (!isJacc) {
            if (webSecAttr == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer b = new StringBuffer("No WebAttributes for context root = ");
                    b.append(contextRoot);
                    Tr.debug(tc, b.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorize: ", PERMIT_REPLY);
                }
                String[] rolesChecked = new String[]{"unprotected"};
                String[] rolesGranted = new String[]{"unprotected"};
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    String msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null) {
                    lastTrailId = auditService.getLastTrailId();
                    eventTrailIds = auditService.getEventTrailIds();
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                    HashMap data = DataHelper.buildSessionData(null, null, null, null);
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", methodName, "web", new Long(0L), null, null, rolesChecked, rolesGranted);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildResponseData(uriName, null, null);
                    contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                    try {
                        auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
                return PERMIT_REPLY;
            }
            WebResourceCollectionConstraints secConstraints = webContext.getConstraints().getConstraints(webContext, uriName, methodName);
            if (secConstraints == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer b = new StringBuffer("No WebConstraints for URI = ");
                    b.append(uriName);
                    b.append(", method = ");
                    b.append(methodName);
                    Tr.debug(tc, b.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "authorize: ", PERMIT_REPLY);
                }
                String[] rolesChecked = new String[]{"unprotected"};
                String[] rolesGranted = new String[]{"unprotected"};
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    String msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null) {
                    lastTrailId = auditService.getLastTrailId();
                    eventTrailIds = auditService.getEventTrailIds();
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "SUCCESS")) {
                    HashMap data = DataHelper.buildSessionData(null, null, null, null);
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessSuccess", methodName, "web", new Long(0L), null, null, rolesChecked, rolesGranted);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildResponseData(uriName, null, null);
                    contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 6L);
                    try {
                        auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
                return PERMIT_REPLY;
            }
        }
        reply = this.unprotectedSpecialURI(webSecAttr, uriName, methodName);
        return reply;
    }

    private WebReply checkAuthStatus(AuthenticationResult authResult, WebAttributes webSecAttr) {
        WebReply reply = null;
        switch (authResult.getStatus()) {
            case 2: {
                reply = DENY_AUTHN_FAILED;
                Tr.audit(tc, "security.authn.failed", new Object[]{authResult.getReason()});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", reply);
                }
                return reply;
            }
            case 3: {
                reply = new ChallengeReply(webSecAttr.getRealm());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authentication failed - sending a 401");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", reply);
                }
                return reply;
            }
            case 5: {
                reply = new TAIChallengeReply(authResult.getTAIChallengeCode());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TAI authentication challenge - sending " + authResult.getTAIChallengeCode());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", reply);
                }
                return reply;
            }
            case 4: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "redirecting to another url");
                }
                reply = authResult.getCookies() != null ? new RedirectReply(authResult.getRedirectURL(), authResult.getCookies()) : new RedirectReply(authResult.getRedirectURL());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", reply);
                }
                return reply;
            }
            case 0: 
            case 6: {
                Tr.audit(tc, "security.authn.failed", new Object[]{new Integer(authResult.getStatus())});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication failed. Status: " + authResult.getStatus());
                }
                reply = DENY_AUTHN_FAILED;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkAuthStatus", reply);
                }
                return reply;
            }
        }
        return reply;
    }

    private WebReply createReply(boolean finalAuthorize, String uriName, ArrayList authCookies) {
        WebReply reply = null;
        if (finalAuthorize) {
            reply = new PermitReply(authCookies);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization check for uri: " + uriName + " succeeded. ");
            }
        } else {
            reply = DENY_AUTHZ_FAILED;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization check for uri: " + uriName + " failed. ");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReply", reply);
        }
        return reply;
    }

    private WebReply getRedirectURL(HttpServletRequest req, String uriName, String methodName) {
        int endInx;
        String hostPort;
        int portInx;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRedirectURL");
        }
        ContextHandler contextHandler = null;
        this.startTime = new Date();
        StringBuffer URL2 = req.getRequestURL();
        String URLString = URL2.toString();
        int inx = URLString.indexOf(47);
        if ((portInx = (hostPort = URLString.substring(inx += 2, endInx = URLString.indexOf(47, inx))).lastIndexOf(58)) != -1) {
            String sPort = hostPort.substring(portInx + 1);
            int port = Integer.parseInt(sPort);
            int httpsPort = this.getHTTPSPort(port);
            String httpsPortStr = Integer.toString(httpsPort);
            URL2.replace(inx + portInx + 1, endInx, httpsPortStr);
        }
        URL2.replace(0, 4, "https");
        if (req.getQueryString() != null) {
            URL2.append("?");
            URL2.append(req.getQueryString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Redirected to " + URL2.toString());
        }
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_RESOURCE_ACCESS", "REDIRECT")) {
            HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, "accessRedirect", methodName, "web", new Long(0L), null, null, null, null);
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            int reqLength = 0;
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                ++reqLength;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "reqLength: " + reqLength);
            }
            Attributes[] reqHdrs = new Attributes[reqLength];
            int attrEnum = -1;
            Enumeration e2 = req.getHeaderNames();
            while (e2.hasMoreElements()) {
                String headerName = (String)e2.nextElement();
                if (reqHdrs[++attrEnum] == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "reqHdrs null, creating new");
                    }
                    reqHdrs[attrEnum] = new Attributes();
                }
                reqHdrs[attrEnum].setName("headerName");
                reqHdrs[attrEnum].setValue(req.getHeader(headerName));
                reqHdrs[attrEnum].setSource("application");
            }
            data = DataHelper.buildResponseData(URL2.toString(), reqHdrs, null);
            contextHandler.buildContextObject("RESPONSE_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "REDIRECT", 21L);
            try {
                auditService.sendEvent("SECURITY_RESOURCE_ACCESS", this.auditOutcome);
            }
            catch (ProviderFailureException e22) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e22});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e22);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRedirectURL", URL2.toString());
        }
        return new RedirectReply(URL2.toString());
    }

    static {
        initialized = false;
        persistCred = false;
        alwaysLogin = false;
    }
}

