/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAppCacheEntry;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebConstraintsTable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WebAppCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WebAppCache.class);
    private static Properties httpMethods = new Properties();
    private static final String VHOST_HOME = "VirtualHostHome";
    private static final String TYPE_HOME = "TypeHome";
    private static WebAttributes UNPROTECTED_WEBATTRS = new WebAttributes();
    private static HashMap cache = new HashMap();
    private boolean reload;

    public WebAppCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebAppCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebAppCache");
        }
    }

    public void addWebApp(String enterprise, String contextRoot, WebApp webapp, DeployedModule webModuleConfig) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding webapp with context root =[" + enterprise + ":" + contextRoot + "]");
        }
        if (cache.get(enterprise + ":" + contextRoot) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create a WebConstraintsTable for this webApp");
            }
            WebConstraintsTable cons = new WebConstraintsTable(webapp, enterprise, webModuleConfig);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create WebAttributes for this webApp.");
            }
            WebAttributes wsa = new WebAttributes(webapp);
            WebAppCacheEntry entry = new WebAppCacheEntry(enterprise, contextRoot, wsa, cons, webapp);
            cache.put(enterprise + ":" + contextRoot, entry);
        }
    }

    public static void removeWebApp(String appName, String contextRoot) {
        cache.remove(appName + ":" + contextRoot);
    }

    public boolean isContained(String appName, String contextRoot) {
        return cache.containsKey(appName + ":" + contextRoot);
    }

    public WebAccessContext getWebAccessContext(String appName, String contextRoot) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebAccessContext", new Object[]{appName, contextRoot});
        }
        WebAppCacheEntry entry = (WebAppCacheEntry)cache.get(appName + ":" + contextRoot);
        WebConstraintsTable cons = null;
        String enterprise = null;
        if (entry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Okay, I found the entry for [" + appName + ":" + contextRoot + "]");
            }
            enterprise = entry.getEnterpriseName();
            cons = entry.getConstraints();
            if (cons == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "WebConstraintsTable is NULL though.");
            }
            WebAttributes attr = entry.getSecurityAttributes();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebAccessContext");
            }
            return new WebAccessContext(enterprise, contextRoot, cons, attr, entry.getWebApp());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NO WEB SECURITY CONTEXT INFO FOUND FOR " + appName + ":" + contextRoot);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebAccessContext");
        }
        return new WebAccessContext(enterprise, contextRoot, null, null, null);
    }

    public WebAttributes getWebSecurityAttributes(final String appName, final String contextRoot) throws Exception {
        WebAttributes wsa;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWebAttributes", new Object[]{appName, contextRoot});
            }
            wsa = UNPROTECTED_WEBATTRS;
            try {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                wsa = (WebAttributes)contextManager.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        WebAppCacheEntry entry = (WebAppCacheEntry)cache.get(appName + ":" + contextRoot);
                        if (entry != null) {
                            return entry.getSecurityAttributes();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.WebAppCache.getWebSecurityAttributes", "155", this);
                if (!tc.isDebugEnabled()) break block5;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Tr.debug(tc, "Exception of getting SecurityAttributes of WebApp", sw.toString());
            }
        }
        if (wsa == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning a NULL web attributes object.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebAttributes");
        }
        return wsa;
    }

    public void alarm(Object alarmCtx) {
        this.mark();
    }

    private void mark() {
    }

    public PermissionRoleMap getPermissionRoleMap(String appName, String contextRoot) {
        WebAppCacheEntry entry = (WebAppCacheEntry)cache.get(appName + ":" + contextRoot);
        WebConstraintsTable prm = null;
        if (entry != null) {
            prm = entry.getConstraints();
        }
        return prm;
    }

    static {
        for (int i = 0; i < Constants.HTTP_METHODS.length; ++i) {
            String method2 = Constants.HTTP_METHODS[i];
            httpMethods.put(method2, "HTTP_" + method2);
        }
    }
}

