/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereBaseTrustAssociationInterceptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.DynamicTAI;
import com.ibm.ws.security.config.InterceptorsConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustAssociationConfig;
import com.ibm.ws.security.web.TAIWrapper;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public final class TrustAssociationManager {
    private static HashMap<String, TrustAssociationManager> _cache = new HashMap();
    public static final String TRUSTED_SERVER_TYPE_WEBSEAL36 = "WebSeal3.6";
    private static TraceComponent tc = Tr.register(TrustAssociationManager.class, null, "com.ibm.ejs.resources.security");
    private String domainID;
    private String firstPassList = "";
    private TAIWrapper[] interceptors = null;
    private int interceptorCount = 0;
    private boolean isTrustAssociationEnabled = false;

    public static TrustAssociationManager getInstance() {
        SecurityConfigManager scm;
        String domainID;
        TrustAssociationManager cachedInstance;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((cachedInstance = _cache.get(domainID = (scm = SecurityObjectLocator.getSecurityConfigManager()).getDomainId())) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "returning cached instance: " + cachedInstance);
            }
            return cachedInstance;
        }
        cachedInstance = new TrustAssociationManager();
        _cache.put(domainID, cachedInstance);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updated the cache with: " + domainID + ", " + cachedInstance);
        }
        return cachedInstance;
    }

    private TrustAssociationManager() {
        this.initialize();
    }

    TAIWrapper getInterceptor(HttpServletRequest req, boolean firstPass) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterceptor()", this.domainID);
        }
        for (int i = 0; i < this.interceptorCount; ++i) {
            TAIWrapper t = this.interceptors[i];
            if (firstPass && this.firstPassList.indexOf(t.getClassName()) != -1 || !firstPass && this.firstPassList.indexOf(t.getClassName()) == -1) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Check if target interceptor [" + i + "]: " + t.getName() + " ...");
                    }
                    if (t.isTargetInterceptor(req)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found interceptor: " + t.getName());
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getInterceptor()");
                        }
                        return t;
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "interceptor " + t.getName() + " throws exception", e);
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.security.web.TrustAssociationManager.getInterceptor", "142");
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Interceptor " + t.getClassName() + " skipped.  First pass list = '" + this.firstPassList + "' First pass: " + firstPass);
        }
        List<DynamicTAI> dynamicTAIs = SecurityObjectLocator.getDynamicTAIConfig().getInterceptors();
        for (int i = 0; i < dynamicTAIs.size(); ++i) {
            DynamicTAI dynamicTAI = dynamicTAIs.get(i);
            if (!dynamicTAI.isLoaded()) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    Tr.error(tc, "security.web.ta.classloaderr");
                    this.isTrustAssociationEnabled = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "class loader failed to load admin domain interceptor");
                    }
                } else {
                    Object taiObject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loading dynamic TAI: " + dynamicTAI.getTAIClassName());
                    }
                    if ((taiObject = this.loadInterceptor(dynamicTAI.getTAIClassName(), dynamicTAI.getTAIProperties(), classLoader)) != null) {
                        dynamicTAI.setLoadedTAIInterceptor(new TAIWrapper(taiObject));
                    }
                }
            }
            TAIWrapper taiWrapper = (TAIWrapper)dynamicTAI.getLoadedTAIInterceptor();
            try {
                if (firstPass && !dynamicTAI.isFirstPass()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Dynamic interceptor " + taiWrapper.getName() + " is not executing on the first pass ...");
                    }
                    continue;
                }
                if (!firstPass && dynamicTAI.isFirstPass()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Dynamic interceptor " + taiWrapper.getName() + " is not executing on the second pass ...");
                    }
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Check if dynamic interceptor " + taiWrapper.getName() + " is target interceptor ...");
                }
                if (!taiWrapper.isTargetInterceptor(req)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found dynamic interceptor: " + taiWrapper.getName());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInterceptor()");
                }
                return taiWrapper;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dynamic interceptor " + taiWrapper.getName() + " throws exception", e);
                }
                FFDCFilter.processException(e, "com.ibm.ws.security.web.TrustAssociationManager.getInterceptor", "208");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterceptor");
        }
        return null;
    }

    boolean isTrustAssociationEnabled() {
        return this.isTrustAssociationEnabled || SecurityObjectLocator.getDynamicTAIConfig().getInterceptors().size() > 0;
    }

    int getInterceptorsCount() {
        return this.interceptorCount;
    }

    private void do_cleanTAInterceptors() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "do_cleanTAInterceptors", this.domainID);
        }
        for (int i = 0; i < this.interceptorCount; ++i) {
            this.interceptors[i].cleanup();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "do_cleanTAInterceptors", this.domainID);
        }
    }

    public void cleanTAInterceptors() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanTAInterceptors");
        }
        Collection<TrustAssociationManager> tais = _cache.values();
        for (TrustAssociationManager current : tais) {
            current.do_cleanTAInterceptors();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanTAInterceptors");
        }
    }

    private void initialize() {
        String aam;
        String domainID;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.domainID = domainID = security2.getDomain();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", this.domainID);
        }
        if ((aam = security2.getActiveAuthMechanism().getType()).equals("LTPA") || aam.equals("KRB5")) {
            boolean taEnabled = false;
            TrustAssociationConfig tac = security2.getTrustAssociation();
            if (tac != null) {
                taEnabled = tac.getBoolean("enabled");
            }
            if (taEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trust Association enabled: Trying to load the interceptors");
                }
                this.firstPassList = security2.getProperty("com.ibm.websphere.security.InvokeTAIbeforeSSO");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First pass list: " + this.firstPassList);
                }
                String classfile = null;
                try {
                    List<InterceptorsConfig> tas = security2.getTrustAssociation().getInterceptors();
                    if (tas.size() == 0) {
                        this.isTrustAssociationEnabled = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No interceptors provided for Trust Association");
                        }
                    } else {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        if (classLoader == null) {
                            Tr.error(tc, "security.web.ta.classloaderr");
                            this.isTrustAssociationEnabled = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "class loader failed to load admin domain interceptor");
                            }
                        } else {
                            ArrayList<Object> tInterceptors = new ArrayList<Object>(tas.size());
                            for (int i = 0; i < tas.size(); ++i) {
                                Object loadedInterceptor;
                                InterceptorsConfig interceptor = tas.get(i);
                                classfile = interceptor.getString("interceptorClassName");
                                Properties trustProps = interceptor.getTrustProperties();
                                if (trustProps == null) {
                                    trustProps = new Properties();
                                }
                                if ((loadedInterceptor = this.loadInterceptor(classfile, trustProps, classLoader)) == null) continue;
                                tInterceptors.add(loadedInterceptor);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Adding Interceptor: " + classfile);
                            }
                            this.interceptorCount = tInterceptors.size();
                            if (this.interceptorCount != 0) {
                                this.interceptors = new TAIWrapper[this.interceptorCount];
                                for (int k = 0; k < this.interceptorCount; ++k) {
                                    this.interceptors[k] = new TAIWrapper(tInterceptors.get(k));
                                }
                                this.isTrustAssociationEnabled = true;
                            } else {
                                this.isTrustAssociationEnabled = false;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Number of Interceptors added are: " + this.interceptorCount);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "207", this);
                    this.isTrustAssociationEnabled = false;
                    Tr.error(tc, "security.web.ta.initerr", new Object[]{classfile, e});
                }
            } else {
                this.isTrustAssociationEnabled = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trust Association not enabled");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private Object loadInterceptor(String classfile, Properties trustProps, ClassLoader classLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadInterceptor", new Object[]{classfile, trustProps});
        }
        if (classfile == null) {
            Tr.error(tc, "security.web.ta.nointclass", new Object[]{classfile});
            return null;
        }
        try {
            Class<?> myClass = classLoader.loadClass(classfile);
            Object tmp = myClass.newInstance();
            Tr.audit(tc, "security.web.ta.loadclass", new Object[]{classfile});
            if (tmp instanceof WebSphereBaseTrustAssociationInterceptor) {
                if (trustProps != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trust Properties = ", trustProps);
                    }
                    int j = ((WebSphereBaseTrustAssociationInterceptor)tmp).init(trustProps);
                    int k = 0;
                    String ignoreError = (String)trustProps.get("com.ibm.websphere.security.trustassociation.ignoreInitStatus");
                    if (ignoreError == null || !ignoreError.equalsIgnoreCase("true")) {
                        String initStatus = (String)trustProps.get("com.ibm.websphere.security.trustassociation.initStatus");
                        if (initStatus != null) {
                            k = Integer.valueOf(initStatus);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Success Status for TAI is : " + k);
                            }
                        }
                        if (j != k) {
                            String errorStatus = Integer.toString(j);
                            Tr.error(tc, "security.web.ta.initerr", new Object[]{classfile, errorStatus});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The Trust Association Implementation file " + classfile + " init method returned error status: " + j + ". The expected status for success is " + k);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "loadInterceptor (null)");
                            }
                            return null;
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The Trust Association Implementation file " + classfile + " init method returned status: " + j);
                    }
                }
                String version = ((WebSphereBaseTrustAssociationInterceptor)tmp).getVersion();
                Tr.audit(tc, "security.web.ta.intsig", new Object[]{version});
            } else if (tmp instanceof TrustAssociationInterceptor) {
                if (trustProps != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trust Properties = ", trustProps);
                    }
                    int j = ((TrustAssociationInterceptor)tmp).initialize(trustProps);
                    int k = 0;
                    String ignoreError = (String)trustProps.get("com.ibm.websphere.security.trustassociation.ignoreInitStatus");
                    if (ignoreError == null || !ignoreError.equalsIgnoreCase("true")) {
                        String initStatus = (String)trustProps.get("com.ibm.websphere.security.trustassociation.initStatus");
                        if (initStatus != null) {
                            k = Integer.valueOf(initStatus);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Success Status for TAI is : " + k);
                            }
                        }
                        if (j != k) {
                            String errorStatus = Integer.toString(j);
                            Tr.error(tc, "security.web.ta.initerr", new Object[]{classfile, errorStatus});
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The Trust Association Implementation file " + classfile + " init method returned error status: " + j + ". The expected status for success is " + k);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "loadInterceptor (null)");
                            }
                            return null;
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The Trust Association Implementation file " + classfile + " init method returned status: " + j);
                    }
                }
                String version = ((TrustAssociationInterceptor)tmp).getVersion();
                Tr.audit(tc, "security.web.ta.intsig", new Object[]{version});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadInterceptor (success)");
            }
            return tmp;
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "178", this);
            Tr.error(tc, "security.web.ta.loadclasserr", new Object[]{classfile});
        }
        catch (NoClassDefFoundError e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "178", this);
            Tr.error(tc, "security.web.ta.loadclasserr", new Object[]{classfile});
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.web.TrustAssociationManager.initialize", "197", this);
            Tr.error(tc, "security.web.ta.initerr", new Object[]{classfile, t});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadInterceptor (exception)");
        }
        return null;
    }
}

