/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLogoutExtensionProcessor
extends WebExtensionProcessor {
    private static TraceComponent tc = Tr.register(FormLogoutExtensionProcessor.class, null, "com.ibm.ejs.resources.security");
    protected static String DEFAULT_LOGOUT_MSG = "<!DOCTYPE HTML PUBLIC \"-//W3C/DTD HTML 4.0 Transitional//EN\"><HTML><TITLE>Default Logout Exit Page</TITLE><BODY><H2>Successful Logout</H2></BODY></HTML>";
    private WebAttributes _webAttrs = null;
    private String _authMechanism = null;
    boolean _securityEnabled = false;
    private static final String componentName = "WAS.security";
    private static final String providerName = "WebSphere";
    private static AuditService auditService = null;
    private static final String ADMIN_APP = "adminconsole";
    private static String ABSOLUTE_URI = "com.ibm.websphere.security.web.absoluteUri";
    private boolean _adminConsole = false;
    private boolean _absoluteUri = false;
    private Date startTime = null;
    private Date endTime = null;
    private static String className;
    private ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private SecurityConfig security = null;

    public FormLogoutExtensionProcessor(IServletContext webapp) {
        super(webapp);
        className = ((Object)((Object)this)).getClass().getName();
        this._adminConsole = false;
        this._absoluteUri = false;
        this.security = SecurityObjectLocator.getSecurityConfig();
        this._securityEnabled = this.security.getBoolean("enabled");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "int, securityEnabled[" + this._securityEnabled + "]");
        }
        if (this._securityEnabled) {
            try {
                WebAppConfig wac = webapp.getWebAppConfig();
                WebModuleMetaData wmmd = wac.getMetaData();
                SecurityMetaData securityMetaData = (SecurityMetaData)wmmd.getSecurityMetaData();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create WebAttributes for this webApp.");
                }
                if (securityMetaData != null) {
                    this._webAttrs = securityMetaData.getWebAttributes();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In FormLogoutExtensionProcessor(), security MetaData is null.");
                }
                if (this._webAttrs == null) {
                    Tr.error(tc, "security.web.form.createWebAttr");
                } else {
                    this._authMechanism = this._webAttrs.getAuthMechanism();
                    if (ADMIN_APP.equalsIgnoreCase(this._webAttrs.getWebAppName())) {
                        this._adminConsole = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "securityEnabled[" + this._securityEnabled + "] " + "authMachism[" + this._authMechanism + "]");
                    }
                }
                String absUri = System.getProperty(ABSOLUTE_URI);
                if (absUri != null && absUri.equalsIgnoreCase("true")) {
                    this._absoluteUri = true;
                }
                this._authMechanism = this.security.getActiveAuthMechanism().getType();
                if (auditService == null) {
                    auditService = ContextManagerFactory.getInstance().getAuditService();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.FormLogoutServlet.init", "103", (Object)this);
                Tr.error(tc, "security.web.form.noWebAppInfo", new Object[]{e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        block10: {
            if (!this._securityEnabled) return;
            if (!(req instanceof HttpServletRequest)) return;
            if (!(res instanceof HttpServletResponse)) return;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            this.startTime = new Date();
            boolean pushed = false;
            try {
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    String profileUUID = (String)((HttpServletRequest)req).getSession().getAttribute("iscSelectedProfileKey");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Pushing UUID during formLogin: " + profileUUID);
                    }
                    pushed = AdminContext.push(profileUUID);
                } else {
                    String appName = this._webAttrs.getWebAppName();
                    boolean isAdminApp = WSAccessManager.checkIfAdminApp(appName);
                    if (!isAdminApp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleRequest pushing user app name " + appName);
                        }
                        pushed = SecurityObjectLocator.pushAppContext(appName);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleRequest pushing admin app name " + appName);
                        }
                        pushed = SecurityObjectLocator.pushAdminContext(appName);
                    }
                }
                this.formLogout(request, response);
                Object var9_9 = null;
                if (!pushed) return;
                if (!SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) break block10;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!pushed) throw throwable;
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    AdminContext.pop();
                    throw throwable;
                }
                SecurityObjectLocator.popContext();
                throw throwable;
            }
            AdminContext.pop();
            return;
        }
        SecurityObjectLocator.popContext();
    }

    private void formLogout(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Principal p;
        Cookie[] cookies;
        String oldLTPACookieName;
        String ltpaCookieName;
        block71: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "formLogout");
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "RequestHeader cookies: ");
                Cookie[] cookieList = req.getCookies();
                if (cookieList != null) {
                    for (int z = 0; z < cookieList.length; ++z) {
                        Tr.debug(tc, "cookieList: " + z + " value: " + cookieList[z].getValue());
                    }
                }
            }
            ContextHandler contextHandler = null;
            String activeUserRegistry = this.security.getActiveUserRegistry().getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activeUserRegistry: " + activeUserRegistry);
            }
            if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
            if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_TERMINATE", "SUCCESS")) {
                if (contextHandler != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "contextHandler not null");
                    }
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("formlogin", "logout", null, null, "logoutSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildAuthnTermData("logout");
                    contextHandler.buildContextObject("AUTHN_TERM_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 9L);
                }
                try {
                    auditService.sendEvent("SECURITY_AUTHN_TERMINATE", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "before get session");
            }
            ContextManager contextManager = ContextManagerFactory.getInstance();
            ltpaCookieName = this._webAttrs.getPreferredLTPACookieName();
            oldLTPACookieName = this._webAttrs.getLTPACookieName();
            cookies = req.getCookies();
            if (cookies != null) {
                String[] cookieValues = null;
                cookieValues = WebAuthenticator.getCookieValues(cookies, ltpaCookieName);
                if (cookieValues == null) {
                    cookieValues = WebAuthenticator.getCookieValues(cookies, oldLTPACookieName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cookie values: " + cookieValues);
                }
                if (cookieValues != null) {
                    for (int n = 0; n < cookieValues.length; ++n) {
                        String val = cookieValues[n];
                        byte[] ltpaToken = null;
                        if (val.length() <= 0 || (ltpaToken = StringUtil.getBytes(Base64Coder.base64Decode(val))) == null || ltpaToken.length <= 0) continue;
                        ByteArray cachekey = new ByteArray(ltpaToken);
                        AuthCache authCache = AuthCache.getInstance();
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Cache Key: " + ltpaToken.toString());
                            }
                            Subject sub = authCache.getSubject(ltpaToken);
                            contextManager.initializeCallerContext(sub);
                            continue;
                        }
                        catch (Exception ce) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception caught while trying to retrieve subject cache entry by using token: " + ce);
                        }
                    }
                }
            }
            HttpSession session = req.getSession(false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "after get session");
            }
            if (this._authMechanism.equals("LTPA") || this._authMechanism.equals("KRB5")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRB5 and/or LTPA Enabled, clearing LTPA Cookies");
                }
                this._webAttrs.createLogoutCookies(req, res);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KRB5, LTPA and SSO NOT Enabled");
            }
            if (session != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invalidating existing HTTP Session");
                }
                session.invalidate();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Existing HTTP Session does not exist, nothing to invalidate");
            }
            try {
                contextManager.clearCallerContext();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block71;
                Tr.debug(tc, "BAD! clearCallerContext failed");
            }
        }
        String user = req.getRemoteUser();
        if (user == null && (p = req.getUserPrincipal()) != null) {
            user = p.getName();
        }
        if (user != null) {
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeEntry(null, user);
            }
            catch (CacheException ce) {
                Tr.debug(tc, "Exception caught while trying to remove a cache entry: " + ce);
            }
        } else if (this._authMechanism.equals("LTPA")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user id is null, attempt to clear AuthCache entry by using LTPAToken cookie.");
            }
            ltpaCookieName = this._webAttrs.getPreferredLTPACookieName();
            oldLTPACookieName = this._webAttrs.getLTPACookieName();
            cookies = req.getCookies();
            if (cookies != null) {
                String[] cookieValues = null;
                cookieValues = WebAuthenticator.getCookieValues(cookies, ltpaCookieName);
                if (cookieValues == null) {
                    cookieValues = WebAuthenticator.getCookieValues(cookies, oldLTPACookieName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cookie values: " + cookieValues);
                }
                if (cookieValues != null) {
                    for (int n = 0; n < cookieValues.length; ++n) {
                        String val = cookieValues[n];
                        byte[] ltpaToken = null;
                        if (val.length() <= 0 || (ltpaToken = StringUtil.getBytes(Base64Coder.base64Decode(val))) == null || ltpaToken.length <= 0) continue;
                        ByteArray cachekey = new ByteArray(ltpaToken);
                        AuthCache authCache = AuthCache.getInstance();
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Cache Key: " + cachekey);
                            }
                            authCache.removeEntry(cachekey);
                            continue;
                        }
                        catch (CacheException ce) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception caught while trying to remove a cache entry by using token: " + ce);
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Enumeration paramNames = req.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                Tr.debug(tc, "paramName:" + paramName);
                String[] paramValues = req.getParameterValues(paramName);
                if (paramValues.length == 1) {
                    String paramValue = paramValues[0];
                    if (paramValue.length() == 0) {
                        Tr.debug(tc, "paramValue:No Value");
                        continue;
                    }
                    Tr.debug(tc, "paramValue:" + paramValue);
                    continue;
                }
                for (int i = 0; i < paramValues.length; ++i) {
                    Tr.debug(tc, "paramValue:" + paramValues[i]);
                }
            }
        }
        String exitPage = req.getParameter("logoutExitPage");
        boolean logoutExitURLaccepted = false;
        try {
            Tr.debug(tc, "com.ibm.websphere.security.allowAnyLogoutExitPageHost is set to: " + SecurityObjectLocator.getSecurityConfig("security").getPropertyBool("com.ibm.websphere.security.allowAnyLogoutExitPageHost"));
            if (exitPage != null && !SecurityObjectLocator.getSecurityConfig("security").getPropertyBool("com.ibm.websphere.security.allowAnyLogoutExitPageHost") && !exitPage.equals("logon.jsp")) {
                logoutExitURLaccepted = this.verifyLogoutURL(req, exitPage);
                if (logoutExitURLaccepted) {
                    Tr.debug(tc, "after verifyLogoutURL, logoutExitPage is valid: " + exitPage);
                } else {
                    Tr.debug(tc, "after verifyLogoutURL, logoutExitPage is not valid: " + exitPage);
                }
            } else {
                logoutExitURLaccepted = true;
            }
        }
        catch (Throwable t) {
            Tr.debug(tc, "caught exception from calling: verifyLogoutURL: " + t.getMessage());
        }
        if (exitPage != null && exitPage.length() != 0 && logoutExitURLaccepted) {
            if (exitPage.startsWith("//")) {
                exitPage = exitPage.substring(1);
            }
            if (!WebContainerSystemProps.getSendRedirectCompatibilty()) {
                Tr.debug(tc, "Compatibility=false (default) redirect mode");
                if (this._absoluteUri && !this._adminConsole) {
                    if (exitPage.equals("/")) {
                        exitPage = "";
                    } else if (exitPage.startsWith("/")) {
                        exitPage = exitPage.substring(1);
                    }
                    Tr.debug(tc, "Logout exit page is not relative to Context Root.");
                } else if (exitPage.startsWith("/")) {
                    StringBuffer sb = new StringBuffer();
                    String contextPath = req.getContextPath();
                    if (contextPath != null && contextPath.endsWith("/")) {
                        int i = contextPath.lastIndexOf("/");
                        contextPath = contextPath.substring(0, i);
                    }
                    sb.append(contextPath);
                    sb.append(exitPage);
                    exitPage = sb.toString();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "logoutExitPage specified, redirecting to: " + exitPage);
            }
            res.sendRedirect(res.encodeURL(exitPage));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No logoutExitPage specified");
            }
            PrintWriter pw = res.getWriter();
            pw.println(DEFAULT_LOGOUT_MSG);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formLogout");
        }
    }

    private boolean verifyLogoutURL(HttpServletRequest req, String exitPage) {
        boolean acceptURL;
        block36: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "verifyLogoutURL", exitPage);
            }
            acceptURL = false;
            InetAddress thisHost = null;
            String logoutURLhost = null;
            try {
                String configuredDomainList = SecurityObjectLocator.getSecurityConfig("security").getProperty("com.ibm.websphere.security.logoutExitPageDomainList");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "List of configured domains for the logout exit page is: " + configuredDomainList);
                }
                String shortName = null;
                String ipAddress = null;
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "about to getLocalHost");
                }
                thisHost = InetAddress.getLocalHost();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "return from getLocalHost: " + thisHost);
                }
                shortName = thisHost.getHostName();
                ipAddress = thisHost.getHostAddress();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "short name of this host is: " + shortName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "ip address of this host is: " + ipAddress);
                }
                String hostFullName = shortName;
                if (ipAddress != null) {
                    hostFullName = InetAddress.getByName(ipAddress).getHostName();
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "this host full name is: " + hostFullName);
                    }
                }
                try {
                    URL logoutURL = new URL(exitPage);
                    logoutURLhost = logoutURL.getHost();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "domain for exitPage url: " + logoutURLhost);
                    }
                }
                catch (MalformedURLException mfmed) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught MalformedURLException getting url for exitPage: " + mfmed.getMessage());
                    }
                    acceptURL = true;
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught exception getting url for exitPage: " + e.getMessage());
                    }
                    acceptURL = false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "specified name of the host for the url redirect is: " + logoutURLhost);
                }
                String localHostIpAddress = "127.0.0.1";
                if (!acceptURL && logoutURLhost != null && (logoutURLhost.equalsIgnoreCase("localhost") || logoutURLhost.equals(localHostIpAddress) || hostFullName != null && logoutURLhost.equalsIgnoreCase(hostFullName) || shortName != null && logoutURLhost.equalsIgnoreCase(shortName) || ipAddress != null && logoutURLhost.equals(ipAddress))) {
                    acceptURL = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exitPage points to this host: all ok");
                    }
                } else if (!acceptURL && logoutURLhost != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exitPage points to another host: verify that it is one on the list of allowed domains.");
                    }
                    if (configuredDomainList != null && configuredDomainList.length() > 0) {
                        StringTokenizer st = new StringTokenizer(configuredDomainList, "|");
                        while (st.hasMoreTokens()) {
                            String nextDomain = st.nextToken();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "trying to match the domain for the exitPage : " + logoutURLhost + " to a domain name: " + nextDomain + " from the configured domain list");
                            }
                            if (!nextDomain.equalsIgnoreCase(logoutURLhost) && !nextDomain.equalsIgnoreCase(exitPage)) continue;
                            acceptURL = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "matched a configured logout exit page domain: " + nextDomain);
                            }
                            break;
                        }
                    }
                } else if (logoutURLhost == null) {
                    acceptURL = true;
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught an unknown exception: " + e.getMessage());
                }
                acceptURL = false;
            }
            if (!acceptURL) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "about to attempt matching the logout exit url with the domain of the request.");
                    }
                    StringBuffer requestURLString = req.getRequestURL();
                    URL requestURL = new URL(new String(requestURLString));
                    String requestURLhost = requestURL.getHost();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " host of the request url is: " + requestURLhost + " and the host of the logout URL is: " + logoutURLhost);
                    }
                    if (logoutURLhost != null && requestURLhost != null && logoutURLhost.equalsIgnoreCase(requestURLhost)) {
                        acceptURL = true;
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block36;
                    Tr.debug(tc, "caught Exception trying to form  request URL object: " + e.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyLogoutURL", acceptURL);
        }
        return acceptURL;
    }
}

