/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class FormLoginExtensionProcessor
extends WebExtensionProcessor {
    private String loginPage = null;
    private String loginErrorPage = null;
    private static TraceComponent tc = Tr.register(FormLoginExtensionProcessor.class, null, "com.ibm.ejs.resources.security");
    private WebAttributes webAttrs = null;
    private static final String providerName = "WebSphere";
    private static final String componentName = "WAS.security";
    private static AuditService auditService = null;
    private static String className;
    private ConcurrentHashMap auditOutcome = new ConcurrentHashMap();

    public FormLoginExtensionProcessor(IServletContext webapp) throws Exception {
        super(webapp);
        className = ((Object)((Object)this)).getClass().getName();
        try {
            WebAppConfig wac = webapp.getWebAppConfig();
            WebModuleMetaData wmmd = wac.getMetaData();
            SecurityMetaData securityMetaData = (SecurityMetaData)wmmd.getSecurityMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create WebAttributes for this webApp.");
            }
            if (securityMetaData != null) {
                this.webAttrs = securityMetaData.getWebAttributes();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In FormLoginExtensionProcessor(), security MetaData is null.");
            }
            this.loginPage = this.webAttrs.getLoginURL();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login page is: " + this.loginPage);
            }
            this.loginErrorPage = this.webAttrs.getReloginURL();
            if (this.loginErrorPage != null && !this.loginErrorPage.startsWith("/")) {
                this.loginErrorPage = "/" + this.loginErrorPage;
            }
            if (auditService == null) {
                auditService = ContextManagerFactory.getInstance().getAuditService();
            }
            if (auditService == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditService was not initialized");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login error page is: " + this.loginErrorPage);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.FormLoginServlet.init", "170", (Object)this);
            Tr.error(tc, "security.web.form.noWebAppInfo", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        block10: {
            if (!(req instanceof HttpServletRequest)) return;
            if (!(res instanceof HttpServletResponse)) return;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            boolean pushed = false;
            try {
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    String profileUUID = (String)((HttpServletRequest)req).getSession().getAttribute("iscSelectedProfileKey");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Pushing UUID during formLogin: " + profileUUID);
                    }
                    pushed = AdminContext.push(profileUUID);
                } else {
                    String appName = this.webAttrs.getWebAppName();
                    boolean isAdminApp = WSAccessManager.checkIfAdminApp(appName);
                    if (!isAdminApp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleRequest pushing user app name " + appName);
                        }
                        pushed = SecurityObjectLocator.pushAppContext(appName);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "handleRequest pushing admin app name " + appName);
                        }
                        pushed = SecurityObjectLocator.pushAdminContext(appName);
                    }
                }
                this.formLogin(request, response);
                Object var9_9 = null;
                if (!pushed) return;
                if (!SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) break block10;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!pushed) throw throwable;
                if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    AdminContext.pop();
                    throw throwable;
                }
                SecurityObjectLocator.popContext();
                throw throwable;
            }
            AdminContext.pop();
            return;
        }
        SecurityObjectLocator.popContext();
    }

    private void formLogin(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String storedReq;
        String username;
        String activeUserRegistry;
        String[] eventTrailIds;
        String lastTrailId;
        ContextHandler contextHandler;
        block89: {
            boolean success = false;
            WSCredential retCreds = null;
            Subject subject = null;
            contextHandler = null;
            lastTrailId = null;
            eventTrailIds = null;
            if (auditService != null) {
                lastTrailId = auditService.getLastTrailId();
                eventTrailIds = auditService.getEventTrailIds();
            }
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            Boolean compliance = security2.getPropertyBool("com.ibm.ws.security.web.logoutOnHTTPSessionExpire");
            boolean comp = compliance;
            if (req.getRequestedSessionId() != null && !req.isRequestedSessionIdValid() && comp) {
                req.getSession(true);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "formLogin, WebAttributes: \n" + this.webAttrs.toString());
            }
            String errorPage = null;
            if (this.loginErrorPage != null) {
                StringBuffer URL2 = HttpUtils.getRequestURL(req);
                String URLString = URL2.toString();
                String ctx = req.getContextPath();
                if (ctx.equals("/")) {
                    ctx = "";
                }
                int index = URLString.indexOf("//");
                index = URLString.indexOf("/", index + 2);
                int endindex = URLString.length();
                errorPage = ctx + this.loginErrorPage;
                URL2.replace(index, endindex, errorPage);
                errorPage = URL2.toString();
            }
            AuthMechanismConfig authMechanism = security2.getActiveAuthMechanism();
            String custom_jaas_config = security2.getProperty("com.ibm.ws.security.webInboundLoginConfig");
            boolean setCookie = false;
            boolean authMechCredForwardable = security2.getActiveAuthMechanism().getBoolean("isCredentialForwardable");
            activeUserRegistry = security2.getActiveUserRegistry().getType();
            boolean sso_enabled = false;
            if (authMechanism.getSingleSignon() != null) {
                sso_enabled = authMechanism.getSingleSignon().getBoolean("enabled");
            }
            if (authMechCredForwardable && !sso_enabled) {
                Tr.error(tc, "security.formlogin.badconfig", new Object[]{this.webAttrs.getWebAppName()});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configuration error.  SSO Not enabled when using FormLogin. Redirecting to error page: " + errorPage);
                }
                res.setStatus(401);
                res.sendRedirect(res.encodeURL(errorPage));
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    String msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 79L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
                return;
            }
            username = req.getParameter("j_username");
            String password = req.getParameter("j_password");
            if (username == null || password == null || password.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "username and/or password are not present");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Redirecting to error page: " + errorPage);
                }
                res.setStatus(401);
                res.sendRedirect(res.encodeURL(errorPage));
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    String msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                    HashMap data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", null, null, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 31L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Form based login: userid/password present in the form. User is: " + username);
            }
            HashMap<String, String> appContext = new HashMap<String, String>(2);
            try {
                String appName = this.webAttrs.getWebAppName();
                String realmName = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
                appContext.put("WebAppName", this.webAttrs.getWebAppName());
                appContext.put("RedirectURL", errorPage);
                final ContextManager ctxMgr = ContextManagerFactory.getInstance();
                final String _realm = realmName;
                final String _username = username;
                final String _password = password;
                final String _custom_jaas_config = custom_jaas_config;
                final HttpServletRequest _req = req;
                final HttpServletResponse _res = res;
                final HashMap<String, String> _appcontext = appContext;
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Subject subject = ctxMgr.login(_realm, _username, _password, _custom_jaas_config, _req, _res, _appcontext);
                        return subject;
                    }
                };
                String newErrorPage = null;
                try {
                    subject = (Subject)AccessController.doPrivileged(action);
                    if (subject != null) {
                        retCreds = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next();
                    }
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "422", (Object)this);
                    Tr.error(tc, "security.authn.error.foruser", new Object[]{username});
                    try {
                        newErrorPage = (String)appContext.get("RedirectURL");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Updating the error page to: " + newErrorPage);
                        }
                    }
                    catch (Throwable t) {
                        newErrorPage = null;
                        Tr.error(tc, "incorrect customized error page: ", new Object[]{t});
                    }
                    if (newErrorPage != null && newErrorPage.length() > 0) {
                        errorPage = newErrorPage;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redirecting to error page: " + errorPage);
                    }
                    res.setStatus(401);
                    res.sendRedirect(res.encodeURL(errorPage));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "webAttrs = " + this.webAttrs.toString());
                    }
                    if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msg = "security.audit.service.context.error";
                        auditService.processAuditFailure(msg, null);
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                        HashMap data = DataHelper.buildSessionData(req.getRequestedSessionId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", null, username, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), _realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "failure");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 15L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, pfe);
                        }
                    }
                    return;
                }
                try {
                    newErrorPage = (String)appContext.get("RedirectURL");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating the error page to: " + newErrorPage);
                    }
                }
                catch (Throwable t) {
                    newErrorPage = null;
                    Tr.error(tc, "incorrect customized error page: ", new Object[]{t});
                }
                if (newErrorPage != null && newErrorPage.length() > 0) {
                    errorPage = newErrorPage;
                }
                if (subject == null || retCreds == null) {
                    Tr.audit(tc, "security.authn.failed.foruser", new Object[]{username});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redirecting to error page: " + errorPage);
                    }
                    res.setStatus(401);
                    res.sendRedirect(res.encodeURL(errorPage));
                    if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                        Tr.error(tc, "security.audit.service.context.error");
                        String msg = "security.audit.service.context.error";
                        auditService.processAuditFailure(msg, null);
                    }
                    if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                        HashMap data = DataHelper.buildSessionData(req.getRequestedSessionId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", null, username, "denied", req.getMethod(), "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), _realm);
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildAuthnData("challengeResponse");
                        contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                        data = DataHelper.buildProviderData(providerName, "failure");
                        contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                        this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 15L);
                        try {
                            auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                        }
                        catch (ProviderFailureException pfe) {
                            Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                            String msg = "security.audit.service.sendevent.error";
                            auditService.processAuditFailure(msg, pfe);
                        }
                    }
                    return;
                }
                ctxMgr.setInvocationSubject(subject);
                ctxMgr.setCallerSubject(subject);
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    String msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
                    HashMap data = DataHelper.buildSessionData(req.getRequestedSessionId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", username, username, "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ctxMgr.getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "661", (Object)this);
                Tr.error(tc, "security.authn.error.foruser", new Object[]{username});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Redirecting to error page: " + errorPage);
                }
                res.setStatus(401);
                res.sendRedirect(res.encodeURL(errorPage));
                if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
                    Tr.error(tc, "security.audit.service.context.error");
                    String msg = "security.audit.service.context.error";
                    auditService.processAuditFailure(msg, null);
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "REDIRECT")) {
                    HashMap data = DataHelper.buildSessionData(req.getRequestedSessionId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", null, username, "authnRedirect", req.getMethod(), "web", new Long(0L), null, null, null, null);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildAuthnData("challengeResponse");
                    contextHandler.buildContextObject("AUTHN_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "failure");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "REDIRECT", 15L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
                    }
                    catch (ProviderFailureException pfe) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pfe});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, pfe);
                    }
                }
                return;
            }
            WebCollaborator.setPrivateAttributes(req, "AUTH_TYPE", "FORM");
            HttpSession session = null;
            FormLoginInfo info = null;
            if (authMechanism.getType().equals("SWAM")) {
                session = req.getSession(true);
                if (session != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Form based login: Store auth data in the HTTP Session");
                    }
                    if ((info = (FormLoginInfo)((IHttpSession)session).getSecurityInfo()) == null) {
                        info = new FormLoginInfo(username, password);
                    } else {
                        info.setUsername(username);
                        info.setPassword(password);
                    }
                    ((IHttpSession)session).putSecurityInfo((Object)info);
                }
                setCookie = false;
            } else {
                Object credentialToken = null;
                boolean isSecure = false;
                setCookie = false;
                boolean ssoEnabled = false;
                if (this.webAttrs.isSSOEnabled()) {
                    ssoEnabled = true;
                    if (this.webAttrs.isSecureSSO()) {
                        setCookie = req.getScheme().equalsIgnoreCase("https");
                        isSecure = true;
                    } else {
                        setCookie = true;
                    }
                }
                if (setCookie) {
                    try {
                        ArrayList cookieList = WebAttributes.createCookies(req, subject);
                        this.clearCookie(req, res);
                        if (cookieList != null) {
                            WebAttributes.addCookiesToResponse(cookieList, res);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "804", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Redirecting to error page: " + errorPage);
                        }
                        res.setStatus(401);
                        res.sendRedirect(res.encodeURL(errorPage));
                        return;
                    }
                }
            }
            storedReq = "";
            if (authMechanism.getType().equals("SWAM")) {
                storedReq = info.getRefererURL();
            } else {
                Cookie[] cookies = req.getCookies();
                storedReq = WebAuthenticator.getCookieValue(cookies, "WASReqURL");
                if (storedReq != null) {
                    String origStoredReq = storedReq;
                    storedReq = storedReq.replaceAll("%3B", ";");
                    if (origStoredReq != (storedReq = storedReq.replaceAll("%25", "%")) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "formLogin: changed input storedReq from " + origStoredReq + " to " + storedReq);
                    }
                    StringBuffer URL3 = HttpUtils.getRequestURL(req);
                    String URLString = URL3.toString();
                    if (!storedReq.startsWith("/") && storedReq.length() != 0) {
                        try {
                            URL storedReqURL = new URL(storedReq);
                            String originalHost = storedReqURL.getHost();
                            if (originalHost != null && originalHost.length() != 0) break block89;
                            URL currentURL = new URL(URLString);
                            String currentHost = currentURL.getHost();
                            int index = storedReq.indexOf("//");
                            if (index != -1) {
                                StringBuffer newURLBuf = new StringBuffer(storedReq);
                                newURLBuf.insert(index + 2, currentHost);
                                storedReq = newURLBuf.toString();
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WASReqURL is malformed. WASReqURL: " + storedReq);
                            }
                            break block89;
                        }
                        catch (MalformedURLException e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "556", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WASReqURL or requested URL is malformed. WASReqURL: " + storedReq + " RequestedURL: " + URLString);
                            }
                            break block89;
                        }
                    }
                    int index = URLString.indexOf("//");
                    index = URLString.indexOf("/", index + 2);
                    storedReq = URLString.substring(0, index) + storedReq;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successful auth - redirecting to the original URL" + storedReq);
        }
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN", "SUCCESS")) {
            HashMap data = DataHelper.buildSessionData(req.getRequestedSessionId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            data = DataHelper.buildAccessData(this.webAttrs.getWebAppName(), "formlogin", username, username, "authnSuccess", req.getMethod(), "web", new Long(0L), null, null, null, null);
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            data = DataHelper.buildAuthnData("challengeResponse");
            contextHandler.buildContextObject("AUTHN_CONTEXT", data);
            data = DataHelper.buildProviderData(providerName, "providerSuccess");
            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 5L);
            try {
                auditService.sendEvent("SECURITY_AUTHN", this.auditOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        if (storedReq != null) {
            if (storedReq.equals("/")) {
                storedReq = "";
            } else if (storedReq.startsWith("/")) {
                storedReq = storedReq.substring(1);
            }
        }
        if (storedReq == null) {
            storedReq = "";
        }
        res.sendRedirect(res.encodeURL(storedReq));
    }

    private Cookie createCookie(String name, String value, boolean isSecure) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie " + name + " " + value);
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        cookie.setSecure(isSecure);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie");
        }
        return cookie;
    }

    private void clearCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies;
        String storedReq;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCookie");
        }
        if ((storedReq = WebAuthenticator.getCookieValue(cookies = req.getCookies(), "WASReqURL")) != null && storedReq.length() > 0) {
            Cookie c = new Cookie("WASReqURL", "");
            c.setPath("/");
            c.setMaxAge(0);
            res.addCookie(c);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleared REFERER_URL cookie. Original value was " + storedReq);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCookie");
        }
    }
}

