/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ObjectDoesNotExistHere;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase;
import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityTaggedComponentAssistorImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SecurityExecutionEnvironment;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.HashMap;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class MultiDomainHelper {
    private static final TraceComponent tc = Tr.register(MultiDomainHelper.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static HashMap<String, ComponentData[]> taggedComponentMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getSecurityDomain(byte[] userKeyBytes, String class_name, Object target) {
        String myDomainName;
        byte[] domainName;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityDomain", new java.lang.Object[]{userKeyBytes, class_name, target});
            }
            domainName = null;
            myDomainName = null;
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            boolean globalSecEnabled = SecurityObjectLocator.getSecurityConfig().getBoolean("enabled");
            if (globalSecEnabled) {
                if (scm.isAdminAgent()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This process is an admin agent.");
                    }
                    if ((myDomainName = CSIServerRIBase.getManagedNodeUUID(target)) == null) {
                        myDomainName = (String)SecurityObjectLocator.getAdminData().peek();
                    }
                } else if (DomainInfo.isMultiDomainDefined()) {
                    if (MultiDomainHelper.isAdmin(userKeyBytes, class_name)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The userKey is tagged to be an admin IOR.");
                        }
                        myDomainName = scm.getDomainId();
                    } else if (MultiDomainHelper.isConfigDomainSpecific()) {
                        boolean pushed = SecurityObjectLocator.pushAppContext("");
                        try {
                            myDomainName = SecurityObjectLocator.getSecurityConfigManager().getDomainId();
                            java.lang.Object var9_8 = null;
                            if (!pushed) break block16;
                        }
                        catch (Throwable throwable) {
                            java.lang.Object var9_9 = null;
                            if (pushed) {
                                SecurityObjectLocator.popContext();
                            }
                            throw throwable;
                        }
                        SecurityObjectLocator.popContext();
                    }
                }
            }
        }
        if (myDomainName != null) {
            domainName = myDomainName.getBytes();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityDomain", new java.lang.Object[]{myDomainName, domainName});
        }
        return domainName;
    }

    public static boolean isAdmin(byte[] userKeyBytes, String class_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdmin", new java.lang.Object[]{userKeyBytes, class_name});
        }
        boolean isAdmin = false;
        java.lang.Object domainName = null;
        String OA_name = null;
        ContextManager ctxManager = null;
        if (userKeyBytes != null && class_name != null) {
            block13: {
                try {
                    if (userKeyBytes != null) {
                        block12: {
                            try {
                                ctxManager = ContextManagerFactory.getInstance();
                            }
                            catch (Exception e) {
                                if (!tc.isDebugEnabled()) break block12;
                                Tr.debug(tc, "exception getting ContextManager: " + e.getMessage());
                            }
                        }
                        if (ctxManager != null) {
                            OA_name = ctxManager.getObjectAdapterName(userKeyBytes);
                        }
                        break block13;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "null userKeyBytes");
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "exception trying to get the object adapter name: " + e.getMessage());
                }
            }
            if (!DomainInfo.isMultiDomainDefined() || MultiDomainHelper.isClassNameAdmin(class_name) || OA_name != null && OA_name.startsWith("JTS")) {
                isAdmin = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The userKey is tagged to be an admin IOR, classname: " + class_name + ", objectAdapterName: " + OA_name);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdmin", isAdmin);
        }
        return isAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConfigDomainSpecific() {
        boolean isCSIv2DomainSpecific;
        boolean isRealmDomainSepcific;
        boolean isAppSecDomainSpecific;
        boolean isConfigDomainSpecific;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isConfigDomainSpecific");
            }
            isConfigDomainSpecific = false;
            isAppSecDomainSpecific = false;
            isRealmDomainSepcific = false;
            isCSIv2DomainSpecific = false;
            boolean globalSecEnabled = SecurityObjectLocator.getSecurityConfig().getBoolean("enabled");
            if (globalSecEnabled) {
                boolean pushed = SecurityObjectLocator.pushAppContext("");
                try {
                    SecurityConfig sc = SecurityObjectLocator.getSecurityConfig("AppSecurity");
                    if (sc != null && sc.getBoolean("appEnabled")) {
                        if (sc.getActiveUserRegistry(false) != null) {
                            isRealmDomainSepcific = true;
                        }
                        if (sc.getCSIv2Config(false) != null) {
                            isCSIv2DomainSpecific = true;
                        }
                        if (sc.isSet("appEnabled")) {
                            isAppSecDomainSpecific = true;
                        }
                    }
                    java.lang.Object var8_7 = null;
                    if (!pushed) break block12;
                }
                catch (Throwable throwable) {
                    java.lang.Object var8_8 = null;
                    if (pushed) {
                        SecurityObjectLocator.popContext();
                    }
                    throw throwable;
                }
                SecurityObjectLocator.popContext();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isAppSecDomainSpecific: " + isAppSecDomainSpecific + ", isRealmDomainSepcific: " + isRealmDomainSepcific + ", isCSIv2DomainSpecific: " + isCSIv2DomainSpecific);
        }
        if (isAppSecDomainSpecific || isRealmDomainSepcific || isCSIv2DomainSpecific) {
            isConfigDomainSpecific = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConfigDomainSpecific", isConfigDomainSpecific);
        }
        return isConfigDomainSpecific;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interceptLocate(String domainName, Profile profile) throws Exception {
        boolean profileUpdated;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "interceptLocate", new java.lang.Object[]{domainName, profile});
            }
            profileUpdated = false;
            boolean pushed = false;
            boolean isAdmin = false;
            try {
                pushed = SecurityObjectLocator.getAdminData().push(domainName);
                if (domainName.equals("domain:admin") || domainName.equals("admin")) {
                    isAdmin = true;
                }
                if (!isAdmin && SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "interceptLocate setting admin=true in AdminAgent for profile " + domainName);
                    }
                    isAdmin = true;
                }
                ComponentData[] componentData = taggedComponentMap.get(domainName);
                try {
                    if (componentData == null) {
                        int i;
                        SecurityTaggedComponentAssistorImpl[] _assistorList = null;
                        ORB _orb = null;
                        VaultImpl _vault = null;
                        _vault = VaultImpl.getInstance();
                        if (_vault != null) {
                            _orb = _vault.getORB();
                        }
                        if ((i = 0) < (_assistorList = SecurityTaggedComponentAssistorImpl.create(_orb, _vault.getMechanismFactory(), _vault.getSecurityConnectionInterceptor())).length) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found local tagged component assistor... getting component data.");
                            }
                            componentData = _assistorList[i].getComponentData(profile, isAdmin, false);
                        }
                        taggedComponentMap.put(domainName, componentData);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got component data from the cache: " + componentData);
                    }
                    if (componentData != null) {
                        for (int i = 0; i < componentData.length; ++i) {
                            if (componentData[i] != null && componentData[i].componentBodyValue != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding tagged component ID: " + componentData[i].componentID);
                                }
                                profile.putTaggedComponent(componentData[i].componentID, componentData[i].componentBodyValue, true);
                                profileUpdated = true;
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Tagged component array had a null value and was not added to the IOR.");
                        }
                    }
                }
                catch (ObjectDoesNotExistHere e) {
                    Manager.Ffdc.log((Throwable)((java.lang.Object)e), MultiDomainHelper.class, "comISecurityLocalObjectBaseL13Impl.MultiDomainHelper.interceptLocate", "%C");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception adding tagged components to IOR.", (java.lang.Object)e);
                    }
                    throw e;
                }
                java.lang.Object var11_12 = null;
                if (!pushed) break block21;
                SecurityObjectLocator.getAdminData().pop();
            }
            catch (Throwable throwable) {
                java.lang.Object var11_13 = null;
                if (pushed) {
                    SecurityObjectLocator.getAdminData().pop();
                }
                throw throwable;
            }
            {
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "interceptLocate", profileUpdated);
        }
        return profileUpdated;
    }

    public static String getIORInfoDomain(ServerRequestInfo iorInfo, String class_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIORInfoDomain", new java.lang.Object[]{iorInfo, class_name});
        }
        String domain = null;
        String servant_class_name = "<unknown>";
        String OA_name = null;
        boolean implementsControlAdminService = false;
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            Class<?> controlAdminServiceClz = null;
            Class<?> rirProxyClz = null;
            try {
                controlAdminServiceClz = Class.forName("com.ibm.ws.management.ControlAdminService");
                rirProxyClz = Class.forName("com.ibm.ws390.orb.RIRProtectedProxyHandler");
            }
            catch (Throwable t) {
                // empty catch block
            }
            Object target = ((ExtendedServerRequestInfo)iorInfo).getTarget();
            Object servant = null;
            if (target != null && rirProxyClz != null && Proxy.isProxyClass(target.getClass())) {
                try {
                    Tie tie;
                    Remote tieTarget;
                    Method getServantMethod = rirProxyClz.getMethod("getServant", null);
                    servant = (Object)getServantMethod.invoke((java.lang.Object)Proxy.getInvocationHandler(target), (java.lang.Object[])null);
                    if (servant instanceof Tie && controlAdminServiceClz.isAssignableFrom((tieTarget = (tie = (Tie)servant).getTarget()).getClass())) {
                        implementsControlAdminService = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Tie target implements control admin service.");
                        }
                    }
                }
                catch (Throwable ex) {
                    Manager.Ffdc.log(ex, MultiDomainHelper.class, "com.ibm.ISecurityLocalObjectBaseL13Impl.MultiDomainHelper.getIORInfoDomain", "388", MultiDomainHelper.class);
                }
                servant_class_name = servant.getClass().getName();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "classname: " + class_name + ", servant classname: " + servant_class_name);
        }
        ObjectKey objectKey = new ObjectKey(iorInfo.object_id());
        byte[] userKeyBytes = null;
        if (objectKey != null) {
            try {
                userKeyBytes = iorInfo.object_id();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception is: " + e);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objectKey is null: cannot set thread local context;  object_id was " + new String(iorInfo.object_id()));
        }
        if (userKeyBytes != null) {
            OA_name = ContextManagerFactory.getInstance().getObjectAdapterName(userKeyBytes);
            if (!DomainInfo.isMultiDomainDefined() || MultiDomainHelper.isClassNameAdmin(class_name) || OA_name != null && OA_name.startsWith("JTS") || implementsControlAdminService) {
                domain = "admin";
            } else if (DomainInfo.isMultiDomainDefined()) {
                domain = "app";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIORInfoDomain", domain);
        }
        return domain;
    }

    public static boolean isClassNameAdmin(String class_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isClassNameAdmin", class_name);
        }
        boolean isAdmin = false;
        if (class_name != null && (class_name.startsWith("javax.management.remote.rmi") || class_name.startsWith("com.ibm.ws.management.connector.rmi") || class_name.startsWith("com.ibm.ws.naming") || PlatformHelperFactory.getPlatformHelper().isZOS() && (class_name.equals("com.ibm.ws390.management.connector.corba.CorbaConnectorImpl") || class_name.equals("com.ibm.ws390.management.connector.corba.CorbaConnectorImpl") || class_name.equals("com.ibm.WsnBootstrap._WsnNameServiceStub")))) {
            isAdmin = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isClassNameAdmin", isAdmin);
        }
        return isAdmin;
    }

    public static void releaseTaggedComponents() {
        String profile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseTaggedComponents");
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && (profile = SecurityExecutionEnvironment.peekAdminContext()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseTaggedComponents releasing tags for profile: " + profile);
            }
            taggedComponentMap.remove(profile);
        }
    }
}

