/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ObjectOutputInputUtil {
    private static final String NULL_SUFFIX = ":null";

    private static String appendNullSuffix(String tag) {
        return tag + NULL_SUFFIX;
    }

    public static void writeUTF(ObjectOutput out, String s, String tag) throws IOException {
        if (s == null) {
            tag = ObjectOutputInputUtil.appendNullSuffix(tag);
            out.writeUTF(tag);
        } else {
            out.writeUTF(tag);
            out.writeUTF(s);
        }
    }

    public static void writeObject(ObjectOutput out, Object obj, String tag) throws IOException {
        if (obj == null) {
            tag = ObjectOutputInputUtil.appendNullSuffix(tag);
            out.writeUTF(tag);
        } else {
            out.writeUTF(tag);
            out.writeObject(obj);
        }
    }

    public static void writeLong(ObjectOutput out, long obj, String tag) throws IOException {
        out.writeLong(obj);
    }

    public static void writeBoolean(ObjectOutput out, boolean obj, String tag) throws IOException {
        out.writeBoolean(obj);
    }

    public static void writeInt(ObjectOutput out, int obj, String tag) throws IOException {
        out.writeInt(obj);
    }

    public static String readUTF(ObjectInput in, String tag) throws IOException {
        String s = in.readUTF();
        s = s != null && s.equals(ObjectOutputInputUtil.appendNullSuffix(tag)) ? null : in.readUTF();
        return s;
    }

    public static Object readObject(ObjectInput in, String tag) throws ClassNotFoundException, IOException {
        String s = in.readUTF();
        if (s != null && s.equals(ObjectOutputInputUtil.appendNullSuffix(tag))) {
            return null;
        }
        return in.readObject();
    }

    public static long readLong(ObjectInput in, String tag) throws ClassNotFoundException, IOException {
        return in.readLong();
    }

    public static boolean readBoolean(ObjectInput in, String tag) throws ClassNotFoundException, IOException {
        return in.readBoolean();
    }

    public static int readInt(ObjectInput in, String tag) throws ClassNotFoundException, IOException {
        return in.readInt();
    }
}

