/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class WSKRBAuthnTokenFactoryFactory {
    private static KRBAuthnTokenFactory _tokenFactory = null;
    private static String WS_KRBAUTH_IMPL_CLASS = "com.ibm.ws.wssecurity.platform.websphere.token.KRBAuthnTokenFactoryImpl";
    private static String BASE_KRBAUTH_IMPL_CLASS = "com.ibm.ws.security.token.WSKRBAuthnTokenFactory";
    private static final TraceComponent tc = Tr.register(WSKRBAuthnTokenFactoryFactory.class, null, "com.ibm.ejs.resources.security");
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public static KRBAuthnTokenFactory getFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFactory");
        }
        if (_tokenFactory == null) {
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
            try {
                _tokenFactory = cl != null ? (KRBAuthnTokenFactory)cl.loadClass(WS_KRBAUTH_IMPL_CLASS).newInstance() : (KRBAuthnTokenFactory)Class.forName(WS_KRBAUTH_IMPL_CLASS).newInstance();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "load:" + WS_KRBAUTH_IMPL_CLASS);
                }
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    _tokenFactory = cl != null ? (KRBAuthnTokenFactory)cl.loadClass(BASE_KRBAUTH_IMPL_CLASS).newInstance() : (KRBAuthnTokenFactory)Class.forName(BASE_KRBAUTH_IMPL_CLASS).newInstance();
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "load: " + BASE_KRBAUTH_IMPL_CLASS);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFactory " + _tokenFactory);
        }
        return _tokenFactory;
    }
}

