/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class WSKRBAuthnTokenFactory
implements KRBAuthnTokenFactory {
    private static Class KRBAuthnTokenImplClass = null;
    private static Class[] createTokenFromBytesCtorArgsClass = new Class[]{byte[].class};
    private static Class[] createTokenFromMapCtorArgsClass = new Class[]{Map.class};
    private static Constructor createTokenFromBytesCtor = null;
    private static Constructor createTokenFromMapCtor = null;
    private static final TraceComponent tc = Tr.register(WSKRBAuthnTokenFactory.class, null, "com.ibm.ejs.resources.security");

    public KRBAuthnToken createToken(byte[] tokenBytes) {
        KRBAuthnToken token;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ceateToken(byte[])");
            }
            token = null;
            if (createTokenFromBytesCtor == null) {
                WSKRBAuthnTokenFactory.getCreateTokenFromBytesCtor();
            }
            if (createTokenFromBytesCtor != null) {
                Object[] tokenCtorArgs = new Object[]{tokenBytes};
                try {
                    token = (KRBAuthnToken)createTokenFromBytesCtor.newInstance(tokenCtorArgs);
                }
                catch (InstantiationException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createToken(byte[]) InstantiationException", e);
                    }
                    break block12;
                }
                catch (IllegalAccessException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createToken(byte[]) IllegalAccessException", e);
                    }
                    break block12;
                }
                catch (InvocationTargetException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createToken(byte[]) InvocationTargetException", e);
                    }
                    break block12;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createToken(byte[]) error creating token ctor object");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createToken(byte[])");
        }
        return token;
    }

    public KRBAuthnToken createToken(Map map) {
        KRBAuthnToken token;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createToken(Map)");
            }
            token = null;
            if (createTokenFromMapCtor == null) {
                WSKRBAuthnTokenFactory.getCreateTokenFromMapCtor();
            }
            if (createTokenFromMapCtor != null) {
                Object[] tokenCtorArgs = new Object[]{map};
                try {
                    token = (KRBAuthnToken)createTokenFromMapCtor.newInstance(tokenCtorArgs);
                }
                catch (InstantiationException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createToken(Map) InstantiationException", e);
                    }
                    break block12;
                }
                catch (IllegalAccessException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createToken(Map) IllegalAccessException", e);
                    }
                    break block12;
                }
                catch (InvocationTargetException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createToken(Map) InvocationTargetException", e);
                    }
                    break block12;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createToken(Map) error creating token ctor object");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createToken(Map)");
        }
        return token;
    }

    public boolean isKRBAuthnToken(byte[] tokenBytes) {
        try {
            KRBAuthnToken token = this.createToken(tokenBytes);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static synchronized void getCreateTokenFromBytesCtor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTokenFromBytesCtor");
        }
        if (createTokenFromBytesCtor == null) {
            if (KRBAuthnTokenImplClass == null) {
                WSKRBAuthnTokenFactory.getKRBAuthnTokenImplClass();
            }
            if (KRBAuthnTokenImplClass != null) {
                try {
                    createTokenFromBytesCtor = KRBAuthnTokenImplClass.getConstructor(createTokenFromBytesCtorArgsClass);
                }
                catch (NoSuchMethodException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getCreateTokenFromBytesCtor NoSuchMethodException", e);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCreateTokenFromBytesCtor error creating Class object");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTokenFromBytesCtor", createTokenFromBytesCtor);
        }
    }

    private static synchronized void getCreateTokenFromMapCtor() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTokenFromMapCtor");
        }
        if (createTokenFromMapCtor == null) {
            if (KRBAuthnTokenImplClass == null) {
                WSKRBAuthnTokenFactory.getKRBAuthnTokenImplClass();
            }
            if (KRBAuthnTokenImplClass != null) {
                try {
                    createTokenFromMapCtor = KRBAuthnTokenImplClass.getConstructor(createTokenFromMapCtorArgsClass);
                }
                catch (NoSuchMethodException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getCreateTokenFromMapCtor NoSuchMethodException", e);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCreateTokenFromMapCtor error creating Class object");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTokenFromMapCtor", createTokenFromMapCtor);
        }
    }

    private static synchronized void getKRBAuthnTokenImplClass() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getKRBAuthnTokenImplClass");
            }
            if (KRBAuthnTokenImplClass == null) {
                try {
                    KRBAuthnTokenImplClass = Class.forName("com.ibm.ws.security.token.KRBAuthnTokenImpl");
                }
                catch (ClassNotFoundException e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "getKRBAuthnTokenImplClass ClassNotFoundException", e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKRBAuthnTokenImplClass ", KRBAuthnTokenImplClass);
        }
    }
}

