/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.AuthenticationTokenImpl;
import com.ibm.ws.security.token.AuthorizationTokenImpl;
import com.ibm.ws.security.token.PropagationTokenImpl;
import com.ibm.ws.security.token.SingleSignonTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;

public class WSCredentialTokenMapper
implements WSCredentialTokenMapperInterface {
    private LTPAServerObject _ltpaServer;
    private SecurityConfig _security;
    private SecurityConfigManager _scm;
    private static WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private DistributedMap dm;
    private DistributedMap dmns;
    private MessageDigest md;
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private String JCEProvider;
    private static boolean propEnabled = true;
    private static boolean propEnabledChecked = false;
    private static final TraceComponent tc = Tr.register(WSCredentialTokenMapper.class, null, "com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final WebSphereRuntimePermission GET_OPAQUE_TOKEN_FROM_MBEAN = new WebSphereRuntimePermission("wssecurity.getOpaqueTokenFromMBean");

    public static WSCredentialTokenMapperInterface getInstance() {
        if (wsCredTokenMapper == null) {
            wsCredTokenMapper = new WSCredentialTokenMapper();
        }
        return wsCredTokenMapper;
    }

    public WSCredentialTokenMapper() {
        block4: {
            this._ltpaServer = null;
            this._security = null;
            this._scm = null;
            this.dm = null;
            this.dmns = null;
            this.md = null;
            this.JCEProvider = "IBMJCE";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSCredentialTokenMapper ctor");
            }
            this.JCEProvider = this.getJCEProvider();
            try {
                this.md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, this.JCEProvider);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.constructor", "180", this);
                Tr.debug(tc, "Exception creating WSCredentialTokenMapper", new Object[]{e});
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager == null) break block4;
                contextManager.setRootException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCredentialTokenMapper ctor");
        }
    }

    private DistributedMap getDM() {
        if (this.dm == null) {
            this.dm = DistributedMapFactory.getMap("WSSecureMap");
        }
        return this.dm;
    }

    private DistributedMap getDMNotShared() {
        if (this.dmns == null) {
            this.dmns = DistributedMapFactory.getMap("WSSecureMapNotShared");
        }
        return this.dmns;
    }

    public WSCredential createWSCredentialFromProperties(Hashtable customProperties) throws WSLoginFailedException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSCredentialFromProperties");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            sm.checkPermission(MAP_CREDENTIAL);
        }
        try {
            WSCredential regCredPriv;
            String accessId = null;
            String realm = null;
            String securityName = null;
            String longSecurityName = null;
            ArrayList<String> groupList = null;
            Hashtable otherPropertiesHashtable = null;
            boolean accessIdFound = false;
            boolean realmFound = false;
            boolean securityNameFound = false;
            boolean longSecurityNameFound = false;
            boolean groupsFound = false;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            Enumeration propertyNameEnum = customProperties.keys();
            while (propertyNameEnum != null && propertyNameEnum.hasMoreElements()) {
                Object value;
                String key = (String)propertyNameEnum.nextElement();
                if (key == null || (value = customProperties.get(key)) == null) continue;
                if (!accessIdFound && key.equals("com.ibm.wsspi.security.cred.uniqueId")) {
                    accessId = (String)value;
                    String userType = "user:";
                    if (!accessId.startsWith("user:") && !contextManager.isInternalServerId(accessId)) {
                        accessId = "user:" + accessId;
                    }
                    accessIdFound = true;
                    continue;
                }
                if (!realmFound && key.equals("com.ibm.wsspi.security.cred.realm")) {
                    realm = (String)value;
                    if (!realm.equalsIgnoreCase(contextManager.getDefaultRealm())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "realms did not match, but let's see if it's in my list of trusted outbound realms");
                        }
                        TrustedAuthenticationRealm outboundRealms = SecurityObjectLocator.getSecurityConfig().getOutboundTrustedAuthenticationRealm();
                        String realmList = outboundRealms.getRealmList();
                        boolean foundMatch = outboundRealms.getTrustAllRealms();
                        if (!foundMatch && realmList != null && !realmList.equals("")) {
                            StringTokenizer st = new StringTokenizer(realmList, "|");
                            while (st.hasMoreTokens() && !foundMatch) {
                                String aTrustedRealm = st.nextToken();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "realm: " + realm);
                                }
                                if (!realm.equalsIgnoreCase(aTrustedRealm)) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "target realm matches a trusted outbound realm: " + aTrustedRealm);
                                }
                                foundMatch = true;
                            }
                        }
                        if (!foundMatch) {
                            Tr.warning(tc, "security.sap.warning.realm.does.not.match.current.realm", new Object[]{realm, contextManager.getDefaultRealm()});
                        }
                    }
                    realmFound = true;
                    continue;
                }
                if (!securityNameFound && key.equals("com.ibm.wsspi.security.cred.securityName")) {
                    securityName = (String)value;
                    securityNameFound = true;
                    continue;
                }
                if (!longSecurityNameFound && key.equals("com.ibm.wsspi.security.cred.longSecurityName")) {
                    longSecurityName = (String)value;
                    longSecurityNameFound = true;
                    continue;
                }
                if (!groupsFound && key.equals("com.ibm.wsspi.security.cred.groups")) {
                    ArrayList oldGroupList = (ArrayList)value;
                    groupList = new ArrayList<String>();
                    groupList.addAll(oldGroupList);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Prepending \"group:\" to group list entries.");
                    }
                    for (int j = 0; j < groupList.size(); ++j) {
                        String old_group = (String)groupList.get(j);
                        String new_group = null;
                        String groupType = "group:";
                        if (old_group.startsWith("group:")) continue;
                        new_group = "group:" + contextManager.getDefaultRealm() + "/" + old_group;
                        groupList.set(j, new_group);
                    }
                    groupsFound = true;
                    continue;
                }
                if (key.equals("com.ibm.wsspi.security.cred.cacheKey")) {
                    if (value != null && value instanceof String && ((String)value).equals("")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Cache Key value is null string. Ignore it.");
                        continue;
                    }
                    if (otherPropertiesHashtable == null) {
                        otherPropertiesHashtable = new Hashtable();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting Cache Key in hashtable: " + value);
                    }
                    otherPropertiesHashtable.put(key, value);
                    continue;
                }
                if (otherPropertiesHashtable == null) {
                    otherPropertiesHashtable = new Hashtable();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting key in hashtable: " + key);
                }
                otherPropertiesHashtable.put(key, value);
            }
            WSCredential cred = null;
            if (longSecurityName == null || longSecurityName.length() == 0) {
                String accessIDWithoutUserType = accessId;
                if (accessId.startsWith("user:")) {
                    accessIDWithoutUserType = accessId.substring("user:".length());
                } else if (accessId.startsWith("server:")) {
                    accessIDWithoutUserType = accessId.substring("server:".length());
                }
                longSecurityName = RealmSecurityName.getSecurityName(accessIDWithoutUserType);
            }
            if (realm == null || realm.length() == 0) {
                realm = contextManager.getDefaultRealm();
            }
            if (longSecurityName == null || longSecurityName.length() == 0) {
                Tr.error(tc, "security.sap.error.longsecurityname.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.longSecurityName property.");
            }
            if (!accessIdFound) {
                Tr.error(tc, "security.sap.error.uniqueid.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.uniqueId property.");
            }
            if (!securityNameFound) {
                Tr.error(tc, "security.sap.error.securityname.not.found.in.hashtable");
                throw new WSLoginFailedException("Did not find value for com.ibm.wsspi.security.cred.securityName property.");
            }
            WSCredential reg_cred = null;
            final String accessIdPriv = accessId;
            final String realmPriv = realm;
            final String securityNamePriv = securityName;
            final String longSecurityNamePriv = longSecurityName;
            final ArrayList<String> groupListPriv = groupList;
            try {
                reg_cred = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(realmPriv, securityNamePriv, longSecurityNamePriv, "", accessIdPriv, null, groupListPriv);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "428", this);
                throw e.getException();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating auth mech cred.");
            }
            SecurityConfig security2 = this.getSecurityConfig();
            boolean ltpaSupported = security2.getActiveAuthMechanism().getBoolean("allowLPTAAuth");
            String activeAuthMech = this.getActiveAuthMechType();
            if (activeAuthMech.equals("LTPA") || activeAuthMech.equals("KRB5") && ltpaSupported) {
                regCredPriv = reg_cred;
                final LTPAServerObject ltpaServerPriv = this.getLTPAServerObject();
                try {
                    cred = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ltpaServerPriv.createLTPAToken(regCredPriv);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "454", this);
                    contextManager.setRootException(e.getException());
                    throw e.getException();
                }
            } else if (activeAuthMech.equals("SWAM")) {
                regCredPriv = reg_cred;
                try {
                    cred = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new WSCredentialImpl(regCredPriv, "No OID for this mechanism", RegistryUtil.nullByteArray, false, -1L);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "476", this);
                    contextManager.setRootException(e.getException());
                    throw e.getException();
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication mechanism not SWAM or LTPA.  Returning reg cred for auth mech: " + activeAuthMech);
                }
                cred = reg_cred;
            }
            if (cred != null && otherPropertiesHashtable != null) {
                Enumeration properties = otherPropertiesHashtable.keys();
                while (properties != null && properties.hasMoreElements()) {
                    Object value;
                    String key = (String)properties.nextElement();
                    if (key == null || (value = otherPropertiesHashtable.get(key)) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting key/value in hashtable of WSCred: " + key + ", " + value);
                    }
                    if (key.equals("com.ibm.wsspi.security.cred.cacheKey") && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cache Key Object: " + value.getClass().getName());
                    }
                    cred.set(key, value);
                }
            }
            if (contextManager.getPlatformHelper().isZOS() && cred != null && cred.get("com.ibm.ws.security.zos.PlatformCredential") == null) {
                SecurityConfig _security = SecurityObjectLocator.getSecurityConfig();
                Boolean isLocalOS = _security.getActiveUserRegistry().getType().equals("LOCALOS");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isLocalOS: " + isLocalOS);
                }
                if (isLocalOS != null && isLocalOS.booleanValue()) {
                    PlatformCredential pc = null;
                    pc = contextManager.isInternalServerCredential(cred) ? PlatformCredentialManager.instance().createServerCredential() : PlatformCredentialManager.instance().createCredential(securityName);
                    cred.set("com.ibm.ws.security.zos.PlatformCredential", pc);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            return cred;
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "537", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSCredentialFromProperties");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromProperties", "543", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public WSCredential createWSCredentialFromTokens(byte[] credToken, AuthorizationToken authzToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSCredentialFromTokens");
        }
        if (credToken == null || authzToken == null) {
            throw new WSLoginFailedException("Passed in null parameters.");
        }
        String accessId = null;
        long expiration = 0L;
        String realm = null;
        String securityName = null;
        String longSecurityName = null;
        String primaryGroupId = null;
        ArrayList<String> groups = null;
        String oid = null;
        boolean forwardable = true;
        WSCredential wsCred = null;
        try {
            Enumeration e = authzToken.getAttributeNames();
            while (e.hasMoreElements()) {
                String[] oidArray;
                String[] groupList;
                String[] primaryGroupIdArray;
                String[] longSecurityNameArray;
                String[] securityNameArray;
                String[] realmArray;
                String[] accessIdArray;
                String key = (String)e.nextElement();
                if ((accessId == null || accessId.length() == 0) && key.equals("com.ibm.wsspi.security.cred.uniqueId") && (accessIdArray = authzToken.getAttributes(key)) != null && accessIdArray.length > 0) {
                    accessId = accessIdArray[0];
                }
                expiration = authzToken.getExpiration();
                if ((realm == null || realm.length() == 0) && key.equals("com.ibm.wsspi.security.cred.realm") && (realmArray = authzToken.getAttributes(key)) != null && realmArray.length > 0) {
                    realm = realmArray[0];
                }
                if ((securityName == null || securityName.length() == 0) && key.equals("com.ibm.wsspi.security.cred.securityName") && (securityNameArray = authzToken.getAttributes(key)) != null && securityNameArray.length > 0) {
                    securityName = securityNameArray[0];
                }
                if ((longSecurityName == null || longSecurityName.length() == 0) && key.equals("com.ibm.wsspi.security.cred.longSecurityName") && (longSecurityNameArray = authzToken.getAttributes(key)) != null && longSecurityNameArray.length > 0) {
                    longSecurityName = longSecurityNameArray[0];
                }
                if ((primaryGroupId == null || primaryGroupId.length() == 0) && key.equals("com.ibm.wsspi.security.cred.primaryGroupId") && (primaryGroupIdArray = authzToken.getAttributes(key)) != null && primaryGroupIdArray.length > 0) {
                    primaryGroupId = primaryGroupIdArray[0];
                }
                if (groups == null && key.equals("com.ibm.wsspi.security.cred.groups") && (groupList = authzToken.getAttributes(key)) != null && groupList.length > 0) {
                    groups = new ArrayList<String>(groupList.length);
                    for (int i = 0; i < groupList.length; ++i) {
                        if (groupList[i] == null) continue;
                        groups.add(groupList[i]);
                    }
                }
                if ((oid == null || oid.length() == 0) && key.equals("com.ibm.wsspi.security.cred.oid") && (oidArray = authzToken.getAttributes(key)) != null && oidArray.length > 0) {
                    oid = oidArray[0];
                }
                if (!key.equals("com.ibm.wsspi.security.cred.forwardable")) continue;
                String[] f_string = authzToken.getAttributes(key);
                if (f_string != null && f_string.length > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Forwardable string = " + f_string[0]);
                    }
                    forwardable = Boolean.valueOf(f_string[0]);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Forwardable attribute null: com.ibm.wsspi.security.cred.forwardable");
            }
            if (accessId == null || accessId.length() == 0) {
                throw new WSLoginFailedException("Missing the ACCESSID attribute: com.ibm.wsspi.security.cred.uniqueId");
            }
            if (expiration == 0L) {
                throw new WSLoginFailedException("Missing the EXPIRATION attribute: com.ibm.wsspi.security.cred.expiration");
            }
            if (realm == null || realm.length() == 0) {
                throw new WSLoginFailedException("Missing the REALM attribute: com.ibm.wsspi.security.cred.realm");
            }
            if (securityName == null || securityName.length() == 0) {
                throw new WSLoginFailedException("Missing the SECURITYNAME attribute: com.ibm.wsspi.security.cred.securityName");
            }
            if (longSecurityName == null || longSecurityName.length() == 0) {
                throw new WSLoginFailedException("Missing the LONGSECURITYNAME attribute: com.ibm.wsspi.security.cred.longSecurityName");
            }
            if (groups == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "There are no groups defined for user: " + securityName);
            }
            if ((primaryGroupId == null || primaryGroupId.length() == 0) && tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no primary group defined for user: " + securityName);
            }
            if (oid == null || oid.length() == 0) {
                throw new WSLoginFailedException("Missing the OID attribute: com.ibm.wsspi.security.cred.oid");
            }
            WSCredential cred = null;
            final String accessIdPriv = accessId;
            SecurityConfig security2 = this.getSecurityConfig();
            boolean ltpaSupported = security2.getActiveAuthMechanism().getBoolean("allowLPTAAuth");
            if ("oid:1.2.840.113554.1.2.2".endsWith(oid) && ltpaSupported) {
                com.ibm.wsspi.security.ltpa.Token ltpaToken = null;
                final String factory = security2.getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating ltpa auth token using factory " + factory + " for caller: " + securityName);
                }
                try {
                    final LTPAServerObject ltpaServerPriv = this.getLTPAServerObject();
                    ltpaToken = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ltpaServerPriv.createLTPAToken(accessIdPriv, factory);
                        }
                    });
                }
                catch (PrivilegedActionException e2) {
                    FFDCFilter.processException((Throwable)e2.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "706", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createSSOTokenFromWSCredential", new Object[]{e2.getException()});
                    }
                    throw e2.getException();
                }
                credToken = ltpaToken.getBytes();
            }
            final byte[] credTokenPriv = credToken;
            final String realmPriv = realm;
            final String securityNamePriv = securityName;
            final String longSecurityNamePriv = longSecurityName;
            final String primaryGroupIdPriv = primaryGroupId;
            final ArrayList<String> groupsPriv = groups;
            final String oidPriv = oid;
            final long expirationPriv = expiration;
            final boolean forwardablePriv = forwardable;
            try {
                cred = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(realmPriv, securityNamePriv, longSecurityNamePriv, primaryGroupIdPriv != null ? primaryGroupIdPriv : RegistryUtil.nullString, accessIdPriv, null, groupsPriv);
                    }
                });
            }
            catch (PrivilegedActionException e3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e3.getException()});
                }
                FFDCFilter.processException((Throwable)e3, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "743", this);
                throw e3.getException();
            }
            final WSCredential credPriv = cred;
            try {
                wsCred = (WSCredential)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(credPriv, oidPriv, credTokenPriv, forwardablePriv, expirationPriv);
                    }
                });
            }
            catch (PrivilegedActionException e4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e4.getException()});
                }
                FFDCFilter.processException((Throwable)e4, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "762", this);
                throw e4.getException();
            }
            if (wsCred == null) {
                throw new WSLoginFailedException("WSCredential is null.");
            }
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{e.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSLoginFailedException occurred creating new WS cred from SAP tokens.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "774", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.credential.not.mapped", new Object[]{e.toString()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS cred from SAP tokens.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createWSCredentialFromTokens", "780", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append("WSCredential created with the following values: \n");
        sb.append("\trealm = ");
        sb.append(realm);
        sb.append("\n\tsecurityName = ");
        sb.append(securityName);
        sb.append("\n\tlongSecurityName = ");
        sb.append(longSecurityName);
        sb.append("\n\taccessId = ");
        sb.append(accessId);
        sb.append("\n\tGroup count = ");
        sb.append(groups != null ? String.valueOf(groups.size()) : "0");
        sb.append("\n\toid = ");
        sb.append(oid);
        sb.append("\n\texpiration = ");
        sb.append(expiration);
        sb.append("\n\tforwardable = ");
        sb.append(forwardable);
        sb.append("\n");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sb.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSCredentialFromTokens");
        }
        return wsCred;
    }

    public AuthenticationToken createAuthTokenFromWSCredential(WSCredential wsCred) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthTokenFromWSCredential", wsCred);
        }
        byte[] token = null;
        SecurityConfig security2 = this.getSecurityConfig();
        boolean ltpaSupported = security2.getActiveAuthMechanism().getBoolean("allowLPTAAuth");
        if (!ltpaSupported) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential (null), ltpa not supported.");
            }
            return null;
        }
        try {
            com.ibm.wsspi.security.ltpa.Token tokenObject;
            AuthenticationTokenImpl authToken;
            block16: {
                authToken = new AuthenticationTokenImpl();
                tokenObject = null;
                try {
                    tokenObject = ((WSCredentialImpl)wsCred).getTokenObject();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Error getting the token Object from WSCredential.", new Object[]{e});
                }
            }
            if (tokenObject != null) {
                authToken.initializeToken("oid:1.3.18.0.2.30.2", tokenObject);
            } else {
                token = wsCred.getCredentialToken();
                if (token != null) {
                    authToken.initializeToken((Subject)null, "oid:1.3.18.0.2.30.2", token);
                }
            }
            if (token == null && tokenObject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuthTokenFromWSCredential (null), no ltpa token in WSCredential.");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential", authToken);
            }
            return authToken;
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.authentication.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthTokenFromWSCredential", "868", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.authentication.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthTokenFromWSCredential", "874", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public SingleSignonToken createSSOTokenFromWSCredential(final WSCredential wsCred) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSSOTokenFromWSCredential", wsCred);
        }
        com.ibm.wsspi.security.ltpa.Token ssoLTPAToken = null;
        SecurityConfig security2 = this.getSecurityConfig();
        try {
            final String factory = security2.getProperty("com.ibm.wsspi.security.token.singleSignonTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating sso token using factory " + factory + " for caller: " + wsCred.getSecurityName());
            }
            try {
                final LTPAServerObject ltpaServerPriv = this.getLTPAServerObject();
                ssoLTPAToken = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ltpaServerPriv.createLTPAToken(wsCred.getAccessId(), factory);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "913", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSSOTokenFromWSCredential", new Object[]{e.getException()});
                }
                throw e.getException();
            }
            SingleSignonTokenImpl ssoToken = new SingleSignonTokenImpl();
            ssoToken.initializeToken(ssoLTPAToken);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenFromWSCredential", ssoToken);
            }
            return ssoToken;
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.single.signon.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenFromWSCredential", "926", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.single.signon.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenFromWSCredential", "932", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public SingleSignonToken createSSOTokenAndSetAttributes(WSCredential cred, boolean kerberosTokenExists) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSSOTokenAndSetAttributes", new Object[]{cred, kerberosTokenExists});
        }
        try {
            SingleSignonToken ssoToken;
            block27: {
                SecurityConfig security2 = this.getSecurityConfig();
                ssoToken = this.createSSOTokenFromWSCredential(cred);
                AuthMechanismConfig amc = SecurityObjectLocator.getSecurityConfig(null).getActiveAuthMechanism();
                if (WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled() || amc.getType().equals("KRB5")) {
                    String processType = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.processType");
                    if (processType != null && (processType.equals("ManagedProcess") || processType.equals("UnManagedProcess"))) {
                        String serverName = SecurityObjectLocator.getAdminData().getString("process.serverName");
                        if (serverName != null) {
                            ssoToken.addAttribute("process.serverName", serverName);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot add serverName to SSO token, config property is null.");
                        }
                        ssoToken.addAttribute("security.authMechOID", security2.getActiveAuthMechanism().getString("OID"));
                        Properties connectorProps = (Properties)security2.getObject("process.jmxConnectorProps");
                        if (connectorProps != null) {
                            ssoToken.addAttribute("java.naming.provider.url", (String)connectorProps.get("java.naming.provider.url"));
                            ssoToken.addAttribute("type", (String)connectorProps.get("type"));
                            ssoToken.addAttribute("host", (String)connectorProps.get("host"));
                            ssoToken.addAttribute("port", (String)connectorProps.get("port"));
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot add connectorProps to SSO token, config property is null.");
                        }
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        if (contextManager.getPlatformHelper().isZOS()) {
                            String servantIdentifier = PlatformHelperFactory.getPlatformHelper().getServantToken();
                            if (servantIdentifier != null) {
                                ssoToken.addAttribute("com.ibm.websphere.zOS.ServantIdentifier", servantIdentifier);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "servantIdentifier added to common constants: " + servantIdentifier);
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Cannot add servantIdentifier to common constants because it is null.");
                            }
                        }
                        if (kerberosTokenExists) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "kerberosToken exists, mark SSO token");
                            }
                            ssoToken.addAttribute("krb5_exists", "true");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not adding connector properties to SSO token, process type: " + processType);
                    }
                }
                if (cred != null) {
                    try {
                        long expiration = cred.getExpiration();
                        if (expiration > 0L) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Expiration set to: " + Long.toString(expiration));
                            }
                            ssoToken.addAttribute("expire", Long.toString(expiration));
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "Exception getting expiration.", new Object[]{e.toString()});
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenAndSetAttributes", ssoToken);
            }
            return ssoToken;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.single.signon.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSSOTokenAndSetAttributes");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createSSOTokenAndSetAttributes", "1035", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public AuthorizationToken createAuthzTokenFromWSCredential(final WSCredential wsCred) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAuthzTokenFromWSCredential", wsCred);
        }
        com.ibm.wsspi.security.ltpa.Token ltpaAuthorizationToken = null;
        SecurityConfig security2 = this.getSecurityConfig();
        try {
            ArrayList groups;
            final String factory = security2.getProperty("com.ibm.wsspi.security.token.authorizationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating authorization token using factory " + factory + " for caller: " + wsCred.getSecurityName());
            }
            try {
                final LTPAServerObject ltpaServerPriv = this.getLTPAServerObject();
                ltpaAuthorizationToken = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ltpaServerPriv.createLTPAToken(wsCred.getAccessId(), factory);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "1073", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createAuthzTokenFromWSCredential", new Object[]{e.getException()});
                }
                throw e.getException();
            }
            ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.uniqueId", wsCred.getAccessId());
            ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.realm", wsCred.getRealmName());
            ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.securityName", wsCred.getSecurityName());
            ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.longSecurityName", wsCred.getUniqueSecurityName());
            ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.primaryGroupId", wsCred.getPrimaryGroupId());
            Object cacheKey = wsCred.get("com.ibm.wsspi.security.cred.cacheKey");
            if (cacheKey != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting cache key in Authz token: " + cacheKey.toString());
                }
                ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.cacheKey", cacheKey.toString());
            }
            if ((groups = wsCred.getGroupIds()) != null) {
                for (int i = 0; i < groups.size(); ++i) {
                    String group = (String)groups.get(i);
                    ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.groups", group);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting group list: " + groups);
                }
            }
            if (wsCred.getOID() != null) {
                ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.expiration", String.valueOf(wsCred.getExpiration()));
                ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.oid", wsCred.getOID());
                boolean f_boolean = wsCred.isForwardable();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Forwardable string set as: " + f_boolean);
                }
                ltpaAuthorizationToken.addAttribute("com.ibm.wsspi.security.cred.forwardable", String.valueOf(f_boolean));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OID is null, deferring adding mechanism attributes to Kerberos commit().");
            }
            AuthorizationTokenImpl authzToken = new AuthorizationTokenImpl();
            authzToken.initializeToken(ltpaAuthorizationToken);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthzTokenFromWSCredential", authzToken);
            }
            return authzToken;
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.authorization.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthzTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "1132", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.authorization.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAuthzTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createAuthzTokenFromWSCredential", "1138", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public PropagationToken createPropagationTokenFromWSCredential(final WSCredential wsCred) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPropagationTokenFromWSCredential", wsCred);
        }
        SecurityConfig security2 = this.getSecurityConfig();
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            String originalHost = contextManager.getProperty("com.ibm.CSI.CellNodeServer");
            String originalCaller = originalHost + ":" + wsCred.getRealmSecurityName();
            final String factory = security2.getProperty("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating propagation token using factory " + factory + " for caller: " + originalCaller + ", host: " + originalHost);
            }
            com.ibm.wsspi.security.ltpa.Token ltpaToken = null;
            try {
                final LTPAServerObject ltpaServerPriv = this.getLTPAServerObject();
                ltpaToken = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ltpaServerPriv.createLTPAToken(wsCred.getAccessId(), factory);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", "1181", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPropagationTokenFromWSCredential", new Object[]{e.getException()});
                }
                throw e.getException();
            }
            ltpaToken.addAttribute("com.ibm.wsspi.security.propagation.callers", originalCaller);
            ltpaToken.addAttribute("com.ibm.wsspi.security.propagation.hosts", originalHost);
            PropagationTokenImpl propagationToken = new PropagationTokenImpl();
            propagationToken.initializeToken(ltpaToken);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenFromWSCredential", propagationToken);
            }
            return propagationToken;
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", "1200", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenFromWSCredential");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenFromWSCredential", "1206", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public ArrayList getForwardablePropagationTokensFromContext() throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getForwardablePropagationTokensFromContext");
        }
        try {
            ArrayList<TokenHolder> tokenList = new ArrayList<TokenHolder>();
            ContextManager contextManager = ContextManagerFactory.getInstance();
            Map propagationTokens = contextManager.getPropagationTokens();
            if (propagationTokens == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No propagation token present on the thread.");
                }
                return null;
            }
            for (PropagationToken token : propagationTokens.values()) {
                if (token == null || !token.isForwardable()) continue;
                long currentTime = System.currentTimeMillis();
                long expiration = token.getExpiration();
                long timeleft = expiration - currentTime - 300000L;
                if (timeleft < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Propagation token with name " + token.getName() + " is expired.  Refreshing propagation token.");
                    }
                    token = (PropagationToken)token.clone();
                }
                if (token == null) continue;
                final PropagationToken fToken = token;
                byte[] tokenBytes = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fToken.getBytes();
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding propagation token, name: " + token.getName());
                }
                tokenList.add(new TokenHolder(tokenBytes, token.getName(), token.getVersion()));
            }
            if (tokenList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagation token list is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getForwardablePropagationTokensFromContext");
            }
            return tokenList;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getForwardablePropagationTokensFromContext", "1285", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting forwardable propagation tokens.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getForwardablePropagationTokensFromContext");
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public PropagationToken createPropagationTokenBeforeAuthenticatedCallerSet() throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
        }
        SecurityConfig security2 = this.getSecurityConfig();
        try {
            final ContextManager contextManager = ContextManagerFactory.getInstance();
            String originalHost = contextManager.getProperty("com.ibm.CSI.CellNodeServer");
            final String factory = security2.getProperty("com.ibm.wsspi.security.token.propagationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating propagation token using factory " + factory + " for host: " + originalHost);
            }
            com.ibm.wsspi.security.ltpa.Token ltpaToken = null;
            try {
                final LTPAServerObject ltpaServerPriv = this.getLTPAServerObject();
                ltpaToken = (com.ibm.wsspi.security.ltpa.Token)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ltpaServerPriv.createLTPAToken("user:" + contextManager.getUnauthenticatedString(), factory);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1317", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPropagationTokenFromWSCredential", new Object[]{e.getException()});
                }
                throw e.getException();
            }
            if (ltpaToken != null) {
                ltpaToken.addAttribute("com.ibm.wsspi.security.propagation.hosts", originalHost);
                PropagationTokenImpl propagationToken = new PropagationTokenImpl();
                propagationToken.initializeToken(ltpaToken);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
                }
                return propagationToken;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet returns null.");
            }
            return null;
        }
        catch (WSLoginFailedException e) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1340", this);
            throw e;
        }
        catch (Exception e) {
            Tr.error(tc, "security.sap.error.propagation.token.not.mapped", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createPropagationTokenBeforeAuthenticatedCallerSet");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1346", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public com.ibm.wsspi.security.ltpa.Token validateLTPAToken(byte[] token) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateLTPAToken");
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            return this.getLTPAServerObject().validateToken(token);
        }
        catch (NullPointerException e) {
            Tr.error(tc, "security.sap.error.ltapserver.null", new Object[]{e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1363", this);
            throw e;
        }
        catch (WSLoginFailedException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred validating LTPA token.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1369", this);
            throw e;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred validating LTPA token.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateLTPAToken");
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createPropagationTokenBeforeAuthenticatedCallerSet", "1375", this);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
    }

    public byte[] getOpaqueTokenFromMBean(ByteArray ssoToken, String serverName, Properties connectorProps) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpaqueTokenFromMBean", new Object[]{serverName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_OPAQUE_TOKEN_FROM_MBEAN.toString());
            }
            sm.checkPermission(GET_OPAQUE_TOKEN_FROM_MBEAN);
        }
        byte[] token = null;
        try {
            GetOpaqueTokenFromMBeanAction getTokenAction = new GetOpaqueTokenFromMBeanAction(ssoToken, serverName, connectorProps);
            token = (byte[])ContextManagerFactory.getInstance().runAsSystem(getTokenAction);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting opaque token.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getOpaqueTokenFromMBean", "1404", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpaqueTokenFromMBean -> " + (token != null));
        }
        return token;
    }

    public byte[] getInitialContextTokenFromMBean(ByteArray ssoToken, String serverName, Properties connectorProps) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialContextTokenFromMBean", new Object[]{serverName, connectorProps});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_OPAQUE_TOKEN_FROM_MBEAN.toString());
            }
            sm.checkPermission(GET_OPAQUE_TOKEN_FROM_MBEAN);
        }
        AdminClient adminClient = null;
        String cellName = null;
        String nodeName = null;
        String processName = null;
        ObjectName securityAdmin = null;
        try {
            ObjectName queryString;
            Set s;
            SecurityConfig security2 = this.getSecurityConfig();
            Properties props = (Properties)security2.getObject("process.jmxConnectorProps");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInitialContextTokenFromMBean got initial jmx props:", props);
            }
            boolean setSecurityEnabledProp = true;
            Enumeration<?> vEnum = props.propertyNames();
            while (vEnum.hasMoreElements()) {
                String name = (String)vEnum.nextElement();
                String value = (String)props.get(name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInitialContextTokenFromMBean found " + (name == null ? "null" : name) + " property with value " + (value == null ? "null" : value) + " in jmx connector props");
                }
                if (name == null || value == null || value.length() <= 0) continue;
                if (!(name.equals("type") || name.equals("host") || name.equals("port"))) {
                    connectorProps.setProperty(name, value);
                }
                if (!name.equals("securityEnabled")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInitialContextTokenFromMBean found securityEnabled");
                }
                setSecurityEnabledProp = false;
            }
            if (setSecurityEnabledProp && SecurityContext.isSecurityEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInitialContextTokenFromMBean adding property securityEnabled");
                }
                connectorProps.setProperty("securityEnabled", "true");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInitialContextTokenFromMBean creating admin client with props:", connectorProps);
            }
            adminClient = AdminClientFactory.createAdminClient(connectorProps);
            StringTokenizer st = new StringTokenizer(serverName, ":");
            if (st != null) {
                cellName = st.nextToken();
                nodeName = st.nextToken();
                processName = st.nextToken();
            }
            String targetSpnNameWithRealm = null;
            if (OID.compareOIDs(this.getSecurityConfig().getActiveAuthMechanism().getString("OID"), "oid:1.2.840.113554.1.2.2")) {
                String targetServer = SecurityObjectLocator.getAdminData().getString("process.hostName");
                String targetSpnName = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Spn");
                String targetRealmName = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "targetServer: " + targetServer);
                    Tr.debug(tc, "targetSpnName: " + targetSpnName);
                    Tr.debug(tc, "targetRealmName: " + targetRealmName);
                }
                targetSpnNameWithRealm = targetSpnName + "@" + targetRealmName;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target active authentication is not Kerberos");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "targetSpnNameWithRealm: " + targetSpnNameWithRealm);
            }
            if ((s = adminClient.queryNames(queryString = new ObjectName("WebSphere:type=SecurityAdmin,cell=" + cellName + ",node=" + nodeName + ",process=" + processName + ",*"), null)).isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInitialContextTokenFromMBean: SecurityAdmin MBean was not found using queryString " + queryString);
                }
                return null;
            }
            securityAdmin = (ObjectName)s.iterator().next();
            TokenHolder th = (TokenHolder)adminClient.invoke(securityAdmin, "getInitialContextToken", new Object[]{ssoToken, targetSpnNameWithRealm}, new String[]{"com.ibm.ws.security.util.ByteArray", "java.lang.String"});
            if (th != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning InitialContext token from MBean.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getInitialContextTokenFromMBean");
                }
                return th.getBytes();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null InitialContext token.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextTokenFromMBean");
            }
            return null;
        }
        catch (MalformedObjectNameException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getInitialContextTokenFromMBean", "1615", this);
        }
        catch (InstanceNotFoundException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getInitialContextTokenFromMBean", "1619", this);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred getting admin client connection.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getInitialContextTokenFromMBean", "1623", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialContextTokenFromMBean");
        }
        return null;
    }

    public Object getDistributedObject(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributedObject: " + key);
        }
        if (this._scm == null) {
            this._scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (this._scm == null || !this._scm.isAdminAgent()) {
            try {
                DistributedMap map = this.getDM();
                if (map != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDistributedObject");
                    }
                    return map.get(key);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDistributedObject returns null.");
                }
                return null;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting distributed object.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getDistributedObject", "1653", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedObject (null)");
        }
        return null;
    }

    public Object getDistributedObjectNotShared(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributedObjectNotShared: " + key);
        }
        if (this._scm == null) {
            this._scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (this._scm == null || !this._scm.isAdminAgent()) {
            try {
                DistributedMap map = this.getDMNotShared();
                if (map != null) {
                    Object dist_object = map.get(key);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDistributedObjectNotShared " + (dist_object != null ? "(not null)" : "(null)"));
                    }
                    return dist_object;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDistributedObjectNotShared returns null.");
                }
                return null;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting distributed object not shared.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.getDistributedObjectNotShared", "1687", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributedObjectNotShared (null)");
        }
        return null;
    }

    public Object putDistributedObjectNotShared(Object key, Object value, int timeToLive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putDistributedObjectNotShared: " + key);
        }
        if (this._scm == null) {
            this._scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (this._scm == null || !this._scm.isAdminAgent()) {
            try {
                DistributedMap map = this.getDMNotShared();
                if (map != null) {
                    Object dist_object = map.put(key, value, 1, timeToLive, 1, null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "putDistributedObjectNotShared " + (dist_object != null ? "(not null)" : "(null)"));
                    }
                    return dist_object;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "putDistributedObjectNotShared returns null.");
                }
                return null;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred putting distributed object not shared.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObjectNotShared", "1721", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putDistributedObjectNotShared (null)");
        }
        return null;
    }

    public Object putDistributedObject(Object key, Object value, int timeToLive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putDistributedObject: ", new Object[]{key, value, timeToLive});
        }
        if (this._scm == null) {
            this._scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (this._scm == null || !this._scm.isAdminAgent()) {
            try {
                DistributedMap map = this.getDM();
                if (map != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "putDistributedObject");
                    }
                    return map.put(key, value, 1, timeToLive, 2, null);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "putDistributedObject returns null.");
                }
                return null;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred putting distributed object.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObject", "1772", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putDistributedObject (null)");
        }
        return null;
    }

    public Object putDistributedObject(Object key, Object value, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putDistributedObject: ", new Object[]{key, new Integer(priority), new Integer(timeToLive), new Integer(sharingPolicy), dependencyIds});
        }
        if (this._scm == null) {
            this._scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (this._scm == null || !this._scm.isAdminAgent()) {
            try {
                DistributedMap map = this.getDM();
                if (map != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "putDistributedObject");
                    }
                    return map.put(key, value, priority, timeToLive, sharingPolicy, dependencyIds);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "putDistributedObject returns null.");
                }
                return null;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred putting distributed object.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.putDistributedObject", "1831", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putDistributedObject (null)");
        }
        return null;
    }

    public void invalidateDistributedObject(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateDistributedObject: ", new Object[]{key});
        }
        try {
            DistributedMap map = this.getDM();
            if (map != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "invalidateDistributedObject");
                }
                map.invalidate(key);
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invalidateDistributedObject returns null.");
            }
            return;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred invalidating distributed object.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.invalidateDistributedObject", "1858", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invalidateDistributedObject");
            }
            return;
        }
    }

    public String createSubjectUniqueID(final Subject subject) {
        String uniqueID;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createSubjectUniqueID", subject);
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Subject is null.");
                }
                return null;
            }
            uniqueID = null;
            try {
                uniqueID = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Object cacheKey;
                        TreeSet<String> uniqueTreeSet = new TreeSet<String>();
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Getting cacheKeyFromHashtable");
                        }
                        if ((cacheKey = WSCredentialTokenMapper.this.getCacheKeyFromHashtable(subject)) != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "Found cacheKeyFromHashtable");
                            }
                            if (cacheKey instanceof String) {
                                uniqueTreeSet.add((String)cacheKey);
                            } else {
                                uniqueTreeSet.add(cacheKey.toString());
                            }
                        } else if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "Did not find cacheKeyFromHashtable");
                        }
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            Set<Token> publicCredentials;
                            Set<Token> privateCredentials = subject.getPrivateCredentials(Token.class);
                            if (privateCredentials != null && privateCredentials.size() > 0) {
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Got some private credentials to iterate through.");
                                }
                                for (Token token : privateCredentials) {
                                    String principal;
                                    String id;
                                    if (token != null && token instanceof KRBAuthnToken) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.debug(tc, "Getting uniqueID from KRBAuthToken.");
                                        }
                                        id = null;
                                        principal = ((KRBAuthnToken)((Object)token)).getTokenPrincipal() + "@" + ((KRBAuthnToken)((Object)token)).getTokenRealm();
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "KRBAuthnToken found, ID/Principal: ", new Object[]{id, principal});
                                        }
                                        if (id == null || id.length() <= 0) continue;
                                        if (principal != null && principal.length() > 0 && uniqueTreeSet.size() == 0) {
                                            uniqueTreeSet.add(principal);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Unique string updated with principal: " + principal);
                                            }
                                        }
                                        uniqueTreeSet.add(id);
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "Unique string updated with custom uniqueID: " + id);
                                        continue;
                                    }
                                    if (token == null || !(token instanceof Token)) continue;
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "Getting uniqueID from token.");
                                    }
                                    id = token.getUniqueID();
                                    principal = token.getPrincipal();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Token found, ID/Principal: ", new Object[]{id, principal});
                                    }
                                    if (id == null || id.length() <= 0) continue;
                                    if (principal != null && principal.length() > 0 && uniqueTreeSet.size() == 0) {
                                        uniqueTreeSet.add(principal);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unique string updated with principal: " + principal);
                                        }
                                    }
                                    uniqueTreeSet.add(id);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Unique string updated with custom uniqueID: " + id);
                                }
                            }
                            if ((publicCredentials = subject.getPublicCredentials(Token.class)) != null && publicCredentials.size() > 0) {
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Got some public credentials to iterate through.");
                                }
                                for (Token token : publicCredentials) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "token found, looking for uniqueID.", new Object[]{token});
                                    }
                                    if (token == null || !(token instanceof Token)) continue;
                                    String id = token.getUniqueID();
                                    String principal = token.getPrincipal();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "ID/Principal: ", new Object[]{id, principal});
                                    }
                                    if (id == null || id.length() <= 0) continue;
                                    if (principal != null && principal.length() > 0 && uniqueTreeSet.size() == 0) {
                                        uniqueTreeSet.add(principal);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Unique string updated with principal: " + principal);
                                        }
                                    }
                                    uniqueTreeSet.add(id);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Unique string updated with custom uniqueID: " + id);
                                }
                            }
                            if (uniqueTreeSet != null && uniqueTreeSet.size() > 0) {
                                ServerCredSigner scs;
                                byte[] uniqueHash;
                                String[] uniqueStringArray = uniqueTreeSet.toArray(new String[uniqueTreeSet.size()]);
                                StringBuffer uniqueID = new StringBuffer(uniqueTreeSet.size());
                                for (int i = 0; i < uniqueStringArray.length; ++i) {
                                    uniqueID.append(uniqueStringArray[i]);
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Getting one-way hash.");
                                }
                                if ((uniqueHash = (scs = ServerCredSigner.getInstance()).getOneWayHash(uniqueID.toString())) != null) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.debug(tc, "Converting hash to string.");
                                    }
                                    BigInteger uniqueBigInteger = new BigInteger(uniqueHash);
                                    String uniqueBigIntegerString = uniqueBigInteger.toString();
                                    if (tc.isDebugEnabled()) {
                                        Tr.exit(tc, "createSubjectUniqueID returns uniqueID (" + uniqueID.toString() + ") as one-way hash: " + uniqueBigIntegerString);
                                    }
                                    return uniqueBigIntegerString;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.exit(tc, "createSubjectUniqueID returns uniqueID (" + uniqueID.toString() + ") as one-way hash: null.");
                                }
                                return null;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.exit(tc, "createSubjectUniqueID returns null for uniqueID.");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectUniqueID", "2026", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "createSubjectUniqueID throwing exception.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectUniqueID " + uniqueID);
        }
        return uniqueID;
    }

    public String createUniqueIDFromAllTokens(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createUniqueIDFromAllTokens", subject);
        }
        String uniqueID = null;
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUniqueIDFromAllTokens: Subject is null, uniqueID = " + uniqueID);
            }
            return uniqueID;
        }
        try {
            uniqueID = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ContextManager contextManager;
                    Map tokenMap;
                    String subjectUniqueID = WSCredentialTokenMapper.this.createSubjectUniqueID(subject);
                    if (subjectUniqueID == null) {
                        try {
                            WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                            subjectUniqueID = wsCred.getRealmUniqueSecurityName();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.createUniqueIDFromAllTokens", "2056", this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "createUniqueIDFromAllTokens catching exception accessing WSCredential and returning null.", new Object[]{e});
                            }
                            return null;
                        }
                    }
                    if ((tokenMap = (contextManager = ContextManagerFactory.getInstance()).getPropagationTokens()) != null) {
                        String propUniqueID = null;
                        for (PropagationToken propToken : tokenMap.values()) {
                            if (propToken == null || propToken.getUniqueID() == null) continue;
                            if (propUniqueID != null) {
                                propUniqueID = propUniqueID + ":" + propToken.getUniqueID();
                                continue;
                            }
                            propUniqueID = propToken.getUniqueID();
                        }
                        if (propUniqueID != null) {
                            subjectUniqueID = subjectUniqueID + ":" + propUniqueID;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "createUniqueIDFromAllTokens: " + subjectUniqueID);
                        }
                        return subjectUniqueID;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createUniqueIDFromAllTokens: no PropTokens set on thread: " + subjectUniqueID);
                    }
                    return subjectUniqueID;
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUniqueIDFromAllToken " + uniqueID);
            }
            return uniqueID;
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createUniqueIDFromAllTokens", "2102", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUniqueIDFromAllTokens throwing exception.", new Object[]{e.getException()});
            }
            return null;
        }
    }

    public String getUniqueIDFromAuthzToken(final Subject subject) {
        String uniqueID;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUniqueIDFromAuthzToken", subject);
            }
            uniqueID = null;
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Subject is null, returning null");
                }
                return null;
            }
            try {
                uniqueID = (String)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            Set<AuthorizationToken> privateCredentials = subject.getPrivateCredentials(AuthorizationToken.class);
                            if (privateCredentials != null && privateCredentials.size() > 0) {
                                for (AuthorizationToken token : privateCredentials) {
                                    String[] uniqueIDArray;
                                    if (token == null || !token.getName().equals("com.ibm.ws.security.token.AuthorizationTokenImpl") || (uniqueIDArray = token.getAttributes("hashed_uid")) == null || uniqueIDArray[0] == null) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "getUniqueIDFromAuthzToken returning uniqueID: " + uniqueIDArray[0]);
                                    }
                                    return uniqueIDArray[0];
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.createSubjectUniqueID", "2148", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "getUniqueIDFromAuthzToken throwing exception.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueIDFromAuthzToken " + uniqueID);
        }
        return uniqueID;
    }

    public Object getCacheKeyFromHashtable(final Subject subject) {
        Object cacheKey;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCacheKeyFromHashtable", subject);
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCacheKeyFromHashtable Subject is null, returning null");
                }
                return null;
            }
            cacheKey = null;
            try {
                cacheKey = com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        HashSet<Hashtable> allCredentials = new HashSet<Hashtable>();
                        Set<Hashtable> privateCredentials = null;
                        Set<Hashtable> publicCredentials = null;
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            privateCredentials = subject.getPrivateCredentials(Hashtable.class);
                            publicCredentials = subject.getPublicCredentials(Hashtable.class);
                            if (publicCredentials.size() > 0) {
                                allCredentials.addAll(publicCredentials);
                            }
                            if (privateCredentials.size() > 0) {
                                allCredentials.addAll(privateCredentials);
                            }
                            if (allCredentials != null && allCredentials.size() > 0) {
                                for (Hashtable hashTable : allCredentials) {
                                    if (hashTable == null) continue;
                                    Object cacheKey = hashTable.get("com.ibm.wsspi.security.cred.cacheKey");
                                    if (cacheKey != null && cacheKey instanceof String && ((String)cacheKey).equals("")) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Cache Key value is null string. Reset to null.");
                                        }
                                        cacheKey = null;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Returning cache key for lookup: " + cacheKey);
                                    }
                                    return cacheKey;
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.getCacheKeyFromHashtable", "2214", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "getCacheKeyFromHashtable throwing exception.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheKeyFromHashtable", cacheKey);
        }
        return cacheKey;
    }

    public boolean subjectContainsLoginHashtable(final Subject subject) {
        Boolean containsLoginHashtable;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "subjectContainsLoginHashtable", subject);
            }
            containsLoginHashtable = Boolean.valueOf("false");
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "subjectContainsLoginHashtable, Subject is null, returning false");
                }
                return containsLoginHashtable;
            }
            try {
                containsLoginHashtable = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        HashSet<Hashtable> allCredentials = new HashSet<Hashtable>();
                        Set<Hashtable> privateCredentials = null;
                        Set<Hashtable> publicCredentials = null;
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            privateCredentials = subject.getPrivateCredentials(Hashtable.class);
                            publicCredentials = subject.getPublicCredentials(Hashtable.class);
                            if (publicCredentials.size() > 0) {
                                allCredentials.addAll(publicCredentials);
                            }
                            if (privateCredentials.size() > 0) {
                                allCredentials.addAll(privateCredentials);
                            }
                            if (allCredentials != null && allCredentials.size() > 0) {
                                for (Hashtable hashTable : allCredentials) {
                                    if (hashTable == null || hashTable.get("com.ibm.wsspi.security.cred.securityName") == null || hashTable.get("com.ibm.wsspi.security.cred.uniqueId") == null) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Subject contains valid login Hashtable.");
                                    }
                                    return Boolean.valueOf("true");
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Subject does not contain valid login Hashtable.");
                            }
                            return Boolean.valueOf("false");
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.subjectContainsLoginHashtable", "2277", this);
                if (!tc.isEntryEnabled()) break block6;
                Tr.exit(tc, "subjectContainsLoginHashtable throwing exception.", new Object[]{e.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "subjectContainsLoginHashtable -> " + containsLoginHashtable);
        }
        return containsLoginHashtable;
    }

    protected synchronized byte[] getOneWayHash(String password) {
        if (!SecurityContext.isSecurityEnabled() || !SecurityContext.isServerProcess()) {
            return null;
        }
        this.md.reset();
        this.md.update(password.getBytes());
        return this.md.digest();
    }

    public boolean checkCushionValidityOfAllTokens(final Subject subject, final long cushion, boolean refresh) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCushionValidityOfAllTokens", new Object[]{new Long(cushion), new Boolean(refresh)});
        }
        Boolean valid = Boolean.TRUE;
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is null, returning false.");
            }
            return false;
        }
        try {
            final WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
            long wsCred_expiration = wsCred.getExpiration();
            final long currentTime = System.currentTimeMillis();
            long wsCred_timeRemaining = wsCred_expiration - currentTime - cushion;
            if (wsCred_expiration != 0L && wsCred_expiration != -1L && wsCred_timeRemaining < 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential has expired, refreshing Subject.");
                }
                valid = Boolean.FALSE;
            }
            if (WSCredentialTokenMapper.isAnyPropagationEnabled() && valid.booleanValue()) {
                valid = (Boolean)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        Boolean noTokensInvalid = Boolean.TRUE;
                        if (!wsCred.isForwardable() || wsCred.isBasicAuth()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WSCredential is not forwardable or BasicAuth.");
                            }
                            return Boolean.TRUE;
                        }
                        ContextManager ctxMgr = ContextManagerFactory.getInstance();
                        PropagationToken propToken = ctxMgr.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                        if (propToken != null) {
                            long expiration = propToken.getExpiration();
                            long timeRemaining = expiration - currentTime - cushion;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Time remaining is " + timeRemaining / 1000L + " seconds, for token: " + propToken.getClass().getName());
                            }
                            if (timeRemaining < 0L) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Refreshing propagation token.");
                                }
                                PropagationToken propagationToken = (PropagationToken)propToken.clone();
                                ctxMgr.setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", propagationToken);
                            }
                        }
                        if (!noTokensInvalid.booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Returned false since WSCredential already expired.");
                            }
                            return noTokensInvalid;
                        }
                        Subject subject2 = subject;
                        synchronized (subject2) {
                            long timeRemaining;
                            long expiration;
                            Set<AbstractTokenImpl> privateCredentials = subject.getPrivateCredentials(AbstractTokenImpl.class);
                            Set<KRBAuthnToken> krbCredentials = subject.getPrivateCredentials(KRBAuthnToken.class);
                            if (tc.isDebugEnabled()) {
                                int numOfTokens = 0;
                                if (privateCredentials != null && privateCredentials.size() > 0) {
                                    numOfTokens += privateCredentials.size();
                                }
                                if (krbCredentials != null && krbCredentials.size() > 0) {
                                    numOfTokens += krbCredentials.size();
                                }
                                Tr.debug(tc, "Total number of Subject tokens to check: " + numOfTokens);
                            }
                            if (privateCredentials != null && privateCredentials.size() > 0) {
                                for (Token token : privateCredentials) {
                                    if (token == null) continue;
                                    expiration = token.getExpiration();
                                    timeRemaining = expiration - currentTime - cushion;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Time remaining is " + timeRemaining / 1000L + " seconds, for token: " + token.getClass().getName());
                                    }
                                    if (timeRemaining >= 0L) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Subject is not valid, should reauthenticate.");
                                    }
                                    noTokensInvalid = Boolean.FALSE;
                                    break;
                                }
                            }
                            if (krbCredentials != null && krbCredentials.size() > 0) {
                                for (KRBAuthnToken kRBAuthnToken : krbCredentials) {
                                    if (kRBAuthnToken == null) continue;
                                    expiration = kRBAuthnToken.getTokenExpiration();
                                    timeRemaining = expiration - currentTime - cushion;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Time remaining is " + timeRemaining / 1000L + " seconds, for token: " + kRBAuthnToken.getClass().getName());
                                    }
                                    if (timeRemaining >= 0L) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Subject is not valid, should reauthenticate.");
                                    }
                                    noTokensInvalid = Boolean.FALSE;
                                    break;
                                }
                            }
                            return noTokensInvalid;
                        }
                    }
                });
            }
            if (refresh && !valid.booleanValue()) {
                boolean success = ContextManagerFactory.getInstance().renew(subject, 0, true);
                if (success) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing old Subject and updating cache with new Subject after renewal.");
                    }
                    WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
                    try {
                        AuthCache.getInstance().removeEntry(credential.getRealmName(), credential.getSecurityName());
                    }
                    catch (CacheException e) {
                        // empty catch block
                    }
                    AuthCache.getInstance().insert(subject);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCushionValidityOfAllTokens -> " + success);
                }
                return success;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCushionValidityOfAllTokens -> " + valid);
            }
            return valid;
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.checkCushionValidityOfAllTokens", "2447", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCushionValidityOfAllTokens throwing exception, returning false.", new Object[]{e.getException()});
            }
            valid = Boolean.FALSE;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.checkCushionValidityOfAllTokens", "2452", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCushionValidityOfAllTokens throwing exception, returning false.", new Object[]{e});
            }
            valid = Boolean.FALSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCushionValidityOfAllTokens -> " + valid);
        }
        return valid;
    }

    public boolean checkCushionValidityOfAllTokens(Subject subject, long cushion) {
        return this.checkCushionValidityOfAllTokens(subject, cushion, false);
    }

    public boolean checkValidityOfAllTokens(Subject subject) {
        return this.checkCushionValidityOfAllTokens(subject, AuthCache.getInstance().getCushion(), false);
    }

    public boolean checkValidityOfAllTokensAndRefresh(Subject subject) {
        return this.checkCushionValidityOfAllTokens(subject, AuthCache.getInstance().getCushion(), true);
    }

    public boolean checkGSSCredExpired(Subject subject) {
        Boolean GSSExpired = Boolean.FALSE;
        GSSCredential gssCred2 = null;
        long cushion = AuthCache.getInstance().getCushion();
        try {
            Set<GSSCredential> privCredentials;
            KRBAuthnToken krbAuthnToken = SubjectHelper.getKerberosAuthnTokenFromSubject(subject);
            if (krbAuthnToken != null) {
                long currentTime;
                long expiration;
                long timeRemaining;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default krbAuthnToken token.");
                }
                if ((timeRemaining = (expiration = krbAuthnToken.getTokenExpiration()) - (currentTime = System.currentTimeMillis()) - cushion) < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "KrbAuthnToken is expired.");
                    }
                    GSSExpired = Boolean.TRUE;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkGSSCredExpired -> " + GSSExpired);
                    }
                    return GSSExpired;
                }
            }
            if ((privCredentials = subject.getPrivateCredentials(GSSCredential.class)) != null) {
                for (GSSCredential gssCred2 : privCredentials) {
                }
            }
            if (gssCred2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found default GSSCredential in subject.");
                }
                long timeRemaining = (long)(gssCred2.getRemainingLifetime() * 1000) - cushion;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cushion: " + cushion);
                    Tr.debug(tc, "Time remaining is " + timeRemaining / 1000L + " seconds, for token: " + gssCred2);
                }
                if (timeRemaining < 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "GSSCredential is expired.");
                    }
                    GSSExpired = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.WSCredentialTokenMapper.checkGSSCredExpired", "2433", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkGSSCredExpired throwing exception, returning true.", new Object[]{e});
            }
            GSSExpired = Boolean.TRUE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkGSSCredExpired -> " + GSSExpired);
        }
        return GSSExpired;
    }

    public String getJCEProvider() {
        List providerList = null;
        if (JSSEProviderFactory.isFipsEnabled() && (providerList = JSSEProviderFactory.fipsJCEProviders()) != null && providerList.size() > 0) {
            this.JCEProvider = (String)providerList.get(0);
        }
        return this.JCEProvider;
    }

    public static boolean isAnyPropagationEnabled() {
        if (!propEnabledChecked) {
            propEnabledChecked = true;
            if (WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "At least one propagation flag is enabled.");
                }
                propEnabled = true;
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Propagation is disabled.");
            }
            propEnabled = false;
            return false;
        }
        return propEnabled;
    }

    public void validateTokenRealm(com.ibm.wsspi.security.ltpa.Token token) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenRealm(byte[])", "token=" + token);
        }
        try {
            this.getLTPAServerObject().realmsMatch(token);
        }
        catch (Exception e) {
            throw new WSLoginFailedException("An exception was thrown while validating realm in received token.", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenRealm(byte[])");
        }
    }

    private LTPAServerObject getLTPAServerObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAServerObject");
        }
        LTPAServerObject ltpaServer = null;
        try {
            if (this._scm == null) {
                this._scm = SecurityObjectLocator.getSecurityConfigManager();
            }
            if (this._scm != null && this._scm.isAdminAgent()) {
                if (!this.getActiveAuthMechType().equals("SWAM")) {
                    ltpaServer = (LTPAServerObject)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return LTPAServerObject.getLTPAServer();
                        }
                    });
                }
            } else {
                if (this._ltpaServer == null && !this.getActiveAuthMechType().equals("SWAM")) {
                    this._ltpaServer = (LTPAServerObject)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return LTPAServerObject.getLTPAServer();
                        }
                    });
                }
                ltpaServer = this._ltpaServer;
            }
        }
        catch (PrivilegedActionException e) {
            Tr.debug(tc, "PrivilegedActionException getting LTPAServerObject", new Object[]{e});
            FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.WSCredentialTokenMapper.init", "2643", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAServerObject", ltpaServer);
        }
        return ltpaServer;
    }

    private String getActiveAuthMechType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveAuthMechType");
        }
        String activeAuthMechType = this.getSecurityConfig().getActiveAuthMechanism().getType();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveAuthMechType", activeAuthMechType);
        }
        return activeAuthMechType;
    }

    private SecurityConfig getSecurityConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityConfig");
        }
        SecurityConfig security2 = null;
        if (this._scm == null) {
            this._scm = SecurityObjectLocator.getSecurityConfigManager();
        }
        if (this._scm != null && this._scm.isAdminAgent()) {
            security2 = SecurityObjectLocator.getSecurityConfig();
        } else {
            if (this._security == null) {
                this._security = SecurityObjectLocator.getSecurityConfig();
            }
            security2 = this._security;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityConfig", security2);
        }
        return security2;
    }

    class GetOpaqueTokenFromMBeanAction
    implements PrivilegedExceptionAction {
        private ByteArray ssoToken = null;
        private String serverName = null;
        private Properties connectorProps = null;

        public GetOpaqueTokenFromMBeanAction(ByteArray _ssoToken, String _serverName, Properties _connectorProps) {
            this.ssoToken = _ssoToken;
            this.serverName = _serverName;
            this.connectorProps = _connectorProps;
        }

        public Object run() throws Exception {
            ObjectName queryString;
            Set s;
            AdminClient adminClient = null;
            String cellName = null;
            String nodeName = null;
            String processName = null;
            ObjectName securityAdmin = null;
            SecurityConfig security2 = WSCredentialTokenMapper.this.getSecurityConfig();
            Properties props = (Properties)security2.getObject("process.jmxConnectorProps");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOpaqueTokenFromMBean got initial jmx props:", props);
            }
            boolean setSecurityEnabledProp = true;
            Enumeration<?> vEnum = props.propertyNames();
            while (vEnum.hasMoreElements()) {
                String name = (String)vEnum.nextElement();
                String value = (String)props.get(name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOpaqueTokenFromMBean found " + (name == null ? "null" : name) + " property with value " + (value == null ? "null" : value) + " in jmx connector props");
                }
                if (name == null || value == null || value.length() <= 0) continue;
                if (!(name.equals("type") || name.equals("host") || name.equals("port"))) {
                    this.connectorProps.setProperty(name, value);
                }
                if (!name.equals("securityEnabled")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "GetOpaqueTokenFromMBeanAction found securityEnabled");
                }
                setSecurityEnabledProp = false;
            }
            if (setSecurityEnabledProp && SecurityContext.isSecurityEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getOpaqueTokenFromMBean adding property securityEnabled");
                }
                this.connectorProps.setProperty("securityEnabled", "true");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOpaqueTokenFromMBean creating admin client with props:", this.connectorProps);
            }
            adminClient = AdminClientFactory.createAdminClient(this.connectorProps);
            StringTokenizer st = new StringTokenizer(this.serverName, ":");
            if (st != null) {
                cellName = st.nextToken();
                nodeName = st.nextToken();
                processName = st.nextToken();
            }
            if ((s = adminClient.queryNames(queryString = new ObjectName("WebSphere:type=SecurityAdmin,cell=" + cellName + ",node=" + nodeName + ",process=" + processName + ",*"), null)).isEmpty()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueTokenFromMBean: SecurityAdmin MBean was not found using queryString " + queryString);
                }
                return null;
            }
            securityAdmin = (ObjectName)s.iterator().next();
            TokenHolder th = (TokenHolder)adminClient.invoke(securityAdmin, "getOpaqueToken", new Object[]{this.ssoToken}, new String[]{"com.ibm.ws.security.util.ByteArray"});
            if (th != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returning opaque token from MBean.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getOpaqueTokenFromMBean");
                }
                return th.getBytes();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null opaque token.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueTokenFromMBean");
            }
            return null;
        }
    }
}

