/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.KerberosTokenImpl;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.KerberosToken;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosServiceTicketImpl
extends AbstractTokenImpl
implements KerberosToken {
    private byte[] tokenBytes = null;
    private GSSCredential gssCredential = null;
    private String KERBEROS_MECH = "1.2.840.113554.1.2.2";
    private String KERBEROS_OID = "oid:" + this.KERBEROS_MECH;
    private String targetServerName = null;
    private ContextManager contextManager = null;
    private String tokenName = "com.ibm.ws.security.token.KerberosServiceTicketImpl";
    private boolean forwardable = true;
    private boolean isReadOnly = false;
    private short version = 1;
    private static final TraceComponent tc = Tr.register(KerberosServiceTicketImpl.class, null, "com.ibm.ejs.resources.security");

    public KerberosServiceTicketImpl(KerberosTokenImpl token, CSIv2PerformPolicy csiv2EffectivePolicy) {
        String hostName = csiv2EffectivePolicy.getTargetHostName();
        String targetRealmSecurityName = csiv2EffectivePolicy.getTargetSecurityName();
        String targetSecurityName = RealmSecurityName.getSecurityName(targetRealmSecurityName);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "hostName: " + hostName);
            Tr.debug(tc, "targetRealmSecurityName: " + targetRealmSecurityName);
            Tr.debug(tc, "targetSecurityName: " + targetSecurityName);
        }
        this.targetServerName = csiv2EffectivePolicy.getTargetSecurityName();
        int realmDelimiterIndex = this.targetServerName.indexOf("@");
        String realm = "";
        if (realmDelimiterIndex != -1) {
            realm = this.targetServerName.substring(realmDelimiterIndex + 1, this.targetServerName.length());
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Calling initSecContext with targetServerName: " + this.targetServerName + " realm: " + realm);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KerberosServiceTicketImpl server = " + this.targetServerName);
        }
        this.gssCredential = token.getGSSCredential();
        if (this.gssCredential == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing GSSCredential in KerberosTokenImpl object");
            }
            throw new NullPointerException("No GSSCredential");
        }
        if (!token.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expired GSSCredential in KerberosTokenImpl object");
            }
            throw new IllegalStateException("Expired GSSCredential");
        }
        this.tokenBytes = this.getServiceTicket();
    }

    public KerberosServiceTicketImpl(KerberosServiceTicketImpl ticket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KerberosServiceTicketImpl server = " + ticket.targetServerName);
        }
        this.targetServerName = ticket.targetServerName;
        this.gssCredential = ticket.gssCredential;
        if (this.gssCredential == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "gssCredential is null");
            }
            throw new NullPointerException("No GSSCredential");
        }
        if (!ticket.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expired GSSCredential in KerberosServiceTicketImpl object");
            }
            throw new IllegalStateException("Expired GSSCredential");
        }
        this.tokenBytes = this.getServiceTicket();
    }

    private byte[] getServiceTicket() {
        byte[] initialContextToken;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServiceTicket for target service " + this.targetServerName);
            }
            GSSContext clientContext = null;
            GSSManager _manager = GSSManager.getInstance();
            initialContextToken = null;
            try {
                Object[] parms;
                Oid _krb5Mech = null;
                try {
                    _krb5Mech = new Oid(this.KERBEROS_MECH);
                }
                catch (GSSException exc) {
                    Object[] parms2 = new Object[]{Oid.class, "Oid(\"" + this.KERBEROS_MECH + "\")", exc};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting OID: " + exc.getMessage());
                    }
                    throw exc;
                }
                GSSName serverName = null;
                String targetGSSServiceName = null;
                if (this.targetServerName.indexOf("/") == -1) {
                    targetGSSServiceName = this.targetServerName;
                } else {
                    int realmDelimiterIndex = this.targetServerName.indexOf("@");
                    if (realmDelimiterIndex == -1) {
                        targetGSSServiceName = this.targetServerName.replace("/", "@");
                    } else {
                        String krbShortName = this.targetServerName.substring(0, realmDelimiterIndex);
                        targetGSSServiceName = krbShortName.replace("/", "@");
                    }
                }
                try {
                    serverName = _manager.createName(targetGSSServiceName, GSSName.NT_HOSTBASED_SERVICE, _krb5Mech);
                }
                catch (GSSException exc) {
                    parms = new Object[]{_manager, "createName()", exc};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling createName: " + exc.getMessage());
                    }
                    throw exc;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "targetGSSServiceName: " + targetGSSServiceName);
                }
                try {
                    clientContext = _manager.createContext(serverName, _krb5Mech, this.gssCredential, 0);
                }
                catch (GSSException exc) {
                    parms = new Object[]{_manager, "createContext()", exc};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling createContext: " + exc.getMessage());
                    }
                    throw exc;
                }
                try {
                    clientContext.requestCredDeleg(true);
                }
                catch (GSSException exc) {
                    parms = new Object[]{clientContext, "requestCredDeleg(true)", exc};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling requestCredDeleg: " + exc.getMessage());
                    }
                    throw exc;
                }
                byte[] inToken = null;
                int len = 0;
                try {
                    initialContextToken = clientContext.initSecContext(inToken, 0, len);
                    Tr.debug(tc, "Token = " + initialContextToken.length + " " + initialContextToken);
                }
                catch (GSSException exc) {
                    Object[] parms3 = new Object[]{clientContext, "initSecContext()", exc};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception calling initSecContext: " + exc.getMessage());
                    }
                    throw exc;
                }
                if (clientContext.isEstablished()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initSecContext: clientContext established successfully.");
                    }
                } else {
                    Object[] parms4 = new Object[]{clientContext, this.targetServerName};
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initSecContext: clientContext not established.");
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.KerberosServiceTicketImpli.getServiceTicket", "1571", this);
                if (!tc.isEntryEnabled()) break block31;
                Tr.exit(tc, "Exception occurred getting service ticket.", new Object[]{e});
            }
        }
        if (initialContextToken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextToken returns null.");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceTicket returns a service ticket.");
        }
        return initialContextToken;
    }

    public boolean isValid() {
        int life = 0;
        try {
            life = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{e});
        }
        return life > 0;
    }

    public long getExpiration() {
        int life = -1;
        try {
            life = this.gssCredential.getRemainingLifetime();
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{e});
            return -1L;
        }
        return (long)(life * 1000) + System.currentTimeMillis();
    }

    public boolean isForwardable() {
        return true;
    }

    public String getPrincipal() {
        if (this.gssCredential != null) {
            String princ = null;
            try {
                princ = Krb5WSCredentialUtils.Krb5ToRegistryDN(((Object)this.gssCredential.getName()).toString());
                this.addAttribute("u", princ);
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception getting principal name from GSSCredential.", new Object[]{e});
            }
            return princ;
        }
        Tr.debug(tc, "GSSCredential is null, cannot get principal.");
        return null;
    }

    public String getUniqueID() {
        return this.getPrincipal();
    }

    public byte[] getBytes() {
        return this.tokenBytes;
    }

    public String getName() {
        return this.tokenName;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public Object clone() {
        try {
            KerberosServiceTicketImpl newTicket = new KerberosServiceTicketImpl(this);
            return newTicket;
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception creating clone of Kerberos service ticket.", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.token.KerberosServiceTicketImpl.clone", "662");
            return null;
        }
    }

    public GSSCredential getGSSCredential() {
        return this.gssCredential;
    }
}

