/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthorizationToken;
import java.security.PrivilegedAction;

public class AuthorizationTokenImpl
extends AbstractTokenImpl
implements AuthorizationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private static final TraceComponent tc = Tr.register(AuthorizationTokenImpl.class, null, "com.ibm.ejs.resources.security");
    private static String factoryClass = null;

    public AuthorizationTokenImpl() {
        if (factoryClass == null) {
            factoryClass = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.wsspi.security.token.authorizationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factoryClass:" + factoryClass);
            }
        }
    }

    public void initializeToken(byte[] _authzToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(byte[])", "_authzToken=" + _authzToken);
        }
        this.initializeToken(_authzToken, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(byte[])");
        }
    }

    public void initializeToken(byte[] _authzToken, boolean refreshIfExpired) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(byte[],boolean)", new Object[]{"_authzToken=" + _authzToken, "refreshIfExpired=" + refreshIfExpired});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authorization token.");
            }
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = null;
            if (factoryClass != null) {
                try {
                    this.token = this.ltpaServer.validateToken(_authzToken, factoryClass, refreshIfExpired);
                }
                catch (Exception e) {
                    Tr.debug(tc, "Exception validating authorization token by using factoryClass.", new Object[]{e});
                }
            }
            if (this.token == null) {
                this.token = this.ltpaServer.validateToken(_authzToken, refreshIfExpired);
            }
            final Token tokenPriv = this.token;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AuthorizationTokenImpl.this.setToken(tokenPriv);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.AuthorizationTokenImpl.initializeToken", "103", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.AuthorizationTokenImpl.initializeToken", "110", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(byte[],boolean)");
        }
    }

    public void initializeToken(Token _token) throws WSLoginFailedException {
        final Token tokenPriv = this.token = _token;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AuthorizationTokenImpl.this.setToken(tokenPriv);
                return null;
            }
        });
    }

    public Object clone() {
        try {
            AuthorizationTokenImpl newToken = new AuthorizationTokenImpl();
            this.token = (Token)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AuthorizationTokenImpl.this.getToken();
                }
            });
            newToken.initializeToken((Token)this.token.clone());
            return newToken;
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception creating clone of authorization token.", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPAToken.clone", "157");
            return null;
        }
    }
}

