/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.filter;

import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.spnego.filter.FilterException;
import com.ibm.ws.security.spnego.filter.IPAddressRange;
import com.ibm.ws.security.spnego.filter.IValue;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.ResourceBundle;

public class ValueIPAddress
implements IValue {
    InetAddress myIP;
    private static ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.security.spnego.resources.TAIMsgs", Locale.getDefault());

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public ValueIPAddress(String ip) throws FilterException {
        try {
            this.myIP = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            String msg = this.getMsg(resBundle, "security.spnego.ipstring.convert.error", new Object[]{ip});
            throw new FilterException(msg, e);
        }
    }

    public boolean equals(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return ((ValueIPAddress)ip).getIP().equals(this.getIP());
    }

    public boolean greaterThan(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.greaterThan(this.getIP(), ((ValueIPAddress)ip).getIP());
    }

    public boolean lessThan(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.lessThan(this.getIP(), ((ValueIPAddress)ip).getIP());
    }

    public boolean containedBy(IValue ip) {
        return this.equals(ip);
    }

    public String toString() {
        return this.getIP().toString();
    }

    protected InetAddress getIP() {
        return this.myIP;
    }
}

