/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.filter;

import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.spnego.filter.FilterException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IPAddressRange {
    private static Logger log = Logger.getLogger(IPAddressRange.class.getName());
    private static ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.security.spnego.resources.TAIMsgs", Locale.getDefault());
    InetAddress ipHigher;
    InetAddress ipLower;
    String ipRange;

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public IPAddressRange(String iprange) throws FilterException {
        String msg;
        this.ipRange = iprange;
        log.log(Level.FINE, "ip range is {0}", iprange);
        String lowerAddr = new String();
        String upperAddr = new String();
        StringTokenizer tokens = new StringTokenizer(iprange, ".:", true);
        boolean foundRange = false;
        String currentTop = "FFFF";
        while (tokens.hasMoreTokens()) {
            String ipPiece = tokens.nextToken();
            if (ipPiece.equals(":")) {
                upperAddr = upperAddr + ipPiece;
                lowerAddr = lowerAddr + ipPiece;
                continue;
            }
            String delim = tokens.hasMoreElements() ? tokens.nextToken() : "";
            ipPiece = ipPiece.trim();
            if (".".equals(delim)) {
                currentTop = "255";
            }
            if (foundRange) {
                if (!ipPiece.equals("*")) {
                    String msg2 = this.getMsg(resBundle, "security.spnego.malformed.iprange", new Object[]{ipPiece});
                    throw new FilterException(msg2);
                }
                upperAddr = upperAddr + currentTop;
                lowerAddr = lowerAddr + "0";
            } else if (ipPiece.startsWith("[") && ipPiece.endsWith("]")) {
                int dash = ipPiece.indexOf(45);
                String startStr = ipPiece.substring(1, dash);
                lowerAddr = lowerAddr + startStr;
                int bracket = ipPiece.lastIndexOf(93);
                String lastStr = ipPiece.substring(dash + 1, bracket);
                upperAddr = upperAddr + lastStr;
                foundRange = true;
            } else if (ipPiece.equals("*")) {
                upperAddr = upperAddr + currentTop;
                lowerAddr = lowerAddr + "0";
                foundRange = true;
            } else {
                upperAddr = upperAddr + ipPiece;
                lowerAddr = lowerAddr + ipPiece;
            }
            upperAddr = upperAddr + delim;
            lowerAddr = lowerAddr + delim;
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, "upperAddr is " + upperAddr);
            log.log(Level.FINEST, "lowerAddr is " + lowerAddr);
        }
        try {
            this.ipHigher = InetAddress.getByName(upperAddr);
        }
        catch (UnknownHostException e) {
            msg = this.getMsg(resBundle, "security.spnego.unknown.host", new Object[]{upperAddr});
            throw new FilterException(msg, e);
        }
        try {
            this.ipLower = InetAddress.getByName(lowerAddr);
        }
        catch (UnknownHostException e) {
            msg = this.getMsg(resBundle, "security.spnego.unknown.host", new Object[]{lowerAddr});
            throw new FilterException(msg, e);
        }
    }

    public boolean inRange(InetAddress ip) {
        if (IPAddressRange.greaterThan(ip, this.ipHigher)) {
            return false;
        }
        return !IPAddressRange.lessThan(ip, this.ipLower);
    }

    public boolean aboveRange(InetAddress ip) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "aboveRange, ip is " + ip);
            log.log(Level.FINEST, "aboveRange, ipHigher is " + this.ipHigher);
        }
        return IPAddressRange.greaterThan(ip, this.ipHigher);
    }

    public boolean belowRange(InetAddress ip) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "belowRange, ip is " + ip);
            log.log(Level.FINEST, "belowRange, ipLower is " + this.ipLower);
        }
        return IPAddressRange.lessThan(ip, this.ipLower);
    }

    public static boolean greaterThan(InetAddress a1, InetAddress a2) {
        return IPAddressRange.compare(a1, a2) > 0;
    }

    public static boolean lessThan(InetAddress a1, InetAddress a2) {
        return IPAddressRange.compare(a1, a2) < 0;
    }

    public static int compare(InetAddress a1, InetAddress a2) {
        int len;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "compare, a1 is " + a1);
            log.log(Level.FINEST, "compare, a2 is " + a2);
        }
        byte[] byte1 = a1.getAddress();
        byte[] byte2 = a2.getAddress();
        int base1 = 0;
        int base2 = 0;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "compare, byte1.length is " + byte1.length);
            log.log(Level.FINEST, "compare, byte2.length is " + byte2.length);
        }
        if (byte1.length > byte2.length) {
            len = byte2.length;
            base1 = byte1.length - len;
            if (!IPAddressRange.isZeros(byte1, byte1.length - len)) {
                return 1;
            }
        } else if (byte1.length < byte2.length) {
            len = byte1.length;
            base2 = byte2.length - len;
            if (!IPAddressRange.isZeros(byte2, byte2.length - len)) {
                return -1;
            }
        } else {
            len = byte1.length;
        }
        for (int i = 0; i < len; ++i) {
            if (byte1[base1] != byte2[base2]) {
                int b2;
                int b1 = byte1[base1];
                if (b1 < 0) {
                    b1 += 256;
                }
                if ((b2 = byte2[base2]) < 0) {
                    b2 += 256;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "compare, b1 is " + b1);
                    log.log(Level.FINEST, "compare, b2 is " + b2);
                }
                if (b1 > b2) {
                    return 1;
                }
                return -1;
            }
            ++base1;
            ++base2;
        }
        return 0;
    }

    private static boolean isZeros(byte[] bytes, int len) {
        for (int i = 0; i < len; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.ipRange;
    }
}

