/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.filter;

import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.spnego.filter.ContainsCondition;
import com.ibm.ws.security.spnego.filter.EqualCondition;
import com.ibm.ws.security.spnego.filter.FilterException;
import com.ibm.ws.security.spnego.filter.GreaterCondition;
import com.ibm.ws.security.spnego.filter.ICondition;
import com.ibm.ws.security.spnego.filter.IRequestInfo;
import com.ibm.ws.security.spnego.filter.IValue;
import com.ibm.ws.security.spnego.filter.LessCondition;
import com.ibm.ws.security.spnego.filter.NotContainsCondition;
import com.ibm.ws.security.spnego.filter.OrCondition;
import com.ibm.ws.security.spnego.filter.RealRequestInfo;
import com.ibm.ws.security.spnego.filter.ValueAddressRange;
import com.ibm.ws.security.spnego.filter.ValueIPAddress;
import com.ibm.ws.security.spnego.filter.ValueString;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class HTTPHeaderFilterBase {
    private static final String ME = HTTPHeaderFilterBase.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private static ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.security.spnego.resources.TAIMsgs", Locale.getDefault());
    private boolean processAll = false;
    protected List filterCondition = new LinkedList();

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public boolean init(String s1) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "init", s1);
        }
        if (s1 == null) {
            logger.logp(Level.SEVERE, ME, "init", "security.spnego.filter.init.null.string");
            return false;
        }
        StringTokenizer st1 = new StringTokenizer(s1, ";");
        StringTokenizer st2 = null;
        String s2 = null;
        while (st1.hasMoreTokens()) {
            s2 = st1.nextToken();
            st2 = new StringTokenizer(s2, "^=!<>%");
            String key = st2.nextToken();
            if (!st2.hasMoreTokens()) {
                logger.logp(Level.SEVERE, ME, "init", "security.spnego.malformed.filter.condition", new Object[]{s1, s2, null});
                return false;
            }
            String valueString = st2.nextToken();
            String operand = s2.substring(key.length(), s2.length() - valueString.length()).trim();
            boolean ipAddress = false;
            if ("remote-address".equals(key)) {
                ipAddress = true;
            }
            logger.logp(Level.FINER, ME, "isValid", "Adding " + key + " " + operand + " " + valueString);
            try {
                ICondition condition = this.makeCondition(key, operand, valueString, ipAddress);
                this.filterCondition.add(condition);
            }
            catch (FilterException e) {
                throw new RuntimeException(e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "init", Boolean.toString(true));
        }
        return true;
    }

    private ICondition makeCondition(String key, String operand, String valueString, boolean ipAddress) throws FilterException {
        if (operand.equals("==")) {
            return new EqualCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals("!=")) {
            return new NotContainsCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals("^=")) {
            OrCondition cond = new OrCondition(key);
            StringTokenizer tokens = new StringTokenizer(valueString, "|");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                cond.addValue(this.makeValue(token, ipAddress));
            }
            return cond;
        }
        if (operand.equals("%=")) {
            return new ContainsCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals("<")) {
            return new LessCondition(key, this.makeValue(valueString, ipAddress));
        }
        if (operand.equals(">")) {
            return new GreaterCondition(key, this.makeValue(valueString, ipAddress));
        }
        logger.logp(Level.SEVERE, ME, "init", "security.spnego.malformed.filter.operator", new Object[]{operand});
        String msg = this.getMsg(resBundle, "security.spnego.malformed.filter.operator", new Object[]{operand});
        throw new FilterException(msg);
    }

    private IValue makeValue(String value, boolean ipAddress) throws FilterException {
        if (ipAddress) {
            return new ValueAddressRange(value);
        }
        return new ValueString(value);
    }

    public boolean isAccepted(HttpServletRequest req) {
        return this.isAccepted(new RealRequestInfo(req));
    }

    public boolean isAccepted(IRequestInfo req) {
        String reason = "TAI will intercept request.";
        boolean isAccepted = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isAccepted");
        }
        if (this.processAll) {
            reason = "processAll is true, therefore we always intercept.";
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isAccepted", isAccepted + " " + reason);
            }
            return true;
        }
        String HTTPheader = null;
        for (ICondition cond : this.filterCondition) {
            HTTPheader = req.getHeader(cond.getKey());
            boolean ipAddress = false;
            if (HTTPheader == null) {
                if (cond.getKey().equals("remote-address")) {
                    HTTPheader = req.getRemoteAddr();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'remote-address' " + HTTPheader);
                    }
                    ipAddress = true;
                } else if (cond.getKey().equals("request-url")) {
                    String queryString = req.getQueryString();
                    HTTPheader = queryString != null ? req.getRequestURL().toString() + "?" + queryString : req.getRequestURL().toString();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'request-url' " + HTTPheader);
                    }
                } else {
                    if (cond instanceof NotContainsCondition) continue;
                    reason = "No HTTPheader found, and no 'remote-address' or 'request-url' rule used - do not Intercept.";
                    isAccepted = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.exiting(ME, "isAccepted", isAccepted + " " + reason);
                    }
                    return false;
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "isAccepted", "Checking condition {0} {1}.", new Object[]{cond, HTTPheader});
            }
            try {
                IValue compareValue = ipAddress ? new ValueIPAddress(HTTPheader) : new ValueString(HTTPheader);
                boolean answer = cond.checkCondition(compareValue);
                if (!answer) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "check failed, returning false. TAI will not intercept");
                    }
                    return false;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.logp(Level.FINER, ME, "isAccepted", "check passed, continuing to next condition");
            }
            catch (FilterException e) {
                throw new RuntimeException(e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isAccepted", "TAI will intercept request");
            logger.exiting(ME, "isAccepted", isAccepted + " " + reason);
        }
        return true;
    }

    public void setProcessAll(boolean b) {
        this.processAll = b;
    }
}

