/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.admin;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.spnego.Constants;
import com.ibm.ws.security.spnego.HTTPHeaderFilter;
import com.ibm.ws.security.spnego.Util;
import com.ibm.ws.security.spnego.filter.HTTPHeaderFilterBase;
import com.ibm.ws.security.util.ConfigUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class CommandProviderImpl
extends SimpleCommandProvider {
    private static final String ME = CommandProviderImpl.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private ConfigService config;
    private Session session;

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        this.config = this.getCommandProviderHelper().getConfigService();
        return super.loadCommand(cmdData);
    }

    public List addSpnegoTAIProperties(AbstractAdminCommand cmd) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "addSpnegoTAIProperties", cmd);
        }
        Map cmdResult = null;
        ObjectName tai = null;
        try {
            int id;
            tai = this.getSpnegoConfig(cmd);
            ArrayList list = (ArrayList)this.config.getAttribute(this.session, tai, "trustProperties");
            Map taiProps = this.toMap(list);
            Map spnIdMap = Util.getSpnIdMap("com.ibm.ws.security.spnego.SPN", taiProps);
            Integer spnId = (Integer)cmd.getParameter("spnId");
            if (spnId != null) {
                id = spnId;
                if (id < 0) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.negative", new Object[]{spnId}, "spnId " + spnId + " is negative, specify a non-negative value.");
                    throw new CommandException(msg);
                }
                String prefix = "com.ibm.ws.security.spnego.SPN" + id;
                if (!Util.extractPropertiesWithPrefix(prefix, taiProps).isEmpty()) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notavailable", new Object[]{spnId}, "spnId " + spnId + " already exists.");
                    throw new CommandException(msg);
                }
            } else {
                id = Util.findAvailableSpnId("com.ibm.ws.security.spnego.SPN", spnIdMap);
            }
            if (!this.isFilterValid(id, cmdResult = this.getParameters(cmd, id))) {
                String filter = (String)cmdResult.get("com.ibm.ws.security.spnego.SPN" + id + ".filter");
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.filter", new Object[]{filter}, "Filter " + filter + " is malformed. Verify the syntax of the specified filter rules.");
                throw new CommandException(msg);
            }
            if (!this.isValidURL(id, cmdResult)) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.url", new Object[0], "One of the URLs specified is malformed.");
                throw new CommandException(msg);
            }
            for (Map.Entry entry : cmdResult.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                AttributeList props = new AttributeList();
                ConfigServiceHelper.setAttributeValue(props, "name", name);
                ConfigServiceHelper.setAttributeValue(props, "value", value);
                this.config.createConfigData(this.session, tai, "trustProperties", null, props);
                log.logp(Level.INFO, ME, "addSpnegoTAIProperties", "security.spnego.addprops", new Object[]{name, value});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException(e, "addSpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "addSpnegoTAIProperties");
        }
        return this.toList(cmdResult);
    }

    public List modifySpnegoTAIProperties(AbstractAdminCommand cmd) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "modifySpnegoTAIProperties", cmd);
        }
        TreeMap<String, String> cmdResult = new TreeMap<String, String>();
        ObjectName tai = null;
        try {
            String name;
            tai = this.getSpnegoConfig(cmd);
            Integer spnId = (Integer)cmd.getParameter("spnId");
            String prefix = "com.ibm.ws.security.spnego.SPN" + spnId + '.';
            ArrayList list = (ArrayList)this.config.getAttribute(this.session, tai, "trustProperties");
            Map spnProps = Util.extractPropertiesWithPrefix(prefix, this.toMap(list));
            if (spnProps.isEmpty()) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notexistent", new Object[]{spnId}, "spnId " + spnId + " does not exist.");
                throw new CommandException(msg);
            }
            int id = spnId;
            Map parms = this.getParameters(cmd, id);
            if (parms.isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Specify the SpnegoTAI properties to be modified.");
                }
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.noprops", new Object[]{spnId}, "Specify the SpnegoTAI properties to be modified.");
                throw new CommandException(msg);
            }
            if (!this.isFilterValid(id, parms)) {
                String filter = (String)parms.get("com.ibm.ws.security.spnego.SPN" + id + ".filter");
                String string = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.filter", new Object[]{filter}, "Filter " + filter + " is malformed. Verify the syntax of the specified filter rules.");
                throw new CommandException(string);
            }
            if (!this.isValidURL(id, parms)) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.invalid.url", new Object[0], "One of the URLs specified is malformed.");
                throw new CommandException(msg);
            }
            for (AttributeList attributeList : list) {
                name = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                if (!parms.containsKey(name)) continue;
                AttributeList newEntry = new AttributeList();
                String value = (String)parms.get(name);
                String previousValue = (String)ConfigServiceHelper.getAttributeValue(attributeList, "value");
                ConfigServiceHelper.setAttributeValue(newEntry, "value", value);
                this.config.setAttributes(this.session, ConfigServiceHelper.createObjectName(attributeList), newEntry);
                parms.remove(name);
                cmdResult.put(name, value);
                log.logp(Level.INFO, ME, "modifySpnegoTAIProperties", "security.spnego.modifyprops", new Object[]{name, value, previousValue});
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(name + " = " + value + " (previous value = " + previousValue + ")");
            }
            if (!parms.isEmpty()) {
                for (Map.Entry entry : parms.entrySet()) {
                    name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    AttributeList props = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(props, "name", name);
                    ConfigServiceHelper.setAttributeValue(props, "value", value);
                    this.config.createConfigData(this.session, tai, "trustProperties", null, props);
                    cmdResult.put(name, value);
                    log.logp(Level.INFO, ME, "modifySpnegoTAIProperties", "security.spnego.addprops", new Object[]{name, value});
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(e, "modifySpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "modifySpnegoTAIProperties");
        }
        return this.toList(cmdResult);
    }

    public List deleteSpnegoTAIProperties(AbstractAdminCommand cmd) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "deleteSpnegoTAIProperties", cmd);
        }
        ObjectName tai = null;
        Map idProps = null;
        try {
            tai = this.getSpnegoConfig(cmd);
            Integer id = (Integer)cmd.getParameter("spnId");
            ArrayList list = (ArrayList)this.config.getAttribute(this.session, tai, "trustProperties");
            if (id == null) {
                this.config.unsetAttributes(this.session, tai, new String[]{"trustProperties"});
                idProps = this.toMap(list);
                log.logp(Level.INFO, ME, "deleteSpnegoTAIProperties", "security.spnego.deleteall");
            } else {
                String prefix = "com.ibm.ws.security.spnego.SPN" + id + '.';
                idProps = Util.extractPropertiesWithPrefix(prefix, this.toMap(list));
                if (idProps.isEmpty()) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notexistent", new Object[]{id}, "spnId " + id + " does not exist.");
                    throw new CommandException(msg);
                }
                for (AttributeList entry : list) {
                    String name = (String)ConfigServiceHelper.getAttributeValue(entry, "name");
                    if (!idProps.containsKey(name)) continue;
                    this.config.deleteConfigData(this.session, ConfigServiceHelper.createObjectName(entry));
                    log.logp(Level.INFO, ME, "deleteSpnegoTAIProperties", "security.spnego.deleteprops", new Object[]{name});
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(e, "deleteSpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "deleteSpnegoTAIProperties");
        }
        return this.toList(idProps);
    }

    public List showSpnegoTAIProperties(AbstractAdminCommand cmd) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "showSpnegoTAIProperties", cmd);
        }
        ObjectName tai = null;
        Map cmdResult = null;
        try {
            Integer spnId;
            tai = this.getSpnegoConfig(cmd);
            ArrayList list = (ArrayList)this.config.getAttribute(this.session, tai, "trustProperties");
            Map taiProps = this.toMap(list);
            String clz = (String)this.config.getAttribute(this.session, tai, "interceptorClassName");
            if (log.isLoggable(Level.FINE)) {
                log.fine("Spnego TAI classname = " + clz);
            }
            if ((spnId = (Integer)cmd.getParameter("spnId")) != null) {
                String prefix = "com.ibm.ws.security.spnego.SPN" + spnId.toString();
                cmdResult = Util.extractPropertiesWithPrefix(prefix, taiProps);
                if (cmdResult.isEmpty()) {
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.spnid.notexistent", new Object[]{spnId}, "spnId " + spnId + " does not exist.");
                    throw new CommandException(msg);
                }
            } else {
                cmdResult = this.toMap(list);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Spnego TAI Properties: " + (cmdResult.isEmpty() ? "None" : ""));
            }
            if (log.isLoggable(Level.FINE)) {
                for (Map.Entry entry : cmdResult.entrySet()) {
                    log.fine("\t" + entry.getKey() + " = " + entry.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(e, "showSpnegoTAIProperties caught an unexpected exception");
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "showSpnegoTAIProperties");
        }
        log.info(TraceNLS.getFormattedMessage("com.ibm.ws.security.resources.AdminCommandText", "security.spnego.page.content.spnego.not.supported", new Object[0], "Default Junk1"));
        log.info(TraceNLS.getFormattedMessage("com.ibm.ws.security.resources.AdminCommandText", "security.spnego.page.content.ntlm.token.received", new Object[0], "Default Junk2"));
        return this.toList(cmdResult);
    }

    public String createKrbConfigFile(AbstractAdminCommand cmd) throws CommandException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "createKrbConfigFile", cmd);
        }
        String path = ConfigUtils.expandKrbFile((String)cmd.getParameter("krbPath"));
        String realm = (String)cmd.getParameter("realm");
        String kdcHost = (String)cmd.getParameter("kdcHost");
        String dns = (String)cmd.getParameter("dns");
        String keytabPath = ConfigUtils.expandKrbFile((String)cmd.getParameter("keytabPath"));
        Integer kdcPort = (Integer)cmd.getParameter("kdcPort");
        kdcPort = kdcPort == null ? new Integer(88) : kdcPort;
        String encrypt = (String)cmd.getParameter("encryption");
        encrypt = encrypt == null ? "rc4-hmac des-cbc-md5" : encrypt;
        File result = null;
        try {
            result = new File(path);
            File dir = result.getParentFile();
            if (!(dir == null || dir.isDirectory() && dir.exists() && dir.canWrite())) {
                log.logp(Level.WARNING, ME, "createKrbConfigFile", "security.spnego.krbconf.pathinvalid", new Object[]{dir});
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.krbconf.pathinvalid", new Object[]{dir}, "Directory " + dir + " does not exist or cannot be created, verify directory exists and is writable.");
                throw new CommandException(msg);
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, ME, "createKrbConfigFile", "krbPath=" + result);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "realm=" + realm);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "kdcHost=" + kdcHost);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "kdcPort=" + kdcPort);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "dns=" + dns);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "keytabPath=" + keytabPath);
                log.logp(Level.FINE, ME, "createKrbConfigFile", "encryption=" + encrypt);
            }
            if (result.exists() || result.isDirectory()) {
                log.logp(Level.WARNING, ME, "createKrbConfigFile", "security.spnego.krbconf.fileexists", new Object[]{result});
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.security.spnego.resources.TAIMsgs", "security.spnego.krbconf.fileexists", new Object[]{result}, "File " + result + " already exists, it has not been overwritten.");
                throw new CommandException(msg);
            }
            FileOutputStream fos = new FileOutputStream(result);
            PrintWriter out = null;
            out = AdminHelper.getPlatformHelper().isZOS() ? new PrintWriter(new OutputStreamWriter((OutputStream)fos, "IBM1047")) : new PrintWriter(new OutputStreamWriter(fos));
            out.println("[libdefaults]");
            out.println("\tdefault_realm = " + realm);
            out.println("\tdefault_keytab_name = FILE:" + keytabPath);
            out.println("\tdefault_tkt_enctypes = " + encrypt);
            out.println("\tdefault_tgs_enctypes = " + encrypt);
            out.println("\tforwardable  = true");
            out.println("\trenewable  = true");
            out.println("\tnoaddresses = true");
            out.println("\tclockskew  = 300");
            out.println("[realms]");
            out.println("\t" + realm + " = {");
            out.println("\t\tkdc = " + kdcHost + ":" + kdcPort);
            String[] dnsArray = dns.split("\\|");
            out.println("\t\tdefault_domain = " + dnsArray[0]);
            out.println("\t}");
            out.println("[domain_realm]");
            for (int i = 0; i < dnsArray.length; ++i) {
                out.println("\t." + dnsArray[i] + " = " + realm);
            }
            out.close();
        }
        catch (IOException e) {
            throw new CommandException(e, "createKrbConfigFile caught an unexpected exception.");
        }
        log.logp(Level.INFO, ME, "createKrbConfigFile", "security.spnego.krbconf.success", new Object[]{result});
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "createKrbConfigFile", result.getAbsolutePath());
        }
        return result.getAbsolutePath() + " has been created.";
    }

    private Map toMap(ArrayList list) throws AttributeNotFoundException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "toMap");
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (list != null) {
            for (AttributeList prop : list) {
                String name = (String)ConfigServiceHelper.getAttributeValue(prop, "name");
                String value = (String)ConfigServiceHelper.getAttributeValue(prop, "value");
                map.put(name, value);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "toMap", "Map=" + map);
        }
        return map;
    }

    private ObjectName getSpnegoConfig(AbstractAdminCommand cmd) throws ConfigServiceException, ConnectorException, CommandValidationException {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getSpnegoConfig", cmd.toString());
        }
        this.session = cmd.getConfigSession();
        ObjectName tai = null;
        ObjectName taiObj = ConfigServiceHelper.createObjectName(null, "TAInterceptor");
        ObjectName[] matches = this.config.queryConfigObjects(this.session, null, taiObj, null);
        if (matches != null && matches.length > 0) {
            for (int i = 0; i < matches.length; ++i) {
                ObjectName obj = matches[i];
                String clz = (String)this.config.getAttribute(this.session, obj, "interceptorClassName");
                if (!clz.equals(Constants.SPNEGO_TAI_CLASSNAME)) continue;
                tai = matches[i];
                break;
            }
        }
        if (tai == null) {
            String msg = "SpnegoTAI is not defined in the configuration.";
            if (log.isLoggable(Level.FINE)) {
                log.fine(msg);
            }
            throw new CommandValidationException(msg);
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getSpnegoConfig", tai.getCanonicalName());
        }
        return tai;
    }

    private Map getParameters(AbstractAdminCommand cmd, int id) throws InvalidParameterNameException {
        Object obj;
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getParameters", "id=" + id);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String prefix = "com.ibm.ws.security.spnego.SPN" + id;
        String parm = (String)cmd.getParameter("host");
        if (parm != null) {
            map.put(prefix + ".hostName", parm);
        }
        if ((parm = (String)cmd.getParameter("filter")) != null) {
            map.put(prefix + ".filter", parm);
        }
        if ((parm = (String)cmd.getParameter("filterClass")) != null) {
            map.put(prefix + ".filterClass", parm);
        }
        if ((parm = (String)cmd.getParameter("noSpnegoPage")) != null) {
            map.put(prefix + ".spnegoNotSupportedPage", parm);
        }
        if ((parm = (String)cmd.getParameter("ntlmTokenPage")) != null) {
            map.put(prefix + ".NTLMTokenReceivedPage", parm);
        }
        if ((obj = cmd.getParameter("trimUserName")) != null) {
            map.put(prefix + ".trimUserName", ((Boolean)obj).toString());
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getParameters", "Map=" + map);
        }
        return map;
    }

    private List toList(Map parms) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "toList", "parms=" + parms);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!parms.isEmpty()) {
            for (Map.Entry entry : parms.entrySet()) {
                result.add(entry.getKey() + "=" + entry.getValue());
            }
        } else {
            result = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "toList", "result=" + result);
        }
        return result;
    }

    private boolean isFilterValid(int id, Map props) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "isFilterValid", "id=" + id + " Map=" + props);
        }
        boolean isValid = true;
        String filter = (String)props.get("com.ibm.ws.security.spnego.SPN" + id + ".filter");
        if (filter != null && filter.length() != 0) {
            String filterClass = (String)props.get("com.ibm.ws.security.spnego.SPN" + id + ".filterClass");
            if (filterClass == null || "com.ibm.ws.security.spnego.HTTPHeaderFilter".equals(filterClass) || "com.ibm.ws.security.spnego.HTTPHeaderFilter2".equals(filterClass)) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, ME, "isFilterValid", "filter=\"" + filter + "\"");
                }
                if ("com.ibm.ws.security.spnego.HTTPHeaderFilter".equals(filterClass)) {
                    isValid = HTTPHeaderFilter.isValid(filter);
                } else if ("com.ibm.ws.security.spnego.HTTPHeaderFilter2".equals(filterClass)) {
                    HTTPHeaderFilterBase hfilter = new HTTPHeaderFilterBase();
                    isValid = hfilter.init(filter);
                }
            }
        } else if (filter != null) {
            isValid = false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "isFilterValid", Boolean.toString(isValid));
        }
        return isValid;
    }

    private boolean isValidURL(int id, Map props) {
        boolean isValid;
        block4: {
            if (log.isLoggable(Level.FINE)) {
                log.entering(ME, "isValidURL", "id=" + id + " Map=" + props);
            }
            isValid = true;
            String url = null;
            try {
                url = (String)props.get("com.ibm.ws.security.spnego.SPN" + id + ".NTLMTokenReceivedPage");
                URL res = new URL(url);
                url = (String)props.get("com.ibm.ws.security.spnego.SPN" + id + ".spnegoNotSupportedPage");
                res = new URL(url);
            }
            catch (MalformedURLException e) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.logp(Level.WARNING, ME, "isValidURL", "Malformed URL=" + url, e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "isValidURL", Boolean.toString(isValid));
        }
        return isValid;
    }
}

