/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.spnego.AllServerConfigs;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.SpnegoHandler;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TrustAssociationInterceptorImpl
implements TrustAssociationInterceptor {
    private static final String VERSION = "Version 6.1.0";
    private AllServerConfigs config;
    private static final String ME = TrustAssociationInterceptorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private static HashMap<String, TrustAssociationInterceptorImpl> _cache = new HashMap();
    private static HashMap<String, Properties> _propertiesCache = new HashMap();

    public static synchronized TrustAssociationInterceptorImpl getInstance() {
        TrustAssociationInterceptorImpl cachedInstance;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        String domainID = security2.getDomain();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getInstance", "domainID: " + domainID);
        }
        if ((cachedInstance = _cache.get(domainID)) != null) {
            return cachedInstance;
        }
        cachedInstance = new TrustAssociationInterceptorImpl();
        _cache.put(domainID, cachedInstance);
        return cachedInstance;
    }

    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest hreq, HttpServletResponse hres) throws WebTrustAssociationFailedException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "negotiateValidateandEstablishTrust");
        }
        TAIResult result = null;
        try {
            result = SpnegoHandler.handleRequest(hreq, hres, this.config);
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.negotiateValidateandEstablishTrust", "104", this);
            logger.logp(Level.SEVERE, ME, "negotiateValidateandEstablishTrust", "security.spnego.unexpected.exception", new Object[]{e});
            result = TAIResult.create(403);
        }
        if (result != null && result.getStatus() == 200 && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "negotiateValidateandEstablishTrust", "Authenticated user: " + result.getAuthenticatedPrincipal() + " Subject: " + result.getSubject());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "negotiateValidateandEstablishTrust", result);
        }
        return result;
    }

    public boolean isTargetInterceptor(HttpServletRequest request) throws WebTrustAssociationException {
        Integer port;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isTargetInterceptor");
        }
        if (!this.config.isTAIEnabled()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isTargetInterceptor: TrustAssociationInterceptorImpl is not enabled");
            }
            return false;
        }
        String host = request.getServerName();
        try {
            host = this.config.getCanonicalHostname(host);
        }
        catch (UnknownHostException ue) {
            FFDCFilter.processException(ue, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.isTargetInterceptor", "168");
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isTargetInterceptor: Hostname not resolved");
            }
            return false;
        }
        if (this.config.isIncludePortInSPN() && (port = new Integer(request.getServerPort())) != 80) {
            host = host + ":" + port.toString();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTargetInterceptor", "Checking host match for " + host);
        }
        if (this.config.isReloadEnabled() && this.config.isItTimeToReload()) {
            this.config.reload();
        }
        if (!ServerCredentialsFactory.hasServerCredentialsFor(host)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "isTargetInterceptor: no credentials match");
            }
            return false;
        }
        boolean answer = false;
        ServerConfig server = this.config.getServerConfig(host);
        if (server != null) {
            SpnegoTAIFilter filter;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "isTargetInterceptor", "Got a match for the server config");
            }
            answer = (filter = server.getFilterClass()) == null ? true : filter.isAccepted(request);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTargetInterceptor", "Failed to get a match for the server config");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isTargetInterceptor: " + answer);
        }
        return answer;
    }

    public synchronized int initialize(Properties properties) {
        Locale l2;
        Locale l1;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initialize");
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        String domainID = security2.getDomain();
        Properties propsCache = _propertiesCache.get(domainID);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "initialize", "properties: " + properties);
            logger.logp(Level.FINER, ME, "initialize", "propsCache: " + propsCache);
        }
        if (propsCache != null && propsCache.equals(properties)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "initialize: found properties in cache for domain: " + domainID);
            }
            return 0;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "initialize", "not found properties in cache for domain: " + domainID);
        }
        try {
            this.config = new AllServerConfigs(properties);
        }
        catch (TAIConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.initialize", "269", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.init.failed", e.getLocalizedMessage());
            logger.exiting(ME, "initialize");
            return 1;
        }
        boolean fixLocale = Boolean.getBoolean("com.ibm.ws.security.spnego.LocaleFix");
        if (fixLocale && !(l1 = Locale.getDefault()).equals(l2 = new Locale("en", "US"))) {
            Locale.setDefault(l2);
            logger.logp(Level.WARNING, ME, "initialize", "security.spnego.fix.locale", new Object[]{l1.toString(), l2.toString()});
        }
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "JGSS Initialization started. For detailed JGSS debug trace set JVM property com.ibm.security.jgss.debug=all");
            }
            SpnegoHandler.initializeServerCreds(this.config);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "JGSS Initialization completed.");
            }
        }
        catch (TAIConfigurationException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.TrustAssociationInterceptorImpl.initialize", "302", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.init.failed", new Object[]{e.getMessage(), properties});
            return 1;
        }
        _propertiesCache.clear();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "initialize", "cache it for domainID: " + domainID + " properties: " + properties);
        }
        _propertiesCache.put(domainID, properties);
        logger.logp(Level.INFO, ME, "initialize", "security.spnego.init.ok", new Object[]{this.config.toString()});
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initialize");
        }
        return 0;
    }

    public void cleanup() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "cleanup");
        }
        this.config.cleanup();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "cleanup");
        }
    }

    public String getVersion() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getVersion");
            logger.exiting(ME, "getVersion", VERSION);
        }
        return VERSION;
    }

    public String getType() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getType");
        }
        String answer = this.getClass().getName();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getType", answer);
        }
        return answer;
    }

    protected void setConfiguration(AllServerConfigs config) {
        this.config = config;
    }
}

