/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.spnego.AllServerConfigs;
import com.ibm.ws.security.spnego.Context;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.ws.security.spnego.Util;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public final class SpnegoHandler {
    private static final String USER_PRINCIPAL = "com.ibm.ws.security.spnego.UserPrincipal";
    private static final String ME = SpnegoHandler.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    protected static final byte[] _SPNEGO_IOD = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};

    public static void initializeServerCreds(AllServerConfigs config) throws TAIConfigurationException {
        logger.entering(ME, "initializeServerCreds");
        ServerCredentialsFactory.initializeServerCreds(config);
        logger.exiting(ME, "initializeServerCreds");
    }

    public static TAIResult handleRequest(HttpServletRequest req, HttpServletResponse resp, AllServerConfigs aConfig) throws WebTrustAssociationFailedException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "handleRequest");
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        Boolean taEnabled = security2.getTrustAssociation().getBoolean("enabled");
        boolean spnegoWebEnabled = security2.getAuthMechanism("SPNEGO").getBoolean("spengoEnabled");
        boolean allowAppAuthMethodFallback = security2.getAuthMechanism("SPNEGO").getBoolean("spengoAllowAppAuthMethodFallback");
        TAIResult result = null;
        try {
            String authName;
            boolean done;
            boolean isFirstRequest;
            Integer port;
            String userPrincipal = null;
            String authHeader = req.getHeader("Authorization");
            String serverName = req.getServerName();
            try {
                serverName = aConfig.getCanonicalHostname(serverName);
            }
            catch (UnknownHostException ue) {
                FFDCFilter.processException(ue, "com.ibm.ws.security.spnego.SpnegoHandler.handleRequest", "144");
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(ME, "isTargetInterceptor: no credentials match");
                }
                throw new WebTrustAssociationFailedException(ue.getMessage());
            }
            if (aConfig.isIncludePortInSPN() && (port = new Integer(req.getServerPort())) != 80) {
                serverName = serverName + ":" + port.toString();
            }
            boolean bl = isFirstRequest = authHeader == null;
            if (isFirstRequest) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "No Authorization header found, sending 401 challenge to the client");
                }
                resp.setStatus(401);
                resp.setHeader("WWW-Authenticate", "Negotiate");
                resp.setContentType(aConfig.getServerConfig(serverName).getSpnegoNotSupportedPageContentType());
                try {
                    resp.getWriter().println(aConfig.getServerConfig(serverName).getSpnegoNotSupportedPage());
                    resp.getWriter().close();
                }
                catch (IOException e1) {
                    logger.logp(Level.FINER, ME, "handleRequest", "Error getting the HttpServletResponse's getWriter for SpnegoNotSupportedPage");
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(ME, "handleRequest: Handshake not finished");
                }
                return TAIResult.create(401);
            }
            if (SpnegoHandler.isAuthHeaderNotSPNEGO(authHeader)) {
                block50: {
                    resp.setStatus(401);
                    try {
                        if (taEnabled.booleanValue() || !allowAppAuthMethodFallback && spnegoWebEnabled) {
                            resp.setContentType(aConfig.getServerConfig(serverName).getNtlmTokenReceivedPageContentType());
                            resp.getWriter().println(aConfig.getServerConfig(serverName).getNTLMTokenReceivedPage());
                            resp.getWriter().close();
                        }
                    }
                    catch (IOException e1) {
                        if (!logger.isLoggable(Level.FINER)) break block50;
                        logger.logp(Level.FINER, ME, "handleRequest", "Error getting the HttpServletResponse's getWriter for NTLMTokenReceivedPage");
                    }
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(ME, "handleRequest: Received a non-SPNEGO Authorization Header");
                }
                return TAIResult.create(401);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Found Authorization header, processing SPNEGO request token..");
            }
            StringTokenizer st = new StringTokenizer(authHeader);
            st.nextToken();
            String bytes = st.nextToken();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Client request token before decoding:" + Util.showHex(bytes.getBytes()));
            }
            byte[] request = Base64Coder.base64Decode(bytes.getBytes());
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Client request token as follows...\r\n" + Util.showHex(request));
            }
            Context context = ServerCredentialsFactory.createContext(serverName);
            byte[] response = null;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Context.begin started.");
            }
            Subject subject = new Subject();
            final Context inContext = context;
            final byte[] inRequest = request;
            try {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return inContext.begin(inRequest);
                    }
                };
                try {
                    response = (byte[])Subject.doAsPrivileged(subject, action, AccessController.getContext());
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.spnego.SpnegoHandler.handleRequest", "266");
                    throw new WebTrustAssociationFailedException(e.getMessage());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.spnego.SpnegoHandler.handleRequest", "270");
                throw new WebTrustAssociationFailedException(e.getMessage());
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "handleRequest", "Context.begin completed.");
            }
            if (done = context.isEstablished()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "SPNEGO request token successfully processed.");
                }
                userPrincipal = context.getPrincipalName();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "security.spnego.login", new Object[]{userPrincipal, new Integer(authHeader.length())});
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "Kerberos client principal: " + userPrincipal);
                }
                req.setAttribute(USER_PRINCIPAL, userPrincipal);
                if (response != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        String msg = "handleRequest: Sending back SPNEGO response token\nServer response token as follows...\r\n" + Util.showHex(response);
                        logger.logp(Level.FINER, ME, "handleRequest", msg);
                    }
                    String responseEnc = new String(Base64Coder.base64Encode(response));
                    resp.setHeader("WWW-Authenticate", "Negotiate " + responseEnc);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "handleRequest", "Encoded response: " + responseEnc);
                    }
                }
                KerberosTicket kTicket = null;
                GSSCredential clientCred = null;
                KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(userPrincipal);
                subject.getPrincipals().add(kerberosPrincipal);
                authName = SpnegoHandler.trimUsername(req, userPrincipal, aConfig);
                long lifetime = context.getLifetime();
                KRBAuthnToken krbAuthnToken = null;
                if (aConfig.getServerConfig(serverName).isEnableCredDelegate()) {
                    block52: {
                        try {
                            clientCred = context.getDelegateCred();
                            if (clientCred != null) {
                                subject.getPrivateCredentials().add(clientCred);
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.logp(Level.FINER, ME, "handleRequest", "clientCredential for Principal = " + authName + " has been stored in Subject = " + subject);
                                }
                            } else {
                                logger.logp(Level.WARNING, ME, "handleRequest", "security.spnego.no.delegated.credentials.found", new Object[]{userPrincipal.toString()});
                            }
                        }
                        catch (GSSException e) {
                            if (!logger.isLoggable(Level.FINER)) break block52;
                            logger.logp(Level.FINER, ME, "handleRequest", "Delegated GSSCredential has not been saved in the HttpSession, GSSException: " + e.getMessage());
                        }
                    }
                    kTicket = context.getKrbTicket();
                    if (clientCred != null || kTicket != null || kerberosPrincipal != null) {
                        krbAuthnToken = Krb5Utils.createKRBAuthnToken(kTicket, clientCred, kerberosPrincipal, null, lifetime);
                    } else if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "handleRequest", "No gssCredential, Kerberos ticket and Kerberos principal name. Do not create KRBAuthnToken");
                    }
                } else {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "handleRequest", "Delegated GSSCredential is not enabled.");
                    }
                    if (kerberosPrincipal != null) {
                        krbAuthnToken = Krb5Utils.createKRBAuthnToken(null, null, kerberosPrincipal, null, lifetime);
                    } else if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "handleRequest", "No Kerberos principal name. Do not create KRBAuthnToken");
                    }
                }
                if (krbAuthnToken != null) {
                    subject.getPrivateCredentials().add(krbAuthnToken);
                }
            } else {
                resp.setStatus(401);
                context.dispose();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "handleRequest", "Error processing SPNEGO token, server response token as follows...\r\n" + Util.showHex(response));
                }
                return TAIResult.create(403);
            }
            result = TAIResult.create(200, authName, subject);
            context.dispose();
        }
        catch (GSSException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.spnego.SpnegoHandler.handleRequest", "402");
            logger.logp(Level.SEVERE, ME, "handleRequest", "security.spnego.bad.token", new Object[]{"GSSException: " + e});
            return TAIResult.create(403);
        }
        logger.exiting(ME, "handleRequest", "Successful completion, HttpServletResponse.SC_OK");
        return result;
    }

    private static String trimUsername(HttpServletRequest req, String principal, AllServerConfigs config) {
        Integer port;
        String serverName;
        block12: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(ME, "trimUsername", "Kerberos principal name = " + principal);
            }
            serverName = req.getServerName();
            try {
                serverName = config.getCanonicalHostname(serverName);
            }
            catch (UnknownHostException ue) {
                FFDCFilter.processException(ue, "com.ibm.ws.security.spnego.SpnegoHandler.handleRequest", "436");
                if (!logger.isLoggable(Level.FINER)) break block12;
                logger.exiting(ME, "trimUsername: UnknownHostException");
            }
        }
        if (config.isIncludePortInSPN() && (port = new Integer(req.getServerPort())) != 80) {
            serverName = serverName + ":" + port.toString();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "trimUsername", "serverName = " + serverName);
        }
        String was_principal = principal;
        boolean trimIt = config.getServerConfig(serverName).isTrimUserName();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "trimUsername", "isTrimUserName() = " + trimIt);
        }
        if (trimIt) {
            int i = was_principal.indexOf("@");
            if (i < 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "trimUsername", "There is nothing to trim in the principal name.");
                }
            } else {
                was_principal = was_principal.substring(0, i);
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "trimUsername", "Principal name was trimmed to: " + was_principal);
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "trimUsername: " + was_principal);
        }
        return was_principal;
    }

    private static boolean isAuthHeaderNotSPNEGO(String authHeader) {
        boolean answer = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isAuthHeaderNotSPNEGO", authHeader);
        }
        if (authHeader != null) {
            StringTokenizer st = new StringTokenizer(authHeader);
            st.nextToken();
            String bytes = st.nextToken();
            byte[] request = Base64Coder.base64Decode(bytes.getBytes());
            byte[] OIDfromToken = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            if (bytes.length() >= 12) {
                OIDfromToken = new byte[]{request[4], request[5], request[6], request[7], request[8], request[9], request[10], request[11]};
            }
            if (!new String(OIDfromToken).equals(new String(_SPNEGO_IOD))) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "isAuthHeaderNotSPNEGO", "Client sent back a non-SPNEGO authentication header: " + Util.showHex(OIDfromToken) + "-" + Util.showHex(_SPNEGO_IOD) + "\nRequest: " + Util.showHex(request));
                }
                answer = true;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isAuthHeaderNotSPNEGO", Boolean.toString(answer));
        }
        return answer;
    }
}

