/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.spnego.PageLoader;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class ServerConfig {
    private static final short STR_LENGTH = 200;
    private static final String _SPNEGO_NOT_SUPPORTED_DEFAULT = "<html><head><title>SPNEGO authentication is not supported.</title></head><body>SPNEGO authentication is not supported on this client.</body></html>";
    private static final String _SPNEGO_NOT_SUPPORTED_PAGE_CONTENT = TraceNLS.getFormattedMessage("com.ibm.ws.security.resources.AdminCommandText", "security.spnego.page.content.spnego.not.supported", new Object[0], "<html><head><title>SPNEGO authentication is not supported.</title></head><body>SPNEGO authentication is not supported on this client.</body></html>");
    private PageLoader spnegoNotSupportedPageLoader = new PageLoader("security.spnego.page.content.spnego.not.supported", _SPNEGO_NOT_SUPPORTED_PAGE_CONTENT);
    private static final String _NTLM_TOKEN_RECEIVED_DEFAULT = "<html><head><title>An NTLM Token was received.</title></head><body>Your browser configuration is correct, but you have not logged into a supported Windows Domain.<p>Please login to the application using the normal login page.</html>";
    private static final String _NTLM_TOKEN_RECEIVED_PAGE_CONTENT = TraceNLS.getFormattedMessage("com.ibm.ws.security.resources.AdminCommandText", "security.spnego.page.content.ntlm.token.received", new Object[0], "<html><head><title>An NTLM Token was received.</title></head><body>Your browser configuration is correct, but you have not logged into a supported Windows Domain.<p>Please login to the application using the normal login page.</html>");
    private PageLoader ntlmTokenReceivedPageLoader = new PageLoader("security.spnego.page.content.ntlm.token.received", _NTLM_TOKEN_RECEIVED_PAGE_CONTENT);
    private boolean enableCredDelegate;
    private String filter;
    private SpnegoTAIFilter filterClass;
    private Oid gssNameType;
    private int gssCredType;
    private int gssCredDuration;
    private String hostName;
    private String realm;
    private String serverName;
    private static final String ME = ServerConfig.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private boolean trimUserName;
    private SecurityConfig _security = null;
    boolean useDefaultFilter = true;

    public ServerConfig() {
        boolean useWAS70Filter;
        logger.entering(ME, "<constructor>");
        this.enableCredDelegate = false;
        this.trimUserName = true;
        this.gssNameType = GSSName.NT_USER_NAME;
        this.gssCredType = 2;
        this.gssCredDuration = Integer.MAX_VALUE;
        this.spnegoNotSupportedPageLoader.reset();
        this.ntlmTokenReceivedPageLoader.reset();
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig("security");
        if (security2 != null && (useWAS70Filter = security2.getPropertyBool("com.ibm.ws.security.spnego.useHttpFilterClass2", false))) {
            this.useDefaultFilter = false;
        }
        logger.exiting(ME, "<constructor>: useDefaultFilter: " + this.useDefaultFilter);
    }

    public SpnegoTAIFilter getFilterClass() {
        return this.filterClass;
    }

    public int getGssCredDuration() {
        return this.gssCredDuration;
    }

    public int getGssCredType() {
        return this.gssCredType;
    }

    public Oid getGssNameType() {
        return this.gssNameType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getNTLMTokenReceivedPage() {
        return this.ntlmTokenReceivedPageLoader.getContent();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSpnegoNotSupportedPage() {
        return this.spnegoNotSupportedPageLoader.getContent();
    }

    public boolean isEnableCredDelegate() {
        return this.enableCredDelegate;
    }

    public boolean isTrimUserName() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTrimUserName", "isTrimUserName = " + this.trimUserName);
        }
        return this.trimUserName;
    }

    public void setEnableCredDelegate(String b) {
        Boolean state = Boolean.valueOf(b);
        this.enableCredDelegate = state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setEnableCredDelegate");
            logger.exiting(ME, "setEnableCredDelegate", state);
        }
    }

    public void setFilter(String filterString, SpnegoTAIFilter filterClass) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setFilter", new Object[]{"filter string='" + filterString + "'", "filter class=" + filterClass});
        }
        if (filterString == null || filterString.length() == 0) {
            logger.logp(Level.FINER, ME, "setFilter", "Since no filter is defined, we force all requests to be processed");
            filterClass.setProcessAll(true);
        } else {
            filterClass.init(filterString);
        }
        this.filter = filterString;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setFilter");
        }
    }

    public void setFilterClass(String filterClassProp) throws TAIConfigurationException {
        ExtClassLoader contextCL;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setFilterClass", filterClassProp);
        }
        if (filterClassProp == null || filterClassProp.length() == 0) {
            filterClassProp = !this.useDefaultFilter ? "com.ibm.ws.security.spnego.HTTPHeaderFilter2" : "com.ibm.ws.security.spnego.HTTPHeaderFilter";
        }
        if ((contextCL = ExtClassLoader.getInstance()) == null) {
            throw new TAIConfigurationException("Classloader initialization error");
        }
        try {
            Class<?> myClass = Class.forName(filterClassProp, true, contextCL);
            this.filterClass = (SpnegoTAIFilter)myClass.newInstance();
            if (!(this.filterClass instanceof SpnegoTAIFilter)) {
                throw new TAIConfigurationException("Wrong FilterClass implementation");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new TAIConfigurationException("FilterClass could not be found: " + filterClassProp);
        }
        catch (Exception e) {
            throw new TAIConfigurationException("Error initializing the FilterClass");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setFilterClass", "FilterClass set to " + this.filterClass.getClass());
        }
    }

    public void setGssCredDuration(String string) {
        String state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssCredDuration", string);
        }
        if (string.trim().equalsIgnoreCase("DEFAULT")) {
            this.gssCredDuration = 0;
            state = "GSSCredential.DEFAULT_LIFETIME";
        } else {
            this.gssCredDuration = Integer.MAX_VALUE;
            state = "GSSCredential.INDEFINITE_LIFETIME";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssCredDuration", "Credential duration set to " + state);
        }
    }

    public void setGssCredType(String string) {
        String state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssCredType", string);
        }
        if ((string = string.trim()).equalsIgnoreCase("INITIATE")) {
            this.gssCredType = 1;
            state = "GSSCredential.INITIATE_ONLY";
        } else if (string.equalsIgnoreCase("BOTH")) {
            this.gssCredType = 0;
            state = "GSSCredential.INITIATE_AND_ACCEPT";
        } else {
            this.gssCredType = 2;
            state = "GSSCredential.ACCEPT_ONLY";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssCredType", "Credential type set to " + state);
        }
    }

    public void setGssNameType(String string) {
        String state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssNameType", string);
        }
        if (string.trim().equalsIgnoreCase("NT_HOSTBASED_SERVICE")) {
            this.gssNameType = GSSName.NT_HOSTBASED_SERVICE;
            state = "GSSName.NT_HOSTBASED_SERVICE";
        } else {
            this.gssNameType = GSSName.NT_USER_NAME;
            state = "GSSName.NT_USER_NAME";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssNameType", "Credential name type set to " + state);
        }
    }

    public void setNTLMTokenReceivedPage(String purl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setNTLMTokenReceivedPage", purl);
        }
        this.ntlmTokenReceivedPageLoader.setUrlName(purl);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setNTLMTokenReceivedPage");
        }
    }

    public void setRealm(String string) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setRealm", string);
        }
        if (string == null) {
            throw new TAIConfigurationException("Kerberos Realm property is not set");
        }
        this.realm = string.toUpperCase().trim();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setRealm", "Kerberos realm set to " + this.realm);
        }
    }

    public void setServerName(String string) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setServerName", string);
        }
        if (string == null) {
            throw new TAIConfigurationException("Required property HostName is not set");
        }
        this.hostName = string = string.trim();
        this.serverName = string;
        StringBuffer result = new StringBuffer();
        if (this.gssNameType == GSSName.NT_HOSTBASED_SERVICE) {
            result.append("HTTP@");
            result.append(string);
        } else if (this.gssNameType == GSSName.NT_USER_NAME) {
            result.append("HTTP/");
            result.append(string);
            result.append("@");
            result.append(this.realm);
        }
        this.serverName = result.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setServerName", "hostName = " + this.hostName + "; serverName = " + this.serverName);
        }
    }

    public void setSpnegoNotSupportedPage(String purl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setSpnegoNotSupportedPage", purl);
        }
        this.spnegoNotSupportedPageLoader.setUrlName(purl);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setSpnegoNotSupportedPage");
        }
    }

    public void setTrimUserName(String b) {
        this.trimUserName = Boolean.valueOf(b);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setTrimUserName", b);
            logger.exiting(ME, "setTrimUserName");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        String keyName = "com.ibm.ws.security.spnego.SPN";
        sb.append("\t").append("Server configuration:");
        sb.append("\n\tKerberos ServicePrincipalName=").append(this.getServerName());
        sb.append("\n\t").append(keyName + ".filter" + "=").append(this.filter);
        sb.append("\n\t").append(keyName + ".filterClass" + "=").append(this.getFilterClass());
        sb.append("\n\t").append(keyName + ".NTLMTokenReceivedPage" + "=").append(this.ntlmTokenReceivedPageLoader.getUrlName());
        sb.append("\n\t").append(keyName + ".spnegoNotSupportedPage" + "=").append(this.spnegoNotSupportedPageLoader.getUrlName());
        return sb.toString();
    }

    public String getNtlmTokenReceivedPageContentType() {
        String contentType = this.ntlmTokenReceivedPageLoader.getContentType();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getNtlmTokenReceivedPageContentType", "contentType: " + contentType);
        }
        return contentType;
    }

    public String getSpnegoNotSupportedPageContentType() {
        String contentType = this.spnegoNotSupportedPageLoader.getContentType();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getSpnegoNotSupportedPageContentType", "contentType: " + contentType);
        }
        return contentType;
    }
}

