/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

class PageLoader {
    private static final String ME = PageLoader.class.getName();
    private static final Logger logger = Logger.getLogger(PageLoader.class.getName(), "com.ibm.ws.security.spnego.resources.TAIMsgs");
    static String defaultContentEncoding = null;
    private static final String HTTP_CONTENT_ENCODING_MARKER = ";charset=";
    private final transient String id;
    private final transient String defaultPageContent;
    private transient String urlName;
    private transient String contentType;
    private transient String contentEncoding;
    transient String content;

    PageLoader(String id, String defaultPageContent) {
        this.id = id;
        this.defaultPageContent = defaultPageContent;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "PageLoader", this);
        }
    }

    public String toString() {
        return this.id;
    }

    void reset() {
        this.contentType = null;
        this.contentEncoding = null;
        this.urlName = null;
        this.content = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "reset", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadPage() {
        block35: {
            block31: {
                block34: {
                    block30: {
                        in = null;
                        isr = null;
                        br = null;
                        try {
                            try {
                                if (PageLoader.logger.isLoggable(Level.FINER)) {
                                    PageLoader.logger.entering(PageLoader.ME, "loadPage", new Object[]{this, this.urlName});
                                }
                                if (this.urlName != null && (pageConnection = (pageURL = new URL(this.urlName)).openConnection()) != null) {
                                    in = pageConnection.getInputStream();
                                    this.contentType = pageConnection.getContentType();
                                    if (PageLoader.logger.isLoggable(Level.FINER)) {
                                        PageLoader.logger.logp(Level.FINER, PageLoader.ME, "loadPage", "contentType: {0}", this.contentType);
                                    }
                                    if (this.contentType == null || "content/unknown".equalsIgnoreCase(this.contentType)) {
                                        this.contentType = "text/*";
                                    }
                                    this.contentEncoding = pageConnection.getContentEncoding();
                                    if (this.contentEncoding == null) {
                                        this.contentEncoding = this.getContentEncodingFromHttpContentType(this.contentType);
                                    }
                                    if (this.contentEncoding == null) {
                                        this.contentEncoding = this.getDefaultContentEncoding();
                                    }
                                    if (PageLoader.logger.isLoggable(Level.FINEST)) {
                                        PageLoader.logger.logp(Level.FINEST, PageLoader.ME, "loadPage", "contentEncoding: {0}", this.contentEncoding);
                                    }
                                    isr = new InputStreamReader(in, this.contentEncoding);
                                    br = new BufferedReader(isr);
                                    pageBuffer = new StringBuffer();
                                    while ((line = br.readLine()) != null) {
                                        pageBuffer.append(line);
                                        pageBuffer.append("\r\n");
                                    }
                                    this.content = pageBuffer.toString();
                                    var9_9 = null;
                                    break block30;
                                }
                                this.setDefaults();
                                break block31;
                            }
                            catch (Exception e) {
                                block32: {
                                    FFDCFilter.processException((Throwable)e, PageLoader.ME + ".loadPage", "175", this);
                                    PageLoader.logger.logp(Level.WARNING, PageLoader.ME, "loadPage", "security.spnego.no.content.loaded", new Object[]{this.urlName, e});
                                    this.setDefaults();
                                    var9_11 = null;
                                    try {
                                        if (br != null) {
                                            br.close();
                                        }
                                        if (isr != null) {
                                            isr.close();
                                        }
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        if (!PageLoader.logger.isLoggable(Level.FINE)) break block32;
                                        PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", e);
                                    }
                                }
                                if (PageLoader.logger.isLoggable(Level.FINER) == false) return;
                                PageLoader.logger.exiting(PageLoader.ME, "loadPage");
                                return;
                            }
                        }
                        catch (Throwable var8_17) {
                            block33: {
                                var9_12 = null;
                                ** try [egrp 2[TRYBLOCK] [6 : 389->416)] { 
lbl62:
                                // 1 sources

                                if (br != null) {
                                    br.close();
                                }
                                if (isr != null) {
                                    isr.close();
                                }
                                if (in != null) {
                                    in.close();
                                }
                                break block33;
lbl69:
                                // 1 sources

                                catch (IOException e) {
                                    if (!PageLoader.logger.isLoggable(Level.FINE)) break block33;
                                    PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", e);
                                }
                            }
                            if (PageLoader.logger.isLoggable(Level.FINER) == false) throw var8_17;
                            PageLoader.logger.exiting(PageLoader.ME, "loadPage");
                            throw var8_17;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 389->416)] { 
lbl78:
                    // 1 sources

                    if (br != null) {
                        br.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    break block34;
lbl85:
                    // 1 sources

                    catch (IOException e) {
                        if (!PageLoader.logger.isLoggable(Level.FINE)) break block34;
                        PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", e);
                    }
                }
                if (PageLoader.logger.isLoggable(Level.FINER) == false) return;
                PageLoader.logger.exiting(PageLoader.ME, "loadPage");
                return;
            }
            var9_10 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 389->416)] { 
lbl95:
            // 1 sources

            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (in != null) {
                in.close();
            }
            break block35;
lbl102:
            // 1 sources

            catch (IOException e) {
                if (!PageLoader.logger.isLoggable(Level.FINE)) break block35;
                PageLoader.logger.logp(Level.FINE, PageLoader.ME, "loadPage", "failed to clean up a stream", e);
            }
        }
        if (PageLoader.logger.isLoggable(Level.FINER) == false) return;
        PageLoader.logger.exiting(PageLoader.ME, "loadPage");
    }

    private final String getContentEncodingFromHttpContentType(String contentType) {
        int pos;
        String encoding = null;
        if (contentType != null && (pos = contentType.indexOf(HTTP_CONTENT_ENCODING_MARKER)) > -1 && pos < contentType.length() - HTTP_CONTENT_ENCODING_MARKER.length() && !this.isValidEncoding(encoding = contentType.substring(pos + HTTP_CONTENT_ENCODING_MARKER.length()))) {
            encoding = null;
        }
        return encoding;
    }

    private final String getDefaultContentEncoding() {
        if (defaultContentEncoding == null) {
            this.synchGetDefaultContentEncoding();
        }
        return defaultContentEncoding;
    }

    private final synchronized void synchGetDefaultContentEncoding() {
        if (defaultContentEncoding == null && !this.isValidEncoding(defaultContentEncoding = System.getProperty("file.encoding"))) {
            defaultContentEncoding = null;
        }
        if (defaultContentEncoding == null) {
            defaultContentEncoding = "UTF-8";
        }
    }

    private final boolean isValidEncoding(String encoding) {
        return Charset.forName(encoding) != null;
    }

    private final void setDefaults() {
        this.urlName = null;
        this.content = this.defaultPageContent;
        this.contentType = "text/html";
        this.contentEncoding = "UTF-8";
    }

    private final void checkLoaded() {
        if (this.content == null) {
            this.loadPage();
        }
    }

    String getContentType() {
        this.checkLoaded();
        return this.contentType;
    }

    String getEncoding() {
        this.checkLoaded();
        return this.contentEncoding;
    }

    String getContent() {
        this.checkLoaded();
        return this.content;
    }

    String getUrlName() {
        return this.urlName;
    }

    void setUrlName(String urlName) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setUrlName", new Object[]{this, urlName});
        }
        this.urlName = urlName;
    }
}

