/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.security.spnego.CredentialManager;
import com.ibm.ws.security.spnego.FailoverException;
import com.ibm.ws.security.spnego.KerberosSSOException;
import com.ibm.ws.security.util.Base64Coder;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DelegatedCredentialExtractor {
    private static final Oid SPNEGOMECHOID;
    private static final Oid KRB5MECHANISMOID;
    private static String LtpaToken;
    private static final String ME;
    private static final Logger logger;

    private DelegatedCredentialExtractor() {
    }

    public static String getSpnegoAuthorizationToken(HttpSession session, String host, String realm) throws KerberosSSOException, FailoverException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getSpnegoAuthorizationToken");
        }
        GSSCredential delegCred = CredentialManager.getDelegatedCredential(session);
        String answer = DelegatedCredentialExtractor.buildSpnegoAuthorizationString(delegCred, host, realm);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getSpnegoAuthorizationToken", "Delegated credentials returned");
        }
        return answer;
    }

    private static String buildSpnegoAuthorizationString(GSSCredential delegCred, String host, String realm) throws KerberosSSOException {
        String token;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "buildSpnegoAuthorizationString");
        }
        if (host == null || realm == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "Unable to build SPN with null fields");
            }
            throw new KerberosSSOException("Unable to build SPN with null fields");
        }
        String SPN = "HTTP/" + host + "@" + realm;
        try {
            GSSManager gssMgr = GSSManager.getInstance();
            if (gssMgr == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "Unable to get Default GSSManager instance");
                }
                throw new KerberosSSOException("Unable to get Default GSSManager instance");
            }
            GSSName backEnd = gssMgr.createName(SPN, GSSName.NT_USER_NAME);
            backEnd = backEnd.canonicalize(SPNEGOMECHOID);
            GSSContext context = gssMgr.createContext(backEnd, SPNEGOMECHOID, delegCred, Integer.MAX_VALUE);
            context.requestMutualAuth(true);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "GSSContext " + context);
            }
            byte[] response = null;
            byte[] request = null;
            int len = 0;
            request = context.initSecContext(response, 0, len);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "initSecContext done");
            }
            token = "Negotiate " + new String(Base64Coder.base64Encode(request));
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "buildSpnegoAuthorizationString", "SPNEGO token\n" + token);
            }
            context.dispose();
        }
        catch (GSSException e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(ME, "buildSpnegoAuthorizationString - GSSException received " + e.getMessage());
            }
            throw new KerberosSSOException(e.getMessage());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "buildSpnegoAuthorizationString", token);
        }
        return token;
    }

    public static void relogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "relogin");
        }
        Cookie[] old = req.getCookies();
        String path = null;
        String domain = null;
        boolean stop = false;
        for (int i = 0; i < old.length; ++i) {
            Cookie c = old[i];
            String name = c.getName();
            if (!name.equals(LtpaToken) || stop) continue;
            path = c.getPath();
            domain = c.getDomain();
            stop = true;
        }
        Cookie cookie = new Cookie(LtpaToken, "");
        cookie.setMaxAge(0);
        cookie.setDomain(domain);
        cookie.setPath(path);
        resp.addCookie(cookie);
        String realURL = req.getRequestURL().toString();
        if (stop) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "relogin", "Redirect back to this ourselves, the TAI should be engaged now!" + realURL);
            }
            resp.sendRedirect(realURL);
        } else {
            logger.logp(Level.WARNING, ME, "relogin", "security.spnego.no.LtpaToken.found", new Object[]{req.getUserPrincipal()});
        }
    }

    static {
        LtpaToken = "LtpaToken";
        ME = DelegatedCredentialExtractor.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
        Oid temp = null;
        try {
            temp = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        KRB5MECHANISMOID = temp;
        try {
            temp = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        SPNEGOMECHOID = temp;
    }
}

