/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.Util;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Context {
    private KerberosTicket krbTicket;
    private long lifetime = 0L;
    private GSSCredential gssCred;
    private GSSContext gssContext;
    private static final String ME = Context.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private static final Oid SPNEGOMECHOID;

    public Context(GSSCredential aGSSCredential) {
        this.gssCred = aGSSCredential;
    }

    public byte[] begin(byte[] request) throws GSSException, PrivilegedActionException, Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "begin", Util.showHex(request));
        }
        this.gssContext = ServerCredentialsFactory.getMgr().createContext(this.gssCred);
        byte[] response = null;
        String property = "javax.security.auth.useSubjectCredsOnly";
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
                return null;
            }
        });
        Subject _subject = new Subject();
        try {
            final GSSContext inServerContext = this.gssContext;
            final byte[] inCredToken = request;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return inServerContext.acceptSecContext(inCredToken, 0, inCredToken.length);
                }
            };
            try {
                response = (byte[])Subject.doAsPrivileged(_subject, action, AccessController.getContext());
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
                throw e.getException();
            }
        }
        catch (GSSException exc) {
            exc.printStackTrace();
            throw exc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.lifetime = 0L;
        this.krbTicket = null;
        if (_subject != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "begin", "_subject: " + _subject);
            }
            this.krbTicket = SubjectHelper.getKerberosTicketFromSubject(_subject);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "begin", "Kerberos ticket: " + this.krbTicket);
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "begin", "subject is null.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "begin", "GSSContext accepted:" + this.gssContext.toString());
        }
        if (!this.gssContext.isEstablished()) {
            String responsebytes = "null";
            if (response != null) {
                responsebytes = Util.showHex(response);
            }
            logger.logp(Level.SEVERE, ME, "begin", "security.spnego.bad.token", new Object[]{responsebytes});
        } else {
            this.lifetime = this.gssContext.getLifetime();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "begin", Util.showHex(response));
        }
        return response;
    }

    public boolean isEstablished() {
        boolean result;
        boolean bl = result = this.gssContext == null ? false : this.gssContext.isEstablished();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isEstablished");
            logger.exiting(ME, "isEstablished", Boolean.toString(result));
        }
        return result;
    }

    public void dispose() throws GSSException {
        this.gssContext.dispose();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "dispose");
            logger.exiting(ME, "dispose");
        }
    }

    public final String getPrincipalName() throws GSSException {
        String result = ((Object)this.gssContext.getSrcName()).toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getPrincipalName");
            logger.exiting(ME, "getPrincipalName", result);
        }
        return result;
    }

    public GSSCredential getDelegateCred() throws GSSException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getDelegateCred");
        }
        GSSCredential deleg = null;
        if (this.gssContext != null && this.gssContext.getCredDelegState()) {
            deleg = this.gssContext.getDelegCred();
            GSSName name = GSSManager.getInstance().createName(((Object)deleg.getName()).toString(), GSSName.NT_USER_NAME, SPNEGOMECHOID);
            int credType = deleg.getUsage();
            int credLifeTime = deleg.getRemainingLifetime();
            deleg.add(name, credLifeTime, credLifeTime, SPNEGOMECHOID, credType);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "getDelegateCred", name + " has been added.");
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getDelegateCred", "Unable to get delegated GSSCredential, GSSContext=" + this.gssContext.toString() + ", GSSCredential=" + this.gssCred);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getDelegateCred", deleg);
        }
        return deleg;
    }

    public KerberosTicket getKrbTicket() {
        return this.krbTicket;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    static {
        Oid temp = null;
        try {
            temp = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException ex) {
            temp = null;
        }
        SPNEGOMECHOID = temp;
    }
}

