/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.SpnegoHandler;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.ws.security.spnego.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AllServerConfigs {
    private int numberOfServers;
    private boolean includePortInSPN = false;
    private static final String ME = AllServerConfigs.class.getName();
    private static Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private Hashtable serverConfigs;
    private boolean taiEnabled;
    private boolean reloadEnabled = false;
    private boolean isProviderConfigured = false;
    private String useSubjCredsValue = null;
    private boolean useSubjCredsState = true;
    private int reloadTimeout;
    private long lastReloadTime;
    private long lastPropFileModifiedTime = 0L;
    private String reloadFile;
    private Properties currentProps;
    private static final short STR_LENGTH = 200;
    private boolean taEnabled = false;
    private boolean dynamicUpdate = false;
    private boolean spnegoWebEnabled = false;
    private boolean allowAppAuthMethodFallback = false;
    private String krb5Config = null;
    private String krb5Keytab = null;
    private boolean canonicalSupport = false;
    private HashMap hostMap;

    private AllServerConfigs() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AllServerConfigs(Properties p) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "<constructor> Properties=" + p);
        }
        long currentLastModifiedTime = 0L;
        boolean spnegoTAIEnabled = Boolean.getBoolean("com.ibm.ws.security.spnego.isEnabled");
        this.getSpnegoWebAuth();
        if (this.spnegoWebEnabled && spnegoTAIEnabled && this.taEnabled) {
            throw new TAIConfigurationException("com.ibm.ws.security.spnego.isEnabled JVM property is true and SPNEGO web authentication is enabled, no further processing will be done.");
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        Boolean canonical_support = security2.getPropertyBool("com.ibm.websphere.security.krb.canonical_host");
        if (canonical_support != null) {
            this.canonicalSupport = canonical_support;
            this.hostMap = new HashMap();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "<constructor>", "com.ibm.websphere.security.krb.canonical_host is configured.");
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "<constructor>", "com.ibm.websphere.security.krb.canonical_host is not defined in the configuration");
        }
        if (this.spnegoWebEnabled) {
            this.setTaiEnabled(true);
        } else {
            boolean ok;
            this.setTaiEnabled(spnegoTAIEnabled);
            if (!this.isTAIEnabled()) {
                throw new TAIConfigurationException("com.ibm.ws.security.spnego.isEnabled JVM property is false or not set, no further processing will be done.");
            }
            String tempReloadTimeout = System.getProperty("com.ibm.ws.security.spnego.propertyReloadTimeout");
            String tempReloadFile = System.getProperty("com.ibm.ws.security.spnego.propertyReloadFile");
            boolean bl = ok = tempReloadTimeout != null && tempReloadFile != null || tempReloadTimeout == null && tempReloadFile == null;
            if (!ok) {
                String detail = "com.ibm.ws.security.spnego.propertyReloadTimeout and com.ibm.ws.security.spnego.propertyReloadFile JVM properties are invalid, both or none must be set.";
                throw new TAIConfigurationException(detail);
            }
            try {
                if (tempReloadTimeout != null && tempReloadTimeout.length() != 0) {
                    this.reloadTimeout = Integer.parseInt(tempReloadTimeout);
                }
            }
            catch (NumberFormatException ex) {
                String detail = "com.ibm.ws.security.spnego.propertyReloadTimeout JVM property value is invalid: " + ex + ". It must be a positive integer.";
                throw new TAIConfigurationException(detail);
            }
            if (tempReloadFile != null && tempReloadFile.length() != 0) {
                try {
                    Properties fileProps = new Properties();
                    fileProps.load(new FileInputStream(tempReloadFile));
                    this.setReloadFile(tempReloadFile);
                    this.setReloadEnabled(true);
                    p = fileProps;
                    File file = new File(tempReloadFile);
                    currentLastModifiedTime = file.lastModified();
                }
                catch (IOException e) {
                    String detail = "com.ibm.ws.security.spnego.propertyReloadFile JVM property value is invalid: " + e.toString();
                    throw new TAIConfigurationException(detail);
                }
            }
        }
        this.setIncludePortInSPN(Boolean.valueOf(System.getProperty("com.ibm.ws.security.spnego.includePortInSPN")));
        this.doLoad(p);
        this.setLastReloadTime();
        this.setCurrentProps(p);
        if (currentLastModifiedTime != 0L) {
            this.lastPropFileModifiedTime = currentLastModifiedTime;
        }
        this.addSpnegoProvider();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "<constructor>");
        }
    }

    private void addSpnegoProvider() throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "addSpnegoProvider");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AllServerConfigs.this.useSubjCredsValue = System.getProperty("javax.security.auth.useSubjectCredsOnly");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "addSpnegoProvider", "useSubjCredsValue = " + AllServerConfigs.this.useSubjCredsValue);
                }
                if (AllServerConfigs.this.useSubjCredsValue == null || AllServerConfigs.this.useSubjCredsValue != null && AllServerConfigs.this.useSubjCredsValue.equalsIgnoreCase("true")) {
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                    AllServerConfigs.this.useSubjCredsState = false;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "addSpnegoProvider", "set useSubjectCredsOnly to false");
                    }
                }
                return null;
            }
        });
        Provider provider = Security.getProvider("IBMSPNEGO");
        if (provider == null) {
            String providerName = "com.ibm.security.jgss.mech.spnego.IBMSPNEGO";
            try {
                Security.addProvider((Provider)Class.forName(providerName).newInstance());
                provider = Security.getProvider("IBMSPNEGO");
                this.isProviderConfigured = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.AllServerConfigs.addSpnegoProvider", "248", this);
                logger.logp(Level.SEVERE, ME, "addSpnegoProvider", "security.spnego.provider.failed", e);
                throw new TAIConfigurationException(e.getLocalizedMessage());
            }
            logger.logp(Level.INFO, ME, "addSpnegoProvider", "security.spnego.init.provider", provider.toString());
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "addSpnegoProvider", provider.toString() + " is already installed.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "addSpnegoProvider");
        }
    }

    public boolean isProviderConfigured() {
        return this.isProviderConfigured;
    }

    public void cleanup() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "cleanup");
        }
        if (this.isProviderConfigured()) {
            Provider provider = Security.getProvider("IBMSPNEGO");
            Security.removeProvider("IBMSPNEGO");
            logger.logp(Level.INFO, ME, "cleanup", "security.spnego.remove.provider", provider.toString());
        }
        if (!this.useSubjCredsState) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (AllServerConfigs.this.useSubjCredsValue != null) {
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", AllServerConfigs.this.useSubjCredsValue);
                    } else {
                        System.clearProperty("javax.security.auth.useSubjectCredsOnly");
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "addSpnegoProvider", "set useSubjectCredsOnly back to " + AllServerConfigs.this.useSubjCredsValue);
                    }
                    return null;
                }
            });
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "cleanup");
        }
    }

    private void doLoad(Properties p) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "doLoad");
        }
        this.numberOfServers = Util.getSpnIdMap("com.ibm.ws.security.spnego.SPN", p).size();
        if (this.numberOfServers < 1) {
            throw new TAIConfigurationException("No properties (com.ibm.ws.security.spnego.SPN*) for the SPNEGO TAI are defined.");
        }
        this.initServerConfigs(p);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "doLoad");
        }
    }

    private void initServerConfigs(Properties p) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initServerConfigs");
        }
        Hashtable<String, ServerConfig> tempServerConfigs = new Hashtable<String, ServerConfig>(this.numberOfServers);
        for (int i = 0; i < this.numberOfServers; ++i) {
            String key = "com.ibm.ws.security.spnego.SPN" + Integer.toString(i + 1);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initServerConfigs", "Setting TAI properties with key = " + key);
            }
            String permGSSNameType = p.getProperty(key + ".GSSNameType");
            String permGSSCredType = p.getProperty(key + ".GSSCredType");
            String permGSSCredDuration = p.getProperty(key + ".GSSCredDuration");
            String permEnableCredDelegate = p.getProperty(key + ".enableCredDelegate");
            String permTrimUserName = p.getProperty(key + ".trimUserName");
            String permHostName = p.getProperty(key + ".hostName");
            if (permHostName == null || permHostName.length() == 0) {
                throw new TAIConfigurationException(key + ".hostName" + " property must be specified.");
            }
            permHostName = permHostName.trim();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initServerConfigs", "Setting TAI configuration for HostName = " + permHostName);
            }
            String permNTLMTokenReceivedPage = null;
            permNTLMTokenReceivedPage = this.spnegoWebEnabled ? p.getProperty(key + ".ntlmTokenReceivedPage") : p.getProperty(key + ".NTLMTokenReceivedPage");
            String permSpnegoNotSupportPage = p.getProperty(key + ".spnegoNotSupportedPage");
            String permFilterClass = p.getProperty(key + ".filterClass");
            String permFilter = p.getProperty(key + ".filter");
            String permRealm = p.getProperty(key + ".krb5Realm");
            if (permRealm == null || permRealm.length() == 0) {
                try {
                    permRealm = Krb5Utils.getKrb5Realm();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.AllServerConfigs.initServerConfigs", "381", this);
                    logger.logp(Level.SEVERE, ME, "initServerConfigs", "security.spnego.krbconf.nodefaultrealm", new Object[]{e});
                    throw new TAIConfigurationException(key + ".krb5Realm" + " " + e.getMessage());
                }
            }
            permRealm = permRealm.trim();
            ServerConfig tempConfig = new ServerConfig();
            if (permGSSNameType != null) {
                tempConfig.setGssNameType(permGSSNameType);
            }
            if (permGSSCredType != null) {
                tempConfig.setGssCredType(permGSSCredType);
            }
            if (permGSSCredDuration != null) {
                tempConfig.setGssCredDuration(permGSSCredDuration);
            }
            if (permEnableCredDelegate != null) {
                tempConfig.setEnableCredDelegate(permEnableCredDelegate);
            }
            if (permNTLMTokenReceivedPage != null) {
                tempConfig.setNTLMTokenReceivedPage(permNTLMTokenReceivedPage);
            }
            if (permSpnegoNotSupportPage != null) {
                tempConfig.setSpnegoNotSupportedPage(permSpnegoNotSupportPage);
            }
            if (permTrimUserName != null) {
                tempConfig.setTrimUserName(permTrimUserName);
            }
            tempConfig.setRealm(permRealm);
            if (this.canonicalSupport) {
                try {
                    permHostName = this.getCanonicalHostname(permHostName);
                }
                catch (UnknownHostException ue) {
                    FFDCFilter.processException((Throwable)ue, "com.ibm.ws.security.spnego.AllServerConfigs.initServerConfigs", "491", this);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "initServerConfigs", "Canonical support specified but error when looking up - " + permHostName + " failed. Aliases will not work.");
                    }
                    throw new TAIConfigurationException(key + ".hostName" + " is unknown.");
                }
            }
            tempConfig.setServerName(permHostName);
            tempConfig.setFilterClass(permFilterClass);
            tempConfig.setFilter(permFilter, tempConfig.getFilterClass());
            if (tempServerConfigs.get(permHostName) == null) {
                tempServerConfigs.put(permHostName, tempConfig);
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.logp(Level.FINER, ME, "initServerConfigs", "Finished adding Config to Hashtable");
                continue;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.logp(Level.FINER, ME, "initServerConfigs", "Config not added to Hashtable - hostname " + permHostName + " is already configured.");
        }
        this.serverConfigs = new Hashtable(this.numberOfServers);
        this.serverConfigs.putAll(tempServerConfigs);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initServerConfigs");
        }
    }

    public synchronized void reload() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "reload");
        }
        if (this.isItTimeToReload()) {
            File file = new File(this.getReloadFile());
            long currentLastModifiedTime = file.lastModified();
            if (currentLastModifiedTime != this.lastPropFileModifiedTime) {
                Properties temp = new Properties();
                try {
                    temp.load(new FileInputStream(this.getReloadFile()));
                    this.doLoad(temp);
                    this.setCurrentProps(temp);
                    this.lastPropFileModifiedTime = currentLastModifiedTime;
                    try {
                        SpnegoHandler.initializeServerCreds(this);
                        logger.logp(Level.INFO, ME, "reload", "security.spnego.reload.ok", new Object[]{this.toString()});
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.AllServerConfigs.reload", "445", this);
                        logger.logp(Level.WARNING, ME, "reload", "security.spnego.reload.initialize.failed");
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.AllServerConfigs.reload", "472", this);
                    logger.logp(Level.WARNING, ME, "reload", "security.spnego.reload.failed");
                }
            } else {
                logger.logp(Level.INFO, ME, "reload", "security.spnego.reload.not.needed");
            }
            this.setLastReloadTime();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "reload");
        }
    }

    public boolean isItTimeToReload() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastLoad = currentTime - this.getLastReloadTime();
        return timeSinceLastLoad > (long)(this.getReloadTimeout() * 1000);
    }

    public final boolean isTAIEnabled() {
        return this.taiEnabled;
    }

    private final void setTaiEnabled(boolean val) {
        this.taiEnabled = val;
    }

    public final boolean isIncludePortInSPN() {
        return this.includePortInSPN;
    }

    public final void setIncludePortInSPN(boolean val) {
        this.includePortInSPN = val;
    }

    private int getNumberOfServers() {
        return this.numberOfServers;
    }

    public Hashtable getServerConfigs() {
        return this.serverConfigs;
    }

    public ServerConfig getServerConfig(String server) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getServerConfig", "server = " + server);
        }
        return (ServerConfig)this.serverConfigs.get(server);
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    private String getReloadFile() {
        return this.reloadFile;
    }

    private int getReloadTimeout() {
        return this.reloadTimeout;
    }

    private void setReloadEnabled(boolean b) {
        this.reloadEnabled = b;
    }

    private void setReloadFile(String string) {
        this.reloadFile = string;
    }

    private void setCurrentProps(Properties p) {
        this.currentProps = p;
    }

    private void setReloadTimeout(int i) {
        this.reloadTimeout = i;
    }

    private long getLastReloadTime() {
        return this.lastReloadTime;
    }

    public void setLastReloadTime() {
        this.lastReloadTime = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "setLastReloadTime", "currentTimeMillis = " + this.lastReloadTime);
        }
    }

    public boolean getCanonicalSupport() {
        return this.canonicalSupport;
    }

    public String getCanonicalHostname(String serverName) throws UnknownHostException {
        block11: {
            if (this.getCanonicalSupport()) {
                String mappedHost = (String)this.hostMap.get(serverName);
                if (mappedHost != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "getCanonicalHostname", "CanonicalSupport has converted " + serverName + " to " + mappedHost);
                    }
                    serverName = mappedHost;
                } else {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "getCanonicalHostname", "CanonicalSupport is configured. serverName is not found in the hostMap. Looking up " + serverName);
                    }
                    try {
                        InetAddress inet = InetAddress.getByName(serverName);
                        String canonicalHostName = inet.getCanonicalHostName();
                        if (this.serverConfigs == null || this.serverConfigs.get(canonicalHostName) != null) {
                            this.hostMap.put(serverName, canonicalHostName);
                            serverName = canonicalHostName;
                            if (logger.isLoggable(Level.FINER)) {
                                logger.logp(Level.FINER, ME, "getCanonicalHostName", "Canonicalization support will map " + serverName + " to " + canonicalHostName);
                            }
                        } else if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, ME, "getCanonicalHostName", serverName + " was resolved to " + canonicalHostName + ". Neither hostname is configured for SPNEGO SSO.");
                        }
                    }
                    catch (UnknownHostException ue) {
                        FFDCFilter.processException((Throwable)ue, "com.ibm.ws.security.spnego.AllServerConfigs.getCanonicalHost", "796", this);
                        if (!logger.isLoggable(Level.FINER)) break block11;
                        logger.logp(Level.FINER, ME, "getCanonicalHostName", "Canonical support specified but error when looking up - " + serverName + "failed. Aliases will not work.");
                    }
                }
            }
        }
        return serverName;
    }

    public String toString() {
        int numServers = this.getNumberOfServers();
        StringBuffer sb = new StringBuffer(200 * numServers);
        if (this.spnegoWebEnabled) {
            sb.append("\tSPNEGO Web Authentication:");
            sb.append("\n\t").append("enabled = ").append(this.spnegoWebEnabled);
            sb.append("\n\t").append("dynamically update = ").append(this.dynamicUpdate);
            sb.append("\n\t").append("allowAppAuthMethodFallback = ").append(this.spnegoWebEnabled);
            sb.append("\n\t").append("krb5Config = ").append(this.krb5Config);
            sb.append("\n\t").append("krb5Keytab = ").append(this.krb5Keytab);
        } else {
            sb.append("\tTAI configuration (JVM) properties:");
            sb.append("\n\t").append("com.ibm.ws.security.spnego.isEnabled=").append(this.isTAIEnabled());
            if (this.isReloadEnabled()) {
                sb.append("\n\t").append("com.ibm.ws.security.spnego.propertyReloadTimeout=").append(this.getReloadTimeout());
                sb.append("\n\t").append("com.ibm.ws.security.spnego.propertyReloadFile=").append(this.getReloadFile());
            }
        }
        Enumeration elem = this.getServerConfigs().elements();
        while (elem.hasMoreElements()) {
            ServerConfig serverConfig = (ServerConfig)elem.nextElement();
            sb.append("\n").append(serverConfig.toString());
        }
        sb.append("\n\t").append("cannonicalSupport=").append(this.getCanonicalSupport());
        return sb.toString();
    }

    public void getSpnegoWebAuth() {
        SecurityConfigManager scm;
        SecurityConfigObjectList dynamicAuthMechs;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        Boolean taEnabled = security2.getTrustAssociation().getBoolean("enabled");
        this.spnegoWebEnabled = security2.getAuthMechanism("SPNEGO").getBoolean("spengoEnabled");
        this.allowAppAuthMethodFallback = security2.getAuthMechanism("SPNEGO").getBoolean("spengoAllowAppAuthMethodFallback");
        this.krb5Config = security2.getAuthMechanism("KRB5").getString("krb5Config");
        if (this.krb5Config != null) {
            Krb5Utils.setKrbConfigProp(this.krb5Config);
        }
        this.krb5Keytab = security2.getAuthMechanism("KRB5").getString("krb5Keytab");
        if (this.krb5Keytab != null) {
            Krb5Utils.setKrbKeytabProp(this.krb5Keytab);
        }
        if ((dynamicAuthMechs = (scm = SecurityObjectLocator.getSecurityConfigManager()).getObjectList("Security::dynamicReload::authMechanisms")) != null) {
            for (int ix = 0; ix < dynamicAuthMechs.size(); ++ix) {
                SecurityConfigObject authMech = dynamicAuthMechs.get(ix);
                if (!authMech.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi", "SPNEGO")) continue;
                this.dynamicUpdate = true;
            }
        }
    }
}

