/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.securitydomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.securitydomain.SecurityDomainCheckerPlugin;
import com.ibm.wsspi.security.securitydomain.SecurityDomainChecker;
import com.ibm.wsspi.security.securitydomain.SecurityDomainValidationException;
import java.util.Iterator;
import java.util.List;

public class DomainCheckerExtensionsProcessor {
    private static TraceComponent tc = Tr.register(DomainCheckerExtensionsProcessor.class, "security", "com.ibm.ws.security.securitydomain");
    private static DomainCheckerExtensionsProcessor checkerProcessor = new DomainCheckerExtensionsProcessor();

    private DomainCheckerExtensionsProcessor() {
    }

    public static DomainCheckerExtensionsProcessor getProcessor() {
        return checkerProcessor;
    }

    public boolean processHandleResource(String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processHandleResource: type = ", resourceType);
        }
        boolean handled = false;
        List extensions = SecurityDomainCheckerPlugin.getPlugin().getExtensionsList();
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext() && !handled) {
                SecurityDomainChecker aChecker = (SecurityDomainChecker)i.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling security domain checker extension", aChecker);
                    }
                    handled = aChecker.handleResource(resourceType);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from security domain checker extension for handleResource", new Object[]{aChecker, handled});
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProcessor", "638", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processHandleResource", new Boolean(handled));
        }
        return handled;
    }

    public boolean processValidateResource(String resourceName, String resourceType) throws SecurityDomainValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processValidateResource: ", resourceName + " of type: " + resourceType);
        }
        boolean validated = false;
        List extensions = SecurityDomainCheckerPlugin.getPlugin().getExtensionsList();
        if (extensions != null) {
            boolean handled = false;
            Iterator i = extensions.iterator();
            while (i.hasNext() && !validated) {
                SecurityDomainChecker aChecker = (SecurityDomainChecker)i.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling security domain checker extension", aChecker);
                    }
                    if (handled = aChecker.handleResource(resourceType)) {
                        validated = aChecker.validateResource(resourceName, resourceType);
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from security domain checker extension for validateResource", new Object[]{aChecker, validated});
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProce", "638", this);
                    if (!handled) continue;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processValidateResource", new Boolean(validated));
        }
        return validated;
    }

    public boolean processAcceptSyncFolder(String resourceConfigId, String resourceType, String node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAcceptSyncFolder: ", resourceConfigId + " of type: " + resourceType);
        }
        boolean accepted = false;
        List extensions = SecurityDomainCheckerPlugin.getPlugin().getExtensionsList();
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext() && !accepted) {
                SecurityDomainChecker aChecker = (SecurityDomainChecker)i.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling security domain checker extension", aChecker);
                    }
                    accepted = aChecker.acceptSyncFolder(resourceConfigId, resourceType, node);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from security domain checker extension for validateResource", new Object[]{aChecker, accepted});
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProce", "638", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAcceptSyncFolder", new Boolean(accepted));
        }
        return accepted;
    }

    public boolean processValidateResource(String resourceName, String resourceType, Session session) throws SecurityDomainValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processValidateResource: ", resourceName + " of type: " + resourceType);
        }
        boolean validated = false;
        List extensions = SecurityDomainCheckerPlugin.getPlugin().getExtensionsList();
        if (extensions != null) {
            boolean handled = false;
            Iterator i = extensions.iterator();
            while (i.hasNext() && !validated) {
                SecurityDomainChecker aChecker = (SecurityDomainChecker)i.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling security domain checker extension", aChecker);
                    }
                    if (handled = aChecker.handleResource(resourceType)) {
                        validated = aChecker.validateResource(resourceName, resourceType, session);
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from security domain checker extension for validateResource", new Object[]{aChecker, validated});
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProce", "638", this);
                    if (!handled) continue;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processValidateResource", new Boolean(validated));
        }
        return validated;
    }

    public void processCellDomainMapped(Session session, ConfigService configService) throws Exception {
        List extensions;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCellDomainMapped");
        }
        if ((extensions = SecurityDomainCheckerPlugin.getPlugin().getExtensionsList()) != null) {
            for (SecurityDomainChecker aChecker : extensions) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling security domain checker extension", aChecker);
                    }
                    aChecker.cellDomainMapped(session, configService);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Back from security domain checker extension for cellDomainMapped");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.securitydomain.DomainCheckerExtensionsProce", "%c%", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCellDomainMapped");
        }
    }
}

