/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.securitydomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.NodeVersionUtils;
import com.ibm.wsspi.security.securitydomain.SecurityDomainChecker;
import com.ibm.wsspi.security.securitydomain.SecurityDomainValidationException;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DomainCheckerExtension
extends SecurityDomainChecker {
    private static TraceComponent tc = Tr.register(DomainCheckerExtension.class, "security", "com.ibm.ws.security.securitydomain");
    private static final String CELL = "Cell";
    private static final String SERVER = "Server";
    private static final String SERVERCLUSTER = "ServerCluster";
    private static final String CLUSTER = "Cluster";

    public boolean handleResource(String type) {
        boolean handled = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResource", type);
        }
        if (type.equals(SERVER)) {
            handled = true;
        } else if (type.equals(CELL)) {
            handled = true;
        } else if (type.equals(CLUSTER)) {
            handled = true;
        } else if (type.equals(SERVERCLUSTER)) {
            handled = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResource", new Boolean(handled));
        }
        return handled;
    }

    /*
     * Loose catch block
     */
    public boolean validateResource(String resourceName, String resourceType) throws SecurityDomainValidationException {
        boolean validated;
        block19: {
            Session session;
            ConfigService configService;
            block18: {
                validated = true;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "validateResource: ", resourceName + " of type: " + resourceType);
                }
                configService = null;
                session = null;
                ObjectName[] resourceObjectName = null;
                session = new Session();
                CommandProviderHelper helper = CommandMgr.getCommandMgr().getCommandProviderHelper();
                configService = helper.getConfigService();
                resourceObjectName = configService.resolve(session, resourceName);
                Properties resourceProps = ConfigServiceHelper.getObjectLocation(resourceObjectName[0]);
                String nodeName = resourceProps.getProperty("node");
                if (nodeName != null) {
                    if (!NodeVersionUtils.isNodeValid((String)nodeName, (Session)session, (int)7, (int)0)) {
                        throw new SecurityDomainValidationException();
                    }
                    break block18;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resource type = ", resourceType);
                }
                if (!resourceType.equals(SERVERCLUSTER) && !resourceType.equals(CLUSTER)) break block18;
                this.checkClusterMembers(resourceObjectName[0], session, configService);
            }
            Object var11_12 = null;
            try {
                if (session != null) {
                    configService.discard(session);
                }
                break block19;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception trying to discard a Session object", e.getMessage());
                }
                break block19;
            }
            {
                catch (ConfigServiceException cse) {
                    FFDCFilter.processException(cse, "com.ibm.ws.security.securitydomain.DomainCheckeExtension", "1106");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception validating resource", cse);
                    }
                    throw new SecurityDomainValidationException(cse);
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.securitydomain.DomainCheckeExtension", "1112");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception validating resource", e);
                    }
                    throw new SecurityDomainValidationException(e);
                }
            }
            catch (Throwable throwable) {
                block20: {
                    Object var11_13 = null;
                    try {
                        if (session != null) {
                            configService.discard(session);
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "caught exception trying to discard a Session object", e.getMessage());
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResource", new Boolean(validated));
        }
        return validated;
    }

    private void checkClusterMembers(ObjectName clusterObject, Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkClusterMembers", clusterObject);
        }
        List members = (List)configService.getAttribute(session, clusterObject, "members");
        for (AttributeList member : members) {
            String memberName = (String)ConfigServiceHelper.getAttributeValue(member, "memberName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberName", memberName);
            }
            String nodeName = (String)ConfigServiceHelper.getAttributeValue(member, "nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", nodeName);
            }
            if (NodeVersionUtils.isNodeValid((String)nodeName, (Session)session, (int)7, (int)0)) continue;
            throw new SecurityDomainValidationException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkClusterMembers");
        }
    }

    public boolean acceptSyncFolder(String resourceName, String resourceType, String node) {
        boolean accepted = false;
        return accepted;
    }

    /*
     * Loose catch block
     */
    public boolean validateResource(String resourceName, String resourceType, Object session) throws SecurityDomainValidationException {
        boolean validated;
        block23: {
            Session tempSession;
            ConfigService configService;
            block22: {
                CommandProviderHelper helper;
                Properties resourceProps;
                String nodeName;
                validated = true;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "validateResource: ", resourceName + " of type: " + resourceType);
                }
                configService = null;
                tempSession = null;
                ObjectName[] resourceObjectName = null;
                if (session == null) {
                    tempSession = new Session();
                    session = tempSession;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "warning: was passed in null session object, a new session is created.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the passed in session object is not null, using it.");
                }
                if ((nodeName = (resourceProps = ConfigServiceHelper.getObjectLocation((resourceObjectName = (configService = (helper = CommandMgr.getCommandMgr().getCommandProviderHelper()).getConfigService()).resolve((Session)session, resourceName))[0])).getProperty("node")) != null) {
                    if (!NodeVersionUtils.isNodeValid((String)nodeName, (Session)((Session)session), (int)7, (int)0)) {
                        throw new SecurityDomainValidationException();
                    }
                    break block22;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resource type = ", resourceType);
                }
                if (!resourceType.equals(SERVERCLUSTER) && !resourceType.equals(CLUSTER)) break block22;
                this.checkClusterMembers(resourceObjectName[0], (Session)session, configService);
            }
            Object var12_13 = null;
            try {
                if (tempSession != null) {
                    configService.discard(tempSession);
                }
                break block23;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception trying to discard a Session object", e.getMessage());
                }
                break block23;
            }
            {
                catch (ConfigServiceException cse) {
                    FFDCFilter.processException(cse, "com.ibm.ws.security.securitydomain.DomainCheckeExtension", "1106");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception validating resource", cse);
                    }
                    throw new SecurityDomainValidationException(cse);
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.securitydomain.DomainCheckeExtension", "1112");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception validating resource", e);
                    }
                    throw new SecurityDomainValidationException(e);
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Object var12_14 = null;
                    try {
                        if (tempSession != null) {
                            configService.discard(tempSession);
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block24;
                        Tr.debug(tc, "caught exception trying to discard a Session object", e.getMessage());
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResource", new Boolean(validated));
        }
        return validated;
    }
}

