/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.security.scanner.Controller;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public class reportSecurityCheck
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(reportSecurityCheck.class, "reportSecurityCheck", "com.ibm.wsspi.security.scanner.commands");
    private String outputFile = null;
    private String checksToRun = null;

    public reportSecurityCheck(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public reportSecurityCheck(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "beforeStepsExecuted");
            }
            super.beforeStepsExecuted();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            Locale locale = this.getLocale();
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "beforeStepsExecuted");
                }
                return;
            }
            try {
                this.checksToRun = (String)this.getParameter("checksToRun");
                ArrayList<String> checksToRunList = null;
                if (this.checksToRun != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Running individual checks using checksToRun paramater");
                    }
                    checksToRunList = new ArrayList();
                    StringTokenizer strTok = new StringTokenizer(this.checksToRun, ",");
                    while (strTok.hasMoreTokens()) {
                        checksToRunList.add(strTok.nextToken().trim());
                    }
                } else {
                    checksToRunList = new ArrayList<String>(0);
                }
                Controller controller = new Controller();
                String s = controller.run(locale, checksToRunList);
                this.outputFile = (String)this.getParameter("outputFile");
                if (this.outputFile == null) {
                    result.setResult(s);
                    break block22;
                }
                try {
                    File outFile = new File(this.outputFile);
                    String parent = outFile.getParent();
                    File parentFile = null;
                    if (parent != null) {
                        parentFile = new File(parent);
                        parentFile.mkdirs();
                    } else {
                        String userInstallRoot = System.getProperty("user.install.root");
                        if (userInstallRoot != null) {
                            outFile = new File(userInstallRoot + File.separator + "logs" + File.separator + this.outputFile);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Printing Security Vulnerability Scanner report to file: " + outFile.getAbsolutePath());
                    }
                    BufferedWriter output = new BufferedWriter(new FileWriter(outFile));
                    PrintWriter pw = new PrintWriter(output);
                    pw.print(s);
                    result.setResult(Controller.getFormattedMessage("security.scanner.write.to.file", new Object[]{outFile.getAbsolutePath()}));
                    try {
                        pw.close();
                        output.close();
                    }
                    catch (IOException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not close output file" + this.outputFile + " for the following reason: " + e);
                        }
                    }
                }
                catch (IOException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not create output file " + this.outputFile + " for the following reason: " + e);
                    }
                    result.setException(new CommandException(e));
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reportSecurityCheck command failed", e);
                }
                result.setException(new CommandException(e, "reportSecurityCheck command failed"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

