/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.scanner.Controller;
import com.ibm.wsspi.security.scanner.ConfigChecker;
import com.ibm.wsspi.security.scanner.ConfigHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

public class SamplesChecker
implements ConfigChecker {
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    ArrayList report;
    boolean defaultApp;
    boolean plantsApp;
    boolean samplesGalleryApp;
    boolean techApp;
    boolean webSvcApp;
    boolean petStoreApp;
    boolean activityApp;
    boolean albumApp;
    boolean accountApp;
    boolean traderApp;
    boolean dynamicQApp;
    boolean facesClientApp;
    boolean currencyExApp;
    boolean JTAExtApp;
    boolean accountReport;
    boolean appClientsApp;
    boolean beenThereApp;
    boolean compContextApp = false;
    int index = 0;
    private ConfigHashMap resultMap = null;
    private static final TraceComponent tc = Tr.register(SamplesChecker.class, "Security", "com.ibm.ejs.resources.security");

    public int doCheck(String path, Locale locale, ArrayList output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCheck", new Object[]{path, locale, output, this});
        }
        this.report = output;
        this.profileName = path;
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        this.fileFound = false;
        this.resultMap = new ConfigHashMap();
        int result = 1;
        int tempResult = this.checkInConfig(f);
        if (tempResult > result) {
            result = tempResult;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCheck");
        }
        return result;
    }

    private int reportSamplesStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reportSamplesStatus", this);
        }
        int result = 1;
        if (this.defaultApp || this.plantsApp || this.samplesGalleryApp || this.techApp || this.webSvcApp || this.petStoreApp || this.activityApp || this.albumApp || this.accountApp || this.traderApp || this.dynamicQApp || this.facesClientApp || this.currencyExApp || this.JTAExtApp || this.accountReport || this.appClientsApp || this.beenThereApp || this.compContextApp) {
            String sampleApplications = " ";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebSphere Application Server Sample Applications are installed");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.samples.improve"));
            if (this.defaultApp) {
                sampleApplications = sampleApplications + "DefaultApplication.ear ";
            }
            if (this.plantsApp) {
                sampleApplications = sampleApplications + "PlantsByWebSphere.ear ";
            }
            if (this.samplesGalleryApp) {
                sampleApplications = sampleApplications + "SamplesGallery.ear ";
            }
            if (this.techApp) {
                sampleApplications = sampleApplications + "TechnologySamples.ear ";
            }
            if (this.webSvcApp) {
                sampleApplications = sampleApplications + "WebServicesSamples.ear ";
            }
            if (this.petStoreApp) {
                sampleApplications = sampleApplications + "petstore.ear ";
            }
            if (this.activityApp) {
                sampleApplications = sampleApplications + "activitysession.ear ";
            }
            if (this.albumApp) {
                sampleApplications = sampleApplications + "AlbumCatalog.ear ";
            }
            if (this.accountApp) {
                sampleApplications = sampleApplications + "AccountManagement.ear ";
            }
            if (this.traderApp) {
                sampleApplications = sampleApplications + "WebSphereTrader.ear ";
            }
            if (this.dynamicQApp) {
                sampleApplications = sampleApplications + "DynamicQuery.ear ";
            }
            if (this.facesClientApp) {
                sampleApplications = sampleApplications + "FacesClientTutorial.ear ";
            }
            if (this.currencyExApp) {
                sampleApplications = sampleApplications + "CurrencyExchange.ear ";
            }
            if (this.JTAExtApp) {
                sampleApplications = sampleApplications + "JTAExtensionsSamples.ear ";
            }
            if (this.accountReport) {
                sampleApplications = sampleApplications + "AccountReport.ear ";
            }
            if (this.appClientsApp) {
                sampleApplications = sampleApplications + "ApplicationClients.ear ";
            }
            if (this.compContextApp) {
                sampleApplications = sampleApplications + "CompanyContext.ear ";
            }
            if (this.beenThereApp) {
                sampleApplications = sampleApplications + "BeenThere.ear ";
            }
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.samples") + sampleApplications);
            this.report.add(this.index, this.resultMap);
            result = 2;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebSphere Application Server Sample Applications are not installed");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.samples.ok"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
            this.report.add(this.index, this.resultMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reportSamplesStatus", new Integer(result));
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public String getCheckName() {
        return Controller.getNLSString("security.scanner.check.samples");
    }

    public String getCategory() {
        return Controller.getNLSString("security.scanner.category.samples");
    }

    public String getPriority() {
        return Controller.getNLSString("security.scanner.priority.medium");
    }

    public int getOrderNumber() {
        return 7;
    }

    public String getProfileName() {
        return this.pathName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComponentName() {
        return Controller.getNLSString("security.scanner.component.security");
    }

    private int checkInConfig(File f) {
        int reportResult;
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("installedApps")) continue;
            int tempResult = this.checkForSamples(kiddos[i]);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        if ((reportResult = this.reportSamplesStatus()) > result) {
            result = reportResult;
        }
        return result;
    }

    private int checkForSamples(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory()) continue;
            File[] kiddosChild = kiddos[i].listFiles();
            for (int j = 0; j < kiddosChild.length; ++j) {
                int tempResult;
                if (!kiddosChild[j].getName().endsWith("ear") || (tempResult = this.checkIfSample(kiddosChild[j])) <= result) continue;
                result = tempResult;
            }
        }
        return result;
    }

    private int checkIfSample(File file) {
        int result = 1;
        String fileName = file.getName();
        if (fileName.equals("DefaultApplication.ear")) {
            this.defaultApp = true;
        }
        if (fileName.equals("PlantsByWebSphere.ear")) {
            this.plantsApp = true;
        }
        if (fileName.equals("SamplesGallery.ear")) {
            this.samplesGalleryApp = true;
        }
        if (fileName.equals("TechnologySamples.ear")) {
            this.techApp = true;
        }
        if (fileName.equals("WebServicesSamples.ear")) {
            this.webSvcApp = true;
        }
        if (fileName.equals("petstore.ear")) {
            this.petStoreApp = true;
        }
        if (fileName.equals("activitysession.ear")) {
            this.activityApp = true;
        }
        if (fileName.equals("AlbumCatalog.ear")) {
            this.albumApp = true;
        }
        if (fileName.equals("AccountManagement.ear")) {
            this.accountApp = true;
        }
        if (fileName.equals("WebSphereTrader.ear")) {
            this.traderApp = true;
        }
        if (fileName.equals("DynamicQuery.ear")) {
            this.dynamicQApp = true;
        }
        if (fileName.equals("FacesClientTutorial.ear")) {
            this.facesClientApp = true;
        }
        if (fileName.equals("CurrencyExchange.ear")) {
            this.currencyExApp = true;
        }
        if (fileName.equals("JTAExtensionsSamples.ear")) {
            this.JTAExtApp = true;
        }
        if (fileName.equals("AccountReport.ear")) {
            this.accountReport = true;
        }
        if (fileName.equals("ApplicationClients.ear")) {
            this.appClientsApp = true;
        }
        if (fileName.equals("CompanyContext.ear")) {
            this.compContextApp = true;
        }
        if (fileName.equals("BeenThere.ear")) {
            this.beenThereApp = true;
        }
        return result;
    }
}

