/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.scanner.Controller;
import com.ibm.wsspi.security.scanner.ConfigChecker;
import com.ibm.wsspi.security.scanner.ConfigHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CorbaNSChecker
implements ConfigChecker {
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    ArrayList report;
    String globalEnabled = "false";
    int index = 0;
    private ConfigHashMap resultMap = null;
    private static final TraceComponent tc = Tr.register(CorbaNSChecker.class, "Security", "com.ibm.ejs.resources.security");

    public int doCheck(String path, Locale locale, ArrayList output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCheck", new Object[]{path, locale, output, this});
        }
        this.report = output;
        this.profileName = path;
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        this.fileFound = false;
        this.resultMap = new ConfigHashMap();
        int result = 1;
        int tempResult = this.checkInConfig(f);
        if (tempResult > result) {
            result = tempResult;
        }
        String fileName = path + File.separator + "config" + File.separator + "cells" + File.separator + Controller.getCellName() + File.separator + "naming-authz.xml";
        if (!this.fileFound) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{fileName});
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.undetermined"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.undetermined"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.undetermined"));
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{fileName}));
            this.report.add(this.index, this.resultMap);
            result = 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCheck", new Integer(result));
        }
        return result;
    }

    private int findAdminIdInXMLDoc(Document d) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAdminIdInXMLDoc", new Object[]{d, this});
        }
        int result = 1;
        Object roleName = null;
        int read = 10;
        int write = 10;
        int create = 10;
        int delete = 10;
        int everyone = 1;
        int allAuth = 2;
        int userid = 3;
        int serverid = 4;
        NodeList auth = d.getElementsByTagName("authorizations");
        if (auth.getLength() == 0) {
            Tr.error(tc, Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{"naming-authx.xml", "No authorizations field in naming-authz.xml file."}));
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{"naming-authx.xml", "No authorizations field in naming-authz.xml file."}));
        } else {
            for (int i = 0; i < auth.getLength(); ++i) {
                String UserId;
                Node special;
                int j;
                NodeList subjects;
                String role = auth.item(i).getAttributes().getNamedItem("role").getNodeValue();
                if (role.equals("SecurityRoleExt_1")) {
                    subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects == null) continue;
                    for (j = 0; j < subjects.getLength(); ++j) {
                        special = subjects.item(j);
                        if (special != null) {
                            UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                            if (UserId.startsWith("EveryoneExt") && read > everyone) {
                                read = everyone;
                            }
                            if (UserId.startsWith("ServerExt") && read > serverid) {
                                read = serverid;
                            }
                            if (UserId.startsWith("AllAuthenticatedUsersExt") && read > allAuth) {
                                read = allAuth;
                            }
                            if (!UserId.startsWith("UserExt") || read <= userid) continue;
                            read = userid;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No id set for reading the CORBA namespace");
                    }
                    continue;
                }
                if (role.equals("SecurityRoleExt_2")) {
                    subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects == null) continue;
                    for (j = 0; j < subjects.getLength(); ++j) {
                        special = subjects.item(j);
                        if (special != null) {
                            UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                            if (UserId.startsWith("EveryoneExt") && write > everyone) {
                                write = everyone;
                            }
                            if (UserId.startsWith("ServerExt") && write > serverid) {
                                write = serverid;
                            }
                            if (UserId.startsWith("AllAuthenticatedUsersExt") && write > allAuth) {
                                write = allAuth;
                            }
                            if (!UserId.startsWith("UserExt") || write <= userid) continue;
                            write = userid;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No id set for writing the CORBA namespace");
                    }
                    continue;
                }
                if (role.equals("SecurityRoleExt_3")) {
                    subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects == null) continue;
                    for (j = 0; j < subjects.getLength(); ++j) {
                        special = subjects.item(j);
                        if (special != null) {
                            UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                            if (UserId.startsWith("EveryoneExt") && create > everyone) {
                                create = everyone;
                            }
                            if (UserId.startsWith("ServerExt") && create > serverid) {
                                create = serverid;
                            }
                            if (UserId.startsWith("AllAuthenticatedUsersExt") && create > allAuth) {
                                create = allAuth;
                            }
                            if (!UserId.startsWith("UserExt") || create <= userid) continue;
                            create = userid;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No id set for creating the CORBA namespace");
                    }
                    continue;
                }
                if (!role.equals("SecurityRoleExt_4") || (subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects")) == null) continue;
                for (j = 0; j < subjects.getLength(); ++j) {
                    special = subjects.item(j);
                    if (special != null) {
                        UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                        if (UserId.startsWith("EveryoneExt") && delete > everyone) {
                            delete = everyone;
                        }
                        if (UserId.startsWith("ServerExt") && delete > serverid) {
                            delete = serverid;
                        }
                        if (UserId.startsWith("AllAuthenticatedUsersExt") && delete > allAuth) {
                            delete = allAuth;
                        }
                        if (!UserId.startsWith("UserExt") || delete <= userid) continue;
                        delete = userid;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No id set for deleting the CORBA namespace");
                }
            }
        }
        if (write == 2 || create == 2 || delete == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\nThe CORBA Namespace can be modified by All Authenticated users ");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.corba.improve.all.auth"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.corba"));
            this.report.add(this.index, this.resultMap);
            result = 2;
        } else if (write == 1 || create == 1 || delete == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\nThe CORBA namespace can be modified by Everyone! ");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.corba.improve.everyone"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.corba"));
            this.report.add(this.index, this.resultMap);
            result = 2;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\nCORBA naming roles are configured");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.corba.ok"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
            this.report.add(this.index, this.resultMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAdminIdInXMLDoc", new Integer(result));
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public String getCheckName() {
        return Controller.getNLSString("security.scanner.check.corba");
    }

    public String getCategory() {
        return Controller.getNLSString("security.scanner.category.corba");
    }

    public String getPriority() {
        return Controller.getNLSString("security.scanner.priority.high");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public int getOrderNumber() {
        return 3;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComponentName() {
        return Controller.getNLSString("security.scanner.component.security");
    }

    private int checkInConfig(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("config")) continue;
            String absolutePath = kiddos[i].getAbsolutePath();
            int tempResult = this.checkSecurityConfig(absolutePath);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        return result;
    }

    private int checkSecurityConfig(String fileName) {
        boolean result = true;
        File f = new File(fileName + "/cells");
        if (!f.isDirectory()) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()});
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()}));
            return 3;
        }
        return this.configCheck(f);
    }

    private int configCheck(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            int tempResult;
            if (kiddos[i].isFile()) {
                if (!kiddos[i].getName().equals("naming-authz.xml") || (tempResult = this.configCheckInFile(kiddos[i])) <= result) continue;
                result = tempResult;
                continue;
            }
            if (!kiddos[i].isDirectory() || (tempResult = this.configCheck(kiddos[i])) <= result) continue;
            result = tempResult;
        }
        return result;
    }

    private int configCheckInFile(File file) {
        int result = 1;
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.fileFound = true;
            int tempResult = this.findAdminIdInXMLDoc(xmlDoc);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.scanner.error.parse.xml", new Object[]{file.getName(), e});
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{file.getName(), e.getMessage()}));
            result = 3;
        }
        return result;
    }
}

