/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.scanner.AdminIdChecker;
import com.ibm.ws.security.scanner.Controller;
import com.ibm.wsspi.security.scanner.ConfigChecker;
import com.ibm.wsspi.security.scanner.ConfigHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdminRoleChecker
implements ConfigChecker {
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    ArrayList<ConfigHashMap> report;
    int index = 0;
    private ConfigHashMap errorMap = null;
    private static final TraceComponent tc = Tr.register(AdminIdChecker.class, "Security", "com.ibm.ejs.resources.security");

    public int doCheck(String path, Locale locale, ArrayList output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCheck", new Object[]{path, locale, output, this});
        }
        this.report = output;
        this.profileName = path;
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        this.fileFound = false;
        this.errorMap = new ConfigHashMap();
        int result = 1;
        int tempResult = this.checkInConfig(f);
        if (tempResult > result) {
            result = tempResult;
        }
        String fileName = path + File.separator + "config" + File.separator + "cells" + File.separator + Controller.getCellName() + File.separator + "admin-authz.xml";
        if (!this.fileFound) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{fileName});
            ConfigHashMap resultMap = new ConfigHashMap();
            resultMap.addItem("status", Controller.getNLSString("security.scanner.status.undetermined"));
            resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.undetermined"));
            resultMap.addItem("action", Controller.getNLSString("security.scanner.action.undetermined"));
            resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{fileName}));
            this.report.add(this.index, resultMap);
            result = 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCheck", new Integer(result));
        }
        return result;
    }

    private int checkRole(NodeList auth, String role, int i) {
        Node grp;
        Node user;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRole", new Object[]{auth, role, new Integer(i)});
        }
        boolean incremented = false;
        int activeRoleCount = 0;
        NodeList users = ((Element)auth.item(i)).getElementsByTagName("users");
        NodeList groups = ((Element)auth.item(i)).getElementsByTagName("groups");
        NodeList subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching role: " + role);
        }
        Node special = null;
        if (subjects != null) {
            for (int j = 0; j < subjects.getLength(); ++j) {
                ConfigHashMap resultMap;
                special = subjects.item(j);
                if (special == null) continue;
                String userId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                if (!userId.startsWith("ServerExt") && !incremented) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "special subject found, increment");
                    }
                    ++activeRoleCount;
                    incremented = true;
                }
                if (role.equals("SecurityRoleExt_1") && (userId.startsWith("EveryoneExt") || userId.startsWith("AllAuthenticatedUsersExt"))) {
                    resultMap = new ConfigHashMap();
                    resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
                    resultMap.addItem("risk", Controller.getFormattedMessage("security.scanner.risk.admin.role.every.all.improve", new Object[]{userId}));
                    resultMap.addItem("action", Controller.getNLSString("security.scanner.action.admin.role.every.all.improve"));
                    this.report.add(this.index, resultMap);
                }
                if (role.equals("SecurityRoleExt_1")) continue;
                if (userId.startsWith("EveryoneExt")) {
                    resultMap = new ConfigHashMap();
                    resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
                    resultMap.addItem("risk", Controller.getFormattedMessage("security.scanner.risk.other.role.every.improve", new Object[]{userId}));
                    resultMap.addItem("action", Controller.getNLSString("security.scanner.action.other.role.every.improve"));
                    this.report.add(this.index, resultMap);
                }
                if (!userId.startsWith("AllAuthenticatedUsersExt")) continue;
                resultMap = new ConfigHashMap();
                resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
                resultMap.addItem("risk", Controller.getFormattedMessage("security.scanner.risk.other.role.all.improve", new Object[]{userId}));
                resultMap.addItem("action", Controller.getNLSString("security.scanner.action.other.role.all.improve"));
                this.report.add(this.index, resultMap);
            }
        }
        if (users != null && (user = users.item(0)) != null && !incremented) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user found, increment");
            }
            ++activeRoleCount;
            incremented = true;
        }
        if (groups != null && (grp = groups.item(0)) != null && !incremented) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "group found, increment");
            }
            ++activeRoleCount;
            incremented = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRole", new Integer(activeRoleCount));
        }
        return activeRoleCount;
    }

    private int findAdminIdInXMLDoc(Document d) {
        int result = 1;
        int activeRoleCount = 0;
        NodeList auth = d.getElementsByTagName("authorizations");
        if (auth.getLength() == 0) {
            Tr.error(tc, Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{"admin-authx.xml", "No authorizations field in admin-authz.xml file."}));
            this.errorMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{"admin-authx.xml", "No authorizations field in admin-authz.xml file."}));
        } else {
            for (int i = 0; i < auth.getLength(); ++i) {
                String role = auth.item(i).getAttributes().getNamedItem("role").getNodeValue();
                if (role.equals("SecurityRoleExt_1")) {
                    activeRoleCount += this.checkRole(auth, "SecurityRoleExt_1", i);
                    continue;
                }
                if (role.equals("SecurityRoleExt_2")) {
                    activeRoleCount += this.checkRole(auth, "SecurityRoleExt_2", i);
                    continue;
                }
                if (role.equals("SecurityRoleExt_3")) {
                    activeRoleCount += this.checkRole(auth, "SecurityRoleExt_3", i);
                    continue;
                }
                if (role.equals("SecurityRoleExt_4")) {
                    activeRoleCount += this.checkRole(auth, "SecurityRoleExt_4", i);
                    continue;
                }
                if (role.equals("SecurityRoleExt_5")) {
                    activeRoleCount += this.checkRole(auth, "SecurityRoleExt_5", i);
                    continue;
                }
                if (!role.equals("SecurityRoleExt_6")) continue;
                activeRoleCount += this.checkRole(auth, "SecurityRoleExt_6", i);
            }
        }
        if (activeRoleCount >= 3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Multiple Administrative roles are configured");
            }
            ConfigHashMap resultMap = new ConfigHashMap();
            resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
            resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.admin.role.ok"));
            resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
            this.report.add(this.index, resultMap);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Multiple Administrative roles are not configured");
            }
            ConfigHashMap resultMap = new ConfigHashMap();
            resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
            resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.admin.role.improve"));
            resultMap.addItem("action", Controller.getNLSString("security.scanner.action.admin.role"));
            this.report.add(this.index, resultMap);
            result = 2;
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public String getCheckName() {
        return Controller.getNLSString("security.scanner.check.admin.role");
    }

    public String getCategory() {
        return Controller.getNLSString("security.scanner.category.admin.role");
    }

    public String getPriority() {
        return Controller.getNLSString("security.scanner.priority.medium");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public int getOrderNumber() {
        return 9;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComponentName() {
        return Controller.getNLSString("security.scanner.component.security");
    }

    private int checkInConfig(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("config")) continue;
            String absolutePath = kiddos[i].getAbsolutePath();
            int tempResult = this.checkSecurityConfig(absolutePath);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        return result;
    }

    private int checkSecurityConfig(String fileName) {
        boolean result = true;
        File f = new File(fileName + "/cells");
        if (!f.isDirectory()) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()});
            this.errorMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()}));
            return 3;
        }
        return this.configCheck(f);
    }

    private int configCheck(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            int tempResult;
            if (kiddos[i].isFile()) {
                if (!kiddos[i].getName().equals("admin-authz.xml") || (tempResult = this.configCheckInFile(kiddos[i])) <= result) continue;
                result = tempResult;
                continue;
            }
            if (!kiddos[i].isDirectory() || (tempResult = this.configCheck(kiddos[i])) <= result) continue;
            result = tempResult;
        }
        return result;
    }

    private int configCheckInFile(File file) {
        int result = 1;
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.fileFound = true;
            int tempResult = this.findAdminIdInXMLDoc(xmlDoc);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.scanner.error.parse.xml", new Object[]{file.getName(), e});
            this.errorMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{file.getName(), e.getMessage()}));
            result = 3;
        }
        return result;
    }
}

