/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.role.metadata.MergeManager;
import com.ibm.wsspi.amm.merge.MergeAction;
import com.ibm.wsspi.amm.merge.MergeException;
import com.ibm.wsspi.amm.scan.AnnotationScanner;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.validate.AnnotationValidator;
import com.ibm.wsspi.amm.validate.AnnotationValidatorManager;
import com.ibm.wsspi.amm.validate.ValidationException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeAction
implements MergeAction {
    private static final TraceComponent tc = Tr.register(AbstractMergeAction.class, "Security");
    protected MergeManager manager;

    abstract Class<? extends Annotation> getAnnotationClass();

    abstract void mergeClassAnnotation(MergeData var1, AnnotationScanner var2, ClassAnnotationTarget var3) throws ValidationException, MergeException;

    abstract void mergeMethodAnnotation(MergeData var1, AnnotationScanner var2, MethodAnnotationTarget var3) throws ValidationException, MergeException;

    public abstract Class<? extends EObject>[] getApplicableTypes();

    public void merge(MergeData mergeData, AnnotationScanner context) throws MergeException, ValidationException {
        String methodName = "merge(MergeData,AnnotationScanner)";
        Class<? extends Annotation> annotationClass = this.getAnnotationClass();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge(MergeData,AnnotationScanner)", "Merging security annotation " + annotationClass.getName() + " in module " + mergeData.getModuleFile());
        }
        this.manager = MergeManager.getInstance(mergeData);
        boolean ignoreValidation = Boolean.getBoolean("com.ibm.ws.security.role.metadata.ignoreValidation");
        AnnotationValidator validator = AnnotationValidatorManager.getInstance().getAnnotationValidator(this.getAnnotationClass());
        Map annotatedClasses = context.getClassAnnotationTargets(annotationClass);
        Map annotatedMethods = context.getMethodAnnotationTargets(annotationClass);
        this.traceTargets(annotatedClasses.values(), annotatedMethods.values());
        for (ClassAnnotationTarget classAnnotationTarget : annotatedClasses.values()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Annotated class = " + classAnnotationTarget.getApplicableClass().getQualifiedName());
            }
            try {
                if (!ignoreValidation) {
                    validator.validate(mergeData, (AnnotationTarget)classAnnotationTarget);
                }
            }
            catch (ValidationException e) {
                if (tc.isDebugEnabled()) {
                    Tr.error(tc, annotationClass.getSimpleName() + " annotation in class " + classAnnotationTarget.getApplicableClass().getQualifiedName() + " is invalid: " + (Object)((Object)e));
                }
                throw e;
            }
            this.mergeClassAnnotation(mergeData, context, classAnnotationTarget);
        }
        for (List targets : annotatedMethods.values()) {
            for (MethodAnnotationTarget methodAnnotationTarget : targets) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Annotated method = " + this.manager.getMethodSignature(methodAnnotationTarget));
                }
                try {
                    if (!ignoreValidation) {
                        validator.validate(mergeData, (AnnotationTarget)methodAnnotationTarget);
                    }
                }
                catch (ValidationException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.error(tc, annotationClass.getSimpleName() + " annotation in method " + this.manager.getMethodSignature(methodAnnotationTarget) + " is invalid: " + (Object)((Object)e));
                    }
                    throw e;
                }
                this.mergeMethodAnnotation(mergeData, context, methodAnnotationTarget);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge(MergeData,AnnotationScanner)");
        }
    }

    private void traceTargets(Collection<ClassAnnotationTarget> classes, Collection<List<MethodAnnotationTarget>> methods) {
        if (tc.isDebugEnabled()) {
            for (ClassAnnotationTarget classAnnotationTarget : classes) {
                Tr.debug(tc, "Annotated class = " + classAnnotationTarget.getApplicableClass().getQualifiedName());
            }
            for (List list : methods) {
                for (MethodAnnotationTarget methodAnnotationTarget : list) {
                    Tr.debug(tc, "Annotated method = " + this.manager.getMethodSignature(methodAnnotationTarget));
                }
            }
        }
    }
}

