/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.DescriptorConversionException;
import com.ibm.ws.security.role.RoleBasedModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.Descriptor;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;

class RolePermissionFromMBean {
    private static TraceComponent tc = Tr.register(RolePermissionFromMBean.class, null, "com.ibm.ejs.resources.security");
    private RoleBasedModule rbMod = null;

    public RoleBasedModule convert(ModelMBeanInfo mbInfo) throws DescriptorConversionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert");
        }
        try {
            int l;
            int k;
            StringBuffer methodId;
            method m;
            int i;
            String MBeanTypeName = (String)mbInfo.getMBeanDescriptor().getFieldValue("type");
            String MBeanInstanceName = (String)mbInfo.getMBeanDescriptor().getFieldValue("mbeanIdentifier");
            this.rbMod = new RoleBasedModule(MBeanTypeName);
            Boolean val = (Boolean)mbInfo.getMBeanDescriptor().getFieldValue("configureMBean");
            boolean isConfigMBean = val == null ? false : val;
            val = (Boolean)mbInfo.getMBeanDescriptor().getFieldValue("deployerMBean");
            boolean isDeployerMBean = val == null ? false : val;
            ArrayList<method> operator_methods = new ArrayList<method>();
            ArrayList<method> monitor_methods = new ArrayList<method>();
            MBeanOperationInfo[] mbois = mbInfo.getOperations();
            ModelMBeanAttributeInfo[] mbais = (ModelMBeanAttributeInfo[])mbInfo.getAttributes();
            for (i = 0; i < mbois.length; ++i) {
                m = new method(mbois[i].getName());
                MBeanParameterInfo[] mbpi = mbois[i].getSignature();
                for (int j = 0; j < mbpi.length; ++j) {
                    m.params.add(mbpi[j].getType());
                }
                if (0 == mbois[i].getImpact()) {
                    monitor_methods.add(m);
                    continue;
                }
                operator_methods.add(m);
            }
            for (i = 0; i < mbais.length; ++i) {
                Descriptor attDescriptor = mbais[i].getDescriptor();
                String proxyInvokeType = (String)attDescriptor.getFieldValue("proxyInvokeType");
                if (proxyInvokeType != null) continue;
                if ((mbais[i].isReadable() || mbais[i].isIs()) && !monitor_methods.contains(m = new method((String)attDescriptor.getFieldValue("getMethod")))) {
                    monitor_methods.add(m);
                }
                if (!mbais[i].isWritable() || operator_methods.contains(m = new method((String)attDescriptor.getFieldValue("setMethod")))) continue;
                operator_methods.add(m);
            }
            HashSet<String> operator_roles = new HashSet<String>();
            if (isConfigMBean) {
                operator_roles.add("configurator");
            } else {
                operator_roles.add("operator");
            }
            List parentRoleList = AdminAuthorizerFactory.getAdminAuthorizer().getAllParentRoles((String)operator_roles.iterator().next());
            operator_roles.addAll(parentRoleList);
            if (isDeployerMBean) {
                operator_roles.add("deployer");
            }
            HashSet<String> monitor_roles = new HashSet<String>();
            parentRoleList = AdminAuthorizerFactory.getAdminAuthorizer().getAllParentRoles("monitor");
            monitor_roles.add("monitor");
            monitor_roles.addAll(parentRoleList);
            Iterator iter = monitor_methods.iterator();
            while (iter.hasNext()) {
                methodId = new StringBuffer(MBeanTypeName + ":");
                m = (method)iter.next();
                methodId.append(m.method_name);
                k = m.params.size();
                for (l = 0; l < k; ++l) {
                    methodId.append(":" + (String)m.params.get(l));
                }
                this.rbMod.add(methodId.toString(), monitor_roles);
            }
            iter = operator_methods.iterator();
            while (iter.hasNext()) {
                methodId = new StringBuffer(MBeanTypeName + ":");
                m = (method)iter.next();
                methodId.append(m.method_name);
                k = m.params.size();
                for (l = 0; l < k; ++l) {
                    methodId.append(":" + (String)m.params.get(l));
                }
                this.rbMod.add(methodId.toString(), operator_roles);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RolePermissionFromMBean.convert", "138", this);
            String msg = "unable to convert the ModelMBeanInfo";
            throw new DescriptorConversionException(ex.toString() + msg);
        }
        return this.rbMod;
    }

    class method {
        private String method_name;
        private ArrayList params = new ArrayList();

        private method(String name) {
            this.method_name = name;
        }

        public boolean equals(Object m) {
            if (this == m) {
                return true;
            }
            if (!(m instanceof method)) {
                return false;
            }
            method other = (method)m;
            return this.method_name.equals(other.method_name);
        }

        public int hashcode() {
            return 0;
        }
    }
}

