/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.models.config.rolebasedauthz.AllAuthenticatedUsersExt;
import com.ibm.websphere.models.config.rolebasedauthz.AllAuthenticatedUsersInTrustedRealmsExt;
import com.ibm.websphere.models.config.rolebasedauthz.EveryoneExt;
import com.ibm.websphere.models.config.rolebasedauthz.PrimaryAdminExt;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.ServerExt;
import com.ibm.websphere.models.config.rolebasedauthz.SpecialSubjectExt;
import com.ibm.websphere.models.config.rolebasedauthz.SubjectExt;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedConfiguratorImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class RoleBasedSubjectMap {
    private static TraceComponent tc = Tr.register(RoleBasedSubjectMap.class);
    public static final String NO_CRED = "NO_CRED_NO_ACCESS_ID";
    public static final String NULL_ACCESS_ID = "NULL_ACCESS_ID";
    private HashSet[] roles = null;
    private HashMap subjects = new HashMap();
    private HashMap subjectGroups = new HashMap();
    private String name = null;
    private boolean defaultAccess = true;
    private String serverId = null;
    private String longServerId = null;
    private String adminAccessId = null;
    private boolean ignoreCase = false;
    private HashMap roleMap = null;

    RoleBasedSubjectMap(String appName, List sec_roles, String Id2, String longId, boolean isWCCMList) {
        Boolean isIgnoreCase = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("ignoreCase");
        if (isIgnoreCase != null && isIgnoreCase.booleanValue()) {
            this.ignoreCase = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoreCase is set");
            }
        }
        this.name = appName;
        this.serverId = Id2;
        this.longServerId = longId;
        int i = sec_roles.size();
        this.roleMap = new HashMap(i);
        if (i == 0) {
            return;
        }
        String[] temp_roles = new String[i];
        int[] factor = new int[i - 1];
        Iterator iter = sec_roles.iterator();
        int k = 0;
        while (iter.hasNext()) {
            temp_roles[k++] = isWCCMList ? new String(((SecurityRoleExt)iter.next()).getRoleName()) : ((ConfigObject)iter.next()).getString("roleName", null);
            Role r = new Role();
            this.roleMap.put(temp_roles[k - 1], r);
        }
        this.roles = new HashSet[1];
        this.roles[0] = new HashSet(1);
        for (int j = 0; j < i; ++j) {
            this.roles[0].add(temp_roles[j]);
        }
    }

    public void addRoles(List sec_roles) {
        int j;
        int i = sec_roles.size();
        if (i == 0) {
            return;
        }
        String[] temp_roles = new String[i];
        int[] factor = new int[i - 1];
        Iterator iter = sec_roles.iterator();
        int k = 0;
        while (iter.hasNext()) {
            temp_roles[k++] = ((ConfigObject)iter.next()).getString("roleName", null);
        }
        for (j = 0; j < i; ++j) {
            if (this.roles[0].contains(temp_roles[j])) continue;
            this.roles[0].add(temp_roles[j]);
        }
        for (j = 0; j < i; ++j) {
            if (this.roleMap.containsKey(temp_roles[j])) continue;
            Role r = new Role();
            this.roleMap.put(temp_roles[j], r);
        }
    }

    public void addSpecialSubjects(String roleName, List ss, boolean isWCCMList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSpecialSubjects: " + roleName);
        }
        if (ss == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list null");
            }
            return;
        }
        Iterator iter = ss.iterator();
        while (iter.hasNext()) {
            Object ssx;
            if (isWCCMList) {
                ssx = (SpecialSubjectExt)iter.next();
                if (ssx instanceof EveryoneExt) {
                    ((Role)this.roleMap.get(roleName)).everyoneAllowed = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added EveryoneExt");
                    continue;
                }
                if (ssx instanceof AllAuthenticatedUsersExt) {
                    ((Role)this.roleMap.get(roleName)).allAuthenAllowed = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added AllAuthenticatedUsersExt");
                    continue;
                }
                if (ssx instanceof AllAuthenticatedUsersInTrustedRealmsExt) {
                    ((Role)this.roleMap.get(roleName)).allAuthenAllowedInTrustedRealms = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added AllAuthenticatedUsersInTrustedRealmsExt");
                    continue;
                }
                if (ssx instanceof ServerExt) {
                    ((Role)this.roleMap.get(roleName)).serverAllowed = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added ServerExt");
                    continue;
                }
                if (!(ssx instanceof PrimaryAdminExt)) continue;
                ((Role)this.roleMap.get(roleName)).adminAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added PrimaryAdminExt");
                continue;
            }
            ssx = (ConfigObject)iter.next();
            if (ssx.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi", "EveryoneExt")) {
                ((Role)this.roleMap.get(roleName)).everyoneAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added EveryoneExt");
                continue;
            }
            if (ssx.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi", "AllAuthenticatedUsersExt")) {
                ((Role)this.roleMap.get(roleName)).allAuthenAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added AllAuthenticatedUsersExt");
                continue;
            }
            if (ssx.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi", "AllAuthenticatedUsersInTrustedRealmsExt")) {
                ((Role)this.roleMap.get(roleName)).allAuthenAllowedInTrustedRealms = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added AllAuthenticatedUsersInTrustedRealmsExt");
                continue;
            }
            if (ssx.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi", "ServerExt")) {
                ((Role)this.roleMap.get(roleName)).serverAllowed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "added ServerExt");
                continue;
            }
            if (!ssx.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi", "PrimaryAdminExt")) continue;
            ((Role)this.roleMap.get(roleName)).adminAllowed = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added PrimaryAdminExt");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSpecialSubjects: " + roleName);
        }
    }

    public boolean isEveryoneGranted(Set requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted");
        }
        if (requiredRoles == null || requiredRoles.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed ? " + this.defaultAccess);
            }
            return this.defaultAccess;
        }
        Iterator iter = requiredRoles.iterator();
        while (iter.hasNext()) {
            Role role = (Role)this.roleMap.get(iter.next());
            if (role == null || !role.everyoneAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "everyone allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted");
        }
        return false;
    }

    public boolean isAllAuthenticatedUsersGranted(Set requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllAuthenticatedUsersGranted");
        }
        if (requiredRoles == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + this.defaultAccess);
            }
            return this.defaultAccess;
        }
        Iterator iter = requiredRoles.iterator();
        while (iter.hasNext()) {
            Role role = (Role)this.roleMap.get(iter.next());
            if (role == null || !role.allAuthenAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "all authenticated users allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllAuthenticatedUsersGanted");
        }
        return false;
    }

    public boolean isAllAuthenticatedUsersInTrustedRealmsGranted(Set requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllAuthenticatedUsersInTrustedRealmsGranted");
        }
        if (requiredRoles == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + this.defaultAccess);
            }
            return this.defaultAccess;
        }
        Iterator iter = requiredRoles.iterator();
        while (iter.hasNext()) {
            Role role = (Role)this.roleMap.get(iter.next());
            if (role == null || !role.allAuthenAllowedInTrustedRealms) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "all authenticated users in trusted realms allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllAuthenticatedUsersInTrustedRealmsGranted");
        }
        return false;
    }

    public boolean isServerGranted(Set requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerGranted");
        }
        if (requiredRoles == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + this.defaultAccess);
            }
            return this.defaultAccess;
        }
        Iterator iter = requiredRoles.iterator();
        while (iter.hasNext()) {
            Role role = (Role)this.roleMap.get(iter.next());
            if (role == null || !role.serverAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerGranted");
        }
        return false;
    }

    public boolean isAdminGranted(Set requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminGranted");
        }
        if (requiredRoles == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requiredRoles null, access allowed? " + this.defaultAccess);
            }
            return this.defaultAccess;
        }
        Iterator iter = requiredRoles.iterator();
        while (iter.hasNext()) {
            Role role = (Role)this.roleMap.get(iter.next());
            if (role == null || !role.adminAllowed) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminID allowed");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAdminGranted");
        }
        return false;
    }

    public void addSubjects(String roleName, List sub, boolean isWCCMList, RoleBasedConfiguratorImpl configurator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSubjects: " + roleName);
        }
        if (sub == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list null");
            }
            return;
        }
        Iterator iter = sub.iterator();
        while (iter.hasNext()) {
            Object sx;
            String accessId = null;
            if (isWCCMList) {
                sx = (SubjectExt)iter.next();
                accessId = sx.getAccessId();
            } else {
                sx = (ConfigObject)iter.next();
                accessId = configurator != null ? configurator.getAccessId((ConfigObject)sx, false) : sx.getString("accessId", null);
            }
            if (accessId != null && this.ignoreCase) {
                accessId = accessId.toLowerCase();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "accessId: " + accessId);
            }
            if (!this.subjects.containsKey(accessId)) {
                HashSet<String> grantedRoles = new HashSet<String>(1);
                grantedRoles.add(roleName);
                this.subjects.put(accessId, grantedRoles);
                continue;
            }
            HashSet hs = (HashSet)this.subjects.get(accessId);
            hs.add(roleName);
            this.subjects.put(accessId, hs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSubjects: " + roleName);
        }
    }

    public void addSubjectGroups(String roleName, List sub, boolean isWCCMList, RoleBasedConfiguratorImpl configurator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSubjectGroups: " + roleName);
        }
        if (sub == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list null");
            }
            return;
        }
        Iterator iter = sub.iterator();
        while (iter.hasNext()) {
            Object sx;
            String accessId = null;
            if (isWCCMList) {
                sx = (SubjectExt)iter.next();
                accessId = sx.getAccessId();
            } else {
                sx = (ConfigObject)iter.next();
                accessId = configurator != null ? configurator.getAccessId((ConfigObject)sx, true) : sx.getString("accessId", null);
            }
            if (accessId != null && this.ignoreCase) {
                accessId = accessId.toLowerCase();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "accessId: " + accessId);
            }
            if (!this.subjectGroups.containsKey(accessId)) {
                HashSet<String> grantedRoles = new HashSet<String>(1);
                grantedRoles.add(roleName);
                this.subjectGroups.put(accessId, grantedRoles);
                continue;
            }
            HashSet hs = (HashSet)this.subjectGroups.get(accessId);
            hs.add(roleName);
            this.subjectGroups.put(accessId, hs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSubjectGroups: " + roleName);
        }
    }

    public void pack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pack");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pack subjects");
        }
        this.packMap(this.subjects);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pack subjectGroups");
        }
        this.packMap(this.subjectGroups);
        this.roles = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pack");
        }
    }

    private void packMap(HashMap hm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "packMap");
        }
        Set s = hm.keySet();
        for (String subjectName : s) {
            HashSet hs = (HashSet)hm.get(subjectName);
            boolean done = false;
            for (int i = 0; !done && i < this.roles.length; ++i) {
                if (!hs.equals(this.roles[i])) continue;
                done = true;
                hm.put(subjectName, this.roles[i]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dump hm");
            s = hm.keySet();
            for (String subjectName : s) {
                Tr.debug(tc, "subjectName: " + subjectName + " roles: " + hm.get(subjectName));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "packMap");
        }
    }

    private boolean isAdminId(WSCredential wsCred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAdminId", new Object[]{wsCred, this});
        }
        try {
            if (this.adminAccessId == null) {
                if (wsCred == null || wsCred.isBasicAuth() || wsCred.isUnauthenticated()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isAdminId returning falsesince the WSCredential is null or basicAuth or Unaauthenticated.");
                    }
                    return false;
                }
                String adminId = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("primaryAdminId");
                if (adminId != null && adminId.length() > 0) {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    String realm = null;
                    if (AdminContext.peek() == null) {
                        realm = contextManager.getAdminRealm();
                    }
                    UserRegistry registry = contextManager.getRegistry(realm);
                    this.adminAccessId = registry.getUniqueUserId(adminId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isAdminId got adminAccessId from registry: ", new Object[]{"realm: " + realm, "adminAccessId: " + this.adminAccessId, this});
                    }
                }
            }
            String accessId = wsCred.getAccessId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminAccessId: " + this.adminAccessId + " accessId: " + accessId);
            }
            if (accessId == null || this.adminAccessId == null) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "isAdminId returning false: accessid is null");
                }
                return false;
            }
            if (this.ignoreCase) {
                accessId = accessId.toLowerCase();
                this.adminAccessId = this.adminAccessId.toLowerCase();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase set: adminAccessId: " + this.adminAccessId + " accessId: " + accessId);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isAdminId returning " + accessId.equals(this.adminAccessId));
            }
            return accessId.equals(this.adminAccessId);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedSubjectMap.isAdminId", "359", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in isAdminId: ", new Object[]{e.getMessage()});
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isAdminId returning false");
            }
            return false;
        }
    }

    private boolean isServerId(WSCredential wsCred) {
        try {
            UserRegistryConfig aur = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
            if (wsCred != null && wsCred.isBasicAuth() && !wsCred.isUnauthenticated()) {
                String serverId = aur.getString("serverId");
                String serverPwd = aur.getDecodedString("serverPassword");
                String wsCredId = wsCred.getSecurityName();
                byte[] wsCredPwdBytes = wsCred.getCredentialToken();
                String wsCredPwd = null;
                if (wsCredPwdBytes != null) {
                    wsCredPwd = StringBytesConversion.getConvertedString(wsCredPwdBytes);
                }
                if (wsCredPwdBytes == null || wsCredId == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning false, either WSCredential ID or password is null.");
                    }
                    return false;
                }
                if (serverId.equals(wsCredId) && serverPwd.equals(wsCredPwd)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Valid BasicAuth server ID.");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not valid BasicAuth server ID: " + wsCredId);
                }
                return false;
            }
            if (wsCred != null && wsCred.isUnauthenticated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unauthenticated cred is not server ID.");
                }
                return false;
            }
            if (wsCred != null) {
                ContextManager contextManager;
                String accessId = wsCred.getAccessId();
                if (accessId == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isServerId? false, accessid is null");
                    }
                    return false;
                }
                if (this.ignoreCase) {
                    accessId = accessId.toLowerCase();
                }
                boolean useRegistryServerId = aur.getBoolean("useRegistryServerId");
                String unexpandedServerId = SecurityObjectLocator.getAdminData().getString("security.unexpandedServerId");
                if (unexpandedServerId != null && useRegistryServerId) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking to determine if serverID is from the same cell.");
                    }
                    return this.isServerIdFromCell(wsCred, accessId, this.serverId, this.longServerId);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "accessId: " + accessId + " serverId: " + this.serverId + " longServerId: " + this.longServerId);
                }
                if (!useRegistryServerId && (contextManager = ContextManagerFactory.getInstance()).isInternalServerCredential(wsCred)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isServerId? - server credential. Returning true");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isServerId? " + (accessId.equals(this.serverId) || accessId.equals(this.longServerId)));
                }
                return accessId.equals(this.serverId) || accessId.equals(this.longServerId);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSCredential is null, returning false.");
            }
            return false;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedSubjectMap.isServerId", "361", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in isServerId: ", new Object[]{e.getMessage()});
            }
            return false;
        }
    }

    public boolean isServerIdFromCell(WSCredential wsCred, String accessId, String serverId, String longServerId) {
        boolean serverIdFromThisNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerIdFromCell", new Object[]{accessId, serverId, longServerId});
        }
        boolean bl = serverIdFromThisNode = accessId.equals(serverId) || accessId.equals(longServerId);
        if (serverIdFromThisNode) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning true, server ID is from this node.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerIdFromCell");
            }
            return true;
        }
        TreeSet serverIDSet = (TreeSet)SecurityObjectLocator.getAdminData().getObject("security.serverNameList");
        String securityName = null;
        try {
            securityName = wsCred.getSecurityName().toLowerCase();
            int index = securityName.indexOf("@");
            if (index != -1) {
                securityName = securityName.substring(0, index);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting security name from WSCredential.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedSubjectMap.isServerIdFromCell", "404", this);
        }
        if (serverIDSet != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverIDSet is not null");
            }
            for (Object o : serverIDSet) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "entry: " + o.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverIDSet == null");
        }
        if (securityName != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "securityName: " + securityName);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "securityName == null");
        }
        if (serverIDSet != null && (serverIDSet.contains(accessId.toLowerCase()) || securityName != null && serverIDSet.contains(securityName))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning true, server ID is from this cell.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isServerIdFromCell");
            }
            return true;
        }
        if (serverIDSet == null && longServerId.startsWith("server")) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerIdFromCell (false)");
        }
        return false;
    }

    public boolean isGrantedAnyRole(WSCredential wsCred, Set requiredRoles) {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isGrantedAnyRole");
            }
            try {
                if (requiredRoles == null || requiredRoles.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: requiredRoles null, access allowed? " + this.defaultAccess);
                    }
                    return this.defaultAccess;
                }
                String accessId = wsCred.getAccessId();
                if (this.ignoreCase) {
                    accessId = accessId.toLowerCase();
                }
                if (accessId != null && !accessId.equalsIgnoreCase(ContextManagerFactory.getInstance().getUnauthenticatedString()) && !accessId.equalsIgnoreCase(NO_CRED) && !accessId.equalsIgnoreCase(NULL_ACCESS_ID) && (this.isAllAuthenticatedUsersGranted(requiredRoles) || this.isServerGranted(requiredRoles) && this.isServerId(wsCred))) {
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isGrantedAnyRole: accessId is: " + accessId);
                }
                if (accessId != null && accessId.equalsIgnoreCase(ContextManagerFactory.getInstance().getUnauthenticatedString())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: has unauthenticated accessId: " + accessId);
                    }
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "about to check for isAllAuthenticatedUsersInTrustedRealmsGranted");
                }
                if (this.isAllAuthenticatedUsersInTrustedRealmsGranted(requiredRoles)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isAllAuthenticatedUsersInTrustedRealmsGranted is true.");
                    }
                    return true;
                }
                if (this.isAdminGranted(requiredRoles) && this.isAdminId(wsCred)) {
                    return true;
                }
                Set grantedRoles = (Set)this.subjects.get(accessId);
                if (grantedRoles == null || grantedRoles.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: grantedRoles null, access denied");
                    }
                    return false;
                }
                Iterator gr = grantedRoles.iterator();
                while (gr.hasNext()) {
                    Iterator rr = requiredRoles.iterator();
                    String grantedRoleName = (String)gr.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isGrantedAnyRole: grantedRolesName = " + grantedRoleName);
                    }
                    while (rr.hasNext()) {
                        if (!grantedRoleName.equals((String)rr.next())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "isGrantedAnyRole: access granted");
                        }
                        return true;
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedSubjectMap.isGrantedAnyRole", "467", this);
                if (!tc.isDebugEnabled()) break block21;
                Tr.debug(tc, "Exception in isGrantedAnyRole: ", new Object[]{e.getMessage()});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGrantedAnyRole: access denied");
        }
        return false;
    }

    public boolean isGroupGrantedAnyRole(String accessId, Set requiredRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGroupGrantedAnyRole");
        }
        if (requiredRoles == null || requiredRoles.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isGroupGrantedAnyRole: requiredRoles null, access allowed? " + this.defaultAccess);
            }
            return this.defaultAccess;
        }
        Set grantedRoles = (Set)this.subjectGroups.get(accessId);
        if (grantedRoles == null || grantedRoles.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isGroupGrantedAnyRole: grantedRoles null, access denied");
            }
            return false;
        }
        Iterator gr = grantedRoles.iterator();
        while (gr.hasNext()) {
            Iterator rr = requiredRoles.iterator();
            String grantedRoleName = (String)gr.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isiGroupGrantedAnyRole: grantedRolesName = " + grantedRoleName);
            }
            while (rr.hasNext()) {
                if (!grantedRoleName.equals((String)rr.next())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isGroupGrantedAnyRole: access granted");
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGroupGrantedAnyRole: access denied");
        }
        return false;
    }

    protected String getSubjectMapName() {
        return this.name;
    }

    protected HashMap getSubjectMap() {
        return this.subjects;
    }

    protected HashSet[] getSecurityRoles() {
        return this.roles;
    }

    class Role {
        private boolean everyoneAllowed = false;
        private boolean allAuthenAllowed = false;
        private boolean allAuthenAllowedInTrustedRealms = false;
        private boolean serverAllowed = false;
        private boolean adminAllowed = false;

        Role() {
        }
    }
}

