/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfiguratorImpl;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.RoleBasedSubjectMap;
import com.ibm.ws.security.stat.impl.SecurityAuthorizationModuleImpl;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

class RoleBasedAuthorizerImpl
implements RoleBasedAuthorizer {
    private static TraceComponent tc = Tr.register(RoleBasedAuthorizerImpl.class, "Security", "com.ibm.ejs.resources.security");
    private RoleBasedConfiguratorImpl configurator = null;
    private String appName = null;
    private String cellName = null;
    private String serverName = null;
    private HashMap accessContext = new HashMap(3);
    private PluggableAuthorizationTableProxy pluggableAuthTable = null;
    private boolean isSAFAuthz = false;
    private boolean _handleAllAuthz = false;
    private boolean _alreadyAttempted = false;
    private boolean ignoreCase = false;
    private boolean staticsInitialized = false;
    private static String providerName = "WebSphere";
    private static final String componentName = "WAS.security";
    private static AuditService auditService = null;
    private Date startTime = null;
    private Date endTime = null;
    private String className = null;
    private String default_realm = null;
    private String activeUserRegistry = null;
    private ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private SecurityConfig security = null;
    private SecurityAuthorizationModuleImpl authModule;

    public RoleBasedAuthorizerImpl(String app_name, RoleBasedConfiguratorImpl rbc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{app_name, rbc});
        }
        if (StatsFactory.isPMIEnabled()) {
            this.authModule = SecurityAuthorizationModuleImpl.getInstance("Security Authorization");
        }
        this.className = this.getClass().getName();
        this.security = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = this.security.getActiveUserRegistry().getType();
        this.default_realm = null;
        this.default_realm = AdminContext.peek() == null ? ContextManagerFactory.getInstance().getAdminRealm() : SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
        this.appName = app_name;
        this.configurator = rbc;
        this.pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (this.pluggableAuthTable != null) {
            this.cellName = SecurityObjectLocator.getAdminData().getString("cellname");
            this.serverName = SecurityObjectLocator.getAdminData().getString("shortservername");
            this.accessContext.put("APPLICATION_NAME", this.appName);
            this.accessContext.put("SERVER_NAME", this.serverName);
            this.accessContext.put("CELL_NAME", this.cellName);
            providerName = "AuthorizationTable";
            this.isSAFAuthz = this.pluggableAuthTable.isSAFAuthorizationEnabled();
        }
        if (!this.staticsInitialized) {
            Boolean isIgnoreCase = this.security.getActiveUserRegistry().getBoolean("ignoreCase");
            if (isIgnoreCase != null && isIgnoreCase.booleanValue()) {
                this.ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase is set");
                }
            }
            try {
                if (auditService == null) {
                    auditService = ContextManagerFactory.getInstance().getAuditService();
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.wsaccessmanager.classnotfound", new Object[]{"J2EEAuditEventFactory"});
            }
            this.staticsInitialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAccess(String moduleName, String resourceName, String methodName) {
        boolean bl;
        long startTime = 0L;
        long endTime = 0L;
        try {
            boolean result;
            block24: {
                if (StatsFactory.isPMIEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "checkAccess", new Object[]{moduleName, resourceName, methodName});
                }
                result = false;
                try {
                    int i;
                    String[] roleNames;
                    CredHolder credHolder = null;
                    RoleBasedSubjectMap subjectMap = this.configurator.getRoleBasedSubjectMap(this.appName);
                    RoleBasedModule module = this.configurator.getRoleBasedModule(this.appName, moduleName);
                    if (module == null && this.appName.startsWith("admin-authz")) {
                        module = this.configurator.getRoleBasedModule("admin-authz", moduleName);
                    }
                    HashSet reqRoles = module != null ? module.getRequiredRoles(resourceName + ":" + methodName) : null;
                    HashSet<String> requiredRoles = new HashSet<String>();
                    String[] stringArray = roleNames = reqRoles != null ? reqRoles.toArray(new String[0]) : new String[]{};
                    if (this.appName.startsWith("admin-authz")) {
                        for (i = 0; i < roleNames.length; ++i) {
                            AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
                            if (aa != null) {
                                List parentList = aa.getAllParentRoles(roleNames[i]);
                                requiredRoles.add(roleNames[i]);
                                requiredRoles.addAll(parentList);
                                continue;
                            }
                            requiredRoles.add(roleNames[i]);
                        }
                    } else {
                        for (i = 0; i < roleNames.length; ++i) {
                            requiredRoles.add(roleNames[i]);
                        }
                    }
                    if (this.isEveryoneGranted(requiredRoles, subjectMap)) {
                        result = true;
                    } else {
                        credHolder = this.getEffectiveCredentials();
                        if (credHolder.isThreadMissingCredentials() && tc.isDebugEnabled()) {
                            String msg = "Invocation and received credentials are both null.";
                            Tr.debug(tc, "Invocation and received credentials are both null.", new Object[]{methodName, resourceName, moduleName});
                        }
                        ContextManager contextManager = ContextManagerFactory.getInstance();
                        if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(credHolder.cred))) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                            }
                            result = this.checkAccess(requiredRoles, moduleName, resourceName, methodName, credHolder);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "calling default authz engine for authorization decision");
                            }
                            result = this.checkAccess(requiredRoles, moduleName, resourceName, methodName, credHolder, subjectMap);
                        }
                    }
                    if (!result) {
                        String accessId = this.getAccessId(credHolder.cred);
                        String securityName = this.getSecurityName(credHolder.cred);
                        String[] roleArray = requiredRoles != null ? requiredRoles.toArray(new String[0]) : new String[]{};
                        StringBuffer sb = new StringBuffer();
                        for (int i2 = 0; i2 < roleArray.length; ++i2) {
                            if (i2 == 0) {
                                sb.append(roleArray[i2]);
                                continue;
                            }
                            sb.append(", ").append(roleArray[i2]);
                        }
                        Tr.audit(tc, "security.rolebauthz.authzfail", new Object[]{this.appName, resourceName, methodName, securityName, accessId, sb.toString()});
                    }
                }
                catch (RoleBasedAppException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", "359", this);
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, "Unable to acquire role info", e);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkAccess", new Boolean(result));
            }
            bl = result;
            Object var21_23 = null;
        }
        catch (Throwable throwable) {
            block25: {
                Object var21_24 = null;
                if (!StatsFactory.isPMIEnabled()) break block25;
                endTime = System.currentTimeMillis();
                this.authModule.onAdminAuthTime(endTime - startTime);
            }
            throw throwable;
        }
        if (StatsFactory.isPMIEnabled()) {
            endTime = System.currentTimeMillis();
            this.authModule.onAdminAuthTime(endTime - startTime);
        }
        return bl;
    }

    private boolean checkAccess(Set requiredRoles, String moduleName, String resourceName, String methodName, CredHolder credHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{requiredRoles, moduleName, resourceName, methodName, credHolder});
        }
        ContextHandler contextHandler = null;
        boolean result = false;
        Exception failure = null;
        String[] roles = null;
        try {
            roles = requiredRoles == null ? new String[]{} : requiredRoles.toArray(new String[0]);
            result = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, roles, credHolder.subject);
        }
        catch (Exception t) {
            FFDCFilter.processException((Throwable)t, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", "400", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception caught: ", t);
            }
            failure = t instanceof Exception ? t : null;
        }
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null) {
            String rSubj = null;
            if (credHolder != null && credHolder.subject != null) {
                rSubj = ((Principal)credHolder.subject.getPrincipals().toArray()[0]).getName();
            }
            if (result) {
                if (auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS")) {
                    HashMap data = DataHelper.buildSessionData(null, null, null, null);
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(resourceName.concat(".").concat(methodName), "authz", null, rSubj, "authzSuccess", resourceName, "WAS", new Long(0L), null, null, roles, roles);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    data = DataHelper.buildPolicyData(null, null);
                    contextHandler.buildContextObject("POLICY_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 8L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            } else if (auditService.isEventRequired("SECURITY_AUTHZ", "DENIED")) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(resourceName.concat(".").concat(methodName), "authz", null, rSubj, "authzDenied", resourceName, "WAS", new Long(0L), null, null, roles, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(result));
        }
        return result;
    }

    private boolean checkAccess(Set requiredRoles, String moduleName, String resourceName, String methodName, CredHolder credHolder, RoleBasedSubjectMap subjectMap) {
        String[] roles;
        boolean result;
        ContextHandler contextHandler;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkAccess", new Object[]{requiredRoles, moduleName, resourceName, methodName, credHolder, subjectMap});
            }
            contextHandler = null;
            result = false;
            Object failure = null;
            roles = null;
            roles = requiredRoles == null ? new String[]{} : requiredRoles.toArray(new String[0]);
            try {
                if (subjectMap.isGrantedAnyRole(credHolder.cred, requiredRoles)) {
                    result = true;
                } else if (this.isGroupGrantedAnyRole(requiredRoles, subjectMap, credHolder.cred)) {
                    result = true;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", "608", this);
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "Unexpected exception caught: ", t);
            }
        }
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null) {
            String rSubj = null;
            if (credHolder != null && credHolder.subject != null) {
                rSubj = ((Principal)credHolder.subject.getPrincipals().toArray()[0]).getName();
            }
            if (result) {
                if (auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS")) {
                    HashMap data = DataHelper.buildSessionData(null, null, null, null);
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData(resourceName.concat(".").concat(methodName), "authz", null, rSubj, "authzSuccess", resourceName, "WAS", new Long(0L), null, null, roles, roles);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    data = DataHelper.buildPolicyData(null, null);
                    contextHandler.buildContextObject("POLICY_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 8L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            } else if (auditService.isEventRequired("SECURITY_AUTHZ", "DENIED")) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(resourceName.concat(".").concat(methodName), "authz", null, rSubj, "authzDenied", resourceName, "WAS", new Long(0L), null, null, roles, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(result));
        }
        return result;
    }

    private boolean isEveryoneGranted(Set requiredRoles, RoleBasedSubjectMap subjectMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{requiredRoles, subjectMap});
        }
        boolean result = false;
        if (this.pluggableAuthTable == null || requiredRoles == null || requiredRoles.size() == 0) {
            result = subjectMap.isEveryoneGranted(requiredRoles);
        } else {
            String[] roles = requiredRoles == null ? new String[]{} : requiredRoles.toArray(new String[0]);
            result = this.pluggableAuthTable.isEveryoneGranted(this.accessContext, roles);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(result));
        }
        return result;
    }

    private boolean isGroupGrantedAnyRole(Set requiredRoles, RoleBasedSubjectMap subjectMap, WSCredential cred) {
        ArrayList groupList;
        boolean result;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isGroupGrantedAnyRole", new Object[]{requiredRoles, subjectMap, cred});
            }
            result = false;
            groupList = null;
            try {
                groupList = cred.getGroupIds();
            }
            catch (GeneralSecurityException gse) {
                FFDCFilter.processException((Throwable)gse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", "845", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception getting group IDs", gse);
            }
        }
        String[] groups = groupList == null ? new String[]{} : groupList.toArray(new String[groupList.size()]);
        for (int i = 0; i < groups.length; ++i) {
            if (this.ignoreCase) {
                groups[i] = groups[i].toLowerCase();
            }
            if (!subjectMap.isGroupGrantedAnyRole(groups[i], requiredRoles)) continue;
            result = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGroupGrantedAnyRole", new Boolean(result));
        }
        return result;
    }

    public boolean isCallerInRole(String roleName) {
        CredHolder credHolder;
        boolean result;
        ContextHandler contextHandler;
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isCallerInRole", roleName);
            }
            contextHandler = null;
            result = false;
            if (roleName == null) {
                Tr.error(tc, "security.roleref.configerror", new Object[]{roleName});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isCallerInRole", new Boolean(result));
                }
                return result;
            }
            credHolder = this.getEffectiveCredentials();
            if (credHolder.isThreadMissingCredentials()) {
                String msg = "Invocation and received credentials are both null";
                Exception ex = new Exception("Invocation and received credentials are both null");
                Tr.error(tc, "security.rolebauthz.nocred2", new Object[]{roleName, ex});
            }
            try {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(credHolder.cred))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                    }
                    result = this.pluggableAuthTable.isGrantedRole(this.accessContext, roleName, credHolder.subject);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling default authz engine for authorization decision");
                    }
                    RoleBasedSubjectMap subjectMap = this.configurator.getRoleBasedSubjectMap(this.appName);
                    HashSet<String> requiredRoles = new HashSet<String>(1);
                    requiredRoles.add(roleName);
                    if (subjectMap.isGrantedAnyRole(credHolder.cred, requiredRoles)) {
                        result = true;
                    } else if (this.isGroupGrantedAnyRole(requiredRoles, subjectMap, credHolder.cred)) {
                        result = true;
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", "929", this);
                if (!tc.isDebugEnabled()) break block28;
                Tr.debug(tc, "Unexpected exception caught: ", t);
            }
        }
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        String[] roles = new String[1];
        if (roleName != null) {
            roles[0] = roleName;
        }
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null) {
            HashMap data;
            String rSubj = null;
            if (credHolder != null && credHolder.subject != null) {
                rSubj = ((Principal)credHolder.subject.getPrincipals().toArray()[0]).getName();
            }
            if (result) {
                if (auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS")) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("isCallerInRole", "authz", null, rSubj, "authzSuccess", null, "WAS", new Long(0L), null, null, roles, roles);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    data = DataHelper.buildPolicyData(null, null);
                    contextHandler.buildContextObject("POLICY_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 8L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            } else if (auditService.isEventRequired("SECURITY_AUTHZ", "DENIED")) {
                data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("isCallerInRole", "authz", null, rSubj, "authzDenied", null, "WAS", new Long(0L), null, null, roles, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
        }
        if (!result && tc.isDebugEnabled()) {
            String securityName = this.getSecurityName(credHolder.cred);
            String accessId = this.getAccessId(credHolder.cred);
            Tr.debug(tc, "SECJ0321E: Role based authorization is caller in role  failed for security name: " + securityName + " accessID: " + accessId + " and role name: " + roleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", new Boolean(result));
        }
        return result;
    }

    private CredHolder getEffectiveCredentials() {
        CredHolder credHolder;
        boolean missingCredentials;
        block19: {
            ContextManager contextManager;
            WSCredential receivedCred;
            Subject receivedSubject;
            WSCredential invocationCred;
            WSCredential effectiveCred;
            Subject effectiveSubject;
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getEffectiveCredentials");
                }
                effectiveSubject = null;
                effectiveCred = null;
                missingCredentials = false;
                Subject invocationSubject = null;
                invocationCred = null;
                receivedSubject = null;
                receivedCred = null;
                contextManager = ContextManagerFactory.getInstance();
                try {
                    invocationSubject = contextManager.getInvocationSubject();
                    invocationCred = SubjectHelper.getWSCredentialFromSubject(invocationSubject);
                    if (invocationCred != null && !invocationCred.isUnauthenticated()) {
                        effectiveSubject = invocationSubject;
                        effectiveCred = invocationCred;
                    }
                    if (effectiveCred == null && (receivedCred = SubjectHelper.getWSCredentialFromSubject(receivedSubject = contextManager.getCallerSubject())) != null && !receivedCred.isUnauthenticated()) {
                        effectiveSubject = receivedSubject;
                        effectiveCred = receivedCred;
                    }
                }
                catch (WSSecurityException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getEffectiveCredentials", "1006", this);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Exception getting invocation credential", e);
                }
            }
            if (invocationCred == null && receivedCred == null) {
                missingCredentials = true;
            }
            if (invocationCred != null && invocationCred.isUnauthenticated() && receivedCred != null && receivedCred.isUnauthenticated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invocation and received creds are UNAUTHENTICATED!");
                }
                effectiveSubject = receivedSubject;
                effectiveCred = receivedCred;
            }
            if (effectiveCred != null && !effectiveCred.isUnauthenticated() && effectiveCred.isBasicAuth()) {
                try {
                    effectiveCred = contextManager.authenticate(effectiveCred);
                }
                catch (WSSecurityException wse) {
                    FFDCFilter.processException((Throwable)wse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "1042", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during authentication", wse);
                    }
                    effectiveCred = null;
                }
            }
            credHolder = new CredHolder(effectiveSubject, effectiveCred, missingCredentials);
            if (credHolder.cred == null) {
                try {
                    credHolder.subject = contextManager.createUnauthenticatedSubject();
                    credHolder.cred = contextManager.getUnauthenticatedCredential();
                }
                catch (WSSecurityException wse) {
                    FFDCFilter.processException((Throwable)wse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "1059", this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "Exception getting unauthenticated cred", wse);
                }
            }
        }
        if (credHolder.cred.isUnauthenticated() || missingCredentials) {
            String msg = "Unauthenticated or missing subject/credentials.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unauthenticated or missing subject/credentials.", new Exception("Unauthenticated or missing subject/credentials."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveCredentials", credHolder);
        }
        return credHolder;
    }

    public boolean isGrantedRole(String[] roleNames, Subject authSubject) {
        ContextHandler contextHandler;
        ContextManager contextManager;
        Exception failure;
        WSCredential authCreds;
        boolean result;
        block36: {
            result = false;
            authCreds = SubjectHelper.getWSCredentialFromSubject(authSubject);
            failure = null;
            contextManager = ContextManagerFactory.getInstance();
            contextHandler = null;
            if (authCreds != null && authCreds.isBasicAuth()) {
                try {
                    authCreds = contextManager.authenticate(authCreds);
                }
                catch (WSSecurityException wse) {
                    FFDCFilter.processException((Throwable)wse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "1095", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during authentication", wse);
                    }
                    authCreds = null;
                }
            }
            if (authCreds == null) {
                try {
                    authSubject = contextManager.createUnauthenticatedSubject();
                    authCreds = contextManager.getUnauthenticatedCredential();
                }
                catch (WSSecurityException wse) {
                    FFDCFilter.processException((Throwable)wse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl", "1110", this);
                    if (!tc.isDebugEnabled()) break block36;
                    Tr.debug(tc, "Exception getting unauthenticated cred", wse);
                }
            }
        }
        try {
            int i;
            LinkedHashSet<String> requiredRoles = new LinkedHashSet<String>();
            if (this.appName.startsWith("admin-authz")) {
                for (i = 0; i < roleNames.length; ++i) {
                    AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
                    if (aa != null) {
                        List parentList = aa.getAllParentRoles(roleNames[i]);
                        requiredRoles.add(roleNames[i]);
                        requiredRoles.addAll(parentList);
                        continue;
                    }
                    requiredRoles.add(roleNames[i]);
                }
            } else {
                for (i = 0; i < roleNames.length; ++i) {
                    requiredRoles.add(roleNames[i]);
                }
            }
            if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(authCreds))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                }
                roleNames = requiredRoles.toArray(new String[0]);
                result = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, roleNames, authSubject);
            } else {
                RoleBasedSubjectMap subjectMap;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling default authz engine for authorization decision");
                }
                if ((subjectMap = this.configurator.getRoleBasedSubjectMap(this.appName)).isGrantedAnyRole(authCreds, requiredRoles)) {
                    result = true;
                } else if (this.isGroupGrantedAnyRole(requiredRoles, subjectMap, authCreds)) {
                    result = true;
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isGrantedRole", "1159", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception caught", t);
            }
            failure = t instanceof Exception ? (Exception)t : null;
        }
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (auditService != null && (contextHandler = ((AuditServiceImpl)auditService).getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        if (auditService != null) {
            HashMap data;
            String rSubj = null;
            if (authSubject != null) {
                rSubj = ((Principal)authSubject.getPrincipals().toArray()[0]).getName();
            }
            if (result) {
                if (auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS")) {
                    data = DataHelper.buildSessionData(null, null, null, null);
                    contextHandler.buildContextObject("SESSION_CONTEXT", data);
                    data = DataHelper.buildAccessData("isGrantedRole", "authz", null, rSubj, "authzSuccess", null, "WAS", new Long(0L), null, null, roleNames, roleNames);
                    contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                    data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                    contextHandler.buildContextObject("EVENT_CONTEXT", data);
                    data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                    contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                    data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                    contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                    data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                    contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                    data = DataHelper.buildProviderData(providerName, "providerSuccess");
                    contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                    data = DataHelper.buildPolicyData(null, null);
                    contextHandler.buildContextObject("POLICY_CONTEXT", data);
                    this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 8L);
                    try {
                        auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                    }
                    catch (ProviderFailureException e) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, e);
                    }
                }
            } else if (auditService.isEventRequired("SECURITY_AUTHZ", "DENIED")) {
                data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData("isGrantedRole", "authz", null, rSubj, "authzDenied", null, "WAS", new Long(0L), null, null, roleNames, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), this.default_realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
        }
        if (!result && tc.isDebugEnabled()) {
            String failedRole = roleNames[roleNames.length - 1];
            String securityName = this.getSecurityName(authCreds);
            String accessId = this.getAccessId(authCreds);
            Tr.debug(tc, "security.rolebauthz.iscallerinrolefail", new Object[]{securityName, accessId, failedRole});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole, result:" + result);
        }
        return result;
    }

    private String getAccessId(WSCredential cred) {
        String accessId;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAccessId", cred);
            }
            accessId = null;
            try {
                if (cred != null) {
                    accessId = cred.getAccessId();
                    if (this.ignoreCase) {
                        accessId = accessId.toLowerCase();
                    }
                } else {
                    accessId = "NO_CRED_NO_ACCESS_ID";
                }
            }
            catch (GeneralSecurityException gse) {
                FFDCFilter.processException((Throwable)gse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getAccessId", "1360", this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Unexpected exception getting accessId", gse);
            }
        }
        if (accessId == null) {
            accessId = "NULL_ACCESS_ID";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", accessId);
        }
        return accessId;
    }

    private String getSecurityName(WSCredential cred) {
        String securityName;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityName", cred);
            }
            securityName = null;
            try {
                if (cred != null) {
                    securityName = cred.getSecurityName();
                }
            }
            catch (GeneralSecurityException gse) {
                FFDCFilter.processException((Throwable)gse, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getAccessId", "1387", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Unexpected exception getting securityName", gse);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", securityName);
        }
        return securityName;
    }

    public boolean isGrantedAnyRole(String[] roles) {
        CredHolder credHolder;
        boolean result;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isGrantedAnyRole", roles);
            }
            result = false;
            if (roles == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGrantedAnyRole", new Boolean(result));
                }
                return result;
            }
            credHolder = this.getEffectiveCredentials();
            if (credHolder.isThreadMissingCredentials()) {
                String msg = "Invocation and received credentials are both null";
                Exception ex = new Exception("Invocation and received credentials are both null");
                Tr.error(tc, "security.rolebauthz.nocred2", new Object[]{roles[0], ex});
            }
            try {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (this.pluggableAuthTable != null && (this.handleAllAuthz() || !contextManager.isInternalServerCredential(credHolder.cred))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling " + this.pluggableAuthTable + " for authorization decision");
                    }
                    result = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, roles, credHolder.subject);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling default authz engine for authorization decision");
                    }
                    RoleBasedSubjectMap subjectMap = this.configurator.getRoleBasedSubjectMap(this.appName);
                    HashSet<String> requiredRoles = new HashSet<String>();
                    for (int i = 0; i < roles.length; ++i) {
                        requiredRoles.add(roles[i]);
                    }
                    if (subjectMap.isGrantedAnyRole(credHolder.cred, requiredRoles)) {
                        result = true;
                    } else if (this.isGroupGrantedAnyRole(requiredRoles, subjectMap, credHolder.cred)) {
                        result = true;
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", "531", this);
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug(tc, "Unexpected exception caught: ", t);
            }
        }
        if (!result && tc.isDebugEnabled()) {
            String securityName = this.getSecurityName(credHolder.cred);
            String accessId = this.getAccessId(credHolder.cred);
            String roleName = roles[0];
            for (int j = 1; j < roles.length; ++j) {
                roleName = roleName + ":" + roles[j];
            }
            Tr.debug(tc, "SECJ0321E: Role based authorization is caller in role  failed for security name: " + securityName + " accessID: " + accessId + " and role name: " + roleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(result));
        }
        return result;
    }

    boolean handleAllAuthz() {
        if (this._alreadyAttempted) {
            return this._handleAllAuthz;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAllAuthz");
        }
        if (this.security.getActiveUserRegistry().getBoolean("useRegistryServerId")) {
            this._handleAllAuthz = true;
        } else if (this.isSAFAuthz) {
            this._handleAllAuthz = true;
        } else {
            Properties toplevel_props = this.security.getProperties();
            String handleAll = (String)toplevel_props.get("com.ibm.websphere.security.handleAllAuthorizations");
            if (handleAll != null && (handleAll.equalsIgnoreCase("true") || handleAll.equalsIgnoreCase("yes"))) {
                this._handleAllAuthz = true;
            }
        }
        this._alreadyAttempted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAllAuthz", new Boolean(this._handleAllAuthz));
        }
        return this._handleAllAuthz;
    }

    private static final class CredHolder {
        WSCredential cred = null;
        Subject subject = null;
        boolean threadMissingCredentials = false;

        CredHolder(Subject subject, WSCredential cred, boolean threadMissingCreds) {
            this.subject = subject;
            this.cred = cred;
            this.threadMissingCredentials = threadMissingCreds;
        }

        public boolean isThreadMissingCredentials() {
            return this.threadMissingCredentials;
        }

        public String toString() {
            return super.toString() + ";cred=" + this.cred + ";subject=" + this.subject + ";threadMissingCredentials=" + this.threadMissingCredentials;
        }
    }
}

