/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.CertificateMapper;
import com.ibm.ws.security.registry.ldap.CertificateMapperException;
import com.ibm.ws.security.registry.ldap.EntryEnumeration;
import com.ibm.ws.security.registry.ldap.IdMap;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.net.URLDecoder;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapRegistryImpl
implements UserRegistry {
    private static TraceComponent tc = Tr.register(LdapRegistryImpl.class, null, "com.ibm.ejs.resources.security");
    private static final int RETRIES = 3;
    public static final String USER_FILTER = "user.filter";
    public static final String GROUP_FILTER = "group.filter";
    public static final String CERTIFICATE_MAP_MODE = "certificate.map.mode";
    public static final String CERTIFICATE_MAP_FILTER = "certificate.map.filter";
    private static final String[] noAttrs = new String[]{"1.1"};
    public static final String OBJECT_FILTER = "(objectclass=*)";
    private boolean URLContextImpl = false;
    private String LdapURL = null;
    private int searchTimeLimit = 120000;
    private static final String[] dnAttrib = new String[]{"dn"};
    private final String[] krbAttr = new String[]{"krbprincipalname"};
    private static final String RACF_GROUP_ATTRIBUTE = "racfconnectgroupname";
    private static final String[] GROUP_ATTRIBUTES = new String[]{"nsroledn", "nsrole", "ibm-allGroups", "memberof"};
    private static final String iPlanet_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static final String MS_OBJECT_FILTER = "(objectCategory=*)";
    private String objectFilter = "(objectclass=*)";
    private String objectGroupDnFilter = "(objectclass=*)";
    private String objectUserDnFilter = "(objectclass=*)";
    private boolean ignoreCaseMatch = false;
    private boolean useAttributeGroupMethod = false;
    private boolean registryExist = false;
    private Vector DirContextPool = new Vector();
    private int ContextPoolSize = 0;
    private boolean recursiveSearch = false;
    private int busyCount = 0;
    private Object lockObj1 = new Object();
    private Object lockObj2 = new Object();
    private static boolean useMixedSearch = false;
    private Vector table1 = new Vector();
    private Vector table2 = new Vector();
    private Vector table3 = new Vector();
    private static Thread LdapMonitorThread = null;
    private String realm = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString = RegistryUtil.nullString;
    protected static final String[] nullStringArray = RegistryUtil.nullStringArray;
    protected static final byte[] nullByteArray = RegistryUtil.nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private LdapConfig ldapConfig;
    private IdMap idMap;
    private CertificateMapper certMap;
    private boolean refresh = false;
    private String bindDN = null;
    private String bindPWD = null;
    private String bindHost = null;
    private String currentActiveLDAP = null;
    private int maxContextPerConnection = 5;
    private int maxIdleContext = 30;
    private static TraceComponent innerTc = Tr.register(LdapMonitor.class.getName(), null, "com.ibm.ejs.resources.security");

    protected DirContext getRootDSE() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootDSE");
        }
        DirContext ctx = null;
        while (this.DirContextPool != null && this.DirContextPool.size() > 30) {
            try {
                ctx = (DirContext)this.DirContextPool.lastElement();
                this.DirContextPool.removeElement(ctx);
                ctx.close();
                --this.ContextPoolSize;
            }
            catch (Exception e) {}
        }
        try {
            ctx = (DirContext)this.DirContextPool.lastElement();
            this.DirContextPool.removeElement(ctx);
            Tr.exit(tc, "getRootDSE");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRootDSE");
            }
            return ctx;
        }
        catch (Exception E) {
            DirContext dse = this.ldapConfig.getRootDSE();
            if (this.ContextPoolSize == 0) {
                for (int i = 0; i < 10; ++i) {
                    ctx = (DirContext)dse.lookup(NONE);
                    this.DirContextPool.addElement(ctx);
                    ++this.ContextPoolSize;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "DirContext pool initialized.");
                }
            }
            ctx = (DirContext)dse.lookup(NONE);
            ++this.ContextPoolSize;
            if (tc.isDebugEnabled() && this.ContextPoolSize > 30) {
                Tr.debug(tc, "DirContext pool size = " + this.ContextPoolSize);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRootDSE");
            }
            return ctx;
        }
    }

    protected void disconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disconnect");
        }
        while (!this.DirContextPool.isEmpty()) {
            try {
                DirContext ctx = (DirContext)this.DirContextPool.lastElement();
                this.DirContextPool.removeElement(ctx);
                ctx.close();
            }
            catch (Exception exception) {}
        }
        this.ContextPoolSize = 0;
        this.ldapConfig.disconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disconnect");
        }
    }

    public String checkPassword(String dn, String pwd) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", dn);
        }
        String authName = null;
        try {
            Result allUsers;
            int size;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticating", dn);
            }
            if (dn.length() == 0 || pwd.length() == 0) {
                PasswordCheckFailedException ex = new PasswordCheckFailedException("The userId and/or password is empty");
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{dn});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", ex);
                }
                throw ex;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Searching for users");
            }
            if (!this.fullDN(dn, this.ldapConfig.getBaseDn())) {
                dn = LdapRegistryImpl.escapeChar(dn, '*');
            }
            if ((size = (allUsers = this.getUsers(dn, 2)).getList().size()) > 1) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("security.authn.failed.multiusers", new Object[]{dn}, "Multiple users with the name of " + dn);
                PasswordCheckFailedException ex = new PasswordCheckFailedException(message);
                Tr.error(tc, message);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", ex);
                }
                throw ex;
            }
            if (size == 0) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("security.authn.failed.nouser", new Object[]{dn}, "No user " + dn + " found");
                PasswordCheckFailedException ex = new PasswordCheckFailedException(message);
                Tr.error(tc, message);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", ex);
                }
                throw ex;
            }
            dn = (String)allUsers.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found user", dn);
            }
            authName = this.authenticate(dn, pwd);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticated with", dn);
            }
        }
        catch (Exception exc) {
            if (!(exc instanceof com.ibm.websphere.security.auth.AuthenticationNotSupportedException || exc instanceof AuthenticationFailedException || exc instanceof RegistryErrorException)) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.checkPassword", "349", this);
                Tr.error(tc, "security.authn.error", new Object[]{dn, exc.toString()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", exc);
            }
            if (exc.getCause() != null) {
                throw new CustomRegistryException(exc.getCause().toString(), exc);
            }
            throw new CustomRegistryException(exc.getMessage(), exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword", authName);
        }
        return authName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String authenticate(String dn, String pwd) throws AuthenticationFailedException, com.ibm.websphere.security.auth.AuthenticationNotSupportedException, RegistryErrorException, CustomRegistryException {
        StringTokenizer st;
        long startTime = 0L;
        LdapConfig tmpConfig = new LdapConfig(this.ldapConfig);
        tmpConfig.setAuthenticationPrincipal(dn);
        tmpConfig.setAuthenticationCredentials(pwd);
        String ldapHost = this.ldapConfig.getDirectoryUrl();
        boolean isRetry = this.ldapConfig.isRetryBind();
        if (isRetry && dn.equalsIgnoreCase(this.ldapConfig.getAuthenticationPrincipal()) && (st = new StringTokenizer(ldapHost)).countTokens() > 1) {
            while (st.hasMoreTokens()) {
                Object var13_14;
                String ldap = st.nextToken();
                tmpConfig.setDirectoryUrl(ldap);
                try {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "(Bind ID) Bind to " + ldap);
                        }
                        startTime = System.currentTimeMillis();
                        this.enterJNDI();
                        InitialDirContext ctx = new InitialDirContext(tmpConfig);
                        this.exitJNDI();
                        ctx.close();
                        if (tc.isDebugEnabled()) {
                            StringBuffer sb = new StringBuffer("Same DN - Time elapsed to open/close DirContext: ");
                            sb = sb.append(System.currentTimeMillis() - startTime);
                            Tr.debug(tc, sb.toString());
                        }
                        String string = dn;
                        var13_14 = null;
                        this.exitJNDI();
                        return string;
                    }
                    catch (NamingException ex) {
                        this.exitJNDI();
                        var13_14 = null;
                        this.exitJNDI();
                    }
                }
                catch (Throwable throwable) {
                    var13_14 = null;
                    this.exitJNDI();
                    throw throwable;
                }
            }
        }
        if (!isRetry) {
            StringTokenizer st2;
            String tempLdapHost = null;
            if (this.currentActiveLDAP != null) {
                tempLdapHost = this.currentActiveLDAP;
            } else if (ldapHost != null && (st2 = new StringTokenizer(ldapHost)).hasMoreTokens()) {
                tempLdapHost = st2.nextToken();
            }
            if (tempLdapHost != null) {
                tmpConfig.setDirectoryUrl(tempLdapHost);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRetry:false Bind to " + tmpConfig.getDirectoryUrl());
            }
        } else if (ldapHost != null && this.currentActiveLDAP != null && !ldapHost.startsWith(this.currentActiveLDAP)) {
            ldapHost = this.currentActiveLDAP + " " + ldapHost;
            tmpConfig.setDirectoryUrl(ldapHost);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Bind to " + tmpConfig.getDirectoryUrl());
            }
        }
        try {
            try {
                CharSequence sb;
                startTime = System.currentTimeMillis();
                this.enterJNDI();
                InitialDirContext ctx = new InitialDirContext(tmpConfig);
                this.exitJNDI();
                ctx.close();
                if (tc.isDebugEnabled()) {
                    sb = new StringBuffer("Time elapsed to open/close DirContext: ");
                    sb = ((StringBuffer)sb).append(System.currentTimeMillis() - startTime);
                    Tr.debug(tc, ((StringBuffer)sb).toString());
                }
                sb = dn;
                Object var15_17 = null;
                this.exitJNDI();
                return sb;
            }
            catch (AuthenticationNotSupportedException anse) {
                this.exitJNDI();
                FFDCFilter.processException((Throwable)anse, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "450", this);
                Tr.error(tc, "security.authn.error", new Object[]{dn, anse.toString()});
                throw new com.ibm.websphere.security.auth.AuthenticationNotSupportedException(anse.getMessage(), anse);
            }
            catch (AuthenticationException ae) {
                this.exitJNDI();
                FFDCFilter.processException((Throwable)ae, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "456", this);
                throw new AuthenticationFailedException(ae.getMessage(), ae);
            }
            catch (NamingException ne) {
                this.exitJNDI();
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "462", this);
                Tr.error(tc, "security.authn.error", new Object[]{dn, ne.toString()});
                this.logNamingException(ne, dn);
                if (!(ne instanceof CommunicationException)) throw new RegistryErrorException(ne.getMessage(), ne);
                String ldaps = this.ldapConfig.getDirectoryUrl();
                Tr.audit(tc, "security.registry.ldap.connect.audit", new Object[]{ldaps});
                throw new RegistryErrorException(ne.getMessage(), ne);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.exitJNDI();
            throw throwable;
        }
    }

    private static String normalizeDN(String dn) {
        int dnlen = dn.length();
        StringBuffer sb = new StringBuffer(dnlen);
        boolean removeSpace = true;
        boolean lowerCase = true;
        int lastChar = 32;
        for (int i = 0; i < dnlen; ++i) {
            char c = dn.charAt(i);
            if (removeSpace) {
                if (c != ' ') {
                    if (lowerCase) {
                        sb.append(Character.toLowerCase(c));
                    } else {
                        sb.append(c);
                        removeSpace = false;
                    }
                    if (c == '=') {
                        lowerCase = false;
                    }
                }
            } else {
                if ((c == ',' || c == ';') && lastChar != 92) {
                    removeSpace = true;
                    lowerCase = true;
                }
                sb.append(c);
            }
            lastChar = c;
        }
        return sb.toString();
    }

    public String mapCertificate(X509Certificate[] cert1) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        X509Certificate cert = cert1[0];
        String name = null;
        String dn = null;
        String filter = null;
        int searchScope = 0;
        try {
            filter = this.certMap.getLdapSearchFilter(cert);
            searchScope = this.certMap.getLdapSearchScope();
        }
        catch (CertificateMapperException cme) {
            FFDCFilter.processException((Throwable)cme, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", "545", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CertificatMapperException caught during LDAP operation while looking for: " + cert.getSubjectDN().getName());
            }
            Tr.error(tc, "security.registry.ldap.mapcredentialBadFilter", new Object[]{cert.getSubjectDN().getName()});
            throw new CertificateMapFailedException(cme.getMessage(), cme);
        }
        try {
            if (searchScope == 0) {
                Result allUsers;
                int size;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Searching for users");
                }
                if ((size = (allUsers = this.getUsers(filter, 2)).getList().size()) > 1) {
                    CertificateMapFailedException ex = new CertificateMapFailedException("Multiple users with the name of " + dn);
                    Tr.error(tc, "security.authn.failed.multiusers", new Object[]{dn});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "mapCertificate", ex);
                    }
                    throw ex;
                }
                if (size == 0) {
                    CertificateMapFailedException ex = new CertificateMapFailedException("No user " + dn + " found");
                    Tr.error(tc, "security.authn.failed.nouser", new Object[]{dn});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "mapCertificate", ex);
                    }
                    throw ex;
                }
                name = (String)allUsers.getList().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "certificate dn =", filter);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "normalized  dn =", name);
                }
            } else {
                EntryEnumeration ee = this.search(searchScope, filter, 2);
                if (ee.hasMoreElements()) {
                    name = (String)ee.nextElement();
                    if (ee.hasMoreElements()) {
                        ee.close();
                        Tr.error(tc, "security.authn.failed.multiusers", new Object[]{cert.getSubjectDN().getName()});
                        throw new CertificateMapFailedException("Multiple users with the name of " + cert.getSubjectDN().getName());
                    }
                }
            }
        }
        catch (NamingException ne) {
            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", "602", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NamingException caught during LDAP operation while looking for: " + cert.getSubjectDN().getName());
            }
            Tr.error(tc, "security.registry.ldap.mapcredentialNamingEx", new Object[]{cert.getSubjectDN().getName(), filter});
            this.logNamingException(ne);
            throw new CertificateMapFailedException(ne.getMessage(), ne);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.mapCertificate", "610", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during LDAP operation while looking for: " + cert.getSubjectDN().getName());
            }
            throw new CertificateMapFailedException(e.getMessage(), e);
        }
        if (name == null) {
            Tr.error(tc, "security.registry.ldap.mapcredentialNotFound", new Object[]{cert.getSubjectDN().getName(), filter});
            throw new CertificateMapFailedException("The name in the certificate: " + cert.getSubjectDN().getName() + " cannot be found in the registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate");
        }
        return name;
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", securityName);
        }
        String retVal = null;
        try {
            Attributes attrs = this.getAttributes(securityName, this.idMap.getAttributes());
            retVal = this.idMap.getGroupName(attrs);
            if (tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security name =", securityName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attributes =", attrs);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Name =", attrs);
                }
            }
        }
        catch (NamingException ne) {
            this.logNamingException(ne);
        }
        if (retVal == null) {
            retVal = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName", retVal);
        }
        return retVal;
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        String groupDN;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", securityName);
        }
        String sName = null;
        try {
            sName = securityName;
            Result allGroups = this.getGroups(sName, 2);
            int size = allGroups.getList().size();
            if (size > 1) {
                CustomRegistryException ex = new CustomRegistryException("Multiple groups with the name of " + sName);
                Tr.error(tc, "security.authn.failed.multiusers", new Object[]{sName});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId", ex);
                }
                throw ex;
            }
            if (size == 0) {
                EntryNotFoundException ex = new EntryNotFoundException("No group " + sName + " found");
                Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{securityName});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId", ex);
                }
                throw ex;
            }
            groupDN = (String)allGroups.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found group", groupDN);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUniqueGroupId", "709", this);
            if (e instanceof CustomRegistryException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId");
                }
                throw new CustomRegistryException(e.getMessage(), e);
            }
            if (e instanceof EntryNotFoundException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId");
                }
                throw new EntryNotFoundException(e.getMessage(), e);
            }
            Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{sName});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueGroupId");
            }
            throw new CustomRegistryException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", groupDN);
        }
        return groupDN;
    }

    public List getUniqueGroupIds(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", uniqueUserId);
        }
        List grpList = this.getGroupsForUser(uniqueUserId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds");
        }
        return grpList;
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
        }
        Result result = new Result();
        if (limit < 0) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
            }
            return result;
        }
        EntryEnumeration e = null;
        int orgLimit = limit++;
        int count = 0;
        if (orgLimit == 0 || orgLimit < Integer.MAX_VALUE) {
            // empty if block
        }
        try {
            ArrayList<Object> groups;
            block21: {
                if (this.fullDN(pattern, this.ldapConfig.getGroupBaseDn())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pattern is full DN");
                    }
                    e = this.search(pattern, 0, this.objectGroupDnFilter, limit);
                } else {
                    String filter = this.ldapConfig.getFilter(GROUP_FILTER).prepare(pattern);
                    e = this.search(this.ldapConfig.getGroupBaseDn(), 2, filter, limit);
                }
                if (e == null) {
                    ArrayList noGroups = new ArrayList(0);
                    result.setList(noGroups);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No groups found");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(orgLimit).toString());
                    }
                    return result;
                }
                groups = new ArrayList<Object>();
                if (orgLimit != 0) {
                    groups = new ArrayList(limit);
                }
                while (e.hasMoreElements()) {
                    groups.add(e.nextElement());
                    if (orgLimit == 0 || ++count != orgLimit) continue;
                }
                result.setList(groups);
                try {
                    if (e.hasMoreElements()) {
                        result.setHasMore();
                        e.close();
                    }
                }
                catch (Exception ee) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "no more groups");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of groups returned = " + groups.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(orgLimit).toString());
            }
            return result;
        }
        catch (NamingException ne) {
            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroups", "819", this);
            this.logNamingException(ne);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{pattern});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", ne);
            }
            throw new CustomRegistryException(ne.getMessage(), ne);
        }
    }

    private void getAllGroupMembersByGroupObject(ArrayList memberNames, ArrayList members, ArrayList found, IdMap.IdEntry[] memberEntries, String objecttype) throws CustomRegistryException {
        if (memberNames.isEmpty()) {
            return;
        }
        boolean circular = true;
        int NoOfNames = memberNames.size();
        for (int k = 0; k < NoOfNames; ++k) {
            String name = (String)memberNames.get(k);
            if (found.contains(name)) continue;
            circular = false;
            found.add(name);
        }
        if (circular) {
            return;
        }
        StringBuffer sb = new StringBuffer("(|");
        for (int j = 0; j < NoOfNames; ++j) {
            String name = (String)memberNames.get(j);
            for (int i = 0; i < memberEntries.length; ++i) {
                if (memberEntries[i].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
                sb.append("(&(").append(objecttype).append("=").append(memberEntries[i].getObjectClassName()).append(")(");
                sb.append(memberEntries[i].getAttributeName()).append("=").append(name).append("))");
            }
        }
        sb.append(")");
        String filter = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "filter =", filter);
        }
        ArrayList<String> groupIds = new ArrayList<String>();
        try {
            String LDAPBaseDN = this.ldapConfig.getBaseDn();
            EntryEnumeration eGroups = new EntryEnumeration(this.ldapConfig.getGroupBaseDn(), this.search(this.ldapConfig.getBaseDn(), 2, filter, noAttrs, 0));
            while (eGroups.hasMoreElements()) {
                groupIds.add((String)eGroups.nextElement());
            }
            if (groupIds.isEmpty()) {
                return;
            }
            int NoOfGroups = groupIds.size();
            for (int l = 0; l < NoOfGroups; ++l) {
                String groupID = (String)groupIds.get(l);
                members.add(groupID);
            }
            if (this.recursiveSearch) {
                this.getAllGroupMembersByGroupObject(groupIds, members, found, memberEntries, objecttype);
            }
        }
        catch (NamingException ne) {
            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", "898", this);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{found.get(0)});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", ne);
            }
            throw new CustomRegistryException(ne.getMessage(), ne);
        }
    }

    private void getAllGroupMembershipsByUserObject(String securityName, ArrayList members, ArrayList found, String[] attributes) throws EntryNotFoundException {
        if (found.contains(securityName)) {
            return;
        }
        found.add(securityName);
        HashSet<String> groupsSet = new HashSet<String>();
        try {
            NamingEnumeration ne;
            if (this.fullDN(securityName, this.ldapConfig.getBaseDn())) {
                ne = this.search(securityName, 0, this.objectUserDnFilter, attributes, 0);
            } else {
                String filter = this.ldapConfig.getFilter(USER_FILTER).prepare(securityName);
                ne = this.search(this.ldapConfig.getBaseDn(), 2, filter, attributes, 0);
            }
            if (ne.hasMoreElements()) {
                SearchResult r = (SearchResult)ne.next();
                NamingEnumeration<? extends Attribute> attrs = r.getAttributes().getAll();
                HashSet<String> attributesSet = new HashSet<String>();
                for (int i = 0; i < attributes.length; ++i) {
                    attributesSet.add(attributes[i]);
                }
                while (attrs.hasMoreElements()) {
                    Attribute attrib = attrs.next();
                    String at = attrib.getID();
                    if (!attributesSet.contains(at)) continue;
                    for (int i = 0; i < attrib.size(); ++i) {
                        String gp = (String)attrib.get(i);
                        gp = RegistryUtil.removeDNSpace(gp, 0);
                        groupsSet.add(gp);
                    }
                }
                if (ne.hasMoreElements()) {
                    ne.close();
                }
                for (String groupID : groupsSet) {
                    if (!members.contains(groupID)) {
                        members.add(groupID);
                    }
                    if (!this.recursiveSearch) continue;
                    this.getAllGroupMembershipsByUserObject(groupID, members, found, attributes);
                }
            }
        }
        catch (NamingException ne) {
            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", "971", this);
            this.logNamingException(ne);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName});
            throw new EntryNotFoundException(ne.getMessage(), ne);
        }
    }

    private void getAllGroupMembershipsByUserObject(String securityName, ArrayList members, ArrayList found, String att) throws EntryNotFoundException {
        if (found.contains(securityName)) {
            return;
        }
        found.add(securityName);
        String[] retAttrs = new String[]{att};
        Vector<String> v = new Vector<String>(5);
        try {
            NamingEnumeration ne;
            if (this.fullDN(securityName, this.ldapConfig.getBaseDn())) {
                ne = this.search(securityName, 0, this.objectUserDnFilter, retAttrs, 0);
            } else {
                String filter = this.ldapConfig.getFilter(USER_FILTER).prepare(securityName);
                ne = this.search(this.ldapConfig.getBaseDn(), 2, filter, retAttrs, 0);
            }
            if (ne.hasMoreElements()) {
                SearchResult r = (SearchResult)ne.next();
                NamingEnumeration<? extends Attribute> attrs = r.getAttributes().getAll();
                while (attrs.hasMoreElements()) {
                    Attribute attrib = attrs.next();
                    String at = attrib.getID();
                    if (!at.equalsIgnoreCase(retAttrs[0])) continue;
                    for (int i = 0; i < attrib.size(); ++i) {
                        String gp = (String)attrib.get(i);
                        gp = RegistryUtil.removeDNSpace(gp, 0);
                        v.addElement(gp);
                    }
                }
                if (ne.hasMoreElements()) {
                    ne.close();
                }
                ListIterator iter = v.listIterator();
                while (iter.hasNext()) {
                    String groupID = (String)iter.next();
                    if (!members.contains(groupID)) {
                        members.add(groupID);
                    }
                    if (!this.recursiveSearch) continue;
                    this.getAllGroupMembershipsByUserObject(groupID, members, found, att);
                }
            }
        }
        catch (NamingException ne) {
            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getGroupsForUser", "1044", this);
            this.logNamingException(ne);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser");
            }
            throw new EntryNotFoundException(ne.getMessage(), ne);
        }
    }

    public List getGroupsForUser(String securityName) throws EntryNotFoundException, CustomRegistryException {
        IdMap.IdEntry[] memberEntries;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", securityName);
        }
        if (!this.fullDN(securityName, this.ldapConfig.getBaseDn())) {
            securityName = this.getUniqueUserId(securityName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using DN: " + securityName);
            }
        }
        if ((memberEntries = this.idMap.getGroupMembers()).length == 0) {
            return new ArrayList(0);
        }
        ArrayList members = new ArrayList();
        if (useMixedSearch) {
            String[] attributes = new String[memberEntries.length];
            for (int i = 0; i < memberEntries.length; ++i) {
                attributes[i] = memberEntries[i].getObjectClassName();
            }
            this.getAllGroupMembershipsByUserObject(securityName, members, new ArrayList(), attributes);
            String objecttype = "objectclass";
            for (int i = 0; i < memberEntries.length; ++i) {
                if (!memberEntries[i].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
                objecttype = "objectCategory";
                break;
            }
            ArrayList<String> memberNames = new ArrayList<String>();
            memberNames.add(securityName);
            this.getAllGroupMembersByGroupObject(memberNames, members, new ArrayList(), memberEntries, objecttype);
            members = new ArrayList(new HashSet(members));
        } else if (this.useAttributeGroupMethod) {
            String returnAtt = memberEntries[0].getObjectClassName();
            this.getAllGroupMembershipsByUserObject(securityName, members, new ArrayList(), returnAtt);
        } else {
            String objecttype = "objectclass";
            for (int i = 0; i < memberEntries.length; ++i) {
                if (!memberEntries[i].getObjectClassName().equalsIgnoreCase("objectCategory")) continue;
                objecttype = "objectCategory";
                break;
            }
            ArrayList<String> memberNames = new ArrayList<String>();
            memberNames.add(securityName);
            this.getAllGroupMembersByGroupObject(memberNames, members, new ArrayList(), memberEntries, objecttype);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of groups returned = " + members.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", members.toArray());
        }
        return members;
    }

    public Result getUsersForGroup(String securityName, int limit) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup");
        }
        Result result = new Result();
        int count = 0;
        String grpDN = null;
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        IdMap.IdEntry[] memberEntries = this.idMap.getGroupMembers();
        if (memberEntries.length == 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No filter specified for groupmeneber.idmap ");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        String[] retAttrs = new String[memberEntries.length];
        for (int i = 0; i < memberEntries.length; ++i) {
            retAttrs[i] = memberEntries[i].getAttributeName();
        }
        ArrayList<String> users = new ArrayList<String>(0);
        if (limit != 0 && limit < Integer.MAX_VALUE) {
            users = new ArrayList(limit + 1);
        } else if (limit == Integer.MAX_VALUE) {
            users = new ArrayList(limit);
        }
        try {
            NamingEnumeration e = this.search(securityName, 0, this.objectFilter, retAttrs, 1);
            if (e.hasMoreElements()) {
                SearchResult r = (SearchResult)e.next();
                NamingEnumeration<? extends Attribute> attrs = r.getAttributes().getAll();
                block3: while (attrs.hasMoreElements()) {
                    Attribute attrib = attrs.next();
                    for (int i = 0; i < attrib.size(); ++i) {
                        grpDN = (String)attrib.get(i);
                        grpDN = RegistryUtil.removeDNSpace(grpDN, 0);
                        users.add(grpDN);
                        if (limit >= Integer.MAX_VALUE || limit == 0 || ++count < limit + 1) continue;
                        result.setHasMore();
                        users.remove(grpDN);
                        continue block3;
                    }
                }
                if (e.hasMoreElements()) {
                    e.close();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsersForGroup");
                }
                result.setList(users);
            }
        }
        catch (NamingException ne) {
            this.logNamingException(ne);
            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsersForGroup", "1223", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{securityName});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup", ne);
            }
            throw new CustomRegistryException(ne.getMessage(), ne);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup");
        }
        return result;
    }

    public String getGroupSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", privilegeAttributeId);
        }
        String grpSecName = this.getUniqueGroupId(privilegeAttributeId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName", grpSecName);
        }
        return grpSecName;
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", securityName);
        }
        String retVal = null;
        try {
            Attributes attrs = this.getAttributes(securityName, this.idMap.getAttributes());
            retVal = this.idMap.getUserName(attrs);
            if (tc.isDebugEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "securityName =", securityName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attributes =", attrs);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "userName =", retVal);
                }
            }
        }
        catch (NamingException ne) {
            this.logNamingException(ne);
        }
        if (retVal == null) {
            retVal = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName");
        }
        return retVal;
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        String secName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        String sName = null;
        try {
            sName = securityName;
            Result allUsers = this.getUsers(sName, 2);
            int size = allUsers.getList().size();
            if (size > 1) {
                CustomRegistryException ex = new CustomRegistryException("Multiple users with the name of " + sName);
                Tr.error(tc, "security.authn.failed.multiusers", new Object[]{sName});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId", ex);
                }
                throw ex;
            }
            if (size == 0) {
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{sName});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId");
                }
                throw new EntryNotFoundException("Cannot find uniqueID for the user " + sName);
            }
            secName = (String)allUsers.getList().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found user", secName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUniqueUserId", "1333", this);
            if (e instanceof CustomRegistryException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId");
                }
                throw new CustomRegistryException(e.getMessage(), e);
            }
            if (e instanceof EntryNotFoundException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId");
                }
                throw new EntryNotFoundException(e.getMessage(), e);
            }
            Tr.error(tc, "security.registry.uniqueusrid.error", new Object[]{sName});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId");
            }
            throw new CustomRegistryException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", secName);
        }
        return secName;
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException {
        ArrayList<Object> users;
        int orgLimit;
        Result result;
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUsers", new Object[]{pattern, new Integer(limit)});
            }
            result = new Result();
            if (limit < 0) {
                ArrayList noUsers = new ArrayList(0);
                result.setList(noUsers);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No users searched as the limit is a negative number.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{pattern, new Integer(limit)});
                }
                return result;
            }
            EntryEnumeration e = null;
            orgLimit = limit++;
            int count = 0;
            if (orgLimit == 0 || orgLimit < Integer.MAX_VALUE) {
                // empty if block
            }
            try {
                if (this.fullDN(pattern, this.ldapConfig.getBaseDn())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pattern is full DN");
                    }
                    e = this.search(pattern, 0, this.objectUserDnFilter, limit);
                } else {
                    String filter = this.ldapConfig.getFilter(USER_FILTER).prepare(pattern);
                    e = this.search(2, filter, limit);
                }
            }
            catch (AuthenticationException ae) {
                FFDCFilter.processException((Throwable)ae, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsers", "1398", this);
                this.logNamingException(ae);
                Tr.error(tc, "security.registry.getusers.error", new Object[]{pattern, ae});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{pattern, new Integer(orgLimit), ae});
                }
                throw new CustomRegistryException(ae.getMessage(), ae);
            }
            catch (NamingException ne) {
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getUsers", "1405", this);
                this.logNamingException(ne);
                Tr.error(tc, "security.registry.getusers.error", new Object[]{pattern, ne});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{pattern, new Integer(orgLimit), ne});
                }
                if (ne.getCause() != null) {
                    throw new CustomRegistryException(ne.getCause().toString(), ne);
                }
                throw new CustomRegistryException(ne.getMessage(), ne);
            }
            if (e == null) {
                ArrayList noUsers = new ArrayList(0);
                result.setList(noUsers);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No users found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUsers", new Object[]{pattern, new Integer(orgLimit)});
                }
                return result;
            }
            users = new ArrayList<Object>();
            if (orgLimit != 0) {
                users = new ArrayList(limit);
            }
            while (e.hasMoreElements()) {
                String activeOID = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getString("OID");
                users.add(e.nextElement());
                if (orgLimit == 0 || ++count != orgLimit) continue;
                break;
            }
            result.setList(users);
            try {
                if (e.hasMoreElements()) {
                    result.setHasMore();
                    e.close();
                }
            }
            catch (Exception ee) {
                if (!tc.isDebugEnabled()) break block24;
                Tr.debug(tc, "no more users");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of users returned = " + users.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", new Object[]{pattern, new Integer(orgLimit)});
        }
        return result;
    }

    public String getUserSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", privilegeAttributeId);
        }
        String usrSecName = this.getUniqueUserId(privilegeAttributeId);
        boolean performIdMap = this.ldapConfig.performIdMap();
        if (performIdMap) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "As performIdMap property is, calling getUserDisplayName() using input : " + usrSecName);
            }
            usrSecName = this.getUserDisplayName(usrSecName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Per performIdMap property,  getUserDisplayName() is called. Returned value is : " + usrSecName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName", usrSecName);
        }
        return usrSecName;
    }

    public void initialize(Properties props) throws CustomRegistryException {
        IdMap.IdEntry[] memberEntries;
        String dirUrl;
        block45: {
            block44: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "initialize");
                }
                String type = "LDAP";
                this.DirContextPool = new Vector();
                this.ContextPoolSize = 0;
                this.busyCount = 0;
                this.currentActiveLDAP = null;
                this.table1 = new Vector();
                this.table2 = new Vector();
                this.table3 = new Vector();
                String s = props.getProperty("java.naming.provider.url");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "original uri: " + s);
                }
                if (s != null && s.length() > 0) {
                    boolean ldapIsh;
                    int i = s.indexOf(typeSeparator);
                    if (i < 0) {
                        throw new CustomRegistryException("Invalid URI: " + s);
                    }
                    StringBuffer newS = new StringBuffer();
                    if (ldapIsh = s.startsWith("//", ++i)) {
                        int j = s.indexOf(realmSeparator, i += 2);
                        if (j < 0) {
                            j = s.length();
                        }
                        if (s.startsWith("::", i)) {
                            newS.append(s.substring(0, i)).append("[");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "first newS: " + newS.toString());
                            }
                            int i1 = s.indexOf(typeSeparator, i += 2);
                            String hostname = s.substring(i, i1);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "hostname: " + hostname);
                            }
                            newS.append(hostname).append("]").append(s.substring(i1 + 1, j));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "second newS: " + newS.toString());
                            }
                            props.setProperty("java.naming.provider.url", newS.toString());
                        }
                    }
                }
                try {
                    this.ldapConfig = new LdapConfig(props);
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.initialize", "1547", this);
                    Tr.error(tc, "security.registry.ldap.initerror", new Object[]{exc});
                    throw new CustomRegistryException(exc.toString(), exc);
                }
                dirUrl = this.ldapConfig.getDirectoryUrl();
                if (dirUrl == null || dirUrl.length() == 0) {
                    throw new CustomRegistryException("No Directory URL");
                }
                if (this.ldapConfig.getFilter(USER_FILTER) == null) {
                    throw new CustomRegistryException("No User Filter");
                }
                if (this.ldapConfig.getFilter(GROUP_FILTER) == null) {
                    throw new CustomRegistryException("No Group Filter");
                }
                this.realm = this.ldapConfig.getLogicRealm();
                if (this.realm == null || this.realm.length() == 0) {
                    this.realm = props.getProperty("LDAP.server.realm");
                }
                if (this.realm == null || this.realm.length() == 0) {
                    int i = dirUrl.indexOf(" ");
                    if (i > 0) {
                        dirUrl = dirUrl.substring(0, i);
                    }
                    int idx = dirUrl.indexOf("://");
                    this.realm = dirUrl.endsWith(realmSeparator) ? dirUrl.substring(idx + 3, dirUrl.length() - 1) : dirUrl.substring(idx + 3, dirUrl.length());
                }
                if (this.realm == null) {
                    throw new CustomRegistryException("Realm is not specified in LDAPRegistry realm field of security.xml");
                }
                this.realm = this.realm.trim();
                this.idMap = new IdMap(this.ldapConfig);
                this.certMap = new CertificateMapper();
                try {
                    this.certMap.setLdapMapMode(props.getProperty(CERTIFICATE_MAP_MODE));
                    this.certMap.setLdapFilterDescriptor(props.getProperty(CERTIFICATE_MAP_FILTER));
                }
                catch (CertificateMapperException cme) {
                    FFDCFilter.processException((Throwable)cme, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.initialize", "1610", this);
                    if (!tc.isDebugEnabled()) break block44;
                    Tr.debug(tc, "initialize", cme);
                }
            }
            try {
                int iTimeLimit = -1;
                String sTimeLimit = props.getProperty("security.registry.ldap.searchTimeLimit");
                if (sTimeLimit != null && sTimeLimit.length() > 0) {
                    iTimeLimit = new Integer(sTimeLimit);
                }
                if (iTimeLimit > 0) {
                    this.searchTimeLimit = iTimeLimit * 1000;
                }
            }
            catch (Exception e1) {
                if (!tc.isDebugEnabled()) break block45;
                Tr.debug(tc, "initialize", "will try for 2 minutes");
            }
        }
        try {
            String sURLContextImpl = props.getProperty("security.registry.ldap.reuseConn");
            if (sURLContextImpl.equalsIgnoreCase("false")) {
                this.URLContextImpl = true;
                this.LdapURL = dirUrl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use URL Context Implementation.");
                }
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.scanInactiveLDAP();
        if (LdapMonitorThread == null) {
            LdapMonitorThread = new LdapMonitor();
            LdapMonitorThread.setDaemon(true);
            LdapMonitorThread.start();
        }
        if ((memberEntries = this.idMap.getGroupMembers()).length > 0 && !this.registryExist) {
            String tempDNFilter;
            this.recursiveSearch = this.ldapConfig.isRecursiveSearchEnabled();
            String filter = this.ldapConfig.getFilter(GROUP_FILTER).prepare("*").toLowerCase();
            if (filter.indexOf("ldapsubentry") > -1) {
                this.objectFilter = iPlanet_OBJECT_FILTER;
            }
            if (filter.indexOf("objectcategory") > -1) {
                this.objectFilter = MS_OBJECT_FILTER;
            }
            this.objectGroupDnFilter = (tempDNFilter = this.ldapConfig.getGroupDnSearchFilter()) != null ? tempDNFilter : this.objectFilter;
            tempDNFilter = this.ldapConfig.getUserDnSearchFilter();
            this.objectUserDnFilter = tempDNFilter != null ? tempDNFilter : this.objectFilter;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objectGroupDnFilter : " + this.objectGroupDnFilter);
                Tr.debug(tc, "objectUserDnFilter : " + this.objectUserDnFilter);
            }
            boolean schemaCheck = true;
            String ldapUrls = this.ldapConfig.getDirectoryUrl();
            StringTokenizer st = new StringTokenizer(ldapUrls);
            boolean groupObjectClass = false;
            while (st.hasMoreTokens()) {
                String ldapHost = st.nextToken();
                LdapConfig tmpConfig = new LdapConfig(this.ldapConfig);
                tmpConfig.setDirectoryUrl(ldapHost);
                try {
                    InitialDirContext ctx = new InitialDirContext(tmpConfig);
                    if (schemaCheck) {
                        schemaCheck = false;
                        for (int i = 0; i < memberEntries.length; ++i) {
                            try {
                                DirContext schema = ctx.getSchema(NONE);
                                String at = "AttributeDefinition/" + memberEntries[i].getObjectClassName();
                                DirContext cnSchema = (DirContext)schema.lookup(at);
                                this.useAttributeGroupMethod = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found attribute of LDAP user object that specifies the distinguished name of those groups to which this user belongs.");
                                }
                                if (!groupObjectClass) continue;
                                useMixedSearch = true;
                                continue;
                            }
                            catch (Exception che) {
                                groupObjectClass = true;
                                if (!this.useAttributeGroupMethod) continue;
                                useMixedSearch = true;
                            }
                        }
                    }
                    ctx.close();
                    break;
                }
                catch (NamingException ex) {
                }
            }
            if (!this.useAttributeGroupMethod && tc.isDebugEnabled()) {
                Tr.debug(tc, "Will call getGroupsForUser() to get user's group memberships.");
            }
        }
        this.maxContextPerConnection = this.ldapConfig.getMaxConcurrentSearchNumberPerConnection();
        this.maxIdleContext = this.ldapConfig.getSizeOfIdleContextPool();
        this.registryExist = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void scanInactiveLDAP() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanInactiveLDAP");
        }
        String ldapUrls = this.ldapConfig.getDirectoryUrl();
        StringTokenizer st = new StringTokenizer(ldapUrls);
        while (st.hasMoreTokens()) {
            String ldapHost = st.nextToken();
            LdapConfig tmpConfig = new LdapConfig(this.ldapConfig);
            tmpConfig.setDirectoryUrl(ldapHost);
            try {
                InitialDirContext ctx = new InitialDirContext(tmpConfig);
                ctx.close();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, ldapHost + " is ready to accept request");
            }
            catch (NamingException ex) {
                Tr.audit(tc, "security.registry.ldap.connect.audit", new Object[]{ldapHost});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanInactiveLDAP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidGroup(String securityName) throws CustomRegistryException {
        block7: {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isValidGroup");
            }
            try {
                try {
                    Result allGroups = this.getGroups(securityName, 2);
                    int size = allGroups.getList().size();
                    if (size != 1) break block7;
                    bl = true;
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidGroup", "1804", this);
                    Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{securityName});
                    Object var6_8 = null;
                    if (!tc.isEntryEnabled()) return false;
                    Tr.exit(tc, "isValidGroup");
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "isValidGroup");
                throw throwable;
            }
            if (!tc.isEntryEnabled()) return bl;
            Tr.exit(tc, "isValidGroup");
            return bl;
        }
        Object var6_7 = null;
        if (!tc.isEntryEnabled()) return false;
        Tr.exit(tc, "isValidGroup");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidUser(String securityName) throws CustomRegistryException {
        block8: {
            boolean bl;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isValidUser");
            }
            try {
                try {
                    Result allUsers;
                    int size;
                    if (!this.fullDN(securityName, this.ldapConfig.getBaseDn())) {
                        securityName = LdapRegistryImpl.escapeChar(securityName, '*');
                    }
                    if ((size = (allUsers = this.getUsers(securityName, 2)).getList().size()) != 1) break block8;
                    bl = true;
                    Object var6_6 = null;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.isValidUser", "1836", this);
                    Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName});
                    Object var6_8 = null;
                    if (!tc.isEntryEnabled()) return false;
                    Tr.exit(tc, "isValidUser");
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "isValidUser");
                throw throwable;
            }
            if (!tc.isEntryEnabled()) return bl;
            Tr.exit(tc, "isValidUser");
            return bl;
        }
        Object var6_7 = null;
        if (!tc.isEntryEnabled()) return false;
        Tr.exit(tc, "isValidUser");
        return false;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    protected Attributes getAttributes(String dn, String[] retAttrs) throws NamingException {
        NamingEnumeration ne = this.search(dn, 0, this.objectFilter, retAttrs, 0);
        if (ne.hasMoreElements()) {
            Attributes att;
            block4: {
                att = ((SearchResult)ne.nextElement()).getAttributes();
                if (ne.hasMoreElements()) {
                    try {
                        ne.close();
                    }
                    catch (NamingException e) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug(tc, "Exception occurs while close NamingException.");
                    }
                }
            }
            return att;
        }
        return null;
    }

    protected String getEntry(String dn) throws NamingException {
        String retval;
        block4: {
            EntryEnumeration nEnum = this.search(dn, 0, this.objectFilter, 0);
            retval = null;
            if (nEnum.hasMoreElements()) {
                retval = (String)nEnum.nextElement();
                if (nEnum.hasMoreElements()) {
                    try {
                        nEnum.close();
                    }
                    catch (NamingException e) {
                        if (!tc.isDebugEnabled()) break block4;
                        Tr.debug(tc, "Exception occurs while close NamingException.");
                    }
                }
            }
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getNormalizedDN(String dn) throws NamingException {
        String retval = null;
        EntryEnumeration nEnum = null;
        int index = dn.indexOf(44);
        if (index == -1) {
            index = dn.indexOf(59);
        }
        if (index == -1) {
            try {
                dn = LdapRegistryImpl.escapeChar(dn, '*');
                nEnum = this.search(dn, 0, this.objectFilter, 0);
                if (!nEnum.hasMoreElements()) return retval;
                retval = (String)nEnum.nextElement();
                if (!nEnum.hasMoreElements()) return retval;
                nEnum.close();
                return retval;
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getNormalizedDN", "1941", this);
                Tr.error(tc, "security.registry.ldap.invalidID");
                this.logNamingException(e, dn);
                throw e;
            }
        }
        try {
            int slen = dn.length();
            String attrib = dn.substring(0, index);
            attrib = LdapRegistryImpl.escapeChar(attrib, '*');
            String ndn = LdapRegistryImpl.escapeChar(dn, '*');
            nEnum = this.search(ndn, 0, this.objectFilter, 0);
            String nDn = LdapRegistryImpl.normalizeDN(dn);
            while (retval == null && nEnum.hasMoreElements()) {
                String res = (String)nEnum.nextElement();
                String nres = LdapRegistryImpl.normalizeDN(res);
                if (!nres.equalsIgnoreCase(nDn)) continue;
                retval = res;
            }
            if (!nEnum.hasMoreElements()) return retval;
            nEnum.close();
            return retval;
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.getNormalizedDN", "1983", this);
            Tr.error(tc, "security.registry.ldap.invalidID");
            this.logNamingException(e, dn);
            throw e;
        }
    }

    private boolean fullDN(String pattern) {
        String bd;
        String pt;
        int idx = pattern.indexOf(61);
        if (pattern.indexOf(61) < 0) {
            return false;
        }
        if (this.ldapConfig.getBaseDn().length() > 0 && (pt = RegistryUtil.removeDNSpace(pattern, 0).toLowerCase()).endsWith(bd = RegistryUtil.removeDNSpace(this.ldapConfig.getBaseDn(), 0).toLowerCase())) {
            return true;
        }
        if (this.ldapConfig.getBaseDn().length() < 1) {
            return true;
        }
        return pattern.indexOf(61, idx + 1) < 0;
    }

    private boolean fullDN(String pattern, String baseDn) {
        String bd;
        String pt;
        if (pattern == null || pattern.length() < 3 || pattern.indexOf(61) < 0) {
            return false;
        }
        int idx = pattern.indexOf(61);
        if (this.ldapConfig.isIgnoreBaseDn()) {
            if (pattern.indexOf(92) < 0 && pattern.indexOf(34) < 0) {
                return true;
            }
            if (pattern.charAt(idx - 1) == '\\' && pattern.indexOf(61, idx + 1) < 0) {
                return false;
            }
            boolean ok = false;
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) == '=') {
                    ok = true;
                }
                if (pattern.charAt(i) == '\\' && pattern.charAt(i + 1) == '=') {
                    ok = false;
                    ++i;
                    continue;
                }
                if (pattern.charAt(i) != '\"') continue;
                boolean quotes = true;
                for (int j = i; j < pattern.length() && quotes; ++j) {
                    if (pattern.charAt(j) != '=') continue;
                    for (int k = j + 1; k < pattern.length() && quotes; ++k) {
                        if (pattern.charAt(k) != '\"') continue;
                        ok = false;
                        quotes = false;
                        i = k;
                    }
                }
            }
            return ok;
        }
        if (baseDn.length() > 0 && (pt = RegistryUtil.removeDNSpace(pattern, 0).toLowerCase()).endsWith(bd = RegistryUtil.removeDNSpace(baseDn, 0).toLowerCase())) {
            return true;
        }
        if (baseDn.length() < 1) {
            return true;
        }
        return pattern.indexOf(61, idx + 1) < 0;
    }

    protected EntryEnumeration search(int searchScope, String filter, int limit) throws NamingException {
        return this.search(this.ldapConfig.getBaseDn(), searchScope, filter, limit);
    }

    protected EntryEnumeration search(String baseDn, int searchScope, String filter, int limit) throws NamingException {
        return new EntryEnumeration(baseDn, this.search(baseDn, searchScope, filter, noAttrs, limit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamingEnumeration search(String baseDn, int searchScope, String filter, String[] retAttrs, int limit) throws NamingException {
        if (baseDn.indexOf(35) > -1) {
            baseDn = LdapRegistryImpl.escapeFirstChar(baseDn, '#');
        }
        Name base = null;
        try {
            if (baseDn != null && baseDn.length() > 0) {
                base = new CompositeName().add(baseDn);
            }
        }
        catch (Exception ce) {
            base = null;
        }
        if (base == null && baseDn.indexOf(92) > 0) {
            baseDn = LdapRegistryImpl.escapeChar(baseDn, '\\');
        }
        if (filter.indexOf(92) > 0) {
            filter = LdapRegistryImpl.escapeChar(filter, '\\');
        }
        StringBuffer sb = null;
        long startTime = 0L;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "search");
            sb = new StringBuffer("DN: ");
            sb.append(baseDn);
            Tr.debug(tc, sb.toString());
            sb = new StringBuffer("Search scope: ");
            sb.append(searchScope);
            Tr.debug(tc, sb.toString());
            sb = new StringBuffer("Filter: ");
            sb.append(filter);
            Tr.debug(tc, sb.toString());
            sb = new StringBuffer("Time limit: ");
            sb.append(limit);
            Tr.debug(tc, sb.toString());
            for (int n = 0; n < retAttrs.length; ++n) {
                sb = new StringBuffer("Attr[");
                sb.append(n);
                sb.append("]: ");
                sb.append(retAttrs[n]);
                Tr.debug(tc, sb.toString());
            }
        }
        NamingException lastException = null;
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchScope);
        controls.setReturningAttributes(retAttrs);
        controls.setReturningObjFlag(false);
        if (limit != 0) {
            controls.setCountLimit(limit);
        }
        controls.setTimeLimit(this.searchTimeLimit);
        String host = null;
        DirContext ctx = null;
        NamingEnumeration<SearchResult> nEnum = null;
        for (int i = 0; i < 3; ++i) {
            Object var20_22;
            try {
                startTime = System.currentTimeMillis();
                if (this.LdapURL == null) {
                    ctx = this.getDirContext();
                    this.enterJNDI();
                    nEnum = base != null ? ctx.search(base, filter, controls) : ctx.search(baseDn, filter, controls);
                    this.exitJNDI();
                    host = (String)ctx.getEnvironment().get("java.naming.provider.url");
                    if (host != null && host.equals(this.currentActiveLDAP)) {
                        this.DirContextPool.addElement(ctx);
                    } else {
                        try {
                            ctx.close();
                        }
                        catch (Exception ce) {}
                    }
                } else {
                    this.enterJNDI();
                    ctx = new InitialDirContext(this.ldapConfig);
                    this.exitJNDI();
                    this.enterJNDI();
                    nEnum = base != null ? ctx.search(base, filter, controls) : ctx.search(baseDn, filter, controls);
                    this.exitJNDI();
                    ctx.close();
                }
                if (tc.isDebugEnabled()) {
                    sb = new StringBuffer("Time elapsed: ");
                    sb = sb.append(System.currentTimeMillis() - startTime);
                    Tr.debug(tc, sb.toString());
                    Tr.exit(tc, "search");
                }
                NamingEnumeration<SearchResult> ce = nEnum;
                var20_22 = null;
                this.exitJNDI();
                return ce;
            }
            catch (NamingException ne) {
                block27: {
                    try {
                        this.exitJNDI();
                        if (tc.isDebugEnabled()) {
                            sb = new StringBuffer("Time elapsed: ");
                            sb = sb.append(System.currentTimeMillis() - startTime);
                            Tr.debug(tc, sb.toString());
                        }
                        this.logNamingException(ne);
                        lastException = ne;
                        String failLDAP = null;
                        try {
                            if (ctx != null) {
                                failLDAP = (String)ctx.getEnvironment().get("java.naming.provider.url");
                                ctx.close();
                            }
                        }
                        catch (Exception ce) {
                            // empty catch block
                        }
                        Tr.debug(tc, "Search against " + failLDAP + " fails.");
                        if (failLDAP != null && !failLDAP.equalsIgnoreCase(this.currentActiveLDAP)) break block27;
                        if (ne instanceof NameNotFoundException) {
                            var20_22 = null;
                            this.exitJNDI();
                            break;
                        }
                        this.recycle();
                    }
                    catch (Throwable throwable) {
                        var20_22 = null;
                        this.exitJNDI();
                        throw throwable;
                    }
                }
                var20_22 = null;
                this.exitJNDI();
                {
                    continue;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "search");
        }
        FFDCFilter.processException(lastException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.search", "2251", this);
        throw lastException;
    }

    public WSCredential createCredential(String name) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        String userName;
        String displayName;
        String uniqueUserId;
        ArrayList<Object> grpList;
        WSCredential cred;
        block67: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCredential", name);
            }
            cred = null;
            grpList = null;
            uniqueUserId = null;
            displayName = null;
            userName = name;
            if (useMixedSearch) {
                uniqueUserId = RegistryUtil.removeDNSpace(this.getUniqueUserId(name), 0);
                grpList = this.getUniqueGroupIds(uniqueUserId);
            } else if (!this.useAttributeGroupMethod) {
                block66: {
                    String[] retAttrs = new String[1];
                    String[] ids = this.idMap.getAttributes();
                    retAttrs[0] = ids[1];
                    String baseDn = this.ldapConfig.getBaseDn();
                    try {
                        NamingEnumeration ne;
                        if (this.fullDN(name)) {
                            ne = this.search(name, 0, this.objectUserDnFilter, retAttrs, 0);
                        } else {
                            name = LdapRegistryImpl.escapeChar(name, '*');
                            String filter = this.ldapConfig.getFilter(USER_FILTER).prepare(name);
                            ne = this.search(baseDn, 2, filter, retAttrs, 0);
                        }
                        if (!ne.hasMoreElements()) break block66;
                        Object o = ne.next();
                        NameClassPair ncp = (NameClassPair)o;
                        String retVal = ncp.getName();
                        if (retVal != null && retVal.trim().length() > 1 && ncp.isRelative()) {
                            try {
                                retVal = new CompositeName(retVal).get(0);
                            }
                            catch (Exception ce) {
                                // empty catch block
                            }
                            if (retVal.charAt(0) == '\"') {
                                retVal = retVal.substring(1, retVal.length() - 1);
                            }
                        }
                        if (retVal != null && retVal.length() > 0 && ncp.isRelative()) {
                            name = retVal;
                            if (baseDn != null && baseDn.trim().length() > 1) {
                                name = retVal + "," + baseDn;
                            }
                        }
                        if (!ncp.isRelative() && retVal != null && retVal.length() > 0) {
                            int j = retVal.indexOf(47, 9);
                            if (j > -1 && retVal.length() > j + 1) {
                                try {
                                    retVal = URLDecoder.decode(retVal, "UTF8");
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                name = retVal.substring(j + 1);
                            } else {
                                name = NONE;
                            }
                        }
                        uniqueUserId = RegistryUtil.removeDNSpace(name, 0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "uniqueUserId = " + uniqueUserId);
                        }
                        SearchResult r = (SearchResult)o;
                        NamingEnumeration<? extends Attribute> attrs = r.getAttributes().getAll();
                        while (attrs.hasMoreElements()) {
                            Attribute attrib = attrs.next();
                            String at = attrib.getID();
                            if (!at.equalsIgnoreCase(retAttrs[0])) continue;
                            displayName = (String)attrib.get(0);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "displayName = " + displayName);
                        }
                    }
                    catch (NamingException ne) {
                        FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2362", this);
                        Tr.error(tc, "security.registry.createcredential.error", new Object[]{name});
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "createCredential", ne);
                        }
                        throw new EntryNotFoundException(ne.toString(), ne);
                    }
                }
                grpList = this.getUniqueGroupIds(uniqueUserId);
            } else {
                IdMap.IdEntry[] memberEntries = this.idMap.getGroupMembers();
                String[] retAttrs = new String[2];
                String[] ids = this.idMap.getAttributes();
                retAttrs[0] = ids[1];
                if (memberEntries.length > 0) {
                    retAttrs[1] = memberEntries[0].getObjectClassName();
                    if (RACF_GROUP_ATTRIBUTE.equalsIgnoreCase(retAttrs[1]) && !this.fullDN(name, this.ldapConfig.getBaseDn())) {
                        name = this.getUniqueUserId(name);
                    }
                }
                Vector<String> v = new Vector<String>(5);
                Object[] groups = null;
                String grpDN = null;
                String baseDn = this.ldapConfig.getBaseDn();
                try {
                    NamingEnumeration ne;
                    if (this.fullDN(name, this.ldapConfig.getBaseDn())) {
                        ne = this.search(name, 0, this.objectUserDnFilter, retAttrs, 0);
                    } else {
                        name = LdapRegistryImpl.escapeChar(name, '*');
                        String filter = this.ldapConfig.getFilter(USER_FILTER).prepare(name);
                        ne = this.search(baseDn, 2, filter, retAttrs, 0);
                    }
                    if (ne.hasMoreElements()) {
                        Object o = ne.next();
                        NameClassPair ncp = (NameClassPair)o;
                        String retVal = ncp.getName();
                        if (retVal != null && retVal.trim().length() > 1 && ncp.isRelative()) {
                            try {
                                retVal = new CompositeName(retVal).get(0);
                            }
                            catch (Exception ce) {
                                // empty catch block
                            }
                            if (retVal.charAt(0) == '\"') {
                                retVal = retVal.substring(1, retVal.length() - 1);
                            }
                        }
                        if (retVal != null && retVal.length() > 0 && ncp.isRelative()) {
                            name = retVal;
                            if (baseDn != null && baseDn.trim().length() > 1) {
                                name = retVal + "," + baseDn;
                            }
                        }
                        if (!ncp.isRelative() && retVal != null && retVal.length() > 0) {
                            int j = retVal.indexOf(47, 9);
                            if (j > -1 && retVal.length() > j + 1) {
                                try {
                                    retVal = URLDecoder.decode(retVal, "UTF8");
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                name = retVal.substring(j + 1);
                            } else {
                                name = NONE;
                            }
                        }
                        uniqueUserId = RegistryUtil.removeDNSpace(name, 0);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "uniqueUserId = " + uniqueUserId);
                        }
                        SearchResult r = (SearchResult)o;
                        NamingEnumeration<? extends Attribute> attrs = r.getAttributes().getAll();
                        while (attrs.hasMoreElements()) {
                            Attribute attrib = attrs.next();
                            String at = attrib.getID();
                            if (at.equalsIgnoreCase(retAttrs[0])) {
                                displayName = (String)attrib.get(0);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "displayName = " + displayName);
                                continue;
                            }
                            if (!at.equalsIgnoreCase(retAttrs[1])) continue;
                            for (int i = 0; i < attrib.size(); ++i) {
                                grpDN = (String)attrib.get(i);
                                grpDN = RegistryUtil.removeDNSpace(grpDN, 0);
                                v.addElement(grpDN);
                            }
                        }
                        if (v.size() > 0) {
                            groups = new String[v.size()];
                            v.copyInto(groups);
                            grpList = new ArrayList<Object>(groups.length);
                            ArrayList groupsList = new ArrayList();
                            if (this.recursiveSearch) {
                                this.getAllGroupMembershipsByUserObject(uniqueUserId, groupsList, new ArrayList(), retAttrs[1]);
                                grpList = groupsList;
                            } else {
                                for (int i = 0; i < groups.length; ++i) {
                                    grpList.add(groups[i]);
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "grops length = " + grpList.size());
                                for (int i = 0; i < grpList.size(); ++i) {
                                    Tr.debug(tc, "groups name = " + grpList.get(i));
                                }
                            }
                        }
                        if (ne.hasMoreElements()) {
                            ne.close();
                        }
                        break block67;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createCredential", "no users with name: " + name + " found");
                    }
                    Tr.error(tc, "security.registry.createcredential.nouser", new Object[]{name});
                    throw new EntryNotFoundException("Cannot find the user: " + name);
                }
                catch (NamingException ne) {
                    FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2510", this);
                    Tr.error(tc, "security.registry.createcredential.error", new Object[]{name});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "createCredential", ne);
                    }
                    throw new EntryNotFoundException(ne.toString(), ne);
                }
            }
        }
        if (displayName == null || displayName.trim().length() <= 0) {
            displayName = uniqueUserId;
        }
        try {
            boolean preserveTaiUsername;
            final String accessId = RegistryUtil.appendRealm(USERTYPE, uniqueUserId, this.realm);
            final String longSecurityName = uniqueUserId;
            ArrayList<String> groupList = new ArrayList<String>();
            String[] groupIds = null;
            String primaryGroupId = null;
            if (grpList != null && grpList.size() > 0) {
                groupIds = grpList.toArray(new String[grpList.size()]);
                for (int i = 0; i < groupIds.length; ++i) {
                    if (i == 0) {
                        primaryGroupId = RegistryUtil.appendRealm(GROUPTYPE, groupIds[i], this.realm);
                    }
                    groupList.add(RegistryUtil.appendRealm(GROUPTYPE, groupIds[i], this.realm));
                }
            }
            if ((preserveTaiUsername = this.ldapConfig.getPreserveTaiUsername()) && tc.isEntryEnabled()) {
                Tr.debug(tc, "Custom Property - PreserveTaiUserName found.  Creating WSCredential with " + userName + "instead of" + displayName);
            }
            final String realmPriv = this.realm;
            final String displayNamePriv = preserveTaiUsername ? userName : displayName;
            final String primaryGroupIdPriv = primaryGroupId;
            final ArrayList<String> groupListPriv = groupList;
            try {
                cred = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(realmPriv, displayNamePriv, longSecurityName, primaryGroupIdPriv != null ? primaryGroupIdPriv : nullString, accessId, null, groupListPriv);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
                }
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2580", this);
                throw e.getException();
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.createCredential", "2586", this);
            Tr.error(tc, "security.registry.createcredential.error", new Object[]{name});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCredential", ex);
            }
            throw new EntryNotFoundException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", name);
        }
        return cred;
    }

    protected static String escapeChar(String dn, char escChar) {
        int dnlen = dn.length();
        StringBuffer sb = new StringBuffer(2 * dnlen);
        for (int i = 0; i < dnlen; ++i) {
            char c = dn.charAt(i);
            if (c == escChar) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String escapeFirstChar(String dn, char escChar) {
        int dnlen = dn.length();
        StringBuffer sb = new StringBuffer(2 * dnlen);
        int d = 32;
        for (int i = 0; i < dnlen; ++i) {
            char c = dn.charAt(i);
            if (i > 1) {
                d = dn.charAt(i - 1);
            }
            if (c == escChar && d == 61) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void logNamingException(NamingException ne) {
        this.logNamingException(ne, null);
    }

    private void logNamingException(NamingException ne, String dn) {
        if (dn != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "name = " + dn);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, ne.getMessage());
        }
        if (ne.getExplanation() != null && tc.isDebugEnabled()) {
            Tr.debug(tc, ne.getExplanation());
        }
        if (ne.getRootCause() != null && tc.isDebugEnabled()) {
            Tr.debug(tc, ne.getRootCause().getMessage(), ne.getRootCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirContext getDirContext() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDirContext");
        }
        DirContext ctx = null;
        Object object = this.lockObj1;
        synchronized (object) {
            if (this.refresh) {
                this.refresh();
                this.refresh = false;
            }
            while (this.DirContextPool != null && this.DirContextPool.size() > this.maxIdleContext) {
                try {
                    ctx = (DirContext)this.DirContextPool.lastElement();
                    this.DirContextPool.removeElement(ctx);
                    ctx.close();
                    --this.ContextPoolSize;
                }
                catch (Exception e) {}
            }
            try {
                if (this.DirContextPool != null && this.DirContextPool.size() > 0) {
                    ctx = (DirContext)this.DirContextPool.lastElement();
                    this.DirContextPool.removeElement(ctx);
                    Tr.exit(tc, "getDirContext");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDirContext");
                    }
                    return ctx;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Context dse = null;
        Object object2 = this.lockObj2;
        synchronized (object2) {
            try {
                if (this.DirContextPool != null && this.DirContextPool.size() > 0) {
                    ctx = (DirContext)this.DirContextPool.lastElement();
                    this.DirContextPool.removeElement(ctx);
                    Tr.exit(tc, "getRootDSE");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDirContext");
                    }
                    return ctx;
                }
            }
            catch (Exception E) {
                // empty catch block
            }
            String ldapUrls = this.ldapConfig.getDirectoryUrl();
            StringTokenizer st = new StringTokenizer(ldapUrls);
            while (st.hasMoreTokens()) {
                String ldapHost = st.nextToken();
                LdapConfig tmpConfig = new LdapConfig(this.ldapConfig);
                tmpConfig.setDirectoryUrl(ldapHost);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "try connect to " + ldapHost);
                }
                try {
                    this.enterJNDI();
                    dse = new InitialDirContext(tmpConfig);
                    this.exitJNDI();
                    break;
                }
                catch (NamingException ex) {
                    this.exitJNDI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, ex.toString());
                    }
                    if (st.hasMoreTokens()) continue;
                    if (ex instanceof CommunicationException) {
                        Tr.audit(tc, "security.registry.ldap.connect.audit", new Object[]{ldapUrls});
                    }
                    throw ex;
                }
            }
            for (int i = 0; i < this.maxContextPerConnection; ++i) {
                try {
                    this.enterJNDI();
                    ctx = (DirContext)dse.lookup(NONE);
                    this.exitJNDI();
                    this.DirContextPool.addElement(ctx);
                    ++this.ContextPoolSize;
                    continue;
                }
                catch (Exception e3) {
                    this.exitJNDI();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "create DirContext pool for this connection.");
            }
            ++this.ContextPoolSize;
        }
        if (tc.isDebugEnabled() && this.DirContextPool.size() + this.busyCount > 30) {
            Tr.debug(tc, "DirContext pool size => " + this.DirContextPool.size() + this.busyCount);
        }
        this.currentActiveLDAP = (String)dse.getEnvironment().get("java.naming.provider.url");
        Tr.audit(tc, "security.registry.ldap.connected.audit", new Object[]{this.currentActiveLDAP});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDirContext");
        }
        return dse;
    }

    protected void recycle() {
        if (this.DirContextPool == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recycle");
        }
        while (!this.DirContextPool.isEmpty()) {
            try {
                DirContext ctx = (DirContext)this.DirContextPool.lastElement();
                this.DirContextPool.removeElement(ctx);
                ctx.close();
            }
            catch (Exception exception) {}
        }
        this.ContextPoolSize = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recycle");
        }
    }

    private synchronized void refresh() {
        block9: {
            LdapConfig tmpConfig = new LdapConfig(this.ldapConfig);
            if (this.bindDN != null) {
                tmpConfig.setAuthenticationPrincipal(this.bindDN);
            }
            if (this.bindPWD != null) {
                tmpConfig.setAuthenticationCredentials(this.bindPWD);
            }
            if (this.bindHost != null) {
                tmpConfig.setDirectoryUrl(this.bindHost);
            }
            try {
                InitialDirContext ctx = new InitialDirContext(tmpConfig);
                ctx.close();
                if (this.bindHost != null) {
                    this.ldapConfig.setDirectoryUrl(this.bindHost);
                }
                if (this.bindDN != null) {
                    this.ldapConfig.setAuthenticationPrincipal(this.bindDN);
                }
                if (this.bindPWD != null) {
                    this.ldapConfig.setAuthenticationCredentials(this.bindPWD);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LDAP registry has been refreshed.");
                }
                this.bindHost = null;
                this.bindDN = null;
                this.bindPWD = null;
                Tr.audit(tc, "security.registry.ldap.updated.audit");
                this.recycle();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "LDAP registry can NOT be refreshed.");
            }
        }
    }

    public synchronized void refreshRegistry(String usr, String pwd, String host) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshRegistry", new Object[]{usr, pwd != null ? "*****" : "null", host});
        }
        this.bindHost = null;
        this.bindDN = null;
        this.bindPWD = null;
        if (host != null && host.length() > 0) {
            this.bindHost = host;
        }
        if (usr != null && usr != NONE && pwd != null && pwd != NONE) {
            this.bindDN = usr;
            this.bindPWD = pwd;
        }
        this.refresh = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshRegistry");
        }
    }

    private void exitJNDI() {
        Thread currThread = Thread.currentThread();
        if (this.table1.contains(currThread)) {
            this.table1.remove(currThread);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exitJNDI:" + currThread.getName());
            }
        }
        if (this.table2.contains(currThread)) {
            this.table2.remove(currThread);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exitJNDI:" + currThread.getName());
            }
        }
        if (this.table3.contains(currThread)) {
            this.table3.remove(currThread);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exitJNDI:" + currThread.getName());
            }
        }
    }

    private void enterJNDI() {
        Thread currThread = Thread.currentThread();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enterJNDI:" + currThread.getName());
        }
        this.table1.add(currThread);
    }

    void interruptJNDI() {
        Thread currThread = null;
        while (this.table3 != null && !this.table3.isEmpty()) {
            currThread = (Thread)this.table3.lastElement();
            this.table3.remove(currThread);
            try {
                currThread.interrupt();
                currThread.interrupted();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Thread interrupted: " + currThread.getName());
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not interrupt thread: " + currThread.getName());
            }
        }
        while (this.table2 != null && !this.table2.isEmpty()) {
            currThread = (Thread)this.table2.lastElement();
            this.table2.removeElement(currThread);
            this.table3.addElement(currThread);
        }
        while (this.table1 != null && !this.table1.isEmpty()) {
            currThread = (Thread)this.table1.lastElement();
            this.table1.removeElement(currThread);
            this.table2.addElement(currThread);
        }
    }

    private final class LdapMonitor
    extends Thread {
        private LdapMonitor() {
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(innerTc, "run");
            }
            try {
                while (true) {
                    try {
                        LdapMonitorThread;
                        Thread.sleep(LdapRegistryImpl.this.searchTimeLimit / 2);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    LdapRegistryImpl.this.interruptJNDI();
                }
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                return;
            }
        }
    }
}

