/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.registry.ldap.CertificateMapperException;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CertificateMapper {
    public static final String exactDnMapMode = "exactDNMode";
    public static final String uniqueKeyMapMode = "uniqueKeyMode";
    public static final String filterDescriptorMapMode = "filterDescriptorMode";
    private String mapMode;
    private int searchScope;
    private String mapDesc = null;
    private String[] mapDescEles = null;

    public CertificateMapper() {
        try {
            this.setLdapMapMode(exactDnMapMode);
        }
        catch (CertificateMapperException cme) {
            FFDCFilter.processException((Throwable)cme, "com.ibm.ws.security.registry.ldap.CertificateMapper.CertificateMapper", "61", this);
        }
    }

    public String getLdapMapMode() {
        return this.mapMode;
    }

    public void setLdapMapMode(String mapMode) throws CertificateMapperException {
        this.mapMode = mapMode;
        if (mapMode.equals(exactDnMapMode)) {
            this.searchScope = 0;
        } else if (mapMode.equals(uniqueKeyMapMode)) {
            this.searchScope = 2;
        } else if (mapMode.equals(filterDescriptorMapMode)) {
            this.searchScope = 2;
        } else {
            throw new CertificateMapperException("invalid map mode: " + mapMode);
        }
    }

    public String getLdapFilterDescriptor() {
        return this.mapDesc;
    }

    public void setLdapFilterDescriptor(String mapDesc) throws CertificateMapperException {
        if (mapDesc != null) {
            this.mapDescEles = this.parseFilterDescriptor(mapDesc);
        }
        this.mapDesc = mapDesc;
    }

    public String getLdapSearchFilter(X509Certificate cert) throws CertificateMapperException {
        if (this.mapMode.equals(exactDnMapMode)) {
            return cert.getSubjectDN().getName();
        }
        if (this.mapMode.equals(uniqueKeyMapMode)) {
            return "userCertificate=" + CertificateMapper.getUniqueKey(cert);
        }
        if (this.mapMode.equals(filterDescriptorMapMode)) {
            return this.getFilterByDescriptor(cert);
        }
        throw new CertificateMapperException("unknown map mode: " + this.mapMode);
    }

    public int getLdapSearchScope() {
        return this.searchScope;
    }

    public static String getUniqueKey(X509Certificate cert) {
        StringBuffer key = new StringBuffer("subjectDN:");
        key.append(cert.getSubjectDN().getName()).append("issuerDN:").append(cert.getIssuerDN().getName());
        return Base64Coder.base64Encode(CertificateMapper.getDigest(key.toString()));
    }

    private String getFilterByDescriptor(X509Certificate cert) throws CertificateMapperException {
        if (this.mapDescEles == null) {
            throw new CertificateMapperException("map descriptor is not set");
        }
        StringBuffer filter = new StringBuffer();
        for (int idx = 0; idx < this.mapDescEles.length; ++idx) {
            String str = this.mapDescEles[idx];
            if (str.charAt(0) != '$') {
                filter.append(str);
                continue;
            }
            if (str.equals("${UniqueKey}")) {
                filter.append(CertificateMapper.getUniqueKey(cert));
                continue;
            }
            if (str.equals("${PublicKey}")) {
                filter.append(cert.getPublicKey().getEncoded());
                continue;
            }
            if (str.equals("${BasicConstraints}")) continue;
            if (str.startsWith("${Issuer")) {
                filter.append(CertificateMapper.getDnSubField(str.substring(8, str.length() - 1), cert.getIssuerDN().getName()));
                continue;
            }
            if (str.equals("${IssuerUniqueID}") || str.equals("${KeyUsage}")) continue;
            if (str.equals("${NotAfter}")) {
                filter.append(cert.getNotAfter().toString());
                continue;
            }
            if (str.equals("${NotBefore}")) {
                filter.append(cert.getNotBefore().toString());
                continue;
            }
            if (str.equals("${SerialNumber}")) {
                filter.append(cert.getSerialNumber());
                continue;
            }
            if (str.equals("${SigAlgName}")) {
                filter.append(cert.getSigAlgName());
                continue;
            }
            if (str.equals("${SigAlgOID}")) {
                filter.append(cert.getSigAlgOID());
                continue;
            }
            if (str.equals("${SigAlgParams}")) {
                filter.append(cert.getSigAlgParams());
                continue;
            }
            if (str.equals("${Signature}")) continue;
            if (str.startsWith("${Subject")) {
                filter.append(CertificateMapper.getDnSubField(str.substring(9, str.length() - 1), cert.getSubjectDN().getName()));
                continue;
            }
            if (str.equals("${SubjectUniqueID}")) continue;
            if (str.equals("${TBSCertificate}")) {
                throw new CertificateMapperException("getTBSCertificate() is unsupported");
            }
            if (str.equals("${Version}")) {
                filter.append(cert.getVersion());
                continue;
            }
            throw new CertificateMapperException("unknown variable: " + str);
        }
        return filter.toString();
    }

    private String[] parseFilterDescriptor(String mapDesc) throws CertificateMapperException {
        Vector<String> list = new Vector<String>();
        int cur_idx = 0;
        int prev_idx = 0;
        int end_idx = mapDesc.length();
        while (cur_idx < end_idx) {
            cur_idx = mapDesc.indexOf("${", prev_idx);
            if (cur_idx == -1) {
                if (prev_idx >= end_idx) break;
                list.addElement(mapDesc.substring(prev_idx));
                break;
            }
            if (prev_idx < cur_idx) {
                list.addElement(mapDesc.substring(prev_idx, cur_idx));
            }
            if ((cur_idx = mapDesc.indexOf("}", prev_idx = cur_idx)) == -1) {
                throw new CertificateMapperException("missing '}'");
            }
            list.addElement(mapDesc.substring(prev_idx, ++cur_idx));
            prev_idx = cur_idx;
        }
        String[] mapDescEles = new String[list.size()];
        for (int idx = 0; idx < list.size(); ++idx) {
            mapDescEles[idx] = (String)list.elementAt(idx);
        }
        return mapDescEles;
    }

    private static String getDnSubField(String varName, String DN) throws CertificateMapperException {
        block6: {
            String value;
            String name;
            if (varName.equals("DN")) {
                return DN;
            }
            String sIsCRDNParsingEnabled = SecurityObjectLocator.getSecurityConfig().getUserRegistry("LDAP").getProperty("security.registry.ldap.compoundRDNParsingEnabled");
            boolean isCRDNParsingEnabled = Boolean.valueOf(sIsCRDNParsingEnabled);
            StringTokenizer st = new StringTokenizer(DN);
            do {
                try {
                    if (isCRDNParsingEnabled) {
                        name = st.nextToken(",=+ ");
                        value = st.nextToken(",+");
                    } else {
                        name = st.nextToken(",= ");
                        value = st.nextToken(",");
                    }
                    if (value == null) continue;
                    value = value.substring(1);
                }
                catch (NoSuchElementException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.security.registry.ldap.CertificateMapper.getDnSubField", "264");
                    break block6;
                }
            } while (!name.equals(varName));
            return value;
        }
        throw new CertificateMapperException("unknown field of DN: " + varName);
    }

    private static String getDigest(String input) {
        MessageDigest md2;
        try {
            md2 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.registry.ldap.CertificateMapper.getDigest", "282");
            return null;
        }
        md2.update(StringUtil.getBytes(input));
        return StringUtil.toString(md2.digest());
    }

    private static String removeSpace(String name) {
        if (name != null && name.trim().length() > 0) {
            StringBuffer sb = new StringBuffer(name.length());
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) == ' ' && (name.charAt(i - 1) == ',' || name.charAt(i - 1) == ' ')) continue;
                sb.append(name.charAt(i));
            }
            return sb.toString();
        }
        return name;
    }
}

