/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.provider.AllPolicyConfigs;
import com.ibm.ws.security.provider.WSPolicyConfigurationImpl;
import java.security.SecurityPermission;
import java.util.Hashtable;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class WSPolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    private static TraceComponent tc = Tr.register(WSPolicyConfigurationFactoryImpl.class, null, "com.ibm.ejs.resources.security");
    private Hashtable policyConfigTable;
    private AllPolicyConfigs allConfigs;

    public WSPolicyConfigurationFactoryImpl() {
        if (this.allConfigs == null) {
            this.allConfigs = AllPolicyConfigs.getInstance();
        }
    }

    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean flag) throws PolicyContextException {
        WSPolicyConfigurationImpl policyConfig;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyConfiguration", new Object[]{contextId, new Boolean(flag)});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (flag && this.allConfigs.getPolicyConfig(contextId) != null) {
            this.allConfigs.remove(contextId);
        }
        if ((policyConfig = this.allConfigs.getPolicyConfig(contextId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hashMap does not contain the contextID: " + contextId);
            }
            policyConfig = new WSPolicyConfigurationImpl(contextId);
            this.allConfigs.setPolicyConfig(contextId, policyConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyConfiguration", contextId);
        }
        policyConfig.setState(0);
        return policyConfig;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        WSPolicyConfigurationImpl policyConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inService", contextID);
        }
        SecurityManager sm = System.getSecurityManager();
        boolean inservice = false;
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if ((policyConfig = this.allConfigs.getPolicyConfig(contextID)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The policy configuration for the the contextID: " + contextID + " does not exist. exit value false");
            }
            return false;
        }
        inservice = policyConfig.inService();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inService", String.valueOf(inservice));
        }
        return inservice;
    }
}

