/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.provider;

import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Group;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.provider.WSPolicyConfigurationImpl;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import org.eclipse.jst.j2ee.common.SecurityRole;

public class JaccProvider {
    private static TraceComponent tc = Tr.register(JaccProvider.class, null, "com.ibm.ejs.resources.security");
    private static JaccProvider jaccProvider;
    private static boolean initialized;
    private static boolean ignoreCase;

    public static JaccProvider getInstance() {
        if (!initialized) {
            jaccProvider = new JaccProvider();
            initialized = true;
            ignoreCase = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("ignoreCase");
            if (ignoreCase && tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoreCase is set");
            }
        }
        return jaccProvider;
    }

    private JaccProvider() {
    }

    public boolean checkUncheckedPerm(WSPolicyConfigurationImpl pc, Permission p) {
        ArrayList uncheckedList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkUncheckedPerm: " + p);
        }
        if ((uncheckedList = pc.getUncheckedList()) != null) {
            for (int i = 0; i < uncheckedList.size(); ++i) {
                Permission unchkPerm = (Permission)uncheckedList.get(i);
                if (!unchkPerm.implies(p)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The permission: " + p + " is in the uncheckedList. exit value:true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "The permission: " + p + " is not in the uncheckedList. exit value:false");
        }
        return false;
    }

    public boolean checkExcludedPerm(WSPolicyConfigurationImpl pc, Permission p) {
        ArrayList excludedList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkExcludedPerm: " + p);
        }
        if ((excludedList = pc.getExcludedList()) != null) {
            for (int i = 0; i < excludedList.size(); ++i) {
                if (!((Permission)excludedList.get(i)).implies(p)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The permission: " + p + " is in the excludedList. exit value:false");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "The permission: " + p + " is not in the excludedList. exit value:true");
        }
        return false;
    }

    public boolean isEveryoneGranted(WSPolicyConfigurationImpl pc, Permission p, String contextID) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "isEveryoneGranted: " + p);
        }
        HashMap roleToPermMap = pc.getRoleToPermMap();
        ArrayList<String> requiredRoleList = null;
        if (!roleToPermMap.isEmpty()) {
            requiredRoleList = new ArrayList<String>();
            for (String role : roleToPermMap.keySet()) {
                ArrayList rList = (ArrayList)roleToPermMap.get(role);
                for (int rr = 0; rr < rList.size(); ++rr) {
                    Permission perm = (Permission)rList.get(rr);
                    if (!perm.implies(p)) continue;
                    requiredRoleList.add(role);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added role: " + role + " to the requiredRoleList for Permission: " + p);
                }
            }
        }
        if (requiredRoleList != null && requiredRoleList.size() > 0) {
            List grantedRoles;
            AuthorizationTable tbl;
            int i = contextID.lastIndexOf("/");
            String appName = null;
            if (i != -1) {
                String fullName = contextID.substring(0, i);
                int j = fullName.lastIndexOf("/");
                appName = j != -1 ? fullName.substring(j + 1) : fullName;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "application name is: " + appName);
            }
            if ((tbl = WSAccessManager.getAuthorizationTable(appName)) != null && (grantedRoles = tbl.getRolesForSubject(Constants.EVERYONE)) != null) {
                for (i = 0; i < grantedRoles.size(); ++i) {
                    if (!requiredRoleList.contains(((SecurityRole)grantedRoles.get(i)).getRoleName())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Everyone is granted access: . exit value:true");
                    }
                    return true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Everyone is not granted access:");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRolePerm(WSPolicyConfigurationImpl pc, Permission p, String contextID) {
        String[] groupIds;
        String accessId;
        List grantedRoles;
        AuthorizationTable tbl;
        ArrayList<String> requiredRoleList;
        block49: {
            Subject subject;
            block48: {
                HashMap roleToPermMap;
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "checkRolePerm: " + p);
                }
                if ((roleToPermMap = pc.getRoleToPermMap()).isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "No required roles list in the PolicyConfiguration for ContextID: " + contextID + " . exit value:true");
                    }
                    return true;
                }
                requiredRoleList = new ArrayList<String>();
                for (String role : roleToPermMap.keySet()) {
                    ArrayList rList = (ArrayList)roleToPermMap.get(role);
                    for (int rr = 0; rr < rList.size(); ++rr) {
                        Permission perm = (Permission)rList.get(rr);
                        if (!perm.implies(p)) continue;
                        requiredRoleList.add(role);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added role: " + role + " to the requiredRoleList for Permission: " + p);
                    }
                }
                if (!(p instanceof WebRoleRefPermission) && !(p instanceof EJBRoleRefPermission) && requiredRoleList.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "No required roles. exit value:true");
                    }
                    return true;
                }
                int i = contextID.lastIndexOf("/");
                String appName = null;
                if (i != -1) {
                    String fullName = contextID.substring(0, i);
                    int j = fullName.lastIndexOf("/");
                    appName = j != -1 ? fullName.substring(j + 1) : fullName;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "application name is: " + appName);
                }
                if ((tbl = WSAccessManager.getAuthorizationTable(appName)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "cannot get the authorization table for application : " + appName + ". exit value:false");
                    }
                    return false;
                }
                grantedRoles = null;
                if (!(p instanceof WebResourcePermission) && (grantedRoles = tbl.getRolesForSubject(Constants.EVERYONE)) != null) {
                    for (i = 0; i < grantedRoles.size(); ++i) {
                        if (!requiredRoleList.contains(((SecurityRole)grantedRoles.get(i)).getRoleName())) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "Everyone is granted access: . exit value:true");
                        }
                        return true;
                    }
                }
                Object obj = null;
                try {
                    obj = PolicyContext.getContext("javax.security.auth.Subject.container");
                }
                catch (PolicyContextException pce) {
                    FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.JaccProvider.implies", "246", this);
                    Tr.error(tc, "security.jacc.provider.pcontextkey.error", new Object[]{"javax.security.auth.Subject.container", pce});
                    obj = null;
                }
                if (obj == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Cannot get the subject from the policy context. exit value:false");
                    }
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Object returned from the policy context is: " + obj);
                }
                subject = null;
                if (obj instanceof Subject) {
                    subject = (Subject)obj;
                }
                WSCredential rCreds = SubjectHelper.getWSCredentialFromSubject(subject);
                if (subject == null || rCreds.isUnauthenticated()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Subject is null or Unauthenticated, exit value:false");
                    }
                    return false;
                }
                ContextManager contextManager = ContextManagerFactory.getInstance();
                try {
                    if (rCreds.isBasicAuth()) {
                        subject = contextManager.login(rCreds);
                    }
                }
                catch (Exception e) {
                    subject = null;
                    if (!tc.isDebugEnabled()) break block48;
                    Tr.debug(tc, "authentication failed:" + e);
                }
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isGrantedAnyRole, getActualCredential() thru an exception, exit value:false");
                }
                return false;
            }
            List grantedAllAuthRoles = tbl.getRolesForSubject(Constants.ALL_AUTHENTICATED_USERS);
            if (grantedAllAuthRoles != null) {
                for (int ii = 0; ii < grantedAllAuthRoles.size(); ++ii) {
                    if (!requiredRoleList.contains(((SecurityRole)grantedAllAuthRoles.get(ii)).getRoleName())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "granted access to authenticated user, exit value:true");
                    }
                    return true;
                }
            }
            WSCredential creds = SubjectHelper.getWSCredentialFromSubject(subject);
            accessId = null;
            try {
                accessId = this.getAccessId(creds);
            }
            catch (GeneralSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAccessId throw an exception:" + e);
                }
                accessId = "???";
            }
            User userSub = WCCMHelper.createUser("user", "user");
            grantedRoles = null;
            User user = userSub;
            synchronized (user) {
                userSub.setAccessId(accessId);
                userSub.setName(accessId);
                grantedRoles = tbl.getRolesForSubject(userSub);
            }
            if (grantedRoles != null) {
                for (int ui = 0; ui < grantedRoles.size(); ++ui) {
                    if (!requiredRoleList.contains(((SecurityRole)grantedRoles.get(ui)).getRoleName())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "granted access, exit value:true");
                    }
                    return true;
                }
            }
            grantedRoles = null;
            groupIds = null;
            try {
                groupIds = this.getGroupIds(creds);
            }
            catch (GeneralSecurityException e) {
                if (!tc.isDebugEnabled()) break block49;
                Tr.debug(tc, "getGroupId throw an exception:" + e);
            }
        }
        int len = groupIds == null ? 0 : groupIds.length;
        Group groupSub = WCCMHelper.createGroup("group", "group");
        for (int r = 0; r < len; ++r) {
            Group group = groupSub;
            synchronized (group) {
                groupSub.setAccessId(groupIds[r]);
                groupSub.setName(groupIds[r]);
                grantedRoles = tbl.getRolesForSubject(groupSub);
            }
            if (grantedRoles == null) continue;
            for (int gi = 0; gi < grantedRoles.size(); ++gi) {
                if (!requiredRoleList.contains(((SecurityRole)grantedRoles.get(gi)).getRoleName())) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Group subjects.contains() accessId[" + accessId + "], exit value:true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "No role or group role found for accessId[" + accessId + "], exit value:false");
        }
        return false;
    }

    private String getAccessId(WSCredential creds) throws GeneralSecurityException {
        String accessId = creds.getAccessId();
        if (accessId != null && accessId.length() > 0 && ignoreCase) {
            accessId = accessId.toLowerCase();
        }
        return accessId;
    }

    private String[] getGroupIds(WSCredential creds) throws GeneralSecurityException {
        ArrayList list = creds.getGroupIds();
        String[] groupIds = list.toArray(new String[list.size()]);
        if (ignoreCase) {
            int len = groupIds == null ? 0 : groupIds.length;
            for (int i = 0; i < len; ++i) {
                groupIds[i] = groupIds[i].toLowerCase();
            }
        }
        return groupIds;
    }

    static {
        initialized = false;
        ignoreCase = false;
    }
}

