/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseCallerIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseSystemIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.ws.security.policy.RunAsPolicyExtension;
import org.eclipse.emf.common.util.EList;

public class RunAsPolicyExtensionImpl
implements RunAsPolicyExtension {
    private static TraceComponent tc = Tr.register(RunAsPolicyExtensionImpl.class, "com.ibm.ejs.resources.security");
    private Object adaptableObject;
    private EJBConfigData ejbConfigData;
    private EJBMethodInfo ejbMethod;
    private boolean isIdentityCached = false;
    private SecurityIdentity securityIdentity = null;

    public RunAsPolicyExtensionImpl(Object adaptableObject) {
        this.adaptableObject = adaptableObject;
    }

    public EJBConfigData getEjbConfigData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEjbConfigData()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEjbConfigData()", this.ejbConfigData);
        }
        return this.ejbConfigData;
    }

    public void setEjbConfigData(EJBConfigData ejbConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEjbConfigData(EJBConfigData)");
        }
        this.ejbConfigData = ejbConfigData;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEjbConfigData(EJBConfigData)", ejbConfigData);
        }
    }

    public EJBMethodInfo getEJBMethodInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBMethodInfo()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBMethodInfo()", this.ejbMethod);
        }
        return this.ejbMethod;
    }

    public void setEJBMethodInfo(EJBMethodInfo ejbMethod) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEJBMethodInfo(EJBMethodInfo)");
        }
        this.ejbMethod = ejbMethod;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEJBMethodInfo(EJBMethodInfo)", ejbMethod);
        }
    }

    public boolean isRunAsCallerIdentity(String methodName) {
        SecurityIdentity id;
        boolean b;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunAsCallerIdentity()");
        }
        boolean bl = b = (id = this.getSecurityIdentity(methodName)) != null ? id.getRunAsMode() instanceof UseCallerIdentity : false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunAsCallerIdentity()", b);
        }
        return b;
    }

    public boolean isRunAsSystemIdentity(String methodName) {
        SecurityIdentity id;
        boolean b;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunAsSystemIdentity()");
        }
        boolean bl = b = (id = this.getSecurityIdentity(methodName)) != null ? id.getRunAsMode() instanceof UseSystemIdentity : false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunAsSystemIdentity()", b);
        }
        return b;
    }

    public boolean isRunAsSpecifiedIdentity(String methodName) {
        SecurityIdentity id;
        boolean b;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunAsSpecifiedIdentity()");
        }
        boolean bl = b = (id = this.getSecurityIdentity(methodName)) != null ? id.getRunAsMode() instanceof RunAsSpecifiedIdentity : false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunAsSpecifiedIdentity()", b);
        }
        return b;
    }

    public String getRunAsSpecifiedIdentity(String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSpecifiedIdentity()");
        }
        String role = null;
        if (this.isRunAsSpecifiedIdentity(methodName) && this.securityIdentity != null) {
            RunAsMode mode = this.securityIdentity.getRunAsMode();
            role = ((RunAsSpecifiedIdentity)mode).getRunAsSpecifiedIdentity().getRoleName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSpecifiedIdentity()", role);
        }
        return role;
    }

    private SecurityIdentity getSecurityIdentity(String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityIdentity()");
        }
        SecurityIdentity identity = null;
        if (!this.isIdentityCached) {
            if (this.ejbConfigData != null && this.ejbMethod != null) {
                EnterpriseBeanExtension ejbExt = (EnterpriseBeanExtension)this.ejbConfigData.getDeploymentExtn();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EnterpriseBeanExtension = " + ejbExt);
                }
                if (ejbExt != null) {
                    EList list;
                    String ejbName = this.ejbConfigData.getJ2EEName().getComponent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejbName = " + ejbName + " methodName = " + methodName);
                    }
                    if ((list = ejbExt.getRunAsSettings()) != null && !list.isEmpty()) {
                        for (SecurityIdentity id : list) {
                            boolean isMethodFound;
                            EList methods = id.getMethodElements();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Check if method matches RunAsSettings", new Object[]{id, id.getRunAsMode(), methods});
                            }
                            if (isMethodFound = BeanPermissionRoleMap.findMatchingMethod(ejbName, methodName, methods)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "RunAsSettings match found.");
                                }
                                identity = id;
                                this.securityIdentity = id;
                                break;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "RunAsSettings match was not found.");
                        }
                        this.isIdentityCached = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RunAsSettings list is null or empty, list=" + list);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EnterpriseBeanExtension is null");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbConfigData=" + this.ejbConfigData + " ejbMethod=" + this.ejbMethod);
            }
        } else {
            identity = this.securityIdentity;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityIdentity()", identity);
        }
        return identity;
    }

    public String toString() {
        return super.toString() + " {WSPolicy=" + this.adaptableObject + " EJBConfigData=" + this.ejbConfigData + " EJBMethodInfo=" + this.ejbMethod + '}';
    }
}

