/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.AuthorizationConfig;
import com.ibm.ws.security.config.GenericConfigHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.JaccUtil;
import com.ibm.wsspi.security.authorization.InitializeJACCProvider;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;

public class JaccPolicyDomainProxy
extends Policy {
    private static Policy policy = null;
    private ProtectionDomain self = null;
    private static final TraceComponent tc = Tr.register(JaccPolicyDomainProxy.class, null, "com.ibm.ejs.resources.security");
    private HashMap<String, Policy> cache = new HashMap();

    public JaccPolicyDomainProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JaccPolicyDomainProxy constructor");
        }
        final JaccPolicyDomainProxy p = this;
        this.self = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return p.getClass().getProtectionDomain();
            }
        });
        policy = Policy.getPolicy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JaccPolicyDomainProxy constructor");
        }
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection pc = policy.getPermissions(codeSource);
        return pc;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc = policy.getPermissions(domain);
        return pc;
    }

    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh()");
        }
        policy.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh()");
        }
    }

    public boolean implies(ProtectionDomain pd, Permission p) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "implies", new Object[]{pd, p});
        }
        boolean result = false;
        if (this.self == pd && this.self != null) {
            result = true;
        } else if (p instanceof WebResourcePermission || p instanceof WebUserDataPermission || p instanceof WebRoleRefPermission || p instanceof EJBRoleRefPermission || p instanceof EJBMethodPermission) {
            try {
                result = this.getDomainPolicy().implies(pd, p);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "implies method caught exception: " + e.getMessage());
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.policy.JaccPolicyDomainProxy.implies", "147", this);
            }
        } else {
            result = policy.implies(pd, p);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "implies)", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy getDomainPolicy() throws Exception {
        SecurityConfigManager scm;
        String cacheKey;
        Policy policy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainPolicy");
        }
        if ((policy = this.cache.get(cacheKey = (scm = SecurityObjectLocator.getSecurityConfigManager()).getDomainId())) == null) {
            JaccPolicyDomainProxy jaccPolicyDomainProxy = this;
            synchronized (jaccPolicyDomainProxy) {
                policy = this.cache.get(cacheKey);
                if (policy == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDomainPolicy: Policy not yet initialized for this cacheKey: " + cacheKey);
                    }
                    String jaccProviderPolicyClass = null;
                    if (cacheKey.equalsIgnoreCase("admin")) {
                        jaccProviderPolicyClass = System.getProperty("javax.security.jacc.policy.provider");
                    }
                    boolean isJACCEnabled = false;
                    AuthorizationConfig authConfig = null;
                    GenericConfigHelper authProvider = null;
                    SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                    authConfig = security2.getAuthorizationConfig();
                    if (authConfig != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainPolicy loaded a non-null authConfig.");
                        }
                        isJACCEnabled = authConfig.getBoolean("useJACCProvider");
                        authProvider = authConfig.getAuthorizationProvider();
                    }
                    if (jaccProviderPolicyClass == null && !isJACCEnabled) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainPolicy JACC Policy class null and JACC not enabled, using default authorization");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using default authorization");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getDomainPolicy returning null.");
                        }
                        return null;
                    }
                    if (jaccProviderPolicyClass == null && authProvider != null && (jaccProviderPolicyClass = authProvider.getString("j2eePolicyImplClassName")) != null && cacheKey.equalsIgnoreCase("admin")) {
                        System.setProperty("javax.security.jacc.policy.provider", jaccProviderPolicyClass);
                    }
                    if (jaccProviderPolicyClass == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainPolicy JACC Policy class null and JACC enabled, not good");
                        }
                        throw new ConfigurationError("The JACC provider's policy class name is null");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDomainPolicy The JACC provider's policy implementation class name is: " + jaccProviderPolicyClass);
                    }
                    if (authProvider.getBoolean("supportsDynamicModuleUpdates")) {
                        JaccUtil.setAppDynamicUpdates();
                    }
                    if (jaccProviderPolicyClass.equals("com.ibm.ws.security.policy.JaccPolicyProxy") || jaccProviderPolicyClass.equals("com.sun.ts.tests.jacc.provider.TSPolicy")) {
                        security2.setBoolean("boolDefaultJaccProvider", true);
                        SecurityConfig appSecurity = SecurityObjectLocator.getSecurityConfig("AppSecurity");
                        if (appSecurity != null) {
                            appSecurity.setBoolean("boolDefaultJaccProvider", true);
                        }
                    }
                    String jaccInitName = authProvider.getString("initializeJACCProviderClassName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getDomainPolicy jaccInit Class Name: ", jaccInitName);
                    }
                    if (jaccInitName != null && jaccInitName.length() != 0) {
                        InitializeJACCProvider initializeJACCProvider = null;
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            initializeJACCProvider = (InitializeJACCProvider)Class.forName(jaccInitName, true, cl).newInstance();
                        }
                        catch (ClassNotFoundException cnfe) {
                            Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, cnfe});
                            FFDCFilter.processException((Throwable)cnfe, "com.ibm.ws.security.policy.JaccPolicyDomainProxy.getDomainPolicy", "255", this);
                        }
                        catch (IllegalAccessException iae) {
                            Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, iae});
                            FFDCFilter.processException((Throwable)iae, "com.ibm.ws.security.policy.JaccPolicyDomainProxy.getDomainPolicy", "261", this);
                        }
                        catch (InstantiationException ie) {
                            Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, ie});
                            FFDCFilter.processException((Throwable)ie, "com.ibm.ws.security.policy.JaccPolicyDomainProxy.getDomainPolicy", "267", this);
                        }
                        try {
                            initializeJACCProvider.initialize(authProvider.getProperties());
                        }
                        catch (Exception e) {
                            Tr.error(tc, "security.jacc.initialize.error", new Object[]{jaccInitName, e});
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.policy.JaccPolicyDomainProxy.getDomainPolicy", "277", this);
                        }
                    }
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        policy = (Policy)Class.forName(jaccProviderPolicyClass, true, cl).newInstance();
                        policy.refresh();
                        this.cache.put(cacheKey, policy);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getDomainPolicy stored policy object in cache key: " + cacheKey);
                        }
                    }
                    catch (Throwable th) {
                        Tr.error(tc, "security.jacc.init.error", new Object[]{jaccProviderPolicyClass, th});
                        FFDCFilter.processException(th, "com.ibm.ws.security.policy.JaccPolicyDomainProxy.getDomainPolicy", "295", this);
                    }
                    Tr.audit(tc, "security.jacc.initialized", new Object[]{jaccProviderPolicyClass, authProvider.getString("policyConfigurationFactoryImplClassName"), authProvider.getString("roleConfigurationFactoryImplClassName"), jaccInitName});
                    security2.setObject("nullSourceCode", new CodeSource(null, (Certificate[])null));
                    security2.setObject("nullProtectionDomain", new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, null));
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDomainPolicy returning policy object from cache.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainPolicy", policy);
        }
        return policy;
    }
}

